
/************************************************************************
*ܽܣat_ctl APעfota¼ľʵֽӿںӿ
*ˣfota
*޸գ
*޸ݣ
*汾ţ
************************************************************************/

#if (APP_OS_TYPE == APP_OS_LINUX)
#include "at_context.h"
#include "fota_update.h"
#include "at_utils.h"


static int zfota_get_update_state()
{
    FOTA_UPDATE_STATE fota_state = FOTA_VERIFY_FAIL;
    FILE * fd = NULL;
    int result = -1;

    fd = fopen(FOTA_DUA_UPDATE_STATUS_FILE, "rb+");
    if(NULL == fd)
    {
		at_print(AT_ERR,"ERR: Call fopen() error.\n");
        return -1;
    }

    result = fscanf(fd, "%d", (int*)&fota_state);
    if(result < 0)
    {
		at_print(AT_ERR,"ERR: Call fscanf() error.\n");
        fclose(fd);
        fd = NULL;
        return -1;
    }

    fclose(fd);
    fd = NULL;
	
	at_print(AT_DEBUG, "DEBUG: zfota_get_update_state from %s, fota_state=%d \n", FOTA_DUA_UPDATE_STATUS_FILE, fota_state);
    return fota_state;
}

static int zfota_start_update()
{
	int result = -1;
    if(zfota_get_update_state() != 0)
    {
        result = -1;
       return result;
    }
    result = system("fota_upi --status  need_update");
    // syncsleep 2ȷ־дɹٻظ2,0
    system("sync");
    sleep(2);
    result = system("fota_upi  --upgrade  recovery &");
    return result;
}


static int zfota_is_updating(int fota_cmd)
{

	int update_result = -1;
	if (fota_cmd>= FOTA_VERIFY && fota_cmd <= FOTA_UPDATE_RESULT)
	{
		update_result = zfota_get_update_state();
		if (FOTA_NEED_UPDATE == update_result || FOTA_RECOVERY_UPDATE_SUCCESS == update_result)
		{
			return TRUE;
		}
		return FALSE;
	}
    return FALSE;
}

void zfota_set_cmd_result(int fota_cmd,int result,void * *res_msg,int * res_msglen)
{
	char str_fota_result[AT_CMD_MAX] = {0};
	int fota_cmd_result = -1;
	char upgrade_result[MAX_CFG_STR_SIZE] = {0};

	sc_cfg_get(NV_FOTA_UPGRADE_RESULT, upgrade_result, sizeof(upgrade_result));
    at_print(AT_DEBUG, "DEBUG: zfota_set_cmd_result get nv %s = %s, result=%d \n", NV_FOTA_UPGRADE_RESULT, upgrade_result, result);
	
	if(result == -1)
	{
        fota_cmd_result = FAIL;
    }
	else if((result == UPDATING) && (zfota_is_updating(fota_cmd)))
	{
		if (FOTA_UPDATE_RESULT == fota_cmd)
		{
			 fota_cmd_result = UPDATING;
		}
		else
		{
			//"ɹ"״̬
			fota_cmd_result =  SUCCESS;
		}
	}
    else 
    {
    	if(FOTA_VERIFY == fota_cmd ||(FOTA_VERIFY_RESULT == fota_cmd && FOTA_VERIFY_SUCCESS == result))
    	{
            fota_cmd_result =  SUCCESS;
    	}
		else if((FOTA_VERIFY_RESULT == fota_cmd ||FOTA_UPDATE_RESULT == fota_cmd)&& FOTA_VERIFY_FAIL == result )
		{
            fota_cmd_result =  FAIL;
    	}	
        else if((FOTA_UPDATE_RESULT == fota_cmd)&&(FOTA_SYSTEM_UPDATE_SUCCESS == result || (!strcmp(upgrade_result,FOTA_UPDATE_RESULT_SUCCESS))))
        {
            fota_cmd_result =  SUCCESS;
        }
		else if((FOTA_UPDATE_RESULT == fota_cmd)&&(FOTA_SYSTEM_UPDATE_FAIL == result || \
			FOTA_RECOVERY_UPDATE_FAIL == result ||!strcmp(upgrade_result,FOTA_UPDATE_RESULT_FAIL)))
        {
            fota_cmd_result =  FAIL;
        }
		else if(FOTA_UPDATE == fota_cmd ||LOCAL_UPDATE == fota_cmd ||LOCAL_UPDATE_RESULT == fota_cmd)
		{
			fota_cmd_result =  SUCCESS;
		}
        else 
        {
            fota_cmd_result =  UPDATING;
        }
    }		
	snprintf(str_fota_result, sizeof(str_fota_result), "%d,%d\r\n", fota_cmd, fota_cmd_result);
	*res_msg = at_query_result_build("FOTACTR",str_fota_result);
	*res_msglen = strlen(*res_msg);
			
}

int zfotactr_req_act(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    int fota_cmd = 0, result = -1;
    PCS_MSG pcsMsg = {{0},-1}; 
    void *p[1] = {&fota_cmd};

    if(at_paras==NULL){
		softap_assert("zfotactr_req_act:at_paras is null");
		return AT_END;
    }

	parse_param2("%d", at_paras, p);
    
    at_print(AT_NORMAL,"zfotactr_req_act:fota_cmd == %d\n", fota_cmd);

	if(zfota_is_updating(fota_cmd))
	{
		zfota_set_cmd_result(fota_cmd,UPDATING,res_msg,res_msglen);
		return AT_END;
	};
	
    switch(fota_cmd)
    {
        case FOTA_VERIFY:
            result = system("fota_upi  --upgrade  verify");
            break;
        case FOTA_VERIFY_RESULT:
            result = zfota_get_update_state();
            break;
        case FOTA_UPDATE:
			result = zfota_start_update();
            break;
        case FOTA_UPDATE_RESULT:
            result = zfota_get_update_state();
            break;
		case FOTA_VOIP_CMD:
            //pcsMsg.deviceID = at_fd;
		    //iResult = ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_VOIP_CALL, MSG_CMD_PPP2VOIP_STOP, sizeof(PCS_MSG), (UCHAR *)&pcsMsg,0);
            break;
        case LOCAL_UPDATE:
            pcsMsg.deviceID = at_fd;
		    result = ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_LOCALUPDATE, MSG_CMD_LOCALUPDATE_START, sizeof(PCS_MSG), (UCHAR *)&pcsMsg,0);
            break;
        case LOCAL_UPDATE_RESULT:
            pcsMsg.deviceID = at_fd;
		    result = ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_LOCALUPDATE, MSG_CMD_LOCALUPDATE_GET_RESULT, sizeof(PCS_MSG), (UCHAR *)&pcsMsg,0);
            break;
        default:
            break;
    }	
	
    at_print(AT_NORMAL,"zfotactr_req_act:result == %d\n", result);
	zfota_set_cmd_result(fota_cmd,result,res_msg,res_msglen);
	return AT_END;
}
#endif


