//ͳ
#include "fluxstat.h"
#include <sys/sem.h>
#include <sys/ipc.h>
#include <errno.h>
#include <sys/prctl.h>
#include <limits.h>


pthread_mutex_t g_getaddrinfo_mutex;
pthread_mutex_t g_getnameinfo_mutex;

int flux_enable_flag = 0;//ͳб־
time_t last_connect_time = 0; //һpdpʱ
BOOL g_need_send_flux_warnning = TRUE; //ǷҪ澯Ϣ
BOOL g_need_send_flux_over =TRUE;  //ǷҪϢ
static int init_sem(int sem_id, int init_value)
{
	union semun sem_union;
	sem_union.val = init_value;
	if (semctl(sem_id, 0, SETVAL, sem_union) == -1) {
		return -1;
	}
	return 0;
}

// ɾsem_idź
static int del_sem(int sem_id)
{
	union semun sem_union = {0}; //cov h
	if (semctl(sem_id, 0, IPC_RMID, sem_union) == -1) {
		return -1;
	}
	return 0;
}

// sem_idִp
static int sem_p(int sem_id)
{
	struct sembuf sem_buf;
	sem_buf.sem_num = 0; //ź
	sem_buf.sem_op = -1; //P
	sem_buf.sem_flg = SEM_UNDO; //ϵͳ˳ǰδͷźϵͳԶͷ
	if (semop(sem_id, &sem_buf, 1) == -1) {
		return -1;
	}
	return 0;
}

// sem_idִV
static int sem_v(int sem_id)
{
	struct sembuf sem_buf;
	sem_buf.sem_num = 0;
	sem_buf.sem_op = 1; //V
	sem_buf.sem_flg = SEM_UNDO;
	if (semop(sem_id, &sem_buf, 1) == -1) {
		return -1;
	}
	return 0;
}

static int get_sem(key_t sem_key)
{
	int sem_id = -1;

	sem_id = semget(sem_key, 1, 0666 | IPC_CREAT | IPC_EXCL);
	if (sem_id < 0) {
		if (errno == EEXIST) {
			slog(FLUXSTAT_PRINT, SLOG_ERR, "[fluxstat]semget already exist\n");
			return semget(sem_key, 1, 0666 | IPC_CREAT);
		}
		slog(FLUXSTAT_PRINT, SLOG_ERR, "[fluxstat]semget == -1, return fail\n");
		return -1;
	}

	union semun sem_union;
	sem_union.val = 1;
	if (semctl(sem_id, 0, SETVAL, sem_union) == -1) {
		return -1;
	}

	slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[fluxstat]semget sem_id= %d, get sem success\n", sem_id);;
	return sem_id;
}


void action_reach_month_limit(void)
{
	char keep_online[10] = {0};
	char auto_connect[10] = {0};

	sc_cfg_get("keep_online_when_limited", keep_online, sizeof(keep_online));
	if (0 == strcmp(keep_online, "no")) {
		if (0 != ipc_send_message(MODULE_ID_FLUXSTAT, MODULE_ID_AT_CTL, MSG_CMD_PDP_DEACT_REQ, 0, NULL, 0)) {
			slog(FLUXSTAT_PRINT, SLOG_ERR, "fluxstat send disconnect msg fail.\n");
			return;
		}
	}

	sc_cfg_get("auto_connect_when_limited", auto_connect, sizeof(auto_connect));
	if (0 == strcmp(auto_connect, "no")) {
		sc_cfg_set(NV_DIAL_MODE, "manual_dial");
	} else if (0 == strcmp(auto_connect, "yes")) {
		sc_cfg_set(NV_DIAL_MODE, "auto_dial");
	}
}

void flux_reach_month_limit()
{
	char total1[20] = {0};
	char total2[20] = {0};
	char delta[20] = {0};
	long long  total1_v = 0; //kw 3
	long long  total2_v = 0;
	long long  delta_v = 0;
	char limit_swith[10] = {0};
	char percent[10] = {0};
	char data_switch[10] = {0};
	int m_warn_value = 0;
	
	sc_cfg_get("is_traffic_limit_on", limit_swith, sizeof(limit_swith));
	sc_cfg_get("flux_month_total", total1, sizeof(total1));
	sc_cfg_get("traffic_alined_delta", delta, sizeof(delta));
	sc_cfg_get("traffic_month_total", total2, sizeof(total2));
	//kw 3
	total1_v = atoll(total1);
	if (total1_v < 0 || total1_v > LLONG_MAX-1)
		total1_v = 0;
	delta_v = atoll(delta);
	if (delta_v < 0 || delta_v > LLONG_MAX-1)
		delta_v = 0;
	total2_v = atoll(total2);
	if (total2_v < 0 || total2_v > LLONG_MAX-1)
		total2_v = 0;

	if (0 == strcmp(limit_swith, "yes") && total1_v + delta_v >= total2_v * 1024 * 1024) {
		action_reach_month_limit();
	}
#if (PRODUCT_TYPE == PRODUCT_PHONE)
	sc_cfg_get(NV_TRAFFIC_LIMIT_SWITCH, data_switch, sizeof(percent));
	sc_cfg_get(NV_TRAFFIC_ALERT_PERCENT, percent, sizeof(percent));	
	m_warn_value = strlen(percent) == 0 ? 100 : atoi(percent);
	/*klocwork 3 SV.TAINTED.BINOP, add if condition*/
	if((m_warn_value < 0 ) || (m_warn_value > 100))
	{
		return;
	}
	slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux] flux_reach_warnning_limit,data_switch=%s, flux_enable_flag=%d, m_warn_value = %d, total = %lld\n", data_switch, flux_enable_flag, m_warn_value, total2_v); //cov m
	
	if ((0==strcmp(data_switch, "1")) && (1 == flux_enable_flag) && (m_warn_value > 0) && (total2_v > 0))
	{
		slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux] flux_reach_warnning_limit,used =%lld, warn =%lld\n", atoll(total1), (total2_v * 1024 * 1024 * m_warn_value)/100);
		
		if(total1_v >= (total2_v * 1024 * 1024 * m_warn_value)/100) 
		{
			if(m_warn_value == 100 && TRUE == g_need_send_flux_over)
			{
				platform_send_msg(MODULE_ID_FLUXSTAT, MODULE_ID_MMI_SVR, MSG_CMD_DATAMANAGER_REACH_LIMIT, 0, NULL);
				g_need_send_flux_over = FALSE;
			}
			else
			{
				if((total1_v >= (total2_v * 1024 * 1024)) && TRUE == g_need_send_flux_over)
				{
					platform_send_msg(MODULE_ID_FLUXSTAT, MODULE_ID_MMI_SVR, MSG_CMD_DATAMANAGER_REACH_LIMIT, 0, NULL);
					g_need_send_flux_over = FALSE;
				}
				else if(TRUE == g_need_send_flux_warnning)
				{
					platform_send_msg(MODULE_ID_FLUXSTAT, MODULE_ID_MMI_SVR, MSG_CMD_DATAMANAGER_REACH_WARNVALUE, 0, NULL);
					g_need_send_flux_warnning = FALSE;
				}
			}
		}
	}
#endif	
}

void data_cfg_init()
{
	//sc_cfg_set("DataStatus","");
	sc_cfg_set("realtime_time", "0");
	sc_cfg_set("realtime_tx_bytes", "0");
	sc_cfg_set("realtime_rx_bytes", "0");
	sc_cfg_set("CTotal_vol", "0");
	sc_cfg_set("realtime_tx_thrpt", "0");
	sc_cfg_set("realtime_rx_thrpt", "0");
	//sc_cfg_set("CurrSpeed_total","0");
//    sc_cfg_set("AverSpeed_up","0");
//    sc_cfg_set("AverSpeed_down","0");
//    sc_cfg_set("AverSpeed_total","0");
	sc_cfg_set("duraConTime_before_time_modify", "0");
	sc_cfg_set("flux_total_flow_when_power_on", "0");

}

void clear_nv()
{
	sc_cfg_set("realtime_tx_thrpt", "0");
	sc_cfg_set("realtime_rx_thrpt", "0");
	sc_cfg_set("traffic_alined_delta", "0");
	sc_cfg_set("monthly_tx_bytes", "0");
	sc_cfg_set("monthly_rx_bytes", "0");
	sc_cfg_set("flux_month_total", "0");
	sc_cfg_set("monthly_time", "0");
	sc_cfg_set("MonthlyConTime_Last", "0");
}


int fluxstat_clear_process(char *str_year_buf, char *str_month_buf)
{
	char sntp_mode[20] = {0};
	char sntp_nv_year[20] = {0};
	char sntp_nv_month[20] = {0};
	char need_clear[20] = {0};
	char sntp_result[20] = {0};

	sc_cfg_get("need_clear_traffic_data", need_clear, sizeof(need_clear));

	sc_cfg_get("sntp_time_set_mode", sntp_mode, sizeof(sntp_mode));

	if (strcmp("manual", sntp_mode) == 0) {
		slog(FLUXSTAT_PRINT, SLOG_NORMAL, "[flux] manual time,check clear_nv,need_clear=%s\n", need_clear);

		if (0 != strcmp("no", need_clear)) {
			slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux] manual reset fluxstat\n");
			clear_nv();
		}
	} else {
		slog(FLUXSTAT_PRINT, SLOG_NORMAL, "[flux] sntp time\n");

		sc_cfg_get("clear_nv_year_temp", sntp_nv_year, sizeof(sntp_nv_year));
		sc_cfg_get("clear_nv_month_temp", sntp_nv_month, sizeof(sntp_nv_month));
		sc_cfg_get("sntp_process_result", sntp_result, sizeof(sntp_result));

		slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux] sntp time,nv temp:%s %s\n", sntp_nv_year, sntp_nv_month);
		slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux] sntp time,result:%s\n", sntp_result);
		if (strcmp("success", sntp_result) == 0) {
			if ((strcmp(str_year_buf, sntp_nv_year) != 0) || (strcmp(str_month_buf, sntp_nv_month) != 0)) {
				slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux] sntp need reset\n");

				if (0 != strcmp("no", need_clear)) {
					slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux] reset fluxstat\n");
					clear_nv();
				}
			}
		}

	}
	return 1;

}

void month_turnto_num(char *imonth, char *month)
{
	if (0 == strcmp("Jan", month)) {
		strcpy(imonth, "01");
	} else if (0 == strcmp("Feb", month)) {
		strcpy(imonth, "02");
	} else if (0 == strcmp("Mar", month)) {
		strcpy(imonth, "03");
	} else if (0 == strcmp("Apr", month)) {
		strcpy(imonth, "04");
	} else if (0 == strcmp("May", month)) {
		strcpy(imonth, "05");
	} else if (0 == strcmp("Jun", month)) {
		strcpy(imonth, "06");
	} else if (0 == strcmp("Jul", month)) {
		strcpy(imonth, "07");
	} else if (0 == strcmp("Aug", month)) {
		strcpy(imonth, "08");
	} else if (0 == strcmp("Sep", month)) {
		strcpy(imonth, "09");
	} else if (0 == strcmp("Oct", month)) {
		strcpy(imonth, "10");
	} else if (0 == strcmp("Nov", month)) {
		strcpy(imonth, "11");
	} else if (0 == strcmp("Dec", month)) {
		strcpy(imonth, "12");
	}
}

void set_time_flux_day_and_month(int update_flag)
{
	char set_current_day[10] = {0};
	char set_current_month[10] = {0};
	char set_current_year[10] = {0};

	sc_cfg_get("flux_set_day", set_current_day, sizeof(set_current_day));
	sc_cfg_get("flux_set_month", set_current_month, sizeof(set_current_month));
	sc_cfg_get("flux_set_year", set_current_year, sizeof(set_current_year));


	if (1 == update_flag || 0 == strlen(set_current_day)
	    || 0 == strlen(set_current_month) || 0 == strlen(set_current_year)) {
		memset(set_current_day, 0, sizeof(set_current_day));
		memset(set_current_month, 0, sizeof(set_current_month));
		memset(set_current_year, 0, sizeof(set_current_year));
		sc_cfg_get("sntp_day", set_current_day, sizeof(set_current_day));
		sc_cfg_get("sntp_month", set_current_month, sizeof(set_current_month));
		sc_cfg_get("sntp_year", set_current_year, sizeof(set_current_year));

		sc_cfg_set("flux_set_day", set_current_day);
		sc_cfg_set("flux_set_month", set_current_month);
		sc_cfg_set("flux_set_year", set_current_year);
	}
}

//cov m
void flux_day_and_month(unsigned long long current_send, unsigned long long current_rcv)
{

	char current_day_flux[128] = {0};
	char current_month_flux[128] = {0};
	char current_month_send_flux[128] = {0};
	char current_month_rcv_flux[128] = {0};
	char char_last_send_day_and_month[128] = {0};
	char char_last_rcv_day_and_month[128] = {0};
	unsigned long long current_total_day = 0;
	unsigned long long current_total_month = 0;
	unsigned long long current_total_send_month = 0;
	unsigned long long current_total_rcv_month = 0;
	long long  tmp_day = 0; //kw 3
	long long  tmp_month = 0;
	long long  tmp_send_month = 0;
	long long  tmp_rcv_month = 0;

	sc_cfg_get("flux_day_total", current_day_flux, sizeof(current_day_flux));
	sc_cfg_get("flux_month_total", current_month_flux, sizeof(current_month_flux));
	sc_cfg_get("monthly_tx_bytes", current_month_send_flux, sizeof(current_month_send_flux));
	sc_cfg_get("monthly_rx_bytes", current_month_rcv_flux, sizeof(current_month_rcv_flux));

	tmp_day = atoll(current_day_flux);
	if (tmp_day < 0 || tmp_day > LLONG_MAX-1)
		tmp_day = 0;
	tmp_month = atoll(current_month_flux);
	if (tmp_month < 0 || tmp_month > LLONG_MAX-1)
		tmp_month = 0;
	tmp_send_month = atoll(current_month_send_flux);
	if (tmp_send_month < 0 || tmp_send_month > LLONG_MAX-1)
		tmp_send_month = 0;
	tmp_rcv_month = atoll(current_month_rcv_flux);
	if (tmp_rcv_month < 0 || tmp_rcv_month > LLONG_MAX-1)
		tmp_rcv_month = 0;

	current_total_day = tmp_day + current_send + current_rcv;
	current_total_month = tmp_month + current_send + current_rcv;
	current_total_send_month = tmp_send_month + current_send;
	current_total_rcv_month = tmp_rcv_month + current_rcv;

	snprintf(current_day_flux, 64, "%llu", current_total_day);
	snprintf(current_month_flux, 64, "%llu", current_total_month);
	snprintf(current_month_send_flux, 64, "%llu", current_total_send_month);
	snprintf(current_month_rcv_flux, 64, "%llu", current_total_rcv_month);

	sc_cfg_set("flux_day_total", current_day_flux);
	sc_cfg_set("flux_month_total", current_month_flux);
	sc_cfg_set("monthly_tx_bytes", current_month_send_flux);
	sc_cfg_set("monthly_rx_bytes", current_month_rcv_flux);

	flux_reach_month_limit();
}


int getInterface(char *wan_name, int len)
{
	char default_wan_rel[30] = {0};
	char default_wan6_rel[30] = {0};
	char pswan[30] = {0};
	sc_cfg_get("pswan", pswan, sizeof(pswan));
	sc_cfg_get("default_wan_rel", default_wan_rel, sizeof(default_wan_rel));
	sc_cfg_get("default_wan6_rel", default_wan6_rel, sizeof(default_wan6_rel));

	if (0 != strcmp(default_wan_rel, "") && 0 == strncmp(default_wan_rel, pswan, strlen(pswan))) {
		strcpy(wan_name, default_wan_rel);
		return 0;
	} else if (0 != strcmp(default_wan6_rel, "") && 0 == strncmp(default_wan6_rel, pswan, strlen(pswan))) {
		strcpy(wan_name, default_wan6_rel);
		return 0;
	} else {
		return -1;
	}

}



//նϵӦķ͡ԼӦʵͳ
void flux_realtime(unsigned long long current_tx_bytes, unsigned long long current_rx_bytes)
{
	char rbuf1[64] = {0};
	char rbuf2[64] = {0};
	char rbuf3[64] = {0};
	char wbuf1[64] = {0};
	char wbuf2[64] = {0};
	char wbuf3[64] = {0};
	unsigned long long total_tx = 0, total_rx = 0, total_bytes = 0;
	unsigned long long last_tx = 0, last_rx = 0, last_bytes = 0;
	unsigned long long current_total_bytes = 0;
	unsigned long long current_tx_speed = 0, current_rx_speed = 0, current_total_speed = 0;
	unsigned long long current_boot_total = 0;
	long long  tmp_rbuf1 = 0; //kw 3
	long long  tmp_rbuf2 = 0;
	long long  tmp_rbuf3 = 0;

	current_total_bytes = current_tx_bytes + current_rx_bytes;

	//
	current_tx_speed = current_tx_bytes / 1;
	current_rx_speed = current_rx_bytes / 1;
	current_total_speed = current_tx_speed + current_rx_speed;
	snprintf(wbuf1, 64, "%llu", current_tx_speed);
	snprintf(wbuf2, 64, "%llu", current_rx_speed);
	snprintf(wbuf3, 64, "%llu", current_total_speed);
	sc_cfg_set("realtime_tx_thrpt", wbuf1);
	sc_cfg_set("realtime_rx_thrpt", wbuf2);
	//sc_cfg_set("CurrSpeed_total", wbuf3);


	memset(wbuf1, 0, sizeof(wbuf1));
	memset(wbuf2, 0, sizeof(wbuf2));
	memset(wbuf3, 0, sizeof(wbuf3));



	//ο
	sc_cfg_get("realtime_tx_bytes", rbuf1, sizeof(rbuf1));
	sc_cfg_get("realtime_rx_bytes", rbuf2, sizeof(rbuf2));
	sc_cfg_get("CTotal_vol", rbuf3, sizeof(rbuf3));
	tmp_rbuf1 = atoll(rbuf1);
	if (tmp_rbuf1 < 0 || tmp_rbuf1 > LLONG_MAX-1)
		tmp_rbuf1 = 0;
	tmp_rbuf2 = atoll(rbuf2);
	if (tmp_rbuf2 < 0 || tmp_rbuf2 > LLONG_MAX-1)
		tmp_rbuf2 = 0;
	tmp_rbuf3 = atoll(rbuf3);
	if (tmp_rbuf3 < 0 || tmp_rbuf3 > LLONG_MAX-1)
		tmp_rbuf3 = 0;
	total_tx = tmp_rbuf1 + current_tx_bytes;
	total_rx = tmp_rbuf2 + current_rx_bytes;
	total_bytes = tmp_rbuf3 + current_total_bytes;
	snprintf(wbuf1, 64, "%llu", total_tx);
	snprintf(wbuf2, 64, "%llu", total_rx);
	snprintf(wbuf3, 64, "%llu", total_bytes);
	sc_cfg_set("realtime_tx_bytes", wbuf1);
	sc_cfg_set("realtime_rx_bytes", wbuf2);
	sc_cfg_set("CTotal_vol", wbuf3);


	memset(rbuf1, 0, sizeof(rbuf1));
	memset(rbuf2, 0, sizeof(rbuf2));
	memset(rbuf3, 0, sizeof(rbuf3));
	memset(wbuf1, 0, sizeof(wbuf1));
	memset(wbuf2, 0, sizeof(wbuf2));
	memset(wbuf3, 0, sizeof(wbuf3));

	//
	sc_cfg_get("Last_up", rbuf1, sizeof(rbuf1));
	sc_cfg_get("Last_down", rbuf2, sizeof(rbuf2));
	sc_cfg_get("Last_total", rbuf3, sizeof(rbuf3));
	tmp_rbuf1 = atoll(rbuf1);
	if (tmp_rbuf1 < 0 || tmp_rbuf1 > LLONG_MAX-1)
		tmp_rbuf1 = 0;
	tmp_rbuf2 = atoll(rbuf2);
	if (tmp_rbuf2 < 0 || tmp_rbuf2 > LLONG_MAX-1)
		tmp_rbuf2 = 0;
	tmp_rbuf3 = atoll(rbuf3);
	if (tmp_rbuf3 < 0 || tmp_rbuf3 > LLONG_MAX-1)
		tmp_rbuf3 = 0;
	last_tx = tmp_rbuf1 + current_tx_bytes;
	last_rx = tmp_rbuf2 + current_rx_bytes;
	last_bytes = tmp_rbuf3 + current_total_bytes;
	snprintf(wbuf1, 64, "%llu", last_tx);
	snprintf(wbuf2, 64, "%llu", last_rx);
	snprintf(wbuf3, 64, "%llu", last_bytes);
	sc_cfg_set("Last_up", wbuf1);
	sc_cfg_set("Last_down", wbuf2);
	sc_cfg_set("Last_total", wbuf3);

	memset(rbuf1, 0, sizeof(rbuf1));
	memset(wbuf1, 0, sizeof(wbuf1));

	//οCTotal_volظ
	sc_cfg_get("flux_total_flow_when_power_on", rbuf1, sizeof(rbuf1));
	tmp_rbuf1 = atoll(rbuf1);
		if (tmp_rbuf1 < 0 || tmp_rbuf1 > LLONG_MAX-1)
			tmp_rbuf1 = 0;
	current_boot_total = tmp_rbuf1 + current_total_bytes;
	snprintf(wbuf1, 64, "%llu", current_boot_total);
	sc_cfg_set("flux_total_flow_when_power_on", wbuf1);
}

void fluxstat_main_loop(void *arg)
{
	unsigned long long data_send = 0, data_rcv = 0;
	unsigned long long data_send_total = 0, data_rcv_total = 0;
	unsigned long long last_send = 0, last_rcv = 0;
	int tx_res = 0;
	int rx_res = 0;

	prctl(PR_SET_NAME, "fluxstat-main", 0, 0, 0);

	int sem_id = -1;
	int result = 0;
	char wan_name[30] = {0};
	char byte_num[64] = {0};
	int first_data_flag = 1;
	sem_id = get_sem(TIME_SEM_KEY_1);

	while (1) {
		//webuiʵʱʱ²ӦsntpͬӰ
		webui_time_nv_set();
		//ʵʱͳƸ²ӦsntpͬӰ
		memset(wan_name, 0, sizeof(wan_name));
		if (0 != getInterface(wan_name, sizeof(wan_name))) {
			fluxstat_date_changed();
			goto LOOP_END;		
		}

		tx_res = getIfStatistic(wan_name, TXBYTE, &data_send_total); //ȡ
		rx_res = getIfStatistic(wan_name, RXBYTE, &data_rcv_total); //ȡ
		sprintf(byte_num, "%llu", data_send);
		sc_cfg_set("wan_tx_byte", byte_num);
		memset(byte_num, 0, sizeof(byte_num));
		sprintf(byte_num, "%llu", data_rcv);
		sc_cfg_set("wan_rx_byte", byte_num);

		if (tx_res == -1 || rx_res == -1) //kw 3
			goto LOOP_END;
				
		if (data_send_total >= last_send) {
			data_send = data_send_total - last_send;			
		} else {
			data_send = data_send_total;			
		}

		if(data_rcv_total >= last_rcv) {
			data_rcv = data_rcv_total - last_rcv;
		} else {
			data_rcv = data_rcv_total;
		}	
		
		last_send = data_send_total;
		last_rcv = data_rcv_total;

		//ϵӦͳ
		flux_realtime(data_send, data_rcv);

		if (fluxstat_date_changed() || first_data_flag) {
			//slog(FLUXSTAT_PRINT,SLOG_DEBUG, "[flux]fluxstat date or month changed.\n");
			first_data_flag = 0;
			time(&last_connect_time);
		}

		//աۼͳsntp
		if (flux_enable_flag) {
			if (sem_id != -1) {
				result = sem_p(sem_id);
			}

			flux_day_and_month(data_send, data_rcv);
			flux_connect_time();

			if (sem_id != -1) {
				result = sem_v(sem_id);
			}
		}

LOOP_END:
		sleep(1);
	}
}
int mc_create_msg_q(void)
{
	return msgget(MODULE_ID_FLUXSTAT, IPC_CREAT | 0600);
}
void update_data_cfg()
{
	long record_time = 0, total_time = 0;
	long long  last_s = 0, last_r = 0, record_send = 0, record_rcv = 0, total_tot = 0;
	char t_time[12], t_send[20], t_rcv[20], t_vol[20];
	long timestat_month = 0;
	long timestat_last = 0;
	char ConectedTimeStr[20] = {0};
	char buf1[64] = {0};
	char buf2[64] = {0};
	char buf3[64] = {0};

	sc_cfg_get("Last_time", buf1, sizeof(buf1));
	sc_cfg_get("Last_up", buf2, sizeof(buf2));
	sc_cfg_get("Last_down", buf3, sizeof(buf3));
	record_time = atol(buf1); //kw 3
	if (record_time < 0 || record_time > LONG_MAX-1)
		record_time = 0;
	record_send = atoll(buf2);
	if (record_send < 0 || record_send > LLONG_MAX-1)
		record_send = 0;
	record_rcv = atoll(buf3);
	if (record_rcv < 0 || record_rcv > LLONG_MAX-1)
		record_rcv = 0;
	memset(buf1, 0, sizeof(buf1));
	memset(buf2, 0, sizeof(buf2));
	memset(buf3, 0, sizeof(buf3));

	sc_cfg_get("realtime_time", buf1, sizeof(buf1));
	sc_cfg_get("realtime_tx_bytes", buf2, sizeof(buf2));
	sc_cfg_get("realtime_rx_bytes", buf3, sizeof(buf3));
	total_time = atol(buf1);
	if (total_time < 0 || total_time > LONG_MAX-1)
			total_time = 0;
	total_time = record_time + total_time;

	last_s = atoll(buf2);
	if (last_s < 0 || last_s > LLONG_MAX-1)
		last_s = 0;
	last_s = record_send + last_s;

	last_r = atoll(buf3);
	if (last_r < 0 || last_r > LLONG_MAX-1)
		last_r = 0;
	last_r = record_rcv + last_r;
	total_tot = last_s + last_r;
	sprintf(t_time, "%ld", total_time);
	sprintf(t_send, "%lld", last_s);
	sprintf(t_rcv, "%lld", last_r);
	sprintf(t_vol, "%lld", total_tot);
	sc_cfg_set("Last_time", t_time);
	memset(buf1, 0, sizeof(buf1));
	memset(buf2, 0, sizeof(buf2));

	/*start added by jhy Nov 28, 2013*/
	sc_cfg_get("MonthlyConTime_Last", buf1, sizeof(buf1));
	sc_cfg_get("realtime_time", buf2, sizeof(buf2));
	timestat_month = atol(buf1);
	if (timestat_month < 0 || timestat_month > LONG_MAX-1)
		timestat_month = 0;
	timestat_last = atol(buf2);
	if (timestat_last < 0 || timestat_last > LONG_MAX-1)
		timestat_last = 0;
	sprintf(ConectedTimeStr, "%ld", timestat_month + timestat_last);
	sc_cfg_set("MonthlyConTime_Last", ConectedTimeStr);
	//sc_cfg_save();
	/*end added by jhy Nov 28, 2013*/

	data_cfg_init();
}

void time_analyze(char *time_ex, struct date_time_t* current_time)
{
	char timetmp[128] = {0};
	char month[4] = {0};
	char day[3] = {0};
	char *tmp = NULL;
	char *save = NULL;
	char nowtime[16] = {0};
	memset(current_time, 0, sizeof(struct date_time_t));

	strncpy(timetmp, time_ex, sizeof(timetmp)-1);
	char *loc = timetmp;
	while (*loc == ' ') {
		loc++;
	}

	tmp = strtok_r(loc, " ", &save);
	if (tmp == NULL)
		return;
	strncpy(current_time->weekday, tmp, sizeof(current_time->weekday)-1);
	tmp = strtok_r(NULL, " ", &save);
	if (tmp == NULL)
		return;
	strncpy(month, tmp, sizeof(month)-1);
	tmp = strtok_r(NULL, " ", &save);
	if (tmp == NULL)
		return;
	strncpy(day, tmp, sizeof(day)-1);
	if (strlen(tmp) == 1) {
		snprintf(current_time->day, 3, "0%d", atoi(tmp));//klocwork
	} else {
		strncpy(current_time->day, tmp, sizeof(current_time->day)-1);
	}

	tmp = strtok_r(NULL, " ", &save);
	if (tmp == NULL)
		return;
	strncpy(current_time->nowtime, tmp, sizeof(current_time->nowtime)-1);
	strncpy(nowtime, tmp, sizeof(nowtime)-1);
	tmp = strtok_r(NULL, " ", &save);
	if (tmp == NULL)
		return;
	strncpy(current_time->year, tmp, 4);
	month_turnto_num(current_time->month, month);

	tmp = strtok_r(nowtime, ":", &save);
	if (tmp == NULL)
		return;
	strncpy(current_time->hour, tmp, sizeof(current_time->hour)-1);
	tmp = strtok_r(NULL, ":", &save);
	if (tmp == NULL)
		return;
	strncpy(current_time->minute, tmp, sizeof(current_time->minute)-1);
	tmp = strtok_r(NULL, ":", &save);
	if (tmp == NULL)
		return;
	strncpy(current_time->second, tmp, sizeof(current_time->second)-1);
}

void set_sntp_nv(struct date_time_t* current_time)
{
	sc_cfg_set("sntp_hour", current_time->hour);
	sc_cfg_set("sntp_minute", current_time->minute);
	sc_cfg_set("sntp_second", current_time->second);
	sc_cfg_set("sntp_year", current_time->year);
	sc_cfg_set("sntp_month", current_time->month);
	sc_cfg_set("sntp_day", current_time->day);
	sc_cfg_set("sntp_weekday", current_time->weekday);
	sc_cfg_set("sntp_nowtime", current_time->nowtime);
}

void get_current_date(struct date_time_t* current_time)
{
	time_t flux_timenow = 0;
	char stri_flux_time[128] = {0};
	time(&flux_timenow);
	ctime_r(&flux_timenow, stri_flux_time);
	time_analyze(stri_flux_time, current_time);
}

//webuiûȡǰϵͳʱ䣬Ӧgoahead
void webui_time_nv_set()
{
	struct date_time_t current_time = {0};
	get_current_date(&current_time);
	set_sntp_nv(&current_time);
}

void fluxstat_init()
{
	//sc_cfg_set("DataStatus","");
	sc_cfg_set("realtime_time", "0");
	sc_cfg_set("realtime_tx_bytes", "0");
	sc_cfg_set("realtime_rx_bytes", "0");
	sc_cfg_set("CTotal_vol", "0");
	sc_cfg_set("realtime_tx_thrpt", "0");
	sc_cfg_set("realtime_rx_thrpt", "0");
	//sc_cfg_set("CurrSpeed_total","0");
//  sc_cfg_set("AverSpeed_up","0");
//   sc_cfg_set("AverSpeed_down","0");
	//sc_cfg_set("AverSpeed_total","0");
	sc_cfg_set("duraConTime_before_time_modify", "0");
	sc_cfg_set("flux_total_flow_when_power_on", "0");
}

int fluxstat_date_changed()
{

	char last_day[3] = {0};
	char last_month[3] = {0};
	char last_year[5] = {0};
	char sntp_result[20] = {0};
	char sntp_mode[20] = {0};
	char tmp[20] = {0};
	int  compare_day = 0;
	int  compare_month = 0;
	int  compare_year = 0;
	int  day_changed = 0;
	int  month_changed = 0;
	int sem_id = -1;
	struct date_time_t current_time = {0};
	char ppp_status[64] = {0};

	sc_cfg_get("sntp_time_set_mode", sntp_mode, sizeof(sntp_mode));
	sc_cfg_get("sntp_process_result", sntp_result, sizeof(sntp_result));
	sc_cfg_get("ppp_status", ppp_status, sizeof(ppp_status));

	if (0 == strcmp("ppp_connected", ppp_status)) {
		flux_enable_flag = 1;
	}

	if (strcmp("manual", sntp_mode) != 0 && strcmp("success", sntp_result) != 0) {
		//slog(FLUXSTAT_PRINT,SLOG_DEBUG, "[flux]fluxstat_date_changed: sntp_mode =%s,sntp_result =%s\n",sntp_mode, sntp_result);
		return 0;
	}

	get_current_date(&current_time);
	sc_cfg_get("flux_last_day", last_day, sizeof(last_day));
	sc_cfg_get("flux_last_month", last_month, sizeof(last_month));
	sc_cfg_get("flux_last_year", last_year, sizeof(last_year));
	compare_day = strcmp(current_time.day, last_day);
	compare_month = strcmp(current_time.month, last_month);
	compare_year = strcmp(current_time.year, last_year);

	day_changed = compare_day | compare_month | compare_year;
	month_changed = compare_month | compare_year;

	if (day_changed) {
		sc_cfg_set("flux_day_total", "0");
		sc_cfg_get("realtime_time", tmp, sizeof(tmp));
		sc_cfg_set("duraConTime_before_time_modify", tmp);
	}
	if (month_changed) {
		sem_id = get_sem(TIME_SEM_KEY_2);

		if (sem_id != -1) {
			sem_p(sem_id);
		}

		fluxstat_clear_process(current_time.year, current_time.month);
		if (sem_id != -1) {
			sem_v(sem_id);
		}

	}
	if (day_changed || month_changed) {
		sc_cfg_set("flux_last_day", current_time.day);
		sc_cfg_set("flux_last_month", current_time.month);
		sc_cfg_set("flux_last_year", current_time.year);
		return 1;
	}
	return 0;
}

//ÿһʱ䣬
void flux_connect_time()
{
	long conneted_time = 0;
	char ConectedTimeStr[20] = {0};
	long duraConTime_before_time_modify = 0;
	char tmp[20] = {0};
	long last_total_connect_time = 0;
	char totalConnectTime[16] = {0};
	long lastDuraConTime = 0;
	long lastMonthlyTime = 0;
	time_t nowtime = 0;
	time(&nowtime);

	conneted_time = nowtime - last_connect_time;
	if (conneted_time < 0 || conneted_time > FLUXSTAT_MAX_WAIT_TIME) {
		slog(FLUXSTAT_PRINT, SLOG_ERR, "[flux]conneted_time =%ld, last_connect_time=%ld, nowtime=%ld\n", conneted_time, last_connect_time, nowtime);
		conneted_time = 0;
	}
	last_connect_time = nowtime;

	sc_cfg_get("realtime_time", tmp, sizeof(tmp));
	sscanf(tmp, "%ld", &lastDuraConTime);
	if (lastDuraConTime < 0 || lastDuraConTime > LONG_MAX-1)
		lastDuraConTime = 0;//kw 3

	memset(tmp, 0, sizeof(tmp));
	sc_cfg_get("duraConTime_before_time_modify", tmp, sizeof(tmp));
	sscanf(tmp, "%ld", &duraConTime_before_time_modify);
	if (duraConTime_before_time_modify < 0 || duraConTime_before_time_modify > LONG_MAX-1)
		duraConTime_before_time_modify = 0;
	if (duraConTime_before_time_modify) {
		sprintf(ConectedTimeStr, "%ld", conneted_time + duraConTime_before_time_modify);
		sc_cfg_set("duraConTime_before_time_modify", "0");
	} else
		sprintf(ConectedTimeStr, "%ld", conneted_time + lastDuraConTime);

	sc_cfg_set("realtime_time", ConectedTimeStr);

	memset(ConectedTimeStr, 0, sizeof(ConectedTimeStr));
	memset(tmp, 0, sizeof(tmp));

	sc_cfg_get("monthly_time", tmp, sizeof(tmp));
	sscanf(tmp, "%ld", &lastMonthlyTime);
	if (lastMonthlyTime < 0 || lastMonthlyTime > LONG_MAX-1)
		lastMonthlyTime = 0;//kw 3
	sprintf(ConectedTimeStr, "%ld", lastMonthlyTime + conneted_time);
	sc_cfg_set("monthly_time", ConectedTimeStr);


	memset(ConectedTimeStr, 0, sizeof(ConectedTimeStr));
	sc_cfg_get("flux_total_connect_time", totalConnectTime, sizeof(totalConnectTime));
	sscanf(totalConnectTime, "%ld", &last_total_connect_time);
	if (last_total_connect_time < 0 || last_total_connect_time > LONG_MAX-1)
		last_total_connect_time = 0;//kw 3
	last_total_connect_time = last_total_connect_time + conneted_time;
	sprintf(ConectedTimeStr, "%ld", last_total_connect_time);
	sc_cfg_set("flux_total_connect_time", ConectedTimeStr);
}

int fluxstat_main(int argc, char * argv[])
{
	int iMsgHandle = 0;
	int iRet = 0;
	int interruptSIG = 0;
	long nowtime;
	UINT32 iConnect_State = -1; //״̬0-Ͽ1-  2- 3-Ͽ
	UINT32 iSwitch_State = -1; //ͳƿ0-ر1-
	MSG_BUF stMsg;
	prctl(PR_SET_NAME, "fluxstat", 0, 0, 0);

	LONG msgSize =  sizeof(MSG_BUF) - sizeof(LONG);
	pthread_t  Create_Data_Thread_id;
	int  Create_Data_Thread_result = 0;
	pthread_attr_t attr;
	
	//NVʼӡ𣬲עᶯ̬ӡź
	loglevel_init();
	
	iMsgHandle = mc_create_msg_q();

	fluxstat_init();

	pthread_attr_init(&attr);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	Create_Data_Thread_result = pthread_create(&Create_Data_Thread_id, &attr, fluxstat_main_loop, NULL);
	pthread_attr_destroy(&attr);
	if (Create_Data_Thread_result != 0) {
		slog(FLUXSTAT_PRINT, SLOG_ERR, "Create_Data_Thread_result faild!\n");
		exit(-1);
	} else {
		slog(FLUXSTAT_PRINT, SLOG_NORMAL, "Create_Data_Thread_result SUCCESS!\n");
	}
	
 #if (PRODUCT_TYPE == PRODUCT_PHONE)
	platform_send_msg(MODULE_ID_FLUXSTAT,MODULE_ID_MMI_SVR,MSG_CMD_DATAMANAGER_FLUXSTAT_READY,0,NULL);
 #endif
	//Rndis״̬ϱ,atͳƷϢʼرͳ;ͳmmiϢ
	for (;;) {
		if (0 == interruptSIG) {
			slog(FLUXSTAT_PRINT, SLOG_ERR, "data begin to rcv msg from queue %d. \n", iMsgHandle);
		}
		memset(&stMsg, '\0', sizeof(stMsg));
		iRet = 0;

		//Ϣ
		iRet = msgrcv(iMsgHandle, &stMsg, msgSize, 0, 0);

		if (-1 == iRet) {
			if (EINTR == errno) {
				interruptSIG = 1;
				continue;
			} else {
				slog(FLUXSTAT_PRINT, SLOG_ERR,  "recv msg from the MODULE_ID_DATA fail errno=%d!\n", errno);
				return ERROR;
			}
		} else {
			interruptSIG = 1;
		}

		switch (stMsg.usMsgCmd) {
		case MSG_CMD_CHANNEL_CONNECT_STATUS: {
			iConnect_State = *(UINT32*)stMsg.aucDataBuf;
			slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux]MSG_CMD_CHANNEL_CONNECT_STATUS  come in.iConnect_State =%d\n", iConnect_State);
			if (1 == iConnect_State) {
				flux_enable_flag = 1;
				time(&last_connect_time);
				sc_cfg_set("syn_ppp_total", "0");
				ipc_send_message(MODULE_ID_FLUXSTAT, MODULE_ID_MMI, MSG_CMD_GET_TRAFFIC_INFO_START, 0, NULL, 0);
			} else if (0 == iConnect_State) {
				update_data_cfg();
				flux_enable_flag = 0;
				sc_cfg_set("syn_ppp_total", "0");
				ipc_send_message(MODULE_ID_FLUXSTAT, MODULE_ID_MMI, MSG_CMD_GET_TRAFFIC_INFO_END, 0, NULL, 0);
			}
			break;
		}
		case MSG_CMD_DATA_END: {
			update_data_cfg();
			flux_enable_flag = 0;
			sc_cfg_set("syn_ppp_total", "0");
			break;
		}	
		//̶̨
		case MSG_CMD_DATAMANAGER_SET_SWITCH_REQ: {
			iSwitch_State = *(UINT32*)stMsg.aucDataBuf;
			slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux]MSG_CMD_DATAMANAGER_SET_SWITCH_REQ  come in.iSwitch_State =%d\n", iSwitch_State);
			flux_enable_flag = 1;
			if(1 == iSwitch_State) {
				sc_cfg_set(NV_TRAFFIC_LIMIT_SWITCH, "1");
				g_need_send_flux_over = TRUE;
				g_need_send_flux_warnning = TRUE;
			} else if(0 == iSwitch_State) {
				sc_cfg_set(NV_TRAFFIC_LIMIT_SWITCH, "0");
			}
			break;
		}
		case MSG_CMD_DATAMANAGER_GET_INFO_REQ: {
			fluxstat_info info = {0};
			sc_cfg_get("traffic_month_total",info.total_flux,sizeof(info.total_flux));
			sc_cfg_get("flux_month_total",info.used_flux,sizeof(info.used_flux));
			sc_cfg_get(NV_TRAFFIC_ALERT_PERCENT,info.warn_percent,sizeof(info.warn_percent));
			slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux]MSG_CMD_DATAMANAGER_GET_INFO_REQ  total =%s,used = %s warn = %s\n", info.total_flux, info.used_flux, info.warn_percent);
			platform_send_msg(MODULE_ID_FLUXSTAT, MODULE_ID_MMI_SVR, MSG_CMD_DATAMANAGER_GET_INFO_RSP, sizeof(fluxstat_info), &info);
			break;
		}
		case MSG_CMD_DATAMANAGER_SET_TOTAL_REQ: {
			slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux]MSG_CMD_DATAMANAGER_SET_TOTAL_REQ  stMsg.aucDataBuf =%s\n", stMsg.aucDataBuf);
			sc_cfg_set("traffic_month_total",stMsg.aucDataBuf);
			g_need_send_flux_over = TRUE;
			g_need_send_flux_warnning = TRUE;
			platform_send_msg(MODULE_ID_FLUXSTAT, MODULE_ID_MMI_SVR, MSG_CMD_DATAMANAGER_SET_TOTAL_RSP, 0, NULL);
			break;
		}
		case MSG_CMD_DATAMANAGER_SET_WARNVALUE_REQ: {
			slog(FLUXSTAT_PRINT, SLOG_DEBUG, "[flux]MSG_CMD_DATAMANAGER_SET_WARNVALUE_REQ  stMsg.aucDataBuf =%s\n", stMsg.aucDataBuf);
			sc_cfg_set(NV_TRAFFIC_ALERT_PERCENT,stMsg.aucDataBuf);
			g_need_send_flux_over = TRUE;
			g_need_send_flux_warnning = TRUE;
			platform_send_msg(MODULE_ID_FLUXSTAT, MODULE_ID_MMI_SVR, MSG_CMD_DATAMANAGER_SET_WARNVALUE_RSP, 0, NULL);
			break;
		}
		case MSG_CMD_PDPSTATUS_SET_SWITCH_REQ:{ //ӿش򿪺֪ͨ
			iSwitch_State = *(UINT32*)stMsg.aucDataBuf;
			if(1 == iSwitch_State)
			{
				g_need_send_flux_over = TRUE;
				g_need_send_flux_warnning = TRUE;
			}
			break;			
		}
		default:
			break;
		}
	}
}


