/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     nvserver.h
* ļʶ:     nvserver.h
* ժҪ:     nv̨Ӧͷļ
* ʹ÷:     #include <nvserver.h>
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/09/20       V1.0        Create                    
* 
*******************************************************************************/
#ifndef _NVSERVER_H
#define _NVSERVER_H

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/    
#define NV_PATH_LEN             256
#define NV_HASH_LEN             512
#define NV_HASH_MUL             31
#define NV_MAX_CONFIG_LEN       512

#define NV_CONFIG_FILE          "/etc_ro/nvconfig"
#define NV_FS_PATH         		"/etc_rw/nv"
#define NV_FS_MAIN_PATH         "/etc_rw/nv/main"
#define NV_FS_BACKUP_PATH       "/etc_rw/nv/backup"

#define NV_BLOCK_SIZE           4096
#define NV_FILE_FLAG            0x123

#define NV_CFG   		"cfg"
#define NV_RO       	"ro"
#define NV_RTDEV    	"rtdev"
#define NV_CERT     	"cert"
#define NV_WAPI     	"wapi"
/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef enum { false, true } bool;

typedef struct nv_item
{
    char *key;
    char *value;
    int saveFlag;
    int update_flag;
    struct nv_item *next;
} T_NV_ITEM; 

typedef struct nv_config
{
    char configFile[NV_PATH_LEN];
    struct nv_config *next;
} T_NV_CONFIG;

typedef struct nv_node
{
    char nvFile[NV_PATH_LEN];
    T_NV_CONFIG *fileList;
    T_NV_ITEM *nvTable[NV_HASH_LEN];
    struct nv_node *next;
}T_NV_NODE ;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/
int nvupdate(char *nv_file, char *config_file, const char *key, const char *value, int saveFlag);
int  reloadFactroyParam(T_NV_NODE *list);
int  delete_not_needed(T_NV_NODE *list);
uint hash(const char *s);
int get_update_status (void);

#endif

