#include <stdio.h>
#include <unistd.h>
#include "zctrm_locknet.h"

int sendflag = 0;
void locknet_msg_proc(MSG_BUF *msg_buf)
{
	switch (msg_buf->usMsgCmd) {
	case MSG_CMD_LOCKLISTAUTH_REQ: 
		zCtrm_LocknetAuthProc(msg_buf);
		break;
	
	case MSG_CMD_LOCKNETLIST_SET_REQ: 
		zCtrm_LocknetListSet(msg_buf);
		break;
		
	case MSG_CMD_LOCKNETKEY_REQ: 
		zCtrm_LocknetKeyProc(msg_buf);
		break;

	case MSG_CMD_LOCKNETAMTSTATUS_GET_REQ: 
		zCtrm_LocknetAmtStatus(msg_buf);
		break;

	case MSG_CMD_LOCKNETDIGEST_GET_REQ:
		zCtrm_LocknetDigestGet(msg_buf);
		break;

	case MSG_CMD_LOCKNETSIGN_SET_REQ:
		zCtrm_LocknetSignSet(msg_buf);
		break;

	case MSG_CMD_LOCKNETLEVEL_GET_REQ:
		zCtrm_LocknetLevel(msg_buf);
		break;

	case MSG_CMD_LOCKNETLIST_GET_REQ:
		zCtrm_LocknetListGetProc(msg_buf);
		break;
		
	case MSG_CMD_LOCKNETAUTH_REQ:
		sendflag = 1;
		zCtrm_makeLocknetAuth(msg_buf);
		break;

	case MSG_CMD_LOCKNETUNLOCKTIMES_GET_REQ:
		zCtrm_LocknetUnlockTimes(msg_buf);
		break;
		
	case MSG_CMD_LOCKNETSTATUS_GET_REQ: 
		zCtrm_LocknetStatus(msg_buf);
		break;
	
	case MSG_CMD_LOCKNETUNLOCK_REQ: 
		zCtrm_LocknetUnlock(msg_buf);
		break;
	case MSG_CMD_ZURDY_LOCKAUTH_REQ:
		zCtrm_makeLocknetAuth(msg_buf);
		break;
	default:
		break;
	}
}

int zte_locknet_main(int argc, char* argv[])
{
	int msg_handle = 0;
	MSG_BUF msg;
	LONG msg_size =  sizeof(MSG_BUF)-sizeof(LONG);
	prctl(PR_SET_NAME, "locknet", 0, 0, 0);
	/* Ϣ*/
	msg_handle = msgget(MODULE_ID_LOCKNET, IPC_CREAT|0600);
	while(1)
	{
		memset(&msg, 0x00, sizeof(MSG_BUF));

		/* ȡϢϢ*/
		if (msgrcv(msg_handle, &msg, msg_size, 0, 0) >= 0)
		{
			locknet_msg_proc(&msg); 		   
		}
		else
		{
			if(errno != EINTR)
				slog(AT_PRINT,SLOG_ERR,"locknet_main msgrcv errno = %d, errmsg = %s\n", errno,strerror(errno));
		}
	}

	return 0;
}
