/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_batterry_adapter.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIȡ͵Ϣ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
******************************************************************************/


/************************************************************************************
                           ͷļ
***********************************************************************************/
#include <linux/netlink.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "mmi_common.h"
#include "mmi_lcd.h"

static BOOL g_mmi_dischg_switch_off = FALSE;//ŵرտأĬŵ
static BOOL g_mmi_dischg_low_current_switch = FALSE;    //ĬϷŵǸߵ1.5A
static UINT32 s_mmi_dischargeoff_voltage_num_low = 0;	//0.5AӦѹĴ÷ŵ0.5A
static UINT32 s_mmi_dischargeoff_voltage_num_high = 0;	//1.5AӦѹĴ÷ŵ1.5A
extern E_zMmiShowMode g_showMode;
extern UINT32 g_temp_protect;
extern UINT32 g_discharge_protect;
extern UINT32 g_fast_poweron;
/***********************************************************************************
˵ȡŵǷ帺״̬
***********************************************************************************/
BOOL mmi_get_load_state(VOID)
{
	char load_state_buf[8] = {0};
	int len = 0;
	FILE* fd_boost_state = NULL;

	fd_boost_state = fopen(BOOST_LOAD_STATUS_PATH, "r");
	if (fd_boost_state == NULL) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_load_state open boost file fail!\n");
		//MMI_ASSERT(0);
		return FALSE;
	}
	len = fread(load_state_buf, 1, 2, fd_boost_state);
	if (len > 0) { //kw 3
		fclose(fd_boost_state);
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_load_state load_state_buf=%s!\n", load_state_buf);
		if (strncmp(load_state_buf, "1", strlen("1")) == 0) {
			return TRUE;
		} else if (strncmp(load_state_buf, "0", strlen("0")) == 0) {
			return FALSE;
		} else {
			slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_load_state read load_state error!\n");
			return FALSE;
		}
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_load_state read boost file fail len = %d!\n", len);
		fclose(fd_boost_state);
		return FALSE;
	}
}

/***********************************************************************************
˵÷ŵ翪ش/ر
***********************************************************************************/
VOID mmi_set_discharge_info(VOID)
{
	BOOL isLoadFlag = FALSE;
	isLoadFlag = mmi_get_load_state();
	if (isLoadFlag) {
		if (g_mmi_dischg_switch_off) {
			mmi_set_discharge_switch(TRUE);
			slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_set_discharge_info HAVE_Load MMI_TURN_ON_DISCHG!!!\n");
			g_mmi_dischg_switch_off = FALSE;
		}
	} else {
		if (!g_mmi_dischg_switch_off) {
			mmi_set_discharge_switch(FALSE);
			slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_set_discharge_info NO_Load MMI_TURN_OFF_DISCHG!!!\n");
			g_mmi_dischg_switch_off = TRUE;
		}
	}
}

/***************************************************************************************
˵:ʼ״̬ǷиأǷҪ򿪷ŵ翪
***************************************************************************************/
VOID mmi_load_state_init(VOID)
{
	mmi_set_discharge_info();
}

/**********************************************************************************
*:֪battery/رշŵ繦
***********************************************************************************/
VOID mmi_set_discharge_switch(BOOL discharge_protect_flag)
{
	if (discharge_protect_flag) {
		system(MMI_TURN_ON_DISCHG);
	} else {
		system(MMI_TURN_OFF_DISCHG);
	}
}

/***********************************************************************************
:͵ŵ籣
***********************************************************************************/
VOID mmi_lowbattery_discharge_protect(UINT32 voltagepower)
{
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_lowbattery_discharge_protect voltagepower = %d !!\n", voltagepower);
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_lowbattery_discharge_protect s_mmi_dischargeoff_voltage_num_low = %d, s_mmi_dischargeoff_voltage_num_high = %d !!\n", s_mmi_dischargeoff_voltage_num_low, s_mmi_dischargeoff_voltage_num_high);
	BOOL isLoadFlag = FALSE;
	isLoadFlag = mmi_get_load_state();
	if (isLoadFlag) {
		if (voltagepower < DISCHARGELEVEL) {
			s_mmi_dischargeoff_voltage_num_high = 0;
			s_mmi_dischargeoff_voltage_num_low ++ ;
			if (s_mmi_dischargeoff_voltage_num_low == 3) {
				s_mmi_dischargeoff_voltage_num_low = 0;
				if (!g_mmi_dischg_low_current_switch) {
					mmi_set_discharge_low_current(TRUE);
					slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_lowbattery_discharge_protect turn to LOW current!!!\n");
					g_mmi_dischg_low_current_switch = TRUE;
				}
			}
		} else if (voltagepower > CHARGINGLEVEL) {
			s_mmi_dischargeoff_voltage_num_low = 0;
			s_mmi_dischargeoff_voltage_num_high ++ ;
			if (s_mmi_dischargeoff_voltage_num_high == 3) {
				s_mmi_dischargeoff_voltage_num_high = 0;
				if (g_mmi_dischg_low_current_switch) {
					mmi_set_discharge_low_current(FALSE);
					slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_lowbattery_discharge_protect turn to HIGH current!!!\n");
					g_mmi_dischg_low_current_switch = FALSE;
				}
			}
		} else {
			s_mmi_dischargeoff_voltage_num_low = 0;
			s_mmi_dischargeoff_voltage_num_high = 0;
		}
	} else {
		mmi_set_discharge_switch(FALSE);
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_lowbattery_discharge_protect NO_Load MMI_TURN_OFF_DISCHG!!!\n");
	}
}

/**
 * @brief ٿ/ػЧжϣ
 * @param 
 * @return TRUEʾЧִпٿ/ػֵʾЧֱӷ
 * @note   ٿ/ػҪȴһη͸ATķģʽϢɲſԼ
 * @warning 
 */
BOOL mmi_valid_fast_onoff(){
    char rsqFlag[NV_CONTENT_LEN] = {0};
    BOOL longPress = TRUE;//־
    sc_cfg_get("cfun_work", rsqFlag, sizeof(rsqFlag));//һεMSG_CMD_AIRMODE_SET_REQǷ
    
    if (!g_fast_poweron) {//δٿػ
        slog(MMI_PRINT, SLOG_NORMAL, "MMI fast_poweron fail,g_fast_poweron=FALSE!! \n\n");
        return FALSE;
    }
    
    while (!strcmp(rsqFlag, "work")) {
        longPress = mmi_get_longpress_flag();
        if(FALSE == longPress){
            slog(MMI_PRINT, SLOG_NORMAL, "MMI fast_poweron fail,no AIRMODE_RSQ!! \n\n");
            return FALSE;
        }
        mmi_ms_sleep(100);
        sc_cfg_get("cfun_work", rsqFlag, sizeof(rsqFlag));
    }
    return TRUE;
}

/***********************************************************************************
:5Sػ
***********************************************************************************/
VOID mmi_handle_fast_poweroff(VOID)
{
	int airmode = 1;
	int usbmode = 0;
	struct ext_msg_data ext_data;

	if(!mmi_valid_fast_onoff()){
		slog(MMI_PRINT, SLOG_NORMAL, "MMI fast_poweron STOP!! \n\n");
		return ;
	}
	sc_cfg_set(NV_FAKE_POWEROFF_STATE, "1");
	ext_data.cmd = Ext_Cmd_POWEROFF_FAKE;
	mmi_wifi_operate(WIFI_TURN_OFF_FAKE_POWEROFF);
	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_handle_fast_poweroff!! \n\n");
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_AT_CTL, (USHORT)MSG_CMD_AIRMODE_SET_REQ, sizeof(int), (CHAR *)(&airmode), 0);
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_USBCFGMNG, (USHORT)MSG_CMD_FASTPOWER_IND, sizeof(int), (CHAR *)(&usbmode), 0);
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_MAIN_CTRL, (USHORT)MSG_CMD_POWEROFF_RSP, sizeof(struct ext_msg_data), (CHAR *)(&ext_data), 0);

	slog(MMI_PRINT, SLOG_DEBUG, "mmi_handle_fast_poweroff!!! play poweroff donghua!!!\n");
	mmi_play_poweroff_cartoon(MMI_POWEROFF_MODE);

	if ((mmi_get_charge_state() == STATE_CHARGING) || (mmi_get_charge_state() == STATE_FULL)) {
		mmi_set_lcd_mode(MMI_FAKE_POWEROFF_CHARGE_MODE);
		mmi_set_led_mode(MMI_FAKE_POWEROFF_CHARGE_MODE);
		mmi_set_update_flag(MMI_TASK_CTRL);
		mmi_set_update_flag(MMI_TASK_BATTERY);

	} else {
		mmi_set_lcd_mode(MMI_FAKE_POWEROFF_MODE);
		mmi_set_led_mode(MMI_FAKE_POWEROFF_MODE);
		mmi_set_update_flag(MMI_TASK_CTRL);
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_handle_fast_poweroff set mode fake poweroff!!\n");
}

VOID mmi_handle_fast_poweron(VOID)
{
	int airmode = 0;
	int usbmode = 1;

	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_handle_fast_poweron!! \n\n");
    //ATģʽӦҪȴ
	if(!mmi_valid_fast_onoff()){
		slog(MMI_PRINT, SLOG_NORMAL, "MMI fast_poweron fail,no AIRMODE_RSQ!! \n\n");
		return ;
	}
	
	set_wake_lock(MMI_MAIN_LOCK_ID);
	sc_cfg_set(NV_FAKE_POWEROFF_STATE, "0");
	mmi_wifi_operate(WIFI_TURN_ON);
	//Ļ 
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_set_work_mode MMI_FAST_POWERON_MODE!! \n\n");
	mmi_set_lcd_mode(MMI_FAST_POWERON_MODE);
	mmi_set_led_mode(MMI_FAST_POWERON_MODE);
	mmi_set_update_flag(MMI_TASK_CTRL);

	ipc_send_message(MODULE_ID_MMI, MODULE_ID_AT_CTL, (USHORT)MSG_CMD_AIRMODE_SET_REQ, sizeof(int), (CHAR *)(&airmode), 0);
	ipc_send_message(MODULE_ID_MMI, MODULE_ID_USBCFGMNG, (USHORT)MSG_CMD_FASTPOWER_IND, sizeof(int), (CHAR *)(&usbmode), 0);

	if (g_discharge_protect) {
		mmi_set_discharge_switch(TRUE);
	}
}

