/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_traffic_led.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIƲ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
#include <limits.h>
#include <float.h>
#include "mmi_common.h"

/**********************************************************************************
						ȫֱ
***********************************************************************************/
static MMI_TRAFFIC_SWITCH s_mmi_traffic_switch = TRAFFIC_LIMIT_SWITCH_OFF;//webuiǷ

static MMI_TRAFFIC_LED s_mmi_t_status = TRAFFIC_LED_MAX;
static MMI_TRAFFIC_LED s_mmi_t_status_ex = TRAFFIC_LED_MAX;

static SINT32 s_low_traffic_flag = 0;//ǲǳ
static SINT32 s_warning_tip_flag = 0;
static UINT32 s_warning_tip_level = 100;//lcd֮ǰҪʾ澯ĺ
static float s_mmi_total_traffic = 0;//
static float s_mmi_used_traffic = 0;//ʹ
static E_ZMmi_Traffic_Data_Unit s_mmi_data_unit = TRAFFIC_DATA_UNIT_MAX;//ʾʱĵλ
static E_ZMmi_Traffic_Data_Unit s_mmi_useddata_unit = TRAFFIC_DATA_UNIT_MAX;//ʹʾʱĵλ
static MMI_TRAFFIC_UNIT s_mmi_traffic_unit = TRAFFIC_UNIT_MAX;//ʱʾ
extern E_zMmiShowMode g_showMode;

SINT32 mmi_get_trafficinfo(UINT32 trafficinfo)
{
	if (trafficinfo != 0) {
		T_zMMITrafficInfo * pTrafficInfo = (T_zMMITrafficInfo *)trafficinfo;
		pTrafficInfo->led_status = s_mmi_t_status;
		pTrafficInfo->traffic_switch = s_mmi_traffic_switch;
		pTrafficInfo->traffic_unit = s_mmi_traffic_unit;
		pTrafficInfo->warning_tip_flag = s_warning_tip_flag;
		pTrafficInfo->warning_tip_level = s_warning_tip_level;
		pTrafficInfo->total_traffic = s_mmi_total_traffic;
		pTrafficInfo->uesd_traffic = s_mmi_used_traffic;
		pTrafficInfo->data_unit = s_mmi_data_unit;
		pTrafficInfo->useddata_unit = s_mmi_useddata_unit;
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_trafficinfo total = %f  used = %f!\n", pTrafficInfo->total_traffic, pTrafficInfo->uesd_traffic);
	}
	return MMI_SUCCESS;
}

SINT32 mmi_RegisterTrafficTaskInfoItem()
{
	T_zMMITaskInfoItem trafficTaskInfoItem = {0};
	trafficTaskInfoItem.task = MMI_TASK_TRAFFIC;
	trafficTaskInfoItem.taskinfo = (VOID *)malloc(sizeof(T_zMMITrafficInfo));
	trafficTaskInfoItem.get_taskinfo_fun = mmi_get_trafficinfo;
	trafficTaskInfoItem.get_ledinfo_fun = mmi_getLedTrafficInfo;
#ifndef DISABLE_LCD
	trafficTaskInfoItem.get_lcdinfo_fun = mmi_getLcdTrafficInfo;
#endif
	trafficTaskInfoItem.ledinfo = (VOID *)malloc(sizeof(T_zMmi_Led_Info));
	//trafficAppInfoItem.show_mode = 2;

	mmi_register_taskinfo_item(&trafficTaskInfoItem);
	return MMI_SUCCESS;
}

static VOID mmi_set_traffic_update()
{
	if (g_showMode == MMI_MODE_LCD || g_showMode == MMI_MODE_ALL) {
		mmi_set_update_flag(MMI_TASK_TRAFFIC);
	}
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		E_zMmi_Work_Mode mode = mmi_get_led_mode();
		if (mode != MMI_RESET_MODE && mode != MMI_RESTART_MODE && mode != MMI_POWEROFF_MODE && mode != MMI_IDLE_LEDOFF_MODE && mode != MMI_IDLE_CHG_LEDOFF_MODE
		    && mode != MMI_FAKE_POWEROFF_MODE && mode != MMI_FAKE_POWEROFF_CHARGE_MODE && mode != MMI_IDLE_STANDBY_LEDOFF_MODE) {
			mmi_set_update_flag(MMI_TASK_TRAFFIC);
		}
	}
}

/**********************************************************************************
:ʹжϵǰ״̬
***********************************************************************************/
static VOID mmi_judge_traffic_status(UINT32 t_traffic, UINT32 u_traffic)
{
	SINT32 leaved_traffic = 0;
	UINT32 i = 0;
	if (u_traffic == 0) {
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_judge_traffic_status  u_traffic is too small!\n");
		s_mmi_t_status = (MMI_TRAFFIC_LED)9;
		return;
	}
	leaved_traffic = t_traffic - u_traffic;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_judge_traffic_status  leaved_traffic = %d !\n", leaved_traffic);
	if (leaved_traffic <= 0) {
		s_mmi_t_status = (MMI_TRAFFIC_LED)0;
		return;
	}

	leaved_traffic = leaved_traffic * 10;
	for (i = 0; i < 10; i++) {
#if MMI_DEBUG
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_judge_traffic_status i = %d   t_traffic * i=%d t_traffic* (i+1)=%d!\n", i, t_traffic * i, t_traffic * (i + 1));
#endif
		if (((UINT32)leaved_traffic > t_traffic * i) && ((UINT32)leaved_traffic <= t_traffic * (i + 1))) {
			s_mmi_t_status = (MMI_TRAFFIC_LED)i;
			slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_judge_traffic_status s_mmi_t_status = %d!\n", s_mmi_t_status);
			return;
		}
	}
	//κһԼs_mmi_t_statusһֵֵֹЧƲ
	s_mmi_t_status = (MMI_TRAFFIC_LED)9;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_judge_traffic_status invalid s_mmi_t_status !\n");
}


/**********************************************************************************
:ȡ⿪״̬
***********************************************************************************/
static VOID mmi_get_traffic_limit_switch(VOID)
{
	CHAR m_switch[2] = {0};
	sc_cfg_get(NV_TRAFFIC_LIMIT_SWITCH, m_switch, sizeof(m_switch));
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_traffic_limit_switch m_switch = %s!\n", m_switch);
	if (!(strncmp(m_switch, "1", 2))) {
		s_mmi_traffic_switch = TRAFFIC_LIMIT_SWITCH_ON;
	} else if (!(strncmp(m_switch, "0", 2))) {
		s_mmi_traffic_switch = TRAFFIC_LIMIT_SWITCH_OFF;
	} else {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_traffic_limit_switch error!\n");
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_traffic_limit_switch s_mmi_traffic_switch = %d!\n", s_mmi_traffic_switch);
}

/**********************************************************************************
:ȡǰλ
***********************************************************************************/
static MMI_TRAFFIC_UNIT mmi_get_traffic_unit(VOID)
{
	CHAR m_unit[5] = {0};
	MMI_TRAFFIC_UNIT traffic_unit = TRAFFIC_UNIT_MAX;
	if (s_mmi_traffic_switch == TRAFFIC_LIMIT_SWITCH_ON) {
		sc_cfg_get(NV_TRAFFIC_LIMIT_UNIT, m_unit, sizeof(m_unit));
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_traffic_unit m_unit = %s!\n", m_unit);
		if (!(strncmp(m_unit, NV_TRAFFIC_LIMIT_UNIT_DATA, 5))) {
			traffic_unit = TRAFFIC_UNIT_DATA;
		} else if (!(strncmp(m_unit, NV_TRAFFIC_LIMIT_UNIT_TIME, 5))) {
			traffic_unit = TRAFFIC_UNIT_TIME;
		} else {
			slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_traffic_unit error!\n");
		}
	} else {
		traffic_unit = TRAFFIC_UNIT_DATA;
	}
	s_mmi_traffic_unit = traffic_unit;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_traffic_unit traffic_unit = %d! s_mmi_traffic_unit = %d\n", traffic_unit, s_mmi_traffic_unit);
	return traffic_unit;

}

/**********************************************************************************
:ȡ澯ֵ
***********************************************************************************/
static UINT32 mmi_get_warning_traffic(VOID)
{
	char m_warn_data[4] = {0};
	UINT32 m_warn_value = 0;
	UINT32 warn_level = 0;
	UINT32 i = 0;
	sc_cfg_get(NV_TRAFFIC_ALERT_PERCENT, m_warn_data, sizeof(m_warn_data));
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_warning_traffic m_warn_data = %s!\n", m_warn_data);
	m_warn_value = strlen(m_warn_data) == 0 ? 0 : atoi(m_warn_data);
	if (m_warn_value > INT_MAX-1) {//kw 3
		m_warn_value = 0;
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_warning_traffic errdata = %s!\n", m_warn_data);
	}
	s_warning_tip_level = m_warn_value;
	if (m_warn_value == 100) {
		warn_level = 0;
		return warn_level;
	} else {
		for (i = 0; i < 10; i++) {
			if (m_warn_value >= 10 * i && m_warn_value < 10 * (i + 1)) {
				warn_level = 9 - i;
				slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_warning_traffic warn_level = %d!\n", warn_level);
				return warn_level;
			}
		}
	}
	return 0;

}
static VOID mmi_set_used_data(float used_data)
{
	float used_data_MB = 0;
	float used_data_GB = 0;

	used_data_MB = used_data / (1024 * 1024);
	if (used_data_MB > 1024) {
		used_data_GB = used_data_MB / 1024;
		if (used_data_GB > 1024) {
			s_mmi_useddata_unit = TRAFFIC_DATA_UNIT_TB;
			s_mmi_used_traffic = used_data_GB / 1024;
		} else {
			s_mmi_useddata_unit = TRAFFIC_DATA_UNIT_GB;
			s_mmi_used_traffic = used_data_GB;
		}
	} else {
		s_mmi_useddata_unit = TRAFFIC_DATA_UNIT_MB;
		s_mmi_used_traffic = used_data_MB;
	}

}

/**********************************************************************************
:ȡʹֵ
***********************************************************************************/
static UINT32 mmi_get_used_traffic(MMI_TRAFFIC_UNIT t_unit)
{
	char m_used_data[25] = {0};
	UINT32 used_traffic = 0;
	if (t_unit == TRAFFIC_UNIT_TIME) {
		sc_cfg_get(NV_TRAFFIC_USED_TIME, m_used_data, sizeof(m_used_data));
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_used_traffic UNIT_TIME m_used_data = %s!\n", m_used_data);
		UINT32 m_used_data_time_value = strlen(m_used_data) == 0 ? 0 : (UINT32)(atoi(m_used_data));
		if(m_used_data_time_value > INT_MAX-1) { //kw 3
			slog(MMI_PRINT, SLOG_ERR, "MMI UNIT_TIME err m_used_data =%s-->%u!\n", m_used_data, m_used_data_time_value);
			m_used_data_time_value = 0;
		}
		used_traffic = m_used_data_time_value / (60 * 60);
		float m_user_data_time_value_f = (float)m_used_data_time_value;
		s_mmi_used_traffic = m_user_data_time_value_f / (60 * 60);
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_used_traffic used_traffic = %d!,s_mmi_used_traffic=%f\n", used_traffic, s_mmi_used_traffic);
	} else if (t_unit == TRAFFIC_UNIT_DATA) {
		sc_cfg_get(NV_TRAFFIC_USED_DATA, m_used_data, sizeof(m_used_data));
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_used_traffic UNIT_DATA m_used_data = %s!\n", m_used_data);
		long long m_user_data_value = atoll(m_used_data);
		if(m_user_data_value < 0 || m_user_data_value > LLONG_MAX-1) { //kw 3
			slog(MMI_PRINT, SLOG_ERR, "MMI UNIT_DATA err m_used_data =%s-->%lld!\n", m_used_data, m_user_data_value);
			m_user_data_value = 0;
		}

		if (s_low_traffic_flag == 1) {
			used_traffic = (UINT32)(m_user_data_value / 1024);
		} else {
			used_traffic = (UINT32)(m_user_data_value / (1024 * 1024));
		}
		
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_used_traffic m_user_data_value = %lld!\n", m_user_data_value);
		float m_user_data_value_f = (float)m_user_data_value;
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_used_traffic m_user_data_value_f = %f!\n", m_user_data_value_f);
		if (s_mmi_traffic_switch == TRAFFIC_LIMIT_SWITCH_OFF) {
			mmi_set_used_data(m_user_data_value_f);
		} else {
			if (s_mmi_data_unit == TRAFFIC_DATA_UNIT_MB) {
				s_mmi_used_traffic = m_user_data_value_f / (1024 * 1024);
			} else if (s_mmi_data_unit == TRAFFIC_DATA_UNIT_GB) {
				s_mmi_used_traffic = m_user_data_value_f / (1024 * 1024);
				s_mmi_used_traffic = s_mmi_used_traffic / (1024);
			} else if (s_mmi_data_unit == TRAFFIC_DATA_UNIT_TB) {
				s_mmi_used_traffic = m_user_data_value_f / (1024 * 1024);
				s_mmi_used_traffic = s_mmi_used_traffic / (1024 * 1024);
			} else {
				s_mmi_used_traffic = m_user_data_value_f / (1024 * 1024);
			}
		}
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_used_traffic used_traffic = %d!,s_mmi_used_traffic=%f\n", used_traffic, s_mmi_used_traffic);
	}

	return used_traffic;
}


/**********************************************************************************
:ȡʹֵ
***********************************************************************************/
static UINT32 mmi_get_total_traffic(MMI_TRAFFIC_UNIT t_unit)
{
	CHAR m_traffic[30] = {0};
	float dataValue = 0;
	UINT32 unitValue = 0;
	float t_traffic = 0;
	sc_cfg_get(NV_TRAFFIC_LIMIT_SIZE, m_traffic, sizeof(m_traffic));
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_total_traffic m_traffic = %s!\n", m_traffic);
	if (s_mmi_traffic_switch == TRAFFIC_LIMIT_SWITCH_OFF) {
		s_mmi_total_traffic = 0;
		return t_traffic;
	}
	if (t_unit == TRAFFIC_UNIT_DATA) {
		sscanf((const char *)m_traffic, "%f_%lu", &dataValue, &unitValue);
		if(dataValue < 0 || dataValue > FLT_MAX) { //kw 3
			slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_total_traffic err dataValue =%f!\n", dataValue);
			dataValue = 0;
		}

		if (unitValue == 1) {
			s_mmi_data_unit = TRAFFIC_DATA_UNIT_MB;
		} else if (unitValue == 1024) {
			s_mmi_data_unit = TRAFFIC_DATA_UNIT_GB;
		} else if (unitValue == 1048576) {
			s_mmi_data_unit = TRAFFIC_DATA_UNIT_TB;
		} else {
			s_mmi_data_unit = TRAFFIC_DATA_UNIT_MB;
			slog(MMI_PRINT, SLOG_ERR, "MMI mmi_get_total_traffic err unitValue=%lu!\n", unitValue);
			unitValue = 1;//kw 3
		}
		slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_total_traffic s_mmi_data_unit = %d!\n", s_mmi_data_unit);
		t_traffic = dataValue * unitValue;
		s_mmi_total_traffic = dataValue;
		if (t_traffic <= 10) {
			t_traffic = t_traffic * 1024;
			s_low_traffic_flag = 1;
		} else {
			s_low_traffic_flag = 0;
		}
	} else if (t_unit == TRAFFIC_UNIT_TIME) {
		if (strlen(m_traffic) == 0) {
			t_traffic = 0;
		} else {
			t_traffic = atof(m_traffic);
		}
		s_mmi_total_traffic = t_traffic;
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_total_traffic t_traffic = %f!\n", t_traffic);
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_total_traffic s_mmi_total_traffic = %f!\n", s_mmi_total_traffic);
	return t_traffic;
}

/**********************************************************************************
:ȡϢ---⿪ءλֵ
***********************************************************************************/
VOID mmi_get_traffic_info(VOID)
{
	UINT32 used_traffic = 0;
	UINT32 total_traffic = 0;
	MMI_TRAFFIC_UNIT t_unit = TRAFFIC_UNIT_MAX;
	mmi_get_traffic_limit_switch();
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		if (s_mmi_traffic_switch != TRAFFIC_LIMIT_SWITCH_ON || mmi_get_net_state() == 0) {
			return;
		}
	}

	t_unit = mmi_get_traffic_unit();
	total_traffic = mmi_get_total_traffic(t_unit);
	used_traffic = mmi_get_used_traffic(t_unit);
	mmi_get_warning_traffic();
	mmi_judge_traffic_status(total_traffic, used_traffic);
}

/**********************************************************************************
:
***********************************************************************************/
VOID mmi_set_trafficled_on(VOID)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI TRAFFIC_LED ON!!!\n");
	s_mmi_t_status_ex = (MMI_TRAFFIC_LED)0;
	mmi_set_traffic_update();
}

/**********************************************************************************
:ȡϢʱص
***********************************************************************************/
static VOID * mmi_get_traffic_info_timer_callback(VOID *arg)
{
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_get_traffic_info_timer_callback!!!\n");
	if (s_mmi_traffic_switch == TRAFFIC_LIMIT_SWITCH_ON && mmi_get_net_state() == 1) {
		mmi_get_traffic_info();
		mmi_set_traffic_update();
	}
	return NULL;
}

/**********************************************************************************
:صзԼϢ
***********************************************************************************/
SINT32 zMMI_Handle_Msg_Get_TafficInfo_Start(VOID* data)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Get_TafficInfo_Start !!!\n");
	int ret = -1;
	ret = sc_timer_create(SET_TRAFFIC_INFO_WAIT_TIMER, TIMER_FLAG_RESTART, SET_TRAFFIC_INFO_WAIT_TIME, &mmi_get_traffic_info_timer_callback, NULL);
	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, " MMI TafficInfo_Start_Timer FAILED,cause=%d!!\n", ret);
	}
	mmi_get_traffic_info();
	mmi_set_traffic_update();
	return 0;
}

SINT32 zMMI_Handle_Msg_Get_TafficInfo_End(VOID* data)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_Get_TafficInfo_End !!!\n");
	sc_timer_delete(SET_TRAFFIC_INFO_WAIT_TIMER);
	//Ͽ磬ر澯
	s_warning_tip_level = 0;
	mmi_set_traffic_update();
	return 0;
}

SINT32 zMMI_Handle_Msg_TafficInfo_Reset(VOID* data)
{
	slog(MMI_PRINT, SLOG_NORMAL, "MMI zMMI_Handle_Msg_TafficInfo_Reset !!!\n");
	s_mmi_t_status_ex = (MMI_TRAFFIC_LED)0;
	mmi_get_traffic_info();
	mmi_set_traffic_update();
	return 0;
}

/**********************************************************************************
:MMI ѭⶨʱKILL  ػʱ
***********************************************************************************/
VOID mmi_kill_traffic_timer(VOID)
{
	if (g_showMode == MMI_MODE_LED || g_showMode == MMI_MODE_ALL) {
		sc_timer_delete(SET_TRAFFIC_INFO_WAIT_TIMER);
	}
}

/**********************************************************************************
:Ƴʼ
***********************************************************************************/
VOID mmi_traffic_init(VOID)
{
	int ret = -1;
	mmi_get_traffic_info();
	mmi_set_traffic_update();

	if (s_mmi_traffic_switch == TRAFFIC_LIMIT_SWITCH_ON) {
		ret = sc_timer_create(SET_TRAFFIC_INFO_WAIT_TIMER, TIMER_FLAG_RESTART, SET_TRAFFIC_INFO_WAIT_TIME, &mmi_get_traffic_info_timer_callback, NULL);
		if (ret != 0) {
			slog(MMI_PRINT, SLOG_ERR, " MMI Taffic init Start Timer FAILED,cause=%d!!\n", ret);
		}
	}

	slog(MMI_PRINT, SLOG_NORMAL, "MMI mmi_traffic_led_init finish!!!\n");
}

