#!/bin/sh

cd ../../..
SRC_PATH=`pwd`
KEYS_PATH=$SRC_PATH/../tools/SignImage
BIN_PATH=$SRC_PATH/prj/"$chip"/"$board"/bin

cd $SRC_PATH/common/src/uboot

make mrproper
rm -f ./u-boot*
rm -fr ./compressed_bin


echo "--Configuring [ "$chip"_boot_config ] for [ "$chip" "$board" "$key_path"] board ...";

############################################################
# project setting
############################################################

is_ok=0

if
	make "$chip"_boot_config;
then
	if	make platform; then
		if make together; then
			is_ok=1
		fi
	fi
fi

if [ $is_ok -eq 1 ];then	
	echo "";
	echo "--Configuring [ "$chip"_boot_config ] for [ "$chip" "$board" "$key_path"] board ...";
	echo "--Finished build [ u-boot.bin ] ...";

	if
		cp compressed_bin/compressed.bin $SRC_PATH/common/scripts/tools;
		cd $SRC_PATH/common/scripts/tools;
		./mkimage -A arm -O u-boot -C none -a "$ram_text" -e "$ram_text" \
					-n ZX297520 -d compressed.bin compressed.bin.head;
	then
		echo "Finished add head to [ u-boot.bin.head ] ...";

		rm compressed.bin;
		mv compressed.bin.head uboot.bin;
		cp uboot.bin tboot.bin
		mv tboot.bin $BIN_PATH/tboot.bin
		
		mkdir -p $KEYS_PATH/Input
		mkdir -p $KEYS_PATH/Output
		chmod -R 777 $SRC_PATH/
		cp uboot.bin $KEYS_PATH/Input/uboot.bin
		rm uboot.bin;
		chmod -R a+x $KEYS_PATH/
		cd $KEYS_PATH/
		./SignImage -s ./Input/uboot.bin ./Output/uboot.bin ./test_key/"$key_path"/private.k
		cp ./Output/uboot.bin $BIN_PATH/uboot.bin
		cp $BIN_PATH/uboot.bin $BIN_PATH/uboot-mirr.bin
		rm -rf Input
		rm -rf Output
		
		cd $SRC_PATH/common/src/uboot;
		cp ./u-boot $BIN_PATH
		cp ./u-boot.map $BIN_PATH

		echo "--Finished build [uboot.bin] ...";
		echo "...............................................OK....";
	fi
fi
