/*
 * (C) Copyright 2016 ZXIC Inc.
 */
#include <asm/io.h>
#include <asm/arch/top_clock.h>
 
#include "flash.h"

struct flash_type flash;

/*
 ******************************************************************************
 * Function:     
 * Description: 
 * Parameters:
 *	 Input:
 *	 Output:
 * Returns:
 * Others:
 *******************************************************************************
 */
char get_boot_mode(void)
{
	char boot_info = 0;

	boot_info = readl(BOOTSEL_INFO);

	if(((boot_info >> 4)&0x3) == 0x3)
	{
		return NOR_BOOT;
	}
	else
	{
		if(((boot_info & 0x7) == 0x0) || ((boot_info & 0x7) == 0x1))
		{
			return NAND_BOOT;
		}
		else if(((boot_info & 0x7) == 0x4) || ((boot_info & 0x7) == 0x5))
		{
			return SPI_NAND_BOOT;
		}
		else
		{
			return OTHER_BOOT;
		}
	}
}



