/*
 * (C) Copyright 2016 ZXIC Inc. 
 *
 */

#ifndef __IMAGE_H__
#define __IMAGE_H__

#define IH_NMLEN		32	    /* Image Name Length		*/
#define IH_MAGIC	0x27051956	/* Image Magic Number		*/


#define CFG_PARTITION_MAGIC                 0x31594876      /* ͬ U-BOOT */



/*
    +--------------+
    |     magic    |        uint32_t
    +--------------+
    |    version   |        uint32_t          
    +--------------+
    |  entry nums  |        uint32_t
    +--------------+
    |     crc      |        uint32_t          
    +==============+
    |    name[1]   |                  
    +--------------+
    |    offset    |                  
    +--------------+
    |     size     |                  
    +==============+
    |              |                  
    +==============+
    |              | 
    +==============+
    
*/
#define MAX_ENTRYS                  30 

typedef struct partition_entry {
    unsigned char	part_name[16]; 
    unsigned char   part_type[16];
    unsigned int    part_offset; 
    unsigned int    part_size;            
}partition_entry_t;

typedef struct partition_table {
    unsigned int       magic;
    unsigned char      platform_name[16];
    unsigned int       version;             /* 汾 */
    unsigned int       entrys;              /* ܵķ */
    unsigned int       crc;
    partition_entry_t  table[MAX_ENTRYS];   
}partition_table_t;

//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC)
/*
flags partition

*/
/*˫ϵͳ*/
#define FLAGS_BOOT_FOTA_OFFSET      (0X0UL)
//#define FLAGS_BOOT_FOTA_SIZE        (0X80000UL)
//#define FLAGS_BOOT_ENV_OFFSET       (FLAGS_BOOT_FOTA_OFFSET + FLAGS_BOOT_FOTA_SIZE)
//#define FLAGS_BOOT_ENV_SIZE         (0X80000UL)
//#define FLAGS_BACKUP_OFFSET         (FLAGS_BOOT_ENV_OFFSET + FLAGS_BOOT_ENV_SIZE)
	
#define FLAGS_MAGIC                  (0X464C4147UL)
	
#define DUALSYSTEM_STATUS_BOOTABLE     (0XB0AB) /**/
#define DUALSYSTEM_STATUS_SUCCESSFUL   (0X5CCF) /*ܳɹ*/
#define DUALSYSTEM_STATUS_UNBOOTABLE   (0XBABE) /**/

typedef struct
{
    int status;                /*bootable/successful/unbootable*/
	int try_cnt;
}T_DualSystem_Status;

typedef enum
{
    DUAL_SYSTEM  = 0X875A,  /*һϵͳ*/
	DUAL_SYSTEM2 = 0X986B,  /*ڶϵͳ*/
}T_BOOT_TARGET;

/*˫ϵͳ*/
typedef enum
{
    DUALSYSTEM_RECOVERY = 0X7575,    /*normal-recovery˫ϵͳ*/
	DUALSYSTEM_AA       = 0XAAAA,    /*AA˫ϵͳ*/
	DUALSYSTEM_AB       = 0XABAB     /*AB˫ϵͳ*/
}T_BOOT_DUALSYSTEM_TYPE;

typedef struct
{
    uint32_t             magic;       /*Чħ*/
	T_BOOT_TARGET        boot_to;     /*ǰϵͳ־*/
	uint32_t             fota_status; /*fota״̬*/
	T_DualSystem_Status  system;      /*һϵͳ״̬*/
	T_DualSystem_Status  system2;     /*ڶϵͳ״̬*/
}T_BOOT_FOTA_FLAG;

typedef struct
{
    unsigned int             magic;        /*Чħ*/
	T_BOOT_DUALSYSTEM_TYPE   dualsys_type; /*˫ϵͳ*/
	char system_boot_env[128];
	char system2_boot_env[128];
}T_BOOT_ENV;

typedef struct
{
    T_BOOT_FOTA_FLAG      boot_flag;
	T_BOOT_ENV            boot_env;
}T_FOTA_FLAG_INFO;
#endif

/*
 * Legacy format image header,  sizeof(image_header_t) = 64
 * all data in network byte order (aka natural aka bigendian).
 */
typedef struct image_header {
	uint32_t ih_magic;	/* Image Header Magic Number	*/
	uint32_t ih_hcrc;	/* Image Header CRC Checksum	*/
	uint32_t ih_time;	/* Image Creation Timestamp	*/
	uint32_t ih_size;	/* Image Data Size		*/
	uint32_t ih_load;	/* Data	 Load  Address	*/
	uint32_t ih_ep;		/* Entry Point Address	used *************	*/
	uint32_t ih_dcrc;	/* Image Data CRC Checksum	*/
	uint8_t	 ih_os;		/* Operating System		*/
	uint8_t	 ih_arch;	/* CPU architecture		*/
	uint8_t	 ih_type;	/* Image Type			*/
	uint8_t	 ih_comp;	/* Compression Type		*/
	uint8_t	 ih_name[IH_NMLEN];	/* Image Name		*/
} image_header_t;

typedef struct
{
	u32 uiPubKeyRsaE[32];
	u32 uiPubKeyRsaN[32];
	u32 uiHashY[32];
} sImageHeader;


extern int read_uboot_image(uint8_t *name, uint32_t *uboot_entry_point);
extern  int nand_read_m0(uint32_t *m0_entry_point);


#endif	/* __IMAGE_H__ */
