/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_erase.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-3-15
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include "downloader_config.h"
#include "downloader_nand.h"
#include "downloader_serial.h"
#include "errno.h"
#include "mmc.h"

/****************************************************************************
* 	                                     Function Definitions
****************************************************************************/

extern partition_table_t * g_partition_table;
extern char *tsp_console_buffer;


/*******************************************************************************
 * Function:do_erase
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int do_erase(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    partition_entry_t *part = NULL;
    char *par=NULL;
    char *ack=tsp_console_buffer;
    int ret = 0;
	int type = 0;

    if(argc<2)
    {
        return cmd_usage(cmdtp);
    }
	type = read_boot_flashtype();
    par = argv[1]; /*erase cmd*/
    if((strcmp(par,"all") == 0) || (strcmp(par,"raw") == 0))
    {
		if((type == IF_TYPE_NAND)||(type == IF_TYPE_SPI_NAND))
		{
		    ret = downloader_nand_eraseall();
		}
		else if(type == IF_TYPE_NOR) 
		{
        	ret = downloader_nor_eraseall();
		}
		
        if(ret == 0)
        {
            sprintf(ack,"OKAY");
            downloader_serial_write(ack, strlen(ack)+1);
            return 0;
        }
        else
        {
            sprintf(ack,"FAIL NAND ERASE");
            downloader_serial_write(ack, strlen(ack)+1);
            return ENOSYS;  /* Function not implemented */
        }
    }
	
    if(strcmp(par,"auto") == 0)
    {
	    if((type == IF_TYPE_NAND)||(type == IF_TYPE_SPI_NAND))
		{
		    ret = downloader_nand_erase_auto();
		}
		else if(type == IF_TYPE_NOR) 
		{
        	ret = downloader_nor_erase_auto();
		}
			
        if(ret == 0)
        {
            sprintf(ack,"OKAY");
            downloader_serial_write(ack, strlen(ack)+1);
            return 0;
        }
        else
        {
            sprintf(ack,"FAIL NAND ERASE");
            downloader_serial_write(ack, strlen(ack)+1);
            return ENOSYS;  /* Function not implemented */
        }
    }
	
    part = downloader_get_part(par);
    if(part == NULL)
    {
        sprintf(ack,"FAIL INVALID PARTITION");
        downloader_serial_write(ack, strlen(ack)+1);
        return EINVAL;	/* Invalid argument */
    }

	if((type == IF_TYPE_NAND)||(type == IF_TYPE_SPI_NAND))
	{
		ret = downloader_nand_erase(part,part->part_size);
	}
	else if(type == IF_TYPE_NOR) 
	{
        ret = downloader_nor_erase(part, part->part_size);
	}

	
    if(ret == 0)
    {
        sprintf(ack,"OKAY");
        downloader_serial_write(ack, strlen(ack)+1);
        return 0;
    }
    else
    {
        sprintf(ack,"FAIL NAND ERASE");
        downloader_serial_write(ack, strlen(ack)+1);
        return ENOSYS;  /* Function not implemented */
    }
}

U_BOOT_CMD(
	erase, CONFIG_SYS_MAXARGS, 0, do_erase,
	"Erase nand: erase [partition]",
	""
);

    
