/*********************************************************************
 Copyright 2016 by  ZIXC Corporation.
*
* FileName::    power.c
* File Mark:
* Description:
* Others:
* Version:   v1.0
* Author:   zhouqi
* Date:   2014-1-15

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/

#include <common.h>
#include <errno.h>
#include <command.h>
#include <malloc.h>
#include <asm/io.h>
#include <power.h>
#include <config.h>


static struct pmu_opt *s_pmu = NULL;

/*******************************************************************************
 * Function:    power_init
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int power_init(void)
{
    /* ṹռ */
    s_pmu = malloc(sizeof(struct pmu_opt));
    if (!s_pmu)
    {
    	printf( "power: out of memory for data structure pmu_opt\n");
    	return -EIO;
    }

    /* pmuʼ */
    pmu_init();

    return 0;

}


/*******************************************************************************
 * Function:    register_pmu_opt
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int register_pmu_opt(struct pmu_opt *opt)
{
    if( opt->read_reg )
        s_pmu->read_reg = opt->read_reg;
    else
        return -EIO;

    if( opt->write_reg )
        s_pmu->write_reg = opt->write_reg;
    else
        return -EIO;

    if( opt->get_boot_reason )
        s_pmu->get_boot_reason = opt->get_boot_reason;
    else
        return -EIO;

    if( opt->ps_hold_pull_on )
        s_pmu->ps_hold_pull_on = opt->ps_hold_pull_on;
    else
        return -EIO;

    if( opt->ps_hold_pull_off )
        s_pmu->ps_hold_pull_off = opt->ps_hold_pull_off;
    else
        return -EIO;

    if( opt->ps_hold2_pull_on )
        s_pmu->ps_hold2_pull_on = opt->ps_hold2_pull_on;

    if( opt->ps_hold2_pull_off )
        s_pmu->ps_hold2_pull_off = opt->ps_hold2_pull_off;

    if( opt->power_off )
        s_pmu->power_off = opt->power_off;
    else
        return -EIO;

    return SUCCESS;
}

/*******************************************************************************
 * Function:    get_pmu_opt
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
struct pmu_opt * get_pmu_opt(void)
{
    return s_pmu;
}

