
#ifndef RSA_DRV_H
#define RSA_DRV_H

/**< offset:000  RW        汾ϢĴ                */
/**< offset:004  RW        ģʹܼĴ                */
/**< offset:008  RW        ģĴ                    */
/**< offset:00C  RW        ݳĴ                    */
/**< offset:010  RW        ж״̬Ĵ                */
/**< offset:014  RW        жʹܼĴ                */
/**< offset:018  RW        жμĴ                */
/**< offset:01C  RW        N0Ĵ                      */
/**< offset:020  RW        N0Ĵ                    */
/**< offset:024  RW        ģʽ                      */
/**< offset:028  RW        ռλ                        */     
/**< offset:100  RW        M data RAMĴ0x100~0x1FF   */
/**< offset:200  RW        E data RAMĴ0x200~0x2FF   */
/**< offset:300  RW        N data RAMĴ0x300~0x3FF   */
/**< offset:400  RW        ʼRAMĴ0x400~0x4FF*/
/**< offset:500  RW        RAMĴ0x500~0x5FF      */

#include <common.h>
#include <secure_verify.h>

#define RSA_REV_INFO        		(SYS_RSA_BASE)
#define RSA_MODULE_ENABLE   	(SYS_RSA_BASE+0x4)
#define RSA_MODULAR_LENGTH 	(SYS_RSA_BASE+0x8)
#define RSA_EXP_LENGTH      		(SYS_RSA_BASE+0xc)
#define RSA_INT_STATUS      		(SYS_RSA_BASE+0x10)
#define RSA_INT_ENABLE      		(SYS_RSA_BASE+0x14)
#define RSA_INT_MASK        		(SYS_RSA_BASE+0x18)
#define RSA_NZORE           			(SYS_RSA_BASE+0x1c)
#define RSA_NZORE_INV       		(SYS_RSA_BASE+0x20)
#define RSA_CALC_MODE       		(SYS_RSA_BASE+0x24)
#define RSA_M_RAM           		(SYS_RSA_BASE+0x100)
#define RSA_E_RAM           		(SYS_RSA_BASE+0x200)
#define RSA_N_RAM           		(SYS_RSA_BASE+0x300)
#define RSA_INIT_CALC_RAM   	(SYS_RSA_BASE+0x400)
#define RSA_RESULT_RAM      		(SYS_RSA_BASE+0x500)

//Ƿ֧еģʽڼ򻯴
//#define RSA_CODE_SUPPORT_ALL

#ifdef RSA_CODE_SUPPORT_ALL
#define RSA_BIG_NUM_MULTIPLE             	9	//input M, E, udNbitLen
#define RSA_INIT_COMPUTE                 		2	//input N, udNbitLen
#define RSA_MOD_MULTIPLE_NO_INIT         8	//input M, E, N, C, udNbitLen, udEbitLen
#define RSA_MOD_EXPO_NO_INIT             	4	//input M, E, N, C, udNbitLen, udEbitLen
#define RSA_MOD_MULTIPLE_WITH_INIT     10	//input M, E, N, udNbitLen, udEbitLen
#endif
#define RSA_MOD_EXPO_WITH_INIT    	       6	//input M, E, N, udNbitLen, udEbitLen

/** RSAӿڴ*/
typedef struct
{
    u32 udCalMode;    /**< RSAģʽ     */                                         
    u32 udNbitLen;     /**< ģN λM λ , ѡ512, 1024, 1536, 2048 */
    u32 udEbitLen;     /**< E λ, С64   */
    u32 *pudInputM;   /**< M    --ϢM          */
    u32 *pudInputE;   /**< E     --E          */
    u32 *pudInputN;   /**< ģ --ģN  (ĳ˻)  */
    u32 *pudInputC;   /**< Ԥֵ,r^2 mod N   */
    u32 *pudOutputP;  /**<  */
}T_Rsa_Paramter;

u32 Rsa_Calculate(T_Rsa_Paramter ptInput);
#endif

