
#ifndef _SPIFC_H_
#define _SPIFC_H_

#define SYS_SPI_NAND_BASE           0x01407000

struct spifc_nor_reg_t
{
    uint32_t     VER_REG;					//0x00
    uint32_t     SFC_START;                 //0x04
    uint32_t     SFC_EN;                    //0x08
	uint32_t	 SFC_CTRL0;					//0x0c 
	uint32_t	 SFC_CTRL1;					//0x10
	uint32_t	 SFC_CTRL2;					//0x14 
	uint32_t	 SFC_BYTE_NUM;				//0x18
	uint32_t	 SFC_ADDR;					//0x1c
	uint32_t	 SFC_INS;					//0x20
	uint32_t	 SFC_TIMING;				//0x24
	uint32_t	 SFC_INT_EN;				//0x28
    uint32_t     SFC_INT_RAW;               //0x2c
    uint32_t     SFC_INT_SW_CLR;            //0x30
    uint32_t     SFC_SW;                    //0x34
    uint32_t     SFC_DATA;                  //0x38
};

/*spifc start 0x4*/
#define     FC_START      (1<<0)
#define     FC_BUSY       (1<<0)

/*spifc enable 0x8*/
#define     FC_EN_BACK          (1)
#define     FC_EN               (0)

/*spifc main ctr0 0xc*/
#define     FC_SCLK_PAUSE_CLR_ALLOW     (17)
#define     FC_SCLK_PAUSE_EN            (16)
#define     FC_TXFIFO_CLR               (15)
#define     FC_RXFIFO_CLR               (14)
#define     FC_TXFIFO_THRES             (10)
#define     FC_RXFIFO_THRES             (6)
#define     FC_TX_DMA_EN                (5)
#define     FC_RX_DMA_EN                (4)
#define     FC_WDOG_EN                  (3)
#define     FC_SPI_MODE                 (1)
#define     FC_WR_PROTECT               (0)

/*spifc ctrl1 0x10  in the condition : SFC_EN = 1 SFC_BUSY = 0*/
#define     FC_ADDR_TX_EN           (4)
#define     FC_DUMMY_TX_EN          (2)
#define     FC_READ_DAT_EN          (1)
#define     FC_WRITE_DAT_EN         (0)

/*spifc ctrl2 0x14*/
#define     FC_DUMMY_BYTE_NUM           (12)  /* [12:15} */
#define     FC_DUMMY_BIT_NUM            (8)   /* [8:10] */
#define     FC_ADDR_BYTE_NUM            (5)   /* [5:6] */ 
#define     FC_ADDR_MULTI_LINE_EN       (4)
#define     FC_DAT_MULTI_LINE_EN        (2)
#define     FC_TRANS_MOD                (0)

#define     FC_ADDR_BYTE_NUM_8             (0) 
#define     FC_ADDR_BYTE_NUM_16            (1) 
#define     FC_ADDR_BYTE_NUM_24            (2)  
#define     FC_ADDR_BYTE_NUM_32            (3)  


/*spifc timing 0x24*/
#define     FC_READ_DELAY           (1<<16)   /* [17:16} */
#define     FC_T_CS_SETUP           (1<<11)   /* [11:13} */
#define     FC_T_CS_HOLD            (1<<6)    /* [8:6} */
#define     FC_T_CS_DESEL           (1<<0)    /* [0:3} */


/*spifc int enable 0x28*/
#define     FC_INT_EN_TX_BYD_THES           (1<<7)
#define     FC_INT_EN_RX_BYD_THES           (1<<6)
#define     FC_INT_EN_TX_UNDERRUN           (1<<5)
#define     FC_INT_EN_RX_OVERRUN            (1<<4)
#define     FC_INT_EN_WDOG_OVERRUN          (1<<2)
#define     FC_INT_EN_FMT_ERR               (1<<1)
#define     FC_INT_EN_CMD_END               (1<<0)

/*spifc raw interrupt 0x2c*/
#define     FC_INT_RAW_TX_BYD_THES           (1<<7)
#define     FC_INT_RAW_RX_BYD_THES           (1<<6)
#define     FC_INT_RAW_TX_UNDERRUN           (1<<5)
#define     FC_INT_RAW_RX_OVERRUN            (1<<4)
#define     FC_INT_RAW_WDOG_OVERRUN          (1<<2)
#define     FC_INT_RAW_FMT_ERR               (1<<1)
#define     FC_INT_RAW_CMD_END               (1<<0)
#define     FC_INT_RAW_MASK              	 (FC_INT_RAW_TX_UNDERRUN|	\
                                              FC_INT_RAW_RX_OVERRUN|	\
                                              FC_INT_RAW_WDOG_OVERRUN|	\
                                              FC_INT_RAW_FMT_ERR|		\
                                              FC_INT_RAW_CMD_END)


/*spifc int startus and clr 0x30*/
#define     FC_INT_CLR_TX_BYD_THES           (1<<7)
#define     FC_INT_CLR_RX_BYD_THES           (1<<6)
#define     FC_INT_CLR_TX_UNDERRUN           (1<<5)
#define     FC_INT_CLR_RX_OVERRUN            (1<<4)
#define     FC_INT_CLR_WDOG_OVERRUN          (1<<2)
#define     FC_INT_CLR_FMT_ERR               (1<<1)
#define     FC_INT_CLR_CMD_END               (1<<0)

/*spifc sw 0x34*/
#define     FC_TX_FIFO_CNT              (16)         /* [16:20} */
#define     FC_TX_FIFO_CNT_MASK         (0x1F)      /* [8:12} */
#define     FC_RX_FIFO_CNT              (8)             /* [8:12} */
#define     FC_RX_FIFO_CNT_MASK         (0x1F)      /* [8:12} */
#define     FC_TX_BYD_THRES             (1<<5)  
#define     FC_RX_BYD_THRES             (1<<4)  
#define     FC_SCLK_PAUSE_FLAG          (1<<3)  
#define     FC_WAIT_FLAG                (1<<2) 
#define     FC_FORMAT_ERR               (1<<1)  


#define     FC_DMA_NONE           		0
#define     FC_DMA_TX             		1
#define     FC_DMA_RX             		2


#define TX_DMA_EN		1 
#define TX_DMA_DIS      0 
#define RX_DMA_EN		1 
#define RX_DMA_DIS      0
#define ADDR_TX_EN      1   
#define ADDR_TX_DIS     0
#define DATA_TX_EN      1
#define DATA_TX_DIS     0
#define DATA_RX_EN      1
#define DATA_RX_DIS     0
#define DUMY_TX_EN      1
#define DUMY_TX_DIS     0
#define ADDR_MULTI_LINE_EN		1 
#define ADDR_MULTI_LINE_DIS      0
#define DATA_MULTI_LINE_EN		1 
#define DATA_MULTI_LINE_DIS      0
#define TRANS_MOD_QUAD		1 
#define TRANS_MOD_DUAL      0
#define TRANS_MOD_SINGLE	2


#define ADDR_WIDTH_8    0
#define ADDR_WIDTH_16   1
#define ADDR_WIDTH_24   2
#define ADDR_WIDTH_32   3



typedef struct spinor_cmd
{
    u8 cmd;
	u8 tx_dma_en;
	u8 rx_dma_en;
    u8 addr_tx_en;
    u8 addr_byte_num;
    u8 data_tx_en;
    u8 data_rx_en;
    u8 dumy_tx_en;
    u8 dumy_byte_num;
	u8 dumy_bit_num;
	u8 addr_multi_line_en;
	u8 data_multi_line_en;
	u8 trans_mod;
	u8 reserved[3];
    u8 *info;
}spinor_cmd_t;

#define CMD_RDFT                   		0x0B
#define CMD_RDID                    	0x9F


#define SPI_NOR_MAX_ID_LEN	8

struct nor_info {
	char		*name;

	u8		id[SPI_NOR_MAX_ID_LEN];
	u8		id_len;

	unsigned	sector_size;
	u16		n_sectors;

	u16		page_size;
	u16		addr_width;

	u16		flags;
#define	SECT_4K				0x01
#define	SPI_NOR_NO_ERASE	0x02
#define	SST_WRITE			0x04
#define	SPI_NOR_NO_FR		0x08
#define	SECT_4K_PMC			0x10
#define	SPI_NOR_DUAL_READ	0x20
#define	SPI_NOR_QUAD_READ	0x40
#define	USE_FSR				0x80
};

extern struct nor_info *spi_nor_flash;


#endif /* _SPIFC_H_ */

