# -*- coding: utf-8 -*-   
import subprocess
import argparse
from subprocess import *
import threading
import time
import ConfigParser
import os,sys
import commands
import string 
import shutil
import hashlib
from collections import OrderedDict

sys.path.append("../../../")
Imagefs_name            = ""
compress_alg            = ""
partition_name          = ""
COMPRESS_ALG_LZMA       = "lzma"
FS_CMD_SPLIT_IMAGE 	    = "split"
FS_CMD_MERGE_BINS_FOR_UPLOAD = "merge"
FS_CMD_PACK_IMAGE_MKJFFS2 = "mkjffs2"
NVRWALL_FILE_NAME       = "nvrwall.bin"
NVRWALL_HASH_FILE       = "nvrwall.hash" 
FOTA_FLAG_RENEW_IMGNAME = "ap_imagefs.img"
CMD_PARTITION_SEPARATOR = ","
SPLIT_EXE_PATH      = "split"
MINILZMA_EXE_PATH   = "./minilzma"
MINIUNLZMA_EXE_PATH = "./miniunlzma"
MKFS_JFFS2_PATH      = "./mkfs.jffs2_lzma"

class si_subprocess (threading.Thread):
	def __init__(self, threadID, name, procmd):
		try:
			threading.Thread.__init__(self)
			self.threadID = threadID
			self.name = name
			self.p = subprocess.Popen(procmd, stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE, shell = False)
			results = self.p.communicate()
			if results:
				print results
			self.outlist = []
			self.lock = threading.Lock()

		except Exception as e:
			print "Error %s" %e

	def run(self):
		try:
			curline = self.p.stdout.readline()
			while(curline):
				self.lock.acquire()
				self.outlist.append(curline)
				self.lock.release()
				curline = self.p.stdout.readline()
		except Exception as e: 
			print "si_subprocess get excption" 
			raise e 
		finally:
			print "Exiting " + self.name

	def terminate(self):
		self.p.kill()

#***********************************************************************
#Interface: gererate md5
#Interface: read config file
#Interface: check param is valid
#***********************************************************************
class special_handle_method(object):
	def __init__(self):
		pass

	def file_md5_hexdigest(self, filename):
		fmd5 = hashlib.md5()
		f = open(filename, 'rb')
		fmd5.update(f.read())
		f.close()
		return fmd5.hexdigest()

	def read_configfile(self, configfile_path, field):
		review = ConfigParser.ConfigParser()  
		review.read(configfile_path)  
		global partition_name
		if review.has_option(partition_name, field) == False:
			raise Exception('field of partition is not exist !',partition_name, field)
		field_value = review.get(partition_name, field)
		return field_value

	def prepare_check_params(self, cmd_type, srcbins_path, product_ini_file, out_path):
		if not os.path.isfile(product_ini_file):
			raise Exception('check: Wrong input param,please check product_ini_file!',\
				os.path.isfile(product_ini_file))

		if cmd_type == FS_CMD_PACK_IMAGE_MKJFFS2:
			image_path = os.path.dirname(out_path)
			if srcbins_path == image_path:
				raise Exception('when you mkjffs2, srcbins_path and out_path should be deferent!',image_path)
			if (not os.path.isdir(srcbins_path)) or (not os.path.isdir(image_path)):
				raise Exception('Wrong input param, please check srcbins_path out_path!',\
					os.path.isdir(srcbins_path), os.path.isdir(image_path))

		elif cmd_type == FS_CMD_SPLIT_IMAGE:
			if (not os.path.isfile(srcbins_path)) or (not os.path.isdir(out_path)):
				raise Exception('Wrong input param, please check srcbins_path out_path!',\
					os.path.isfile(srcbins_path), os.path.isdir(out_path))

		elif cmd_type == FS_CMD_MERGE_BINS_FOR_UPLOAD:
			if (not os.path.isdir(srcbins_path)) or (not os.path.isfile(product_ini_file)):
				raise Exception('Wrong input param, please check srcbins_path!',\
					os.path.isdir(srcbins_path))

#***********************************************************************
#Interface: pack imagefs using mkjffs2
#Interface: split bins
#Interface: uncompress bins
#Interface: merge bins for upload
#Interface: compress bins
#***********************************************************************
class  imagefs_operation(object):
	def __init__(self):
		pass

	def opcmd_get_suffix(self): 
		if Imagefs_name.find("_") == -1:
			suffix = Imagefs_name
		else:
			str_img   = os.path.splitext(Imagefs_name)[0]
			suffix = str_img.split("_")[-1]
		return suffix

	def opcmd_packimgfs_mkjffs2(self, srcbins_dir, configfile_path, out_dir): 
		handle = special_handle_method()
		review = ConfigParser.ConfigParser()  
		review.read(configfile_path)  
		action_Image_cmd = handle.read_configfile(configfile_path, "mkfs_jffs2")
		makejffs2_allinone_cmd = MKFS_JFFS2_PATH + " " + action_Image_cmd + " -d " + srcbins_dir + " -o " + out_dir
		print "cmd is %s" %makejffs2_allinone_cmd
		print "path %s" %os.getcwd()
		os.system(makejffs2_allinone_cmd)
		#si_subprocess(1, "file system pack thread", makejffs2_allinone_cmd)
		print "Generating %s ok!"%out_dir

	def opcmd_split_binfs(self, srcbins_dir, configfile_path, out_dir): 
		mycase = special_handle_method()
		suffix = self.opcmd_get_suffix()
		split_block_size = mycase.read_configfile(configfile_path, "split_block_size")
		block_figure = mycase.read_configfile(configfile_path, "split_figure")
		block_name = suffix + "_"
		small_bin_file = os.path.join(out_dir, block_name)
		split_Image_cmd = SPLIT_EXE_PATH + " -b " + split_block_size + " " + srcbins_dir + " -d -a " + block_figure + " " + small_bin_file
		os.system(split_Image_cmd)
		os.remove(srcbins_dir)

	def opcmd_uncompress_bins(self, srcbins_dir): 
		suffix = self.opcmd_get_suffix()
		if compress_alg == COMPRESS_ALG_LZMA:
			#Miniunlzma -k -o  E:\imagefs_tool_new\fs\cpuap_00  E:\imagefs_tool_new\fs\cpuap_00.lzma
			lzmafiles = os.listdir(srcbins_dir)
			if len(lzmafiles)==0:
				raise Exception('uncompress binfiles error: srcdir is Null!')
			for each in lzmafiles:
				if (each.find("_") == -1) or (each.split("_")[0] != suffix) or (each.find(".lzma") == -1):
					continue
				bin_file		= each.split(".lzma")[0]
				bin_file		= os.path.join(srcbins_dir, bin_file)
				lzmabin_file	= os.path.join(srcbins_dir, each)
				unlzma_cmd		= MINIUNLZMA_EXE_PATH + " -o " + bin_file + " " + lzmabin_file
				os.system(unlzma_cmd)
				#os.remove(lzmabin_file)

	def opcmd_merge_bins_for_upload(self, srcbins_dir, out_dir): 
		suffix = self.opcmd_get_suffix()
		if compress_alg == COMPRESS_ALG_LZMA:
			path_list = os.listdir(srcbins_dir)
			path_name = []
			keyword = suffix + "_"
			for i in path_list:
				if (i.find(keyword) !=-1):
					path_name.append(i.split("\n")[0])

			if len(path_name)==0:
				raise Exception('merge bins error: no src small bin file')
			# sort
			path_name.sort()

			if  os.path.exists(out_dir):
				os.remove(out_dir)
			for file_name in path_name:
				# "a" zhuijia
				fullname = os.path.join(srcbins_dir, file_name)
				with open(fullname, "rb") as file_object:
					file_info = file_object.read()
					with open(out_dir, "ab") as f:
						f.write(file_info)
						print "fullname %s"%fullname
					f.close()
					file_object.close()
					os.remove(fullname)

	def opcmd_compress_bins(self, out_dir):
		suffix = self.opcmd_get_suffix()
		if compress_alg == COMPRESS_ALG_LZMA:
			#ls cpuap_* | ..\bin\xargs -I {} ..\bin\minilzma -t  512 {}
			members = os.listdir(out_dir)
			key_word = suffix + "_"
			for member in members:
				smallbin_file = os.path.join(out_dir, member)
				if ((member.find(key_word) != -1) and (member.find(".lzma") != -1)):
					os.remove(smallbin_file)

			members = os.listdir(out_dir)
			for member in members:
				if (member.find("_") == -1) or (member.split("_")[0] != suffix):
					continue
				member = member.split("\n")[0]
				smallbin_file = os.path.join(out_dir, member)
				lzma_cmd = MINILZMA_EXE_PATH + " -t " + lzma_dict + " " + smallbin_file
				os.system(lzma_cmd)
				#si_subprocess(4, "file lzma compress thread", lzma_cmd)

#***********************************************************************
#for 16M download
#first:  split big bin to small bins according to product.ini
#second: using lzma alg to compress small bins
#***********************************************************************
def split_image_start(srcbins_dir, config_file_dir, out_dir):
	try:
		Instance = imagefs_operation()
		if split_enable=="yes":
			#Instance.check_bins_valid(srcbins_dir)
			Instance.opcmd_split_binfs(srcbins_dir, config_file_dir, out_dir)
			Instance.opcmd_compress_bins(out_dir)
			print "Split and compress bins complete!"
		else:
			raise Exception('largefile_split_enable is no, please check!')

	except Exception as e:
		print "Error %s" %e

#***********************************************************************
#for 16M upload
#first:  uncompress small lzma bins
#second: write all small bins to a big bin
#***********************************************************************
def merge_image_for_upload_start(srcbins_dir, combin_dir):
	try:
		#Instance.check_bins_valid(srcbins_dir)
		if split_enable=="yes":
			Instance = imagefs_operation()
			print "----------uncompress begin---------------"
			Instance.opcmd_uncompress_bins(srcbins_dir)
			print "----------merge begin--------------------"
			Instance.opcmd_merge_bins_for_upload(srcbins_dir, combin_dir)
			print "Uncompress and merge bins complete!"
		else:
			pass
	except Exception as e:
		print "Error %s" %e

#***********************************************************************
#function：for mkjffs2 pack imagefs
#first:    check bins valid：
#second:   generate fotaflag and nvrwall.hash file
#***********************************************************************
def package_check_bins_valid(newbins_path, product_path):
		bins_list = os.listdir(newbins_path)
		nvrwall_file = os.path.join(newbins_path, NVRWALL_FILE_NAME)
		if os.path.exists(product_path):
			if os.path.exists(nvrwall_file):
				md5_object = special_handle_method()
				hash = md5_object.file_md5_hexdigest(nvrwall_file)
				nvrwall_hash   = os.path.join(newbins_path, NVRWALL_HASH_FILE)
				if os.path.exists(nvrwall_hash) == True:
					os.remove(nvrwall_hash)
				with open(nvrwall_hash, "w+") as fp:
					fp.write(hash)

			if Imagefs_name == FOTA_FLAG_RENEW_IMGNAME:
				fotaflag_path  = os.path.join(newbins_path, "fotaflag")
				if not os.path.exists(fotaflag_path):
					with open(fotaflag_path, "wb+") as fotafp:
						fotafp.write(b'\xFF' * 1024)
						fotafp.close()
			return "True"
		else:
			raise Exception('product config file not exist, please check!') 

#***********************************************************************
#function：mkjffs2 code
#first:    check bins valid：fotaflag and hash
#second:   package all bins to imagfs using mkjffs2 exe 
#***********************************************************************
def package_image_start(newbins_dir, product_dir, allinone_dir):
	try:
		if not os.path.exists(newbins_dir):
			raise Exception('imgfs_dir not exist, please check!') 
		if not os.path.exists(product_dir):
			raise Exception('product_dir not exist, please check!') 
		if not os.path.exists(os.path.dirname(allinone_dir)):
			raise Exception('allinone_dir not exist, please check!')
		package_check_bins_valid(newbins_dir, product_dir)
		#mkjffs2
		Instance = imagefs_operation()
		Instance.opcmd_packimgfs_mkjffs2(newbins_dir, product_dir, allinone_dir)
	except Exception as e:
		print "Error %s" %e
		#jp.end()

#***********************************************************************
#function：main fun
#first:    check params and read product.ini config file
#second:   support three kinds of command: mkjffs2\split\merge
#***********************************************************************
def main():
	parser = argparse.ArgumentParser()

	parser.add_argument('-d', '--srcdir', type=str, help="srcdir")
	parser.add_argument('-c', '--cmd', type=str, help="cmd type")
	parser.add_argument('-p', '--configfile', type=str, help="product.ini config file path")
	parser.add_argument('-o', '--outdir', type=str, help='destination directory')
	parser.add_argument('-r', '--keyword', type=str, help='read keyword from product.ini ')

	args = parser.parse_args()
	object = special_handle_method()
	global partition_name

	if (args.keyword != None and args.configfile != None):
		key_word = unicode(args.keyword,'utf-8')
		if (key_word.find(CMD_PARTITION_SEPARATOR) == -1):
			print('Exception: key_word param error: usage [-h] [-d SRCDIR] [-c KEYWORD,PARTITION] [-p CONFIGFILE] [-o OUTDIR]')
			return
		key_name		 = key_word.split(CMD_PARTITION_SEPARATOR)[0]
		partition_name	 = key_word.split(CMD_PARTITION_SEPARATOR)[1]
		product_ini_file = unicode(args.configfile,'utf-8')
		print object.read_configfile(product_ini_file, key_name)
		return object.read_configfile(product_ini_file, key_name)

	if (args.srcdir == None or args.cmd == None or args.configfile == None or args.outdir == None):
		print(''' Exception: cmd:mkjffs2 usage:[-h] [-d SRCDIR] [-c CMD] [-p CONFIGFILE] [-o OUTDIR] \n
		cmd:split or merge usage:[-h] [-d SRCDIR] [-c CMD,PARTITION] [-p CONFIGFILE] [-o OUTDIR]\n
		keyword read from Product.ini usage:[-h] [-p CONFIGFILE] [-r KEYWORD,PARTITION]''')
		return

	srcbins_path	= unicode(args.srcdir, 'utf-8')
	cmd				= unicode(args.cmd, 'utf-8')
	out_path		= unicode(args.outdir,'utf-8')
	product_ini_file = unicode(args.configfile,'utf-8')

	print "srcbins_path %s ^^^^^^^^" %srcbins_path
	print "out_path %s ^^^^^^^^" %out_path
	print "product config file %s ^^^^^^^^" %product_ini_file

	global split_enable
	global Imagefs_name

	if cmd == FS_CMD_PACK_IMAGE_MKJFFS2:
		Imagefs_name = os.path.basename(out_path)
		if Imagefs_name.find("_") == -1:
			partition_name = Imagefs_name
		else:
			str_img   = os.path.splitext(Imagefs_name)[0]
			partition_name = str_img.split("_")[-1]
		object.prepare_check_params(cmd, srcbins_path, product_ini_file, out_path)
		package_image_start(srcbins_path, product_ini_file, out_path)
		return
	else: 	#split/merge bins
		if (cmd.find(CMD_PARTITION_SEPARATOR) == -1):
			print('Exception: cmd param error: usage [-h] [-d SRCDIR] [-c CMD,PARTITION] [-p CONFIGFILE] [-o OUTDIR]')
			return
		cmd_type       = cmd.split(CMD_PARTITION_SEPARATOR)[0]
		partition_name = cmd.split(CMD_PARTITION_SEPARATOR)[1]
		object.prepare_check_params(cmd_type, srcbins_path, product_ini_file, out_path)
		split_enable = object.read_configfile(product_ini_file, "largefile_split_enable")
		if split_enable  == "yes":
			global lzma_dict
			global compress_alg
			lzma_dict = object.read_configfile(product_ini_file, "lzma_dict")
			compress_alg = object.read_configfile(product_ini_file, "compress_algorithm")
			if compress_alg != COMPRESS_ALG_LZMA:
				print "Exception: Now %s is not supported, please choose lzma as compress_algorithm!"%compress_alg
				return

	if cmd_type == FS_CMD_SPLIT_IMAGE:
		Imagefs_name = os.path.basename(srcbins_path)
		split_image_start(srcbins_path, product_ini_file, out_path)

	elif cmd_type == FS_CMD_MERGE_BINS_FOR_UPLOAD:
		Imagefs_name = os.path.basename(out_path)
		merge_image_for_upload_start(srcbins_path, out_path)

	else:
		raise Exception('cmd type error, support three kind of cmds: split merge or mkjffs2, please check!') 

if __name__ == '__main__':
	main()


