/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <cstdint>
#include <string>
#include <vector>
#include <memory>

#include "CommandBody.h"
#include "CommandAck.h"

#ifndef SRCOMDATAFORMAT_H_
#define SRCOMDATAFORMAT_H_

//p37, table 28
class SrComDataFormat {
public:
    SrComDataFormat();
    virtual ~SrComDataFormat();
    int decodeSrCmomDt();
    const std::string& getAc() const;
    void setAc(const std::string ac);
    std::uint8_t getAcfe() const;
    void setAcfe(std::uint8_t acfe);
    std::uint8_t getAcl() const;
    void setAcl(std::uint8_t acl);
    std::uint8_t getCct() const;
    void setCct(std::uint8_t cct);
    const std::string& getCd() const;
    void setCd(const std::string cd);
    std::uint8_t getChs() const;
    void setChs(std::uint8_t chs);
    std::uint8_t getChsfe() const;
    void setChsfe(std::uint8_t chsfe);
    std::uint32_t getCid() const;
    void setCid(std::uint32_t cid);
    std::uint8_t getCt() const;
    void setCt(std::uint8_t ct);
    std::uint8_t getFileExs() const;
    void setFileExs(std::uint8_t fileExs);
    std::uint32_t getSid() const;
    void setSid(std::uint32_t sid);
    std::uint8_t getType() const;
    void setType(std::uint8_t type);
    bool isIncludedCmdCode(std::uint16_t cmd);
    std::string encode(std::uint16_t cmd, bool ack);
    bool isNeedNewSms();
    int getEcallReqPara();
private:

    std::shared_ptr<CommandBody> mCmdBody;
    std::shared_ptr<CommandAck> mCmdAck;

    std::uint8_t type;
    std::uint8_t CT; //4bit
    std::uint8_t CCT;//4bit

    std::uint32_t CID;
    std::uint32_t SID;

    std::uint8_t fileExs;
    std::uint8_t ACFE; //1bit
    std::uint8_t CHSFE; //1bit

    std::uint8_t CHS; // O (CHSFE)
    std::uint8_t ACL; //O (ACFE)
    //std::vector<std::uint8_t> AC; //O (0, 255)
    //std::vector<std::uint8_t> CD; //O (0, 65205)
    std::string AC; //O (0, 255)
    std::string CD; //O (0, 65205)

    std::string ct2str(uint8_t ct);
    std::string cct2str(uint8_t cct);
    int decodeCtCom();
    int decodeCtComCfg();

    //CT: command type
    static const std::uint8_t CT_COMCONF = 0b0001;
    static const std::uint8_t CT_MSGCONF = 0b0010;
    static const std::uint8_t CT_MSGFROM = 0b0011;
    static const std::uint8_t CT_MSGTO = 0b0100;
    static const std::uint8_t CT_COM = 0b0101;
    static const std::uint8_t CT_DELCOM = 0b0110;
    static const std::uint8_t CT_SUBREQ = 0b0111;
    static const std::uint8_t CT_DELIV = 0b1000;

    //CCT-type fo acknowledgement (make sense for CT_COMCONF, CT_MSGCONF, or CT_DELIV commands)
    static const std::uint8_t CC_OK = 0b0000;
    static const std::uint8_t CC_ERROR = 0b0001;
    static const std::uint8_t CC_ILL = 0b0010;
    static const std::uint8_t CC_DEL = 0b0011;
    static const std::uint8_t CC_NFOUND = 0b0100;
    static const std::uint8_t CC_NCONF = 0b0101;
    static const std::uint8_t CC_INPROG = 0b0110;

    //CHS -character encoding used in the CD field that contains the command body
    static const std::uint8_t cp_1251     = 0;
    static const std::uint8_t IA5         = 1;
    static const std::uint8_t binary_data = 2;
    static const std::uint8_t Latin1      = 3;
    static const std::uint8_t binary_data_2 = 4;
    static const std::uint8_t JIS         = 5;
    static const std::uint8_t cyrillic    = 6;
    static const std::uint8_t latin_Hebrew= 7;
    static const std::uint8_t  UCS2        = 8;
};

#endif /* SRCOMDATAFORMAT_H_ */
