#ifndef __LYNQ_DEFLOG_H__
#define __LYNQ_DEFLOG_H__
#include "liblog.h"

#ifdef __cplusplus
extern "C" {
#endif

void lynq_log_configuration_init(char *log_name);
void lynq_log_configuration_set(char *log_name,char log_data_arr);
void lynq_log_verbose(const char *format,...);
void lynq_log_error(const char *format,...);
void lynq_log_warning(const char *format,...);
void lynq_log_info(const char *format,...);
void lynq_log_debug(const char *format,...);


#ifndef USER_LOG_TAG 
#define LYVERBLOG(X...)  lynq_log_global_output(LOG_VERBOSE,X)
#define LYERRLOG(X...)  lynq_log_global_output(LOG_ERROR,X)
#define LYWARNLOG(X...)  lynq_log_global_output(LOG_WARNING,X)
#define LYINFLOG(X...)  lynq_log_global_output(LOG_INFO,X)
#define LYDBGLOG(X...)  lynq_log_global_output(LOG_DEBUG,X)
#define LYLOGSET(a) lynq_log_configuration_set(USER_LOG_TAG,a)
#define LYLOGEINIT(Y) lynq_log_configuration_init(Y)
#else
#define LYVERBLOG(X...)  
#define LYERRLOG(X...)  
#define LYWARNLOG(X...)  
#define LYINFLOG(X...)  
#define LYDBGLOG(X...)  
#define LYLOGSET(a)
#define LYLOGEINIT(Y)
#endif

char* lynq_read_log_version();
#ifdef __cplusplus
}
#endif

#endif  //__LYNQ_DEFLOG_H__