/*******************************************************
* 
* @brief:
* @details:  add fota upgrade api
* @author:   l.yang
* @date:     2023.8.3
* @version:  V1.0
* @copyright：Copyright (c) MobileTek 
*
*********************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <dirent.h>
#include <getopt.h>
#include <unistd.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "include/lynq-qser-fota.h"
#include "liblog/lynq_deflog.h"


#define USER_LOG_TAG "LYNQ_FOTA"


#define  SYSTEM_A  "34650"
#define  SYSTEM_B  "39019"

char path[] = {0};

#define BOOTABLE   "45227"
#define UNBOOTABLE "47806"


#define    LYNQ_UPGRADE_STATUS_VERIFING            (0)
#define    LYNQ_UPGRADE_STATUS_VERIFY_SUCCESS      (1)
#define    LYNQ_UPGRADE_STATUS_VERIFY_FAIL         (2)
#define    LYNQ_UPGRADE_STATUS_UPDATING            (3)
#define    LYNQ_UPGRADE_STATUS_UPDATE_SUCCESS      (4)
#define    LYNQ_UPGRADE_STATUS_UPDATE_FAIL         (5)



typedef struct
{
    int system;
    int status;
    int try_cnt;
} z_system_info_t;

typedef struct
{
    int upgrade_status;
    int total_size;
    int upgraded_size;
} z_upgrade_status_info_t;

typedef struct
{
    int boot_to;        
    int fota_status;
    z_system_info_t system_1;
    z_system_info_t system_2;
} z_upgrade_system_info_t;

typedef struct
{
    z_upgrade_status_info_t *status;
    void(* status_cb)(z_upgrade_status_info_t *status);
} z_upgrade_flush_status_t;

extern int zxic_dual_verify();
extern int zxic_dual_upgrade(z_upgrade_flush_status_t *flush_status);
extern int zxic_dual_get_upgrade_status(z_upgrade_status_info_t *upgrade_info);
extern int zxic_dual_get_current_system();
extern int zxic_dual_get_boot_to_system();
extern int zxic_dual_set_boot_to_system(int system, int reboot_flag);
extern int zxic_dual_get_system_status(z_upgrade_system_info_t *system_info);
extern int zxic_dual_set_system_status(int system, int status);
extern int zxic_dual_get_fota_status_for_nv();
extern int zxic_dual_set_fota_status_for_nv(int status);
extern int zxic_dual_sync_system(void);
extern int zxic_dual_get_upgrade_type(void);
extern void zxic_dual_get_sync_status(int *sync_status);
extern int zxic_dual_set_sync_status(int sync_status);
extern int zxic_dual_config_package_path(char *upgrade_package_path, int length);

int lynq_fota_verify();
int lynq_fota_upgrade();
int lynq_get_current_system();
int lynq_get_boot_to_system();
int lynq_set_boot_to_system(char *option_para);
int lynq_set_system_a_status(char *option_para);
int lynq_set_system_b_status(char *option_para);
int lynq_sync_system();
int lynq_get_upgrade_type();
int lynq_get_sync_status();
int lynq_set_sync_status(char *option_para);


/*****************************************
* @brief:rock_update_main
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int rock_update_main(int reboot_flag)
{
    
    int ret = 0;
    int current_slot = 0;

    ret = lynq_fota_verify();
    if(ret != 0)
    {
        LYINFLOG("Verify package failed exit upgrade");
        return -1;
    }
    
    
    LYINFLOG("-----Begin to upgrade ----");
    ret = lynq_fota_upgrade();
    if(ret != 0)
    {
        LYINFLOG("Fota upgrade failed!!!");
        return -1;
    }

    ret = lynq_get_upgrade_status();
    if(ret != LYNQ_UPGRADE_STATUS_UPDATE_SUCCESS)
    {
        LYINFLOG("Upgrade failed ");
        return -1;
    }

    current_slot = lynq_get_current_system();
    if(current_slot < 0)
    {
        LYINFLOG("Get current system failed");
        return -1;
    }

    
    if(current_slot == atoi(SYSTEM_A))
    {
        LYINFLOG("current system is system a");

        
        ret = lynq_set_boot_to_system((char *)SYSTEM_B);
        if(ret != 0)
        {
            LYINFLOG("set system B boot failed ");
            return -1;
        }

         
        ret = lynq_set_system_a_status((char *)UNBOOTABLE);
        if(ret < 0)
        {
            LYINFLOG("Set system A status to [%s] error ", UNBOOTABLE);
            return -1;
        }

        ret = lynq_set_system_b_status((char *)BOOTABLE);
        if(ret < 0)
        {
            LYINFLOG("Set system B status to [%s] error ", BOOTABLE);
            return -1;
        }

    }
    else if( current_slot == atoi(SYSTEM_B))
    {
        LYINFLOG("current system is system a");

        
        ret = lynq_set_boot_to_system((char *)SYSTEM_A);
        if(ret != 0)
        {
            LYINFLOG("set system B boot failed ");
            return -1;
        }

        
        ret = lynq_set_system_b_status((char *)UNBOOTABLE);
        if(ret < 0)
        {
            LYINFLOG("Set system B status to [%s] error ", UNBOOTABLE);
            return -1;
        }

        ret = lynq_set_system_a_status((char *)BOOTABLE);
        if(ret < 0)
        {
            LYINFLOG("Set system A status to [%s] error ", BOOTABLE);
            return -1;
        }

    }

    if(reboot_flag == 1)
    {
        LYINFLOG("Enter reboot device");
        system("reboot");
    }
    
    return 0;
}

/*****************************************
* @brief:upgrade callback function
* @param count [IN]:z_upgrade_status_info_t *p_status
* @param sum [OUT]:NA
* @return :NA
* @todo:
* @see:NA
* @warning:NA
******************************************/
void lynq_g_flush_upgrade_status(z_upgrade_status_info_t *p_status)
{

    LYINFLOG("Current status:%d ", p_status->upgrade_status);

    LYINFLOG("Total size:%d ", p_status->total_size);

    LYINFLOG("Updated size:%d ", p_status->upgraded_size);
    return ;
}

/*****************************************
* @brief:lynq_fota_set_addr_value
* @param count [IN]:char  *path
* @param sum [OUT]:
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_fota_set_addr_value(char        *value,int size)
{
    int ret =0;
    
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    
    if (NULL == value || size <= 0)
    {
        LYINFLOG("Bad package path!!!");
        return -1;
    }
    ret = zxic_dual_config_package_path(value, strlen(value));
    if(ret == -1)
    {
        LYINFLOG("Configure upgrade package path fail");
        return -1;
    }
    
    LYINFLOG("Configure upgrade package path success");
    return 0;
}


/*****************************************
* @brief:lynq_fota_verify
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_fota_verify()
{
    int ret = 0;

    LYINFLOG("-----Begin to verify upgrade package----");
    ret = zxic_dual_verify();
    if(ret != 0)
    {
        LYINFLOG("Verify upgrade package failed");
        return -1;
    }

    return 0;

}

/*****************************************
* @brief:upgrade function
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_fota_upgrade()
{
    int ret = 0;
    z_upgrade_flush_status_t flush_status;
    z_upgrade_status_info_t status;
    memset(&status, 0, sizeof(z_upgrade_status_info_t));
    flush_status.status = &status; 
    flush_status.status_cb = &lynq_g_flush_upgrade_status;

    
    LYINFLOG("Enter lynq_fota_upgrade !!!!");
    ret = zxic_dual_upgrade(&flush_status);
    if(ret != 0)
    {
        LYINFLOG("Fota upgrade failed!!!");
        return -1;
    }
    return 0;
}

/*****************************************
* @brief:lynq_fota_nrestart no reboot
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_fota_nrestart(void)
{
    int ret = 0;
    ret = rock_update_main(0);
    if(ret != 0)
    {
         LYINFLOG("Upgrade failed !!!!");
         return -1;
    }
    else
    {
        LYINFLOG("upgrade success!!!");
    }
    return 0;
}

/*****************************************
* @brief:lynq_rock_main,upgrade done reboot
* @param count [IN]:int first_run
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_rock_main(int first_run)
{
    if(first_run <= 0)
    {
        LYINFLOG("Bad input value !!!");
        return -1;
    }
    
    int ret = 0;
    ret = rock_update_main(1);
    LYINFLOG("rock_update_main ret = %d\n", ret);
    if(ret != 0)
    {
        LYINFLOG("fota update fail!\n");
    }
    return 0;

}

/*****************************************
* @brief:lynq_get_current_system
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success: curretn slot , failed:-1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_get_current_system()
{
    int ret = 0;

    ret = zxic_dual_get_current_system();
    if(ret < 0)
    {
        LYINFLOG("lynq get current system faile");
        return -1;
    }
    if(ret == 34650)
    {
        LYINFLOG("Get current system is system A");
    }
    else if(ret == 39019)
    {
        LYINFLOG("Get current system is system B");
    }
    
    return ret;

}

/*****************************************
* @brief:lynq_get_boot_to_system
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_get_boot_to_system()
{
    int boot_to = 0;
    boot_to = zxic_dual_get_boot_to_system();
    if(boot_to < 0)
    {
        LYINFLOG("lynq get boot to system failed");
        return -1;
    }
    else
    {
        LYINFLOG("Boot to system:0x%08X[%d]",boot_to);
    }

    return 0;

}

/*****************************************
* @brief:lynq_set_boot_to_system
* @param count [IN]:char *option_para
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_set_boot_to_system(char *option_para)
{
    int ret = 0;
    if(option_para == NULL)
    {
        LYINFLOG("Input invalid value! null option parameters! ");
        return -1;
    }

    ret = zxic_dual_set_boot_to_system(atoi(option_para), 0);
    if(ret < 0)
    {
        LYINFLOG("Set boot to [%s] error ", option_para);
        return -1;
    }

    return 0;
}

/*****************************************
* @brief:lynq_get_upgrade_status
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_get_upgrade_status(void)
{
    z_upgrade_status_info_t status;
    int ret = 0;

    
    ret = zxic_dual_get_upgrade_status(&status);
    if(ret  < 0)
    {
        LYINFLOG("Get upgrade status fail! ");
        return -1;
    }
     
    LYINFLOG("Current upgrade info: ");
    LYINFLOG("Current upgrade status:%d ", status.upgrade_status);
    LYINFLOG("Current upgrade total size:%d ", status.total_size);
    LYINFLOG("Current upgrade updated size:%d ", status.upgraded_size);

    return status.upgrade_status;

}

/*****************************************
* @brief:lynq_get_upgrade_status
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_get_system_info()
{
    int ret = 0;
    z_upgrade_system_info_t system_info;

    ret = zxic_dual_get_system_status(&system_info);
    if(ret < 0)
    {
        LYINFLOG("Get upgrade status fail! ");
        return -1;
    }
    else
    {
        LYINFLOG("System info: ");
        LYINFLOG("Boot to:0x%08X[%d] ", system_info.boot_to, system_info.boot_to);
        LYINFLOG("Fota status:%d ", system_info.fota_status);
        LYINFLOG("System1 system:0x%08X [%d] ", system_info.system_1.system, system_info.system_1.system);
        LYINFLOG("System1 status:%d ", system_info.system_1.status);
        LYINFLOG("System1 try_cnt:%d ", system_info.system_1.try_cnt);
        LYINFLOG("System2 system:0x%08X [%d] ", system_info.system_2.system, system_info.system_2.system);
        LYINFLOG("System2 status:%d ", system_info.system_2.status);
        LYINFLOG("System2 try_cnt:%d ", system_info.system_2.try_cnt);
    }

    return 0;

}

/*****************************************
* @brief:lynq_set_system_a_status
* @param count [IN]:char *option_para
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/
int lynq_set_system_a_status(char *option_para)
{
    int ret = -1;
    if (NULL == option_para) 
    {
        LYINFLOG("Invalid option_para value  ");
        return -1;
    }

    //34650 A slot status : bootable:45527     unbootalbe:47806   success:23579
    ret = zxic_dual_set_system_status(34650, atoi(option_para));
    if(ret < 0)
    {
        LYINFLOG("Set system 1 status to [%s] error ", option_para);
        return -1;
    }

    return 0;

}

/*****************************************
* @brief:lynq_set_system_b_status
* @param count [IN]:char *option_para
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
*****************************************/
int lynq_set_system_b_status(char * option_para)
{
    int ret = -1;
    if (NULL == option_para) 
    {
        LYINFLOG("Invalid option_para  value  ");
        return -1;
    }

    //39019 B slot status: bootable:45227     unbootalbe:47806   success:23579
    ret = zxic_dual_set_system_status(39019, atoi(option_para)); 
    if(ret < 0)
    {
        LYINFLOG("Set system 2 status to [%s] error ", option_para);
    }

    return 0;
}

/*****************************************
* @brief:lynq_get_fota_status_for_nv
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
*****************************************/
int lynq_get_fota_status_for_nv()
{
    int status = 0;    
    status = zxic_dual_get_fota_status_for_nv();
    if(status != 0)
    {
        LYINFLOG("Fota status:%d ", status);
        return -1;
    }
    return 0;
}

/*****************************************
* @brief:lynq_set_fota_status_for_nv
* @param count [IN]:char *option_para
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
*****************************************/
int lynq_set_fota_status_for_nv(char * option_para)
{
    int ret = 0;

    if (NULL == option_para)
    {
        LYINFLOG("Invalid value! null option parameters! ");
        return -1;
    }

    ret = zxic_dual_set_fota_status_for_nv(atoi(option_para));
    if(ret < 0)
    {
        LYINFLOG("Set fota_status to [%s] error ", option_para);
    }

    return ret;
}

/*****************************************
* @brief:lynq_sync_system
* @param count [IN]:char *option_para
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
*****************************************/
int lynq_sync_system()
{
    int ret = -1;

    ret = zxic_dual_sync_system();
    if( ret != 0)
    {
        LYINFLOG("lynq sync system failed !!!!");
        return -1;
    }

    return 0;
}

/*****************************************
* @brief:lynq_get_upgrade_type
* @param count [IN]:NA
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
*****************************************/
int lynq_get_upgrade_type()
{
    int upgrade_type = -1;

    upgrade_type = zxic_dual_get_upgrade_type();
    if(upgrade_type < 0)
    {
        LYINFLOG("Get upgrade type failed \n");
        return -1;
    }
    else
    {
        LYINFLOG("upgrade type is %d", upgrade_type);
    }
    return 0;
}

/*****************************************
* @brief:lynq_get_sync_status
* @param count [IN]:char *option_para
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
*****************************************/
int lynq_get_sync_status()
{
    int sync_status = -2;
    zxic_dual_get_sync_status(&sync_status);
    LYINFLOG("Current sync status is %d", sync_status);
    return 0;
}

/*****************************************
* @brief:lynq_set_sync_status
* @param count [IN]:char *option_para
* @param sum [OUT]:NA
* @return :success: 0, failed:-1
* @todo:NA
* @see:NA
* @warning:NA
*****************************************/
int lynq_set_sync_status(char * option_para)
{
    int ret = 0;

    if (NULL == option_para) 
    {
        LYINFLOG("Command input invalid value! null option parameters! ");
        return -1;
    }

    ret = zxic_dual_set_sync_status(atoi(option_para));
    if (0 != ret)
    {
        LYINFLOG("set sync status fail");
        return -1;
    }

    return 0;
}


#ifdef __cplusplus
}
#endif

