/*============================================================================= 
#     FileName: lynq_gnss.c
#     Desc: about GNSS
#     Author: cz.li
#     Version: V1.0
#     LastChange: 2023-06-13 
#     History: 
=============================================================================*/

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <errno.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <pthread.h>
#include <termios.h>
#include <time.h>
#include <sys/timeb.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <dlfcn.h>
#include <stdint.h>
#include "mbtk_gnss_internal.h"
#include "ringbuffer.h"
#include "lynq_qser_gnss.h"
#ifdef __cplusplus
extern "C" {
#endif

int ret;
LYNQ_INJECT_TIME_INTO_T time_test;

int qser_Gnss_Init(uint32_t *h_gnss)
{
    ret = lynq_gnss_client_init(h_gnss);
    if(ret)
    {
        printf("Init faild\n");
    }
    return 0;
}

int qser_Gnss_Deinit(uint32_t h_gnss)
{
    ret = lynq_gnss_client_deinit(h_gnss);
    if(ret)
    {
        printf("Deinit faild\n");
    }
    return 0;
}

int qser_AddRxIndMsgHandler(gnss_handler_func_t handler_ptr,uint32_t h_gnss)
{
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    if(0 == h_gnss && NULL == handler_ptr)
    {
        printf("%s handler invalid.\n", __func__);
        return -1;
    }
    gnss_handle->gnss_handler_func = handler_ptr;
    return 0;
}

int qser_Set_Indications(uint32_t h_gnss,e_msg_id_t type)
{
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    printf("type in\n");
    switch(type)
    {

    case 1:
    {
        gnss_handle->mode = 1;
        break;
    }

    case 3:
    {
        gnss_handle->mode = 3;
        break;
    }
    default:
        break;

    }
    return 0;
}


/*need  set system time in advance*/
int qser_Gnss_InjectTime(uint32_t h_gnss,LYNQ_INJECT_TIME_INTO_T *time_info)
{
    time_t tNOW =time(NULL);
    struct timeb tmNOW;
    struct tm *ptm = {0};
    ptm = gmtime(&tNOW);
    printf("gmtime\n");
    ftime(&tmNOW);
    printf("fuzhi start\n");
    time_info->year = (ptm->tm_year+1900);
    time_info->month = (ptm->tm_mon+1);
    time_info->day = ptm->tm_mday;
    time_info->hour = ptm->tm_hour;
    time_info->minute = ptm->tm_min;
    time_info->second = ptm->tm_sec;
    time_info->millisecond = tmNOW.millitm;
    printf("fuzhi complate\n");
    char send_buf[128] = {0};
    printf("%d\n,%d\n,%d\n,%d\n,%d\n,%d\n,%d\r\n",time_info->year,time_info->month,time_info->day,\
           time_info->hour,time_info->minute,time_info->second,time_info->millisecond);
    snprintf(send_buf, sizeof(send_buf), "$AIDTIME,%d,%d,%d,%d,%d,%d,%d\r\n", time_info->year,time_info->month,time_info->day,\
             time_info->hour,time_info->minute,time_info->second,time_info->millisecond);
    ret = lynq_gnss_send_cmd(h_gnss, send_buf, sizeof(send_buf));
    if(ret < 0)
    {
        printf("send fail\n");
        return -1;
    }

    return 0;
}

int qser_Gnss_Start(uint32_t h_gnss)
{
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    lynq_open_gps(1);
    ret = set_baudrate(gnss_handle->dev_fd, B9600);
    if(-1 == ret)
    {
        return  -2;
    }
    return 0;
}

int qser_Gnss_Stop(uint32_t h_gnss)
{
    lynq_open_gps(0);
    return 0;
}



/*清除辅助数据
bit0 - 清除星历
bit1 - reserve0
bit2 - 清除接收机位置和接收机时间
bit3 - reserve1
bit4 - 清除电离层修正参数和 UTC 参数
bit5 - reserve2
bit6 - reserve3
bit7 - 清除历书
*/

int qser_Gnss_Delete_Aiding_Data(uint32_t h_gnss,DELETE_AIDING_DATA_TYPE_T flags)
{
    char send_buf[60] = {0};
    struct mbtk_gnss_handle_t *gnss_handle = (struct mbtk_gnss_handle_t *)h_gnss;
    switch(flags)
    {
    case 0:
    {
        snprintf(send_buf, sizeof(send_buf), "$RESET,0,h00\r\n");

        break;
    }
    case 1:
    {
        snprintf(send_buf, sizeof(send_buf), "$RESET,0,h01\r\n");

        break;
    }
    case 2:
    {
        snprintf(send_buf, sizeof(send_buf), "$RESET,0,h04\r\n");
        break;
    }
    case 3:
    {
        snprintf(send_buf, sizeof(send_buf), "$RESET,0,h10\r\n");
        break;
    }
    case 4:
    {
        snprintf(send_buf, sizeof(send_buf), "$RESET,0,h80\r\n");
        break;
    }
    case 5:
    {
        snprintf(send_buf, sizeof(send_buf), "$RESET,0,hFF\r\n");//冷启动
        break;
    }
    }
    ring_buffer_clean(&gnss_handle->ring_buffer);
    gnss_log("%s : %s\n", __FUNCTION__, send_buf);
    pthread_mutex_lock(&gnss_handle->_cond_mutex);
    gnss_handle->reset_state = 1;
    pthread_mutex_unlock(&gnss_handle->_cond_mutex);
    ret = lynq_gnss_send_cmd(h_gnss, send_buf, strlen(send_buf));
    if(ret < 0)
    {
        printf("send faild");
        return -1;
    }
    printf("reset OK!!!!!\n");

    ret = set_baudrate(gnss_handle->dev_fd, B9600);
    if(-1 == ret)
    {
        return  -2;
    }

    return 0;
}

#ifdef __cplusplus
}
#endif
