/**
 *@file     qser_voice.h
 *@date     2017-11-30
 *@author   
 *@brief    
 */


#ifndef __LYNQ_QSER_VOICE_H__
#define __LYNQ_QSER_VOICE_H__
#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
    E_QSER_VCALL_EXTERNAL_SLOT_1,
    E_QSER_VCALL_EXTERNAL_SLOT_2,
    E_QSER_VCALL_EMBEDDED,
    E_QSER_VCALL_REMOTE,
    E_QSER_VCALL_ID_MAX
}E_QSER_VCALL_ID_T;

typedef enum 
{
    E_QSER_VOICE_CALL_STATE_INCOMING      = 0x0000, /**< MT incoming; CC setup. */
    E_QSER_VOICE_CALL_STATE_DIALING       = 0x0001, /**< Dialing state. */
    E_QSER_VOICE_CALL_STATE_ALERTING      = 0x0002, /**< MT call waiting; MO alterting. */
    E_QSER_VOICE_CALL_STATE_ACTIVE        = 0x0003, /**< Call is active. */
    E_QSER_VOICE_CALL_STATE_HOLDING       = 0x0004, /**< Call is on hold. */
    E_QSER_VOICE_CALL_STATE_END           = 0x0005, /**< Call is disconnected. */
    E_QSER_VOICE_CALL_STATE_WAITING       = 0x0006, /**< Call is waiting. */
}qser_voice_call_state_t;

typedef enum 
{
    E_QSER_VOICE_CALL_WAITING_VOICE_ENABLED       = 0, /**<  Voice call waiting enabled. */
    E_QSER_VOICE_CALL_WAITING_DISABLED            = 1, /**<  Voice call waiting disabled. */
}E_QSER_VOICE_CALL_WAITING_SERVICE_T;

typedef struct 
{
    E_QSER_VOICE_CALL_WAITING_SERVICE_T   waiting_service;
}qser_voice_call_waiting_service_t;

typedef qser_voice_call_state_t E_QSER_VOICE_CALL_STATE_T;

typedef uint32_t voice_client_handle_type;

/* Callback function registered via QSER_Voice_Call_AddStateHandler;
   This will be called if any stated changed of call_id
*/
typedef void (*QSER_VoiceCall_StateHandlerFunc_t)
(
    int                     caLOCAL_C_INCLUDESll_id,
    char*                   phone_num,
    E_QSER_VOICE_CALL_STATE_T state,
    void                    *contextPtr
);

/* Init voice module and return h_voice, this should be called before any other APIs */
int qser_voice_call_client_init(voice_client_handle_type  *ph_voice);

/* DeInit voice module and release resources, this should be called at last */
int qser_voice_call_client_deinit(voice_client_handle_type h_voice);

/* Add callback function, if any call state changed, handlerPtr will be called to notify App */
int qser_voice_call_addstatehandler(voice_client_handle_type          h_voice,
                                  QSER_VoiceCall_StateHandlerFunc_t   handlerPtr,
                                  void*                             contextPtr);

/* Remove callback function, won't receive any notify anymore */
int qser_voice_call_removestatehandle(voice_client_handle_type       h_voice);

/* Start call and return call_id, this can be used in the later */
int qser_voice_call_start(voice_client_handle_type    h_voice,
                        E_QSER_VCALL_ID_T             simId,
                        char*                       phone_number,   ///< [IN] Destination identifier for the voice
                        int                         *call_id);       ///< [OUT] call id

/* End call of call_id, which returned by QSER_Voice_Call_Start or callback func register via QSER_Voice_Call_AddStateHandler */
int qser_voice_call_end(  voice_client_handle_type    h_voice,
                        int                         call_id);        ///< [IN] call id, return by QSER_Voice_Start

/* Answer the call of call_id, which returned by callback func register via QSER_Voice_Call_AddStateHandler */
int qser_voice_call_answer(voice_client_handle_type    h_voice,
                         int                         call_id );

int qser_voice_call_switch_waiting_or_holding_and_active(voice_client_handle_type h_voice);

//Set voice call waiting
int qser_voice_call_setwaiting
( 
    int                                 h_voice, 
    qser_voice_call_waiting_service_t e_service
);

//Get voice call waiting status
int qser_voice_call_getwaitingstatus
(
    int                                 h_voice, 
    qser_voice_call_waiting_service_t *pe_service
);


/*
Usage 1 (register callback and wait for new call in, then answer): 
1, QSER_Voice_Call_Client_Init
2, QSER_Voice_Call_AddStateHandler(pf_cb)
3, wait for new call arrive, pf_cb will pass the call_id to app.
4, QSER_Voice_Call_Answer(call_id)
5, QSER_Voice_Call_End
6, QSER_Voice_Call_Client_Deinit


Usage 2 (call out): 
1, QSER_Voice_Call_Client_Init
2, QSER_Voice_Call_AddStateHandler(pf_cb)
3, QSER_Voice_Call_Start
4, QSER_Voice_Call_End
5, QSER_Voice_Call_Client_Deinit


*/
    
#ifdef __cplusplus
}
#endif

#endif // __QSER_VOICE_H__

