#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <liblog/lynq_deflog.h>
#include <sys/types.h>
#include <pthread.h>
#include <libcall/lynq_call.h>

#include "lynq-qser-voice.h"

#define USER_LOG_TAG "LYNQ_QSER_CALL"

#define RESULT_OK (0)
#define RESULT_ERROR (-1)

static pthread_t s_lynq_voice_tid = -1;
static QSER_VoiceCall_StateHandlerFunc_t   s_voice_cb = NULL;
static int s_voice_thread_status = 0;

 typedef enum {
     LYNQ_CALL_ACTIVE = 0,
     LYNQ_CALL_HOLDING = 1,
     LYNQ_CALL_DIALING = 2,    /* MO call only */
     LYNQ_CALL_ALERTING = 3,   /* MO call only */
     LYNQ_CALL_INCOMING = 4,   /* MT call only */
     LYNQ_CALL_WAITING = 5,    /* MT call only */
     /*warren add for T800 platform 2022/04/26 start*/
     LYNQ_CALL_END = 6,         /*CALL END*/
     /*warren add for T800 platform 2022/04/26 end*/
}lynq_call_state_t;


void *voice_thread_recv(void *context)
{
    int handle = 0;
    int call_state;
    int toa;
    int direction;
    char addr[64];
    E_QSER_VOICE_CALL_STATE_T voice_state;
    while (s_voice_thread_status)
    {
        lynq_wait_call_state_change(&handle);
        lynq_get_current_call_state(&handle,&call_state,&toa,&direction,addr);
        if (call_state == LYNQ_CALL_ACTIVE)
        {
            voice_state = E_QSER_VOICE_CALL_STATE_ACTIVE;
        }
        else if(call_state == LYNQ_CALL_HOLDING)
        {
            voice_state = E_QSER_VOICE_CALL_STATE_HOLDING;
        }
        else if(call_state == LYNQ_CALL_DIALING)
        {
            voice_state = E_QSER_VOICE_CALL_STATE_DIALING;
        }
        else if(call_state == LYNQ_CALL_ALERTING)
        {
            voice_state = E_QSER_VOICE_CALL_STATE_ALERTING;
        }
        else if(call_state == LYNQ_CALL_INCOMING)
        {
            voice_state = E_QSER_VOICE_CALL_STATE_INCOMING;
        }
        else if(call_state == LYNQ_CALL_WAITING)
        {
            voice_state = E_QSER_VOICE_CALL_STATE_WAITING;
        }
        else if(call_state == LYNQ_CALL_END)
        {
            voice_state = E_QSER_VOICE_CALL_STATE_END;
        }
        else
        {
            LYERRLOG("unknow call state");
            continue;
        }
        if (s_voice_cb != NULL)
        {
            s_voice_cb(handle,addr,voice_state,context);
        }
    }
    return NULL;
}

int qser_voice_call_client_init(voice_client_handle_type  *ph_voice)
{   
    if(NULL == ph_voice)
    {
        LYERRLOG("input error");
        return RESULT_ERROR;
    }
    *ph_voice = (voice_client_handle_type)getpid();
    return lynq_init_call(*ph_voice);
}

int qser_voice_call_client_deinit(voice_client_handle_type h_voice)
{
    if (0 == h_voice)
    {
        LYERRLOG("init first");
        return RESULT_ERROR;
    }
    return lynq_deinit_call();
}

int qser_voice_call_addstatehandler(voice_client_handle_type          h_voice,
                                  QSER_VoiceCall_StateHandlerFunc_t   handlerPtr,
                                  void*                             contextPtr)
{
    if(h_voice == 0 || handlerPtr== NULL)
    {
        LYERRLOG("input error");
        return RESULT_ERROR;
    }
    if (s_voice_cb != NULL)
    {
        LYERRLOG("The existing state handle does not need to be added");
        return RESULT_ERROR;
    }
    s_voice_cb = handlerPtr;
    s_voice_thread_status = 1;
    int rt = pthread_create(&s_lynq_voice_tid, NULL, voice_thread_recv, contextPtr);
    if(rt < 0)
    {
        LYDBGLOG("qser_voice_call_addstatehandler pthread_create error!!!\n");
        s_voice_cb = NULL;
        s_voice_thread_status = 0;
        s_lynq_voice_tid = -1;
        return RESULT_ERROR;
    }
    return RESULT_OK;
}

int qser_voice_call_removestatehandle(voice_client_handle_type h_voice)
{
    int ret;
    if (s_lynq_voice_tid != -1)
    {
        ret = pthread_cancel(s_lynq_voice_tid);
        LYDBGLOG("pthread cancel ret = %d",ret);
    }
    if (s_lynq_voice_tid != -1)
    {
        ret = pthread_join(s_lynq_voice_tid,NULL);
        LYDBGLOG("pthread cancel ret = %d",ret);
        s_lynq_voice_tid = -1;
    }
    s_voice_thread_status = 0;
    s_voice_cb = NULL;
    return RESULT_OK;
}

int qser_voice_call_start(voice_client_handle_type    h_voice,
                        E_QSER_VCALL_ID_T             simId,
                        char*                       phone_number,
                        int                         *call_id)
{
    if(h_voice == 0 || NULL == phone_number || NULL == call_id)
    {
        LYERRLOG("qser_voice_call_start input error");
        return RESULT_ERROR;
    }
    return lynq_call(call_id,phone_number);
}  

int qser_voice_call_end(voice_client_handle_type h_voice,int call_id)
{
    if(h_voice == 0 || call_id <= 0)
    {
        LYERRLOG("qser_voice_call_end input error");
        return RESULT_ERROR;
    }
    return lynq_call_hungup(&call_id);
}

int qser_voice_call_answer(voice_client_handle_type h_voice,int call_id)
{
    if(h_voice == 0 || call_id <= 0)
    {
        LYERRLOG("qser_voice_call_answer input error");
        return RESULT_ERROR;
    }
    return lynq_call_answer();
}

int qser_voice_call_getwaitingstatus(int h_voice,qser_voice_call_waiting_service_t *pe_service)
{
    LYINFLOG("To be completed");
    return RESULT_OK;
}

int qser_voice_call_setwaiting(int h_voice, qser_voice_call_waiting_service_t e_service)
{
    LYINFLOG("To be completed");
    return RESULT_OK;
}


int qser_voice_call_switch_waiting_or_holding_and_active(voice_client_handle_type h_voice)
{
    if (h_voice == 0)
    {
        LYERRLOG("init first");
        return RESULT_ERROR;
    }
    return lynq_switch_waiting_or_holding_and_active();
}