/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "EcallUtils.h"
#include "../../utils/GostEcallUtils.h"
using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_EGOST_EcallUtils"

EcallUtils::EcallUtils() {
    // TODO Auto-generated constructor stub

}

EcallUtils::~EcallUtils() {
    // TODO Auto-generated destructor stub
}

const std::string& EcallUtils::getEcallMsdReq() const {
    return ecallMsdReq;
}

void EcallUtils::setEcallMsdReq(const std::string ecallMsdReq) {
    this->ecallMsdReq = ecallMsdReq;
}

std::uint8_t EcallUtils::getEcallReq() const {
    return ecallReq;
}

void EcallUtils::setEcallReq(std::uint8_t ecallReq) {
    this->ecallReq = ecallReq;
}

std::int32_t EcallUtils::getMid() const {
    return mid;
}

void EcallUtils::setMid(std::int32_t mid) {
    this->mid = mid;
}

std::uint8_t EcallUtils::getTransport() const {
    return transport;
}

void EcallUtils::setTransport(std::uint8_t transport) {
    this->transport = transport;
}

int EcallUtils::decodeMsgReq(const string& data) {
    if (data.empty()) {
        MTK_RLOGD("data is invalid, return");
        return -1;
    }
    MTK_RLOGD("data: %s", data.c_str());
    uint32_t index = 0;
    int64_t ret = 0;
    //MID(message identifier)
    ret = decodeValue(data, index, 8, "MID(message identifier)");
    if (ret == -1) {
        MTK_RLOGW("decode MID fail");
        return -1;
    }
    MTK_RLOGD("index: %d, MID: %d", index, (int32_t )ret);
    mid = (int32_t) (ret);
    //transport
    ret = decodeValue(data, index, 2, "transport");
    if (ret == -1) {
        MTK_RLOGW("decode transport fail");
        return -1;
    }
    MTK_RLOGD("index: %d, transport: %u", index, (uint8_t )ret);
    transport = (uint8_t) (ret);
    ecallMsdReq = data;
    if(data.size() != index) {
        MTK_RLOGW("maybe error data.size(%d) != index", data.size(), index);
        return -1;
    }
    return 0;
}

const std::string& EcallUtils::getNumber() const {
    return number;
}

void EcallUtils::setNumber(const std::string number) {
    this->number = number;
}

int EcallUtils::decodeReq(const string& data) {
    if (data.empty()) {
        MTK_RLOGD("data is invalid, return");
        return -1;
    }
    MTK_RLOGD("data: %s", data.c_str());
    uint32_t index = 0;
    int64_t ret = 0;

    //ecallReq
    ret = decodeValue(data, index, 2, "ecallReq");
    if (ret == -1) {
        MTK_RLOGW("decode ecallReq fail");
        return -1;
    }
    MTK_RLOGD("index: %d, ecallReq: %u", index, (uint8_t )ret);
    ecallReq = (uint8_t) (ret);
    return 0;
}

int EcallUtils::decodeECallCmd(std::uint16_t cmd, const string& data) {
    MTK_RLOGD("cmd=0X%02X, data: %s", cmd, (data.empty() ? "": data.c_str()));
    if(cmd == EGTS_ECALL_MSD_REQ) {
        int ret = decodeMsgReq(data);
        if(ret == -1) {
            MTK_RLOGW("decodeMsgReq() fail");
            return -1;
        }
    } else if(cmd == EGTS_ECALL_REQ) {
        int ret = decodeReq(data);
        if(ret == -1) {
            MTK_RLOGW("decodeReq() fail");
            return -1;
        }
    } else if(cmd == EGTS_ECALL_DEREGISTRATION) {
        MTK_RLOGD("decocde EGTS_ECALL_DEREGISTRATION success");
        return 0;
    } else {
        MTK_RLOGW("don't support, just return");
    }
    return 0;
}

bool EcallUtils::isEcallCmd(std::uint16_t cmd) {
    MTK_RLOGD("cmd=0X%02X", cmd);
    switch (cmd) {
    case EGTS_ECALL_REQ:
    case EGTS_ECALL_MSD_REQ:
    case EGTS_ACCEL_DATA:
    case EGTS_TRACK_DATA:
    case EGTS_ECALL_DEREGISTRATION:
        ///General-purpose settings
    case EGTS_ECALL_TEST_NUMBER:
        //service configuration and configuration data. Base Service of Road Accident Emergency Response System.
    case EGTS_ECALL_ON:
    case EGTS_ECALL_CRASH_SIGNAL_INTERNAL:
    case EGTS_ECALL_CRASH_SIGNAL_EXTERNAL:
    case EGTS_ECALL_SOS_BUTTON_TIME:
    case EGTS_ECALL_NO_AUTOMATIC_TRIGGERING:
    case EGTS_ASI15_TRESHOLD:
    case EGTS_ECALL_MODE_PIN:
    case EGTS_ECALL_CCFT:
    case EGTS_ECALL_INVITATION_SIGNAL_DURATION:
    case EGTS_ECALL_SEND_MSG_PERIOD:
    case EGTS_ECALL_AL_ACK_PERIOD:
    case EGTS_ECALL_MSD_MAX_TRANSMISSON_TIME:
    case EGTS_ECALL_NAD_DEREGISTRATION_TIMER:
    case EGTS_ECALL_DIAL_DURATION:
    case EGTS_ECALL_AUTO_DIAL_ATTEMPTS:
    case EGTS_ECALL_MANUAL_DIAL_ATTEMPTS:
    case EGTS_ECALL_MANUAL_CAN_CANCEL:
    case EGTS_ECALL_SMS_FALLBACK_NUMBER:
        //Acceleration profile recording in case of road accidents
    case IGNITION_OFF_FOLLOW_UP_TIME1:
    case IGNITION_OFF_FOLLOW_UP_TIME2:
    case EGTS_CRASH_RECORD_TIME:
    case EGTS_CRASH_RECORD_RESOLUTION:
    case EGTS_CRASH_PRE_RECORD_TIME:
    case EGTS_CRASH_PRE_RECORD_RESOLUTION:
    case EGTS_TRACK_RECORD_TIME:
    case EGTS_TRACK_PRE_RECORD_TIME:
    case EGTS_TRACK_RECORD_RESOLUTION:
        //vehicle parameters
    case EGTS_VEHICLE_VIN:
    case EGTS_VEHICLE_PROPULSION_STORAGE_TYPE:
    case EGTS_VEHICLE_TYPE: {
        return true;
    }
    }
    return false;
}

bool EcallUtils::isNeedNewSms() {
    MTK_RLOGD("transport = %d", transport);
    return (transport == 2);
}

int EcallUtils::getEcallReqPara() {
    MTK_RLOGD("ecallReq = %d", ecallReq);
    return ecallReq;
}
