#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include "lynq_data.h"
#include <cutils/jstring.h>
#include <pthread.h>
#include "liblog/lynq_deflog.h"
#include <sys/time.h>
#include <include/lynq_uci.h>
#include <errno.h>
#include <vector>
#include "lynq_data_urc.h"

#define LYNQ_SERVICE_PORT 8088
#define LYNQ_REC_BUF 8192
#define LYNQ_REQUEST_PARAM_BUF 8192
#define LYQN_SEDN_BUF 1024*8+sizeof(int)*3
#define USER_LOG_TAG "LYNQ_DATA"

#define LYNQ_DATA_UCI_BUF 258

#define LYNQ_ADDRESS "127.0.0.1"

using ::android::Parcel;
typedef struct{
    int uToken;
    int request;
    int paramLen;
    char param[LYNQ_REQUEST_PARAM_BUF];
}lynq_client_t;
typedef enum{
    LYNQ_E_CARDSTATE_ERROR=8000,
    /* The voice service state is out of service*/
    LYNQ_E_STATE_OUT_OF_SERVICE=8001,
    /* The voice service state is EMERGENCY_ONLY*/
    LYNQ_E_STATE_EMERGENCY_ONLY=8002,
    /* The radio power is power off*/
    LYNQ_E_STATE_POWER_OFF=8003,
    LYNQ_E_TIME_OUT=8004,
    /*create or open sms DB fail */
    LYNQ_E_SMS_DB_FAIL=8005,
    /*Failed to execute sql statement*/
    LYNQ_E_SMS_SQL_FAIL = 8006,
    LYNQ_E_SMS_NOT_FIND = 8007,
    /* The logic conflict*/
    LYNQ_E_CONFLICT=9000,
    /*Null anomaly*/
    LYNQ_E_NULL_ANONALY=9001
}LYNQ_E;

int lynq_client_sockfd = 0;
int Global_uToken = 0;
struct sockaddr_in lynq_data_socket_server_addr;
int lynq_data_socket_server_addr_len;

int lynq_data_call_change_id = -1;
pthread_t lynq_data_tid =-1;
static pthread_mutex_t s_data_call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_data_call_state_change_cond = PTHREAD_COND_INITIALIZER;

static pthread_mutex_t s_lynq_apn_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_lynq_apn_change_cond = PTHREAD_COND_INITIALIZER;
static pthread_mutex_t s_lynq_urc_vector_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_lynq_urc_vector_cond = PTHREAD_COND_INITIALIZER;
/**g_lynq_data_sendto_mutex
* @brief mark data send request mutex
*/
static pthread_mutex_t g_lynq_data_sendto_mutex;
/*This value data the state of the wait*/
static int data_waiting_status = 0;
/*The value indicates that 8085 error occurs in data*/
static int data_invaild_error = 0;
/*This value ensure the data call timing is correct*/
static int data_timelimit = 0;

/**g_lynq_data_init_flag
* @brief mark data initialization state
* 0:deinit status
* 1:init state
*/
static int g_lynq_data_init_flag = 0;
/**g_lynq_apn_result
* @brief temp of apn result info
*/
char g_lynq_apn_result[1024] = {};

static std::vector<int> s_data_urc_wait_list;

typedef struct
{
    char apn[LYNQ_APN_MAX_LEN];
    char apnType[LYNQ_APN_TYPE_MAX_LEN];
    char ifaceName[LYNQ_IFACE_NAME_MAX_LEN];
#ifdef MOBILETEK_TARGET_PLATFORM_T106
    int cid;
#endif
    int status;
    char statusApnType[LYNQ_APN_TYPE_MAX_LEN];
    int hasUsed;
    int hasTimeout;
}lynq_apn_t;
lynq_apn_t lynq_apn_table[LYNQ_APN_CHANNEL_MAX] = {};
lynq_data_call_response_v11_t lynq_data_call_lists[LYNQ_APN_CHANNEL_MAX] = {};
int lynq_data_call = 0;

int getLynqApnID(char apnType[])
{
    int ret = 0;
    int len = 0;
    for(ret;ret<LYNQ_APN_CHANNEL_MAX;ret++)
    {
        len = strlen(apnType);
        LYINFLOG("apn_table[%d].apnType:%s,input apntype:%s,len:%d",ret,lynq_apn_table[ret].apnType,apnType,len);
        if(strncmp(lynq_apn_table[ret].apnType,apnType,len)==0)
        {
            return ret;
        }
    }
    return -1;
}

int  getDeactApnID(char apnType[])
{
    int ret = 0;
    int len = 0;
    for(ret;ret<LYNQ_APN_CHANNEL_MAX;ret++)
    {
        len = strlen(apnType);
        LYINFLOG("apn_table[%d].apnType:%s,input apntype:%s,len:%d",ret,lynq_apn_table[ret].apnType,apnType,len);
        if(strncmp(lynq_apn_table[ret].statusApnType,apnType,len)==0)
        {
            return ret;
        }
    }
    return -1;
}

void updateApnTable(lynq_apn_t *apn_table,char apn[],char apntype[],char ifaceName[])
{
    LYDBGLOG("[updateApnTable] apn:%s,apntype:%s,ifaceName:%s",apn,apntype,ifaceName);
    if(apn_table==NULL)
    {
        LYERRLOG("apn_table is null");
        return;
    }
    memcpy(apn_table->apn,apn,strlen(apn)+1);
    memcpy(apn_table->apnType,apntype,strlen(apntype)+1);
    memcpy(apn_table->ifaceName,ifaceName,strlen(ifaceName)+1);
    apn_table->hasTimeout = 0;
    apn_table->hasUsed = 1;
    return;
}

void cleanOnceApnTable(int apnId)
{
    LYDBGLOG("%s:apn id:%d",__FUNCTION__,apnId);
    if((apnId < 0) || (apnId > LYNQ_APN_CHANNEL_MAX-1))
    {
        LYERRLOG("apn id is invalid!!!");
        return;
    }
    lynq_apn_table[apnId].hasTimeout = 0;
    lynq_apn_table[apnId].hasUsed = 0;
    memcpy(lynq_apn_table[apnId].statusApnType,lynq_apn_table[apnId].apnType,strlen(lynq_apn_table[apnId].apnType));
    bzero(lynq_apn_table[apnId].apn,LYNQ_APN_MAX_LEN);
    bzero(lynq_apn_table[apnId].apnType,LYNQ_APN_TYPE_MAX_LEN);
    bzero(lynq_apn_table[apnId].ifaceName,LYNQ_IFACE_NAME_MAX_LEN);
    lynq_apn_table[apnId].status = 32;
#ifdef MOBILETEK_TARGET_PLATFORM_T106
    lynq_apn_table[apnId].cid = 0;
#endif
    return;
}
void cleanDeactApn(int apnId)
{
    LYDBGLOG("%s:apn id:%d",__FUNCTION__,apnId);
    if((apnId < 0) || (apnId > LYNQ_APN_CHANNEL_MAX-1))
    {
        LYERRLOG("apn id is invalid!!!");
        return;
    }
    lynq_apn_table[apnId].status = 0;
    bzero(lynq_apn_table[apnId].statusApnType,LYNQ_APN_TYPE_MAX_LEN);
}

void updateDeactApn(int apnId,int pdnState)
{
    LYDBGLOG("%s:apn id:%d",__FUNCTION__,apnId);
    if((apnId < 0) || (apnId > LYNQ_APN_CHANNEL_MAX-1))
    {
        LYERRLOG("apn id is invalid!!!");
        return;
    }
    lynq_apn_table[apnId].status = pdnState;
}


int getUnusedElement()
{
    if (lynq_apn_table == NULL)
    {
        LYERRLOG("get UnusedElemnt apn_table is null");
        return -1;
    }
    for(int i=0;i < LYNQ_APN_CHANNEL_MAX; i++)
    {
        if(lynq_apn_table[i].hasUsed!=1)
        {
            return i;
        }
    }
	LYERRLOG("None of get unused Element");
    return -1;
}
int updateApn(char apnType[])
{
    int ret = 0;
    ret = getUnusedElement();
    if(ret >= 0)
    {
    	memcpy(lynq_apn_table[ret].apnType,apnType,strlen(apnType)+1);
    	lynq_apn_table[ret].hasUsed = 1;
	}
    return ret;
}
//xf.li@20230610 add for T106 data start
int findCidInTable(int cid)
{
    int i = 0;
    for(i = 0;i < LYNQ_APN_CHANNEL_MAX; i++)
    {
        if(lynq_apn_table[i].cid == cid)
        {
            LYERRLOG("has exit this cid %d in slot %d\n", cid, i);
            return i;
        }
    }
    return -1;
}
//xf.li@20230610 add for T106 data end
int handleCheck(int handle)
{
    if (lynq_apn_table[handle].hasUsed == 1)
    {
        return 0;
    }
    else 
    {
        return -1;
    }
}
int waitApnResult()
{
    int ret = 0;
    LYINFLOG("start wait apn result!!!");
    int sec = 0;
    int usec = 0;
    struct timeval now;
    struct timespec timeout;
    gettimeofday(&now, NULL);
    sec = 20000 / 1000;
    usec = 20000 % 1000;
    timeout.tv_sec = now.tv_sec + sec;
    timeout.tv_nsec = now.tv_usec * 1000 + usec * 1000000;
    pthread_mutex_lock(&s_lynq_apn_change_mutex);
    ret = pthread_cond_timedwait(&s_lynq_apn_change_cond, &s_lynq_apn_change_mutex, &timeout);
    pthread_mutex_unlock(&s_lynq_apn_change_mutex);
    return ret;
}

void sendSignalApnChange()
{
    LYINFLOG("start send Signal Apn Change");
    pthread_mutex_lock(&s_lynq_apn_change_mutex);
    pthread_cond_signal(&s_lynq_apn_change_cond);
    pthread_mutex_unlock(&s_lynq_apn_change_mutex);
    return;
}

int waitPdnChange()
{
    int ret = 0;
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    ret = pthread_cond_wait(&s_lynq_urc_vector_cond,&s_lynq_urc_vector_mutex);
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return ret;
}
int waitDataCallstateChange(int mtime)
{
    int ret = 0;
    int sec = 0;
    int usec = 0;
    struct timeval now;
    struct timespec timeout;
    gettimeofday(&now,NULL);
    sec = mtime/1000;
    usec = mtime%1000;
    timeout.tv_sec = now.tv_sec+sec;
    timeout.tv_nsec = now.tv_usec*1000+usec*1000000;
    pthread_mutex_lock(&s_data_call_state_change_mutex);
    ret = pthread_cond_timedwait(&s_data_call_state_change_cond,&s_data_call_state_change_mutex,&timeout);
    pthread_mutex_unlock(&s_data_call_state_change_mutex);
    return ret;
}
void sendSignalDataCallStateChange()
{
    pthread_mutex_lock(&s_data_call_state_change_mutex);
    pthread_cond_signal(&s_data_call_state_change_cond);
    pthread_mutex_unlock(&s_data_call_state_change_mutex);
    return;
}
void sendSignalPdnChange()
{
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    pthread_cond_signal(&s_lynq_urc_vector_cond);
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return;
}

int get_response(int sockfd,Parcel &p)
{
    int len = 0;
    char recvline[LYNQ_REC_BUF];
    bzero(recvline,LYNQ_REC_BUF);
    /* receive data from server */
    len = recvfrom(sockfd,recvline,LYNQ_REC_BUF,0,(struct sockaddr *)&lynq_data_socket_server_addr,(socklen_t *)&lynq_data_socket_server_addr_len);
    //len = read(sockfd, recvline, LYNQ_REC_BUF);
    if(len == -1)
    {
        LYERRLOG("get_response fail,errno:%d",errno);
        return -1;
    }
    if (recvline != NULL) {
        p.setData((uint8_t *)recvline,len); // p.setData((uint8_t *) buffer, buflen);
        p.setDataPosition(0);
    }
    return 0;
}
int JumpHeader(Parcel &p,int *resp_type,int *request,int *slot_id,int *error)
{
    if(p.dataAvail() > 0)
    {
        p.readInt32(resp_type);
        p.readInt32(request);
        p.readInt32(slot_id);
        p.readInt32(error);
        return 0;
    }
    else
    {
        return -1;
    }
}
int send_request(int sockfd,lynq_client_t *client_tmp)
{
    int ret=0;
    ret = write(sockfd, client_tmp, LYQN_SEDN_BUF);
    if(ret==-1)
    {
        perror("write error");
        return -1;
    }
    return 0;
}
static char *strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}
static char *strdupReadString_p(Parcel *p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p->readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

/*Warren add for T800 platform 2021/11/19 start*/
int lynq_socket_client_start()
{
    /* init lynq_socket_server_addr */
    bzero(&lynq_data_socket_server_addr, sizeof(lynq_data_socket_server_addr));
    lynq_data_socket_server_addr.sin_family = AF_INET;
    lynq_data_socket_server_addr.sin_port = htons(LYNQ_SERVICE_PORT);
    lynq_data_socket_server_addr.sin_addr.s_addr = inet_addr(LYNQ_ADDRESS);
    lynq_data_socket_server_addr_len = sizeof(lynq_data_socket_server_addr);
    /*
    if(inet_pton(AF_INET,"127.0.0.1", &lynq_socket_server_addr.sin_addr) <= 0)
    {
        LYINFLOG("[%s] is not a valid IPaddress\n", argv[1]);
        exit(1);
    }
*/
    lynq_client_sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    struct timeval timeOut; 

    timeOut.tv_sec = 30;
    timeOut.tv_usec = 0; 

    if (setsockopt(lynq_client_sockfd, SOL_SOCKET, SO_RCVTIMEO, &timeOut, sizeof(timeOut)) < 0) 
    { 
        LYERRLOG("time out setting failed"); 
    } 
    if(connect(lynq_client_sockfd, (struct sockaddr *)&lynq_data_socket_server_addr, sizeof(lynq_data_socket_server_addr)) == -1)
    {
        perror("connect error");
        return -1;
    }
    return 0;
}

bool is_support_urc(int urc_id)
{
    switch(urc_id)
    {
        case LYNQ_URC_DATA_CALL_STATUS_IND:

        case LYNQ_URC_MODIFY_APNDB:
        case LYNQ_URC_RESET_APNDB:
            return true;                
        default:
            return false;
    }    
}
//xf.li@20230610 add for T106 data start
bool is_support_urc_t106(int urc_id)
{
    switch(urc_id)
    {
        case RIL_UNSOL_DATA_CALL_LIST_CHANGED:
        case LYNQ_URC_MODIFY_APNDB:
        case LYNQ_URC_RESET_APNDB:
            return true;                
        default:
            return false;
    }    
}
//xf.li@20230610 add for T106 data end
int printf_apn_table()
{
    int ret = 0;
    if (lynq_apn_table == NULL)
    {
        LYERRLOG("apn table is null");
        return -1;
    }
    for(ret;ret<LYNQ_APN_CHANNEL_MAX;ret++)
    {
        //xf.li@20230610 add for T106 data start
#ifdef MOBILETEK_TARGET_PLATFORM_T106
        LYINFLOG("[Typethree test info]apn=%s ;apntype=%s ;cid=%d ;ifname=%s ;hasTimeout = %d ; hasUsed = %d", \
        lynq_apn_table[ret].apn,lynq_apn_table[ret].apnType,lynq_apn_table[ret].cid,lynq_apn_table[ret].ifaceName, \
        lynq_apn_table[ret].hasTimeout,lynq_apn_table[ret].hasUsed);
#else
		LYINFLOG("[%s][%d] apn=%s ;apntype=%s ;ifname=%s ;hasTimeout = %d ; hasUsed = %d,status = %d,statusDeactApn = %s",__FUNCTION__,ret, \
        lynq_apn_table[ret].apn,lynq_apn_table[ret].apnType,lynq_apn_table[ret].ifaceName, \
        lynq_apn_table[ret].hasTimeout,lynq_apn_table[ret].hasUsed,lynq_apn_table[ret].status,lynq_apn_table[ret].statusApnType);
#endif
        //xf.li@20230610 add for T106 data end
    }
    return 0;
}
//xf.li@20230607 add for T106 data start
void urc_msg_process_add_for_t106(Parcel *p)
{
    int len;
    int resp_type;
    int urcid;
    int slot_id;
    int check_count = 0;

    int version = -1;
    int num = -1;
    int status = -1;
    int suggestedRetryTime = -1;
    int cid = -1;
    int active = -1;
    int mtu = -1;

    int pdnState = 0;
    char apn[LYNQ_APN_MAX_LEN];
    char apnType[LYNQ_APN_TYPE_MAX_LEN];
    char ifaceName[LYNQ_IFACE_NAME_MAX_LEN];
    char type[LYNQ_TYPE_MAX_LEN];
    char addresses[LYNQ_ADDRESSES_MAX_LEN];
    char dnses[LYNQ_DNSES_MAX_LEN];
    char gateways[LYNQ_GATEWAYS_MAX_LEN];
    char pcscf[LYNQ_PCSCF_MAX_LEN];

    int cid_list[LYNQ_APN_CHANNEL_MAX] = {-1};
    int cid_index = 0;
    int j = 0;
    char *urc_msg = NULL;

    LYINFLOG("DATA in urc_msg_process_add_for_t106\n");
    int size = p->dataSize();
    p->readInt32(&resp_type);
    p->readInt32(&urcid);
    p->readInt32(&slot_id);
    LYINFLOG("data lib recv urc:resp_type=%d,urcid=%d,slot_id=%d,size=%d\n",resp_type,urcid,slot_id,size);
    switch(urcid)
    {
        case RIL_UNSOL_DATA_CALL_LIST_CHANGED:
            LYINFLOG("LIBLYNQ_DATA receive RIL_UNSOL_DATA_CALL_LIST_CHANGED\n");
            p->readInt32(&version);
            p->readInt32(&num);
        /* update apn start*/
            for(int i = 0; i < num; i++)
            {
                bzero(type,LYNQ_TYPE_MAX_LEN);
                bzero(ifaceName,LYNQ_IFACE_NAME_MAX_LEN);
                bzero(addresses,LYNQ_ADDRESSES_MAX_LEN);
                bzero(dnses,LYNQ_DNSES_MAX_LEN);
                bzero(gateways,LYNQ_GATEWAYS_MAX_LEN);
                bzero(pcscf,LYNQ_PCSCF_MAX_LEN);

                p->readInt32(&status);
                p->readInt32(&suggestedRetryTime);
                p->readInt32(&cid);
                p->readInt32(&active);

                cid_list[cid_index] = cid;
                cid_index++;

                urc_msg = strdupReadString_p(p);
                int len = strlen(urc_msg);
                if(len < LYNQ_TYPE_MAX_LEN-1)
                {
                    memcpy(type,urc_msg,len+1);
                }
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_IFACE_NAME_MAX_LEN-1)
                {
                    memcpy(ifaceName,urc_msg,len+1);
                }
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_ADDRESSES_MAX_LEN-1)
                {
                    memcpy(addresses,urc_msg,strlen(urc_msg)+1);
                }
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_DNSES_MAX_LEN-1)
                {
                    memcpy(dnses,urc_msg,strlen(urc_msg)+1);
                }
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_GATEWAYS_MAX_LEN-1)
                {
                    memcpy(gateways,urc_msg,strlen(urc_msg)+1);
                }
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_PCSCF_MAX_LEN-1)
                {
                    memcpy(pcscf,urc_msg,strlen(urc_msg)+1);
                }
                free(urc_msg);
                p->readInt32(&mtu);
                /*
                //update the lynq_apn_table start
                int apnId = getLynqApnID(apnType);
                LYINFLOG("URC apnType:%s,ifaceName:%s,apn:%s pdnState:%d",apnType,ifaceName,apn,pdnState);
                if(apnId >= 0)
                {
                    updateApnTable(&lynq_apn_table[apnId],apn,apnType,ifaceName);
                }
                
                pthread_mutex_lock(&s_lynq_urc_vector_mutex);
                s_data_urc_wait_list.push_back(apnId);
                pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
                lynq_data_call_change_id = apnId;
                sendSignalPdnChange();
                LYDBGLOG("data call state:%d",lynq_data_call);
                //update the lynq_apn_table completed
                */
            }
        /* update apn end*/

            /*delete apn start*/
            for(int i = 0; i < LYNQ_APN_CHANNEL_MAX; i++)
            {
                if( lynq_apn_table[i].hasUsed != 1)
                {
                    continue;
                }
                for(j = 0; j < num ; j++)
                {
                    if(cid_list[j] == lynq_apn_table[i].cid)
                    {
                        LYINFLOG("lynq_apn_table[%d], cid = &d, needn't delete\n",i, lynq_apn_table[i].cid);
                        break;
                    }
                }
                if(j == num)
                {
                    LYINFLOG("need delete lynq_apn_table[%d]\n", i);
                    bzero(lynq_apn_table[i].apnType,LYNQ_APN_TYPE_MAX_LEN);//async clean
                    lynq_apn_table[i].hasUsed = 0;
                    lynq_apn_table[i].cid = 0;
                    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
                    s_data_urc_wait_list.push_back(i);
                    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
                    sendSignalPdnChange();
                }
            }
            /*delete apn end*/
            LYINFLOG("update lynq_apn_table end\n");
            printf_apn_table();
            break;

        case LYNQ_URC_MODIFY_APNDB:
            urc_msg = strdupReadString_p(p);
            if (NULL == urc_msg)
            {
                LYERRLOG("error apn msg");
            }
            else
            {
                bzero(g_lynq_apn_result, 1024);
                strcpy(g_lynq_apn_result, urc_msg);
                sendSignalApnChange();
            }
            break;
        case LYNQ_URC_RESET_APNDB:
            {
                urc_msg = strdupReadString_p(p);
                if (NULL == urc_msg)
                {
                    LYERRLOG("error apn msg");
                }
                else
                {
                    bzero(g_lynq_apn_result, 1024);
                    strcpy(g_lynq_apn_result, urc_msg);
                    sendSignalApnChange();
                }
            }
        default:
            break;
    }
    
}
//xf.li@20230607 add for T106 data end
void printf_apn_table_debug(const char *fun,int line)
{
    LYINFLOG("[%s][%d]apn_table msg",fun,line);
    printf_apn_table();
}
void urc_msg_process(Parcel *p)
{
    int len;
    int resp_type;
    int urcid;
    int slot_id;
    int check_count = 0;
    static int apnId=-1;

    int pdnState = 0;
    char apn[LYNQ_APN_MAX_LEN];
    char apnType[LYNQ_APN_TYPE_MAX_LEN];
    char ifaceName[LYNQ_IFACE_NAME_MAX_LEN];
    char *urc_msg = NULL;

    int size = p->dataSize();
    p->readInt32(&resp_type);
    p->readInt32(&urcid);
    p->readInt32(&slot_id);
    LYINFLOG("data lib recv urc:resp_type=%d,urcid=%d,slot_id=%d,size=%d\n",resp_type,urcid,slot_id,size);
    switch(urcid)
    {
        case LYNQ_URC_DATA_CALL_STATUS_IND:
            p->readInt32(&pdnState);
            bzero(apn,LYNQ_APN_MAX_LEN);
            bzero(apnType,LYNQ_APN_TYPE_MAX_LEN);
            bzero(ifaceName,LYNQ_IFACE_NAME_MAX_LEN);
            if(pdnState!=4)//PDN_DISCONNECTED
            {
                urc_msg = strdupReadString_p(p);
                int len = strlen(urc_msg);
                if((len < LYNQ_APN_MAX_LEN-1) && (len > 0))
                {
                    memcpy(apn,urc_msg,len+1);
                }
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if((len < LYNQ_APN_TYPE_MAX_LEN-1) && (len > 0))
                {
                    memcpy(apnType,urc_msg,len+1);
                }
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if((len < LYNQ_IFACE_NAME_MAX_LEN-1) && (len > 0))
                {
                    memcpy(ifaceName,urc_msg,strlen(urc_msg)+1);
                }
                free(urc_msg);
                //sendSignalDataCallStateChange();
                apnId = getLynqApnID(apnType);
                if(apnId >= 0)
                {
                    LYINFLOG("URC apnType:%s,ifaceName:%s,apn:%s pdnState:%d,handle:%d",apnType,ifaceName,apn,pdnState,apnId);
                    if(lynq_apn_table[apnId].hasTimeout==1)
                    {
                        /*whether timeout?,real or not,*/
                        printf_apn_table();
                        LYERRLOG("apn:%s has time out,deacive this apn",lynq_apn_table[apnId].apn);
                        if (NULL != lynq_apn_table[apnId].apn && NULL != lynq_apn_table[apnId].apnType && strlen(lynq_apn_table[apnId].apn)>0)
                        {
                            LYERRLOG("deactive this time out APN");
                            lynq_deactive_data_call(&apnId);
                        }
                        else
                        {
                            /*if apn lose,update apn and deactive all apn*/
                            LYERRLOG("this table is invalid update APN table");
                        }
                        break;
                    }
                    updateApnTable(&lynq_apn_table[apnId],apn,apnType,ifaceName);
                    printf_apn_table_debug(__FUNCTION__,__LINE__);
                }
                /*To be completed*/
                else
                {
                    data_invaild_error = 1;
                    printf_apn_table_debug(__FUNCTION__,__LINE__);
                    apnId = getDeactApnID(apnType);
                    if(apnId < 0)
                    {
                        LYERRLOG("[%d]invalid apnId:%d",__LINE__,apnId);
                        break;
                    }
                    LYINFLOG("URC apnType:%s,ifaceName:%s,apn:%s pdnState:%d,handle:%d",apnType,ifaceName,apn,pdnState,apnId);
                    updateDeactApn(apnId,pdnState);
                    printf_apn_table_debug(__FUNCTION__,__LINE__);
                }
                pthread_mutex_lock(&s_lynq_urc_vector_mutex);
                s_data_urc_wait_list.push_back(apnId);
                pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
                lynq_data_call_change_id = apnId;
                sendSignalPdnChange();
                LYDBGLOG("data call state:%d",lynq_data_call);
                if(lynq_data_call==1)
                {
                    while (data_timelimit == 0)
                    {
                        LYINFLOG("client not ready to wait");
                        for (check_count = 0;check_count < 500;check_count++)
                        {
                            /*wait 10ms*/
                            usleep(10*1000);
                        }
                        LYERRLOG("client still without res");
                        break;
                    }
                    sendSignalDataCallStateChange();
                    lynq_data_call = 0;
                    data_timelimit = 0;
                }
                printf_apn_table_debug(__FUNCTION__,__LINE__);
            }
            else
            {
                urc_msg = strdupReadString_p(p);
                free(urc_msg);
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_APN_TYPE_MAX_LEN-1)
                {
                    memcpy(apnType,urc_msg,len+1);
                }
                free(urc_msg);
                LYDBGLOG("[data thread_urc_recv] apntype:%s",apnType);
                apnId = getLynqApnID(apnType);
                if(apnId >= 0)
                {
                    LYINFLOG("URC apnType:%s,ifaceName:%s,apn:%s pdnState:%d,handle:%d",apnType,ifaceName,apn,pdnState,apnId);
                    lynq_data_call_change_id = apnId;
                    //bzero(lynq_apn_table[apnId].apnType,LYNQ_APN_TYPE_MAX_LEN);//async clean
                    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
                    s_data_urc_wait_list.push_back(apnId);
                    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
                    sendSignalPdnChange();
                }
                else
                {
                    apnId = getDeactApnID(apnType);
                    if(apnId < 0)
                    {
                        LYERRLOG("[%d]invalid apnId:%d",__LINE__,apnId);
                        break;
                    }
                    LYINFLOG("URC apnType:%s,ifaceName:%s,apn:%s pdnState:%d,handle:%d",apnType,ifaceName,apn,pdnState,apnId);
                    cleanDeactApn(apnId);
                    lynq_data_call_change_id = apnId;
                    bzero(lynq_apn_table[apnId].apnType,LYNQ_APN_TYPE_MAX_LEN);//async clean
                    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
                    s_data_urc_wait_list.push_back(apnId);
                    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
                    sendSignalPdnChange();
                    printf_apn_table_debug(__FUNCTION__,__LINE__);
                }
                LYDBGLOG("data call state:%d",lynq_data_call);
                if(lynq_data_call==1)
                {
                    while (data_timelimit == 0)
                    {
                        LYINFLOG("client not ready to wait");
                        for (check_count = 0;check_count < 500;check_count++)
                        {
                            /*wait 10ms*/
                            usleep(10*1000);
                        }
                        LYERRLOG("client still without res");
                        break;
                    }
                    sendSignalDataCallStateChange();
                    lynq_data_call = 0;
                    data_timelimit = 0;
                }
                printf_apn_table_debug(__FUNCTION__,__LINE__);
            }
            break;
        case LYNQ_URC_MODIFY_APNDB:
            urc_msg = strdupReadString_p(p);
            if (NULL == urc_msg)
            {
                LYERRLOG("error apn msg");
            }
            else
            {
                bzero(g_lynq_apn_result, 1024);
                strcpy(g_lynq_apn_result, urc_msg);
                sendSignalApnChange();
            }
            free(urc_msg);
            break;
        case LYNQ_URC_RESET_APNDB:
            {
                urc_msg = strdupReadString_p(p);
                if (NULL == urc_msg)
                {
                    LYERRLOG("error apn msg");
                }
                else
                {
                    bzero(g_lynq_apn_result, 1024);
                    strcpy(g_lynq_apn_result, urc_msg);
                    sendSignalApnChange();
                }
                free(urc_msg);
            }
        default:
            break;
    }
    
}

int create_urc_vector_signal_thread()
{
    int ret;
    pthread_mutex_init(&s_lynq_urc_vector_mutex,NULL);
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    s_data_urc_wait_list.clear();
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return 0;
}

int lynq_init_data(int uToken)
{
    if (g_lynq_data_init_flag == 1)
    {
        LYERRLOG("init twice is not allowed");
        return -1;
    }
    g_lynq_data_init_flag = 1;
    int result = 0;
    Global_uToken = uToken;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    result = lynq_socket_client_start();
    pthread_mutex_init(&g_lynq_data_sendto_mutex, NULL);
    if(result!=0)
    {
        LYERRLOG("init socket client fail!!!");
        return -1;
    }
    result = lynq_init_data_urc_thread();
    if(result!=0)
    {
        LYERRLOG("init socket urc fail!!!");
        return -1;
    }

    result = create_urc_vector_signal_thread();
    if(result!=0)
    {
        LYERRLOG("init socket urc fail!!!");
        return -1;
    }
    memset(lynq_apn_table,0,sizeof(lynq_apn_table));
    LYDBGLOG("lynq init call success!!!");
    return 0;

}
int lynq_deinit_data()
{
    int ret = -1;
    if (g_lynq_data_init_flag == 0)
    {
        LYERRLOG("deinit twice is not allowed");
        return ret;
    }
    g_lynq_data_init_flag = 0;
    for(int i =0;i<LYNQ_APN_CHANNEL_MAX;i++)
    {
        if(strlen(lynq_apn_table[i].apnType)!=0)
        {
            lynq_deactive_data_call(&i);
        }
    }
    if(lynq_client_sockfd>0)
    {
        close(lynq_client_sockfd);
    }
    ret = lynq_deinit_data_urc_thread();
    if (ret != 0)
    {
        LYERRLOG("lynq_deinit_data_urc_thread fail");
        return ret;
    }
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    s_data_urc_wait_list.clear();
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return 0;
}
int lynq_setup_data_call(int *handle)
{
    int error = -1;
    //xf.li@20230610 add for T106 data start
    #ifdef MOBILETEK_TARGET_PLATFORM_T106
    LYINFLOG("[%s][%d] call lynq_setup_data_call_sp",__FUNCTION__,__LINE__);
    error = lynq_setup_data_call_sp_t106(handle,NULL,"iot_default",NULL,NULL,NULL,NULL,NULL);
    return error;
    #else
    //xf.li@20230610 add for T106 data end
    #ifdef GSW_RIL_CFG  //becuase gsw not have connman,data can not be triggered by connman.
    LYINFLOG("[%s][%d]",__FUNCTION__,__LINE__);
    error = lynq_setup_data_call_sp(handle,NULL,"iot_default",NULL,NULL,NULL,NULL,NULL);
    #else
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int lynq_data_call_id = 0;
    if(handle==NULL)
    {
        LYERRLOG("handle is null!!!");
        return LYNQ_E_NULL_ANONALY;
    }
    client.uToken = Global_uToken;
    client.request = 27;//RIL_REQUEST_SETUP_DATA_CALL
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    lynq_data_call_id = updateApn("default");
    if (lynq_data_call_id < 0)
    {
        LYERRLOG("update apn table fail error id = %d",lynq_data_call_id);
        return LYNQ_E_NULL_ANONALY+1;
    }
    *handle = lynq_data_call_id;//T8TSK-211 (2023/5/16) why? If it times out, the client application will also try to reconnect.
    //Reconnection needs to be deactivated first, and deactivation needs to know which apn to activate.
    lynq_data_call = 1;
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return LYNQ_E_NULL_ANONALY+2;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    if(error==0)
    {
        data_timelimit = 1;
        if (waitDataCallstateChange(60000) == ETIMEDOUT) // 60s
        {
            error = LYNQ_E_TIME_OUT;
            LYERRLOG("timeout:wait data Call state fail!!!");
            lynq_apn_table[lynq_data_call_id].hasTimeout = 1;
            if (data_invaild_error == 1)
            {
                data_invaild_error = 0;
                LYERRLOG("urc apn info error!!!");
                return 8085;
            }
            printf_apn_table_debug(__FUNCTION__,__LINE__);
            return error;
        }
    }
    printf_apn_table_debug(__FUNCTION__,__LINE__);
    #endif //GSW_RIL_CFG
    #endif
    return error;
}

int lynq_deactive_data_call(int *handle)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int lynq_data_call_id = -1;
    int ret = 0;
    if(handle==NULL)
    {
        LYERRLOG("handle is null!!!");
        return -1;
    }
    ret = handleCheck(*handle);
    if (ret != 0)
    {
        LYERRLOG("incomming handle is invalid");
        return -1;
    }
    lynq_data_call_id = *handle;
    client.uToken = Global_uToken;
    client.request = 41;//RIL_REQUEST_DEACTIVATE_DATA_CALL
    //xf.li@20230610 add for T106 data start
#ifndef MOBILETEK_TARGET_PLATFORM_T106
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    #ifdef GSW_RIL_CFG
    client.paramLen = 1;
    sprintf(client.param,"%s",lynq_apn_table[lynq_data_call_id].apnType);
    #else
    if(strcmp(lynq_apn_table[lynq_data_call_id].apnType,"default")!=0)
    {
        client.paramLen = 1;
        sprintf(client.param,"%s",lynq_apn_table[lynq_data_call_id].apnType);
    }
    #endif //GSW_RIL_CFG

#endif
#ifdef MOBILETEK_TARGET_PLATFORM_T106
    client.paramLen = 1;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    sprintf(client.param,"%d",lynq_apn_table[lynq_data_call_id].cid);
#endif
//xf.li@20230610 add for T106 data start
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    cleanOnceApnTable(lynq_data_call_id);
    printf_apn_table_debug(__FUNCTION__,__LINE__);
    return error;
}
//xf.li@20230610 add for T106 data start
int lynq_setup_data_call_sp_t106(int *handle,char *apn,char *apnType,char *user,char *password,char *authType,char *normalProtocol,char *roamingProtocol)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int lynq_data_call_id = -1;
    char *argv[10] = {};
    //T106 arg
    int slot_tmp = -1;
    int version = -1;
    int num = -1;
    int status = -1;
    int suggestedRetryTime = -1;
    int cid = -1;
    int active = -1;
    int utoken = -1;
    char ifaceName[LYNQ_IFACE_NAME_MAX_LEN];
    char type[LYNQ_TYPE_MAX_LEN];
    char addresses[LYNQ_ADDRESSES_MAX_LEN];
    char dnses[LYNQ_DNSES_MAX_LEN];
    char gateways[LYNQ_GATEWAYS_MAX_LEN];
    char pcscf[LYNQ_PCSCF_MAX_LEN];

    char *tmp_msg = NULL;
    int len = 0;

    LYINFLOG("[%s][%d]",__FUNCTION__,__LINE__);
    if(handle==NULL)
    {
        LYERRLOG("handle is null!!!");
        return -1;
    }
    if(normalProtocol==NULL)
    {
        argv[4] = "IPV4V6";
    }
    else
    {
        argv[4] = normalProtocol;
    }

    client.uToken = Global_uToken;
    client.request = 27;//RIL_REQUEST_SETUP_DATA_CALL
    client.paramLen = 7;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);

    sprintf(client.param,"%s %s %s %s %s %s %s",apn,apnType,argv[1],argv[2],argv[3],argv[4],argv[5]);

    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);

    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
 
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }

    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);

    bzero(type,LYNQ_TYPE_MAX_LEN);
    bzero(ifaceName,LYNQ_IFACE_NAME_MAX_LEN);

    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&utoken);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error);
        p.readInt32(&version);
        p.readInt32(&num);
        p.readInt32(&status);
        p.readInt32(&suggestedRetryTime);
        p.readInt32(&cid);

        LYINFLOG("resp_type=%d,utoken=%d,request=%d,socket_id=%d,error_code=%d,version=%d,num=%d,status=%d,suggestedRetryTime=%d,cid=%d\n",resp_type,utoken,request,slot_id,error,version,num,status,suggestedRetryTime,cid);
    }
    else
    {
        LYINFLOG("avail <= 0\n");
        return -1;
    }

    if(error==0)
    {
        if(version == 0)
        {
            slot_tmp = findCidInTable(cid);
            if(slot_tmp >= 0)
            {
                *handle = slot_tmp;
                return error;
            }
        }
//version != 0 || slot < 0, the cid out of lynq_apn_table, need add a new item
        p.readInt32(&active);

        tmp_msg = strdupReadString(p);
        len = strlen(tmp_msg);
        if(len < LYNQ_TYPE_MAX_LEN-1)
        {
            memcpy(type,tmp_msg,len+1);
        }
        free(tmp_msg);
        tmp_msg = strdupReadString(p);
        len = strlen(tmp_msg);
        if(len < LYNQ_IFACE_NAME_MAX_LEN-1)
        {
            memcpy(ifaceName,tmp_msg,len+1);
        }
        free(tmp_msg);
        LYINFLOG("resp_type=%d,utoken=%d,request=%d,socket_id=%d,error_code=%d,version=%d,num=%d,status=%d,suggestedRetryTime=%d,cid=%d,active=%d,type=%s,ifname=%s\n",
            resp_type,utoken,request,slot_id,error,version,num,status,suggestedRetryTime,cid,active,type,ifaceName);
        for(lynq_data_call_id = 0; lynq_data_call_id < LYNQ_APN_CHANNEL_MAX; lynq_data_call_id++)
        {
            if(lynq_apn_table[lynq_data_call_id].hasUsed == 0)
            {
                break;
            }
        }
        if (lynq_data_call_id == LYNQ_APN_CHANNEL_MAX)
        {
            LYERRLOG("update apn table fail error id = %d",lynq_data_call_id);
            return -1;
        }
        LYINFLOG("lynq_data_call_id = %d\n", lynq_data_call_id);
        *handle = lynq_data_call_id;
        lynq_apn_table[lynq_data_call_id].cid = cid;
        memcpy(lynq_apn_table[lynq_data_call_id].ifaceName, ifaceName, strlen(ifaceName) + 1);
        memcpy(lynq_apn_table[lynq_data_call_id].apnType, apnType, strlen(apnType) + 1);
        lynq_apn_table[lynq_data_call_id].hasUsed = 1;
        printf_apn_table();
        return status;
    }
    else
    {
        return error;
    }
}
//xf.li@20230610 add for T106 data end
int lynq_setup_data_call_sp(int *handle,char *apn,char *apnType,char *user,char *password,char *authType,char *normalProtocol,char *roamingProtocol)
{
    int t106_error = -1;
#ifdef MOBILETEK_TARGET_PLATFORM_T106
    t106_error = lynq_setup_data_call_sp_t106(handle, apn, apnType, user, password, authType, normalProtocol, roamingProtocol);
    return t106_error;
#endif
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int lynq_data_call_id = -1;
    char *argv[10] = {};
    #ifdef GSW_RIL_CFG
    LYINFLOG("[%s][%d]",__FUNCTION__,__LINE__);
    if(handle==NULL||apnType==NULL)
    {
        LYERRLOG("handle or apntype is null!!!");
        return -1;
    }
    #else
    if(handle==NULL||apn==NULL||apnType==NULL)
    {
        LYERRLOG("handle ,apn or apntype is null!!!");
        return LYNQ_E_NULL_ANONALY;
    }
    #endif //GSW_RIL_CFG
    if(user==NULL)
    {
        argv[1] = "null";
    }
    else
    {
        argv[1] = user;
    }
    if(password==NULL)
    {
        argv[2] = "null";
    }
    else
    {
        argv[2] = password;
    }
    if(authType==NULL)
    {
        argv[3] = "null";
    }
    else
    {
        argv[3] = authType;
    }
    if(normalProtocol==NULL)
    {
        argv[4] = "null";
    }
    else
    {
        argv[4] = normalProtocol;
    }
    if(roamingProtocol==NULL)
    {
        argv[5] = "null";
    }
    else
    {
        argv[5] = roamingProtocol;
    }
    client.uToken = Global_uToken;
    client.request = 27;//RIL_REQUEST_SETUP_DATA_CALL
    client.paramLen = 7;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    #ifdef GSW_RIL_CFG
    if(NULL == apn)
    {
        sprintf(client.param,"null %s %s %s %s %s %s",apnType,argv[1],argv[2],argv[3],argv[4],argv[5]);
    }
    else
    {
        sprintf(client.param,"%s %s %s %s %s %s %s",apn,apnType,argv[1],argv[2],argv[3],argv[4],argv[5]);
    }
    #else
    sprintf(client.param,"%s %s %s %s %s %s %s",apn,apnType,argv[1],argv[2],argv[3],argv[4],argv[5]);
    #endif  //GSW_RIL_CFG
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    lynq_data_call_id = updateApn(apnType);
    if (lynq_data_call_id < 0)
    {
        LYERRLOG("update apn table fail error id = %d",lynq_data_call_id);
        return LYNQ_E_NULL_ANONALY+1;
    }
    *handle = lynq_data_call_id;//T8TSK-211 (2023/5/16)
    lynq_data_call = 1;
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return LYNQ_E_NULL_ANONALY+2;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    if(error==0)
    {
        data_timelimit = 1;
        if(waitDataCallstateChange(60000)==ETIMEDOUT)//60s
        {
            error = LYNQ_E_TIME_OUT;
            LYERRLOG("timeout:wait data Call state fail!!!");
            lynq_apn_table[lynq_data_call_id].hasTimeout = 1;
            if (data_invaild_error == 1)
            {
                data_invaild_error = 0;
                LYERRLOG("urc apn info error!!!");
                return 8085;
            }
            printf_apn_table_debug(__FUNCTION__,__LINE__);
            return error;
        }
    }
    printf_apn_table_debug(__FUNCTION__,__LINE__);
    return error;
}
/*
int lynq_deactive_data_call_sp(int *handle,char *apnType)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    if(handle==NULL||apnType==NULL)
    {
        LYERRLOG("handle is null!!!");
        return -1;
    }
    client.uToken = Global_uToken;
    client.request = 41;//RIL_REQUEST_DEACTIVATE_DATA_CALL
    client.paramLen = 1;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    sprintf(client.param,"%s",apnType);
    LYERRLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    return error;
}
*/
int getDataCallLists(lynq_data_call_response_v11_t dataCallList[LYNQ_APN_CHANNEL_MAX],int *realNum)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int token;
    int request = -1;    
    int slot_id = -1;
    int error = -1;
    int version =0;
    int num = 0;
    char *temp_char = NULL;
    if(dataCallList==NULL)
    {
        LYERRLOG("dataCallList is null!!!");
        return -1;
    }
    Global_uToken++;
    client.uToken = Global_uToken;
    client.request = 57;//RIL_REQUEST_DATA_CALL_LIST
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&token);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error);
    }
    else
    {
        return -1;
    }
    LYINFLOG("resp_type=%d,uToken=%d,request=%d,slot_id=%d,error_code=%d",resp_type,token,request,slot_id,error);
    p.readInt32(&version);
    if(version==11)
    {
        p.readInt32(&num);
        *realNum = num;
        for (int i = 0; i < num; i++)
        {
            p.readInt32(&dataCallList[i].status);
            p.readInt32(&dataCallList[i].suggestedRetryTime);
            p.readInt32(&dataCallList[i].cid);
            p.readInt32(&dataCallList[i].active);
            temp_char = strdupReadString(p);
            LYINFLOG("[%s][%d]%s",__FUNCTION__,__LINE__,temp_char);
            if(temp_char)
            {
                memcpy(dataCallList[i].type,temp_char,strlen(temp_char)+1);
                free(temp_char);
            }
            temp_char = strdupReadString(p);
            LYINFLOG("[%s][%d]%s",__FUNCTION__,__LINE__,temp_char);
            if(temp_char)
            {
                memcpy(dataCallList[i].ifname,temp_char,strlen(temp_char)+1);
                free(temp_char);
            }
            temp_char = strdupReadString(p);
            LYINFLOG("[%s][%d]%s",__FUNCTION__,__LINE__,temp_char);
            if(temp_char)
            {
                memcpy(dataCallList[i].addresses,temp_char,strlen(temp_char)+1);
                free(temp_char);
            }
            temp_char = strdupReadString(p);
            LYINFLOG("[%s][%d]%s",__FUNCTION__,__LINE__,temp_char);
            if(temp_char)
            {
                memcpy(dataCallList[i].dnses,temp_char,strlen(temp_char)+1);
                free(temp_char);
            }
            temp_char = strdupReadString(p);
            LYINFLOG("[%s][%d]%s",__FUNCTION__,__LINE__,temp_char);
            if(temp_char)
            {
                memcpy(dataCallList[i].gateways,temp_char,strlen(temp_char)+1);
                free(temp_char);
            }
            temp_char = strdupReadString(p);
            LYINFLOG("[%s][%d]%s",__FUNCTION__,__LINE__,temp_char);
            if(temp_char)
            {
                memcpy(dataCallList[i].pcscf,temp_char,strlen(temp_char)+1);
                free(temp_char);
            }
            p.readInt32(&dataCallList[i].mtu);
        }
    }
    return error;
}
int lynq_get_data_call_list(int *handle,lynq_data_call_response_v11_t *dataCallList)
{
    lynq_data_call_response_v11_t interDataCallList[LYNQ_APN_CHANNEL_MAX]={};
    int number = 0;
    int lynq_data_call_id = 0;
    int error = 0;
    lynq_data_call_id = *handle;
    if(handle==NULL)
    {
        LYERRLOG("handle is NULL");
        return LYNQ_E_NULL_ANONALY;
    }
    if (*handle<0 && handle>8)
    {
        LYERRLOG("handle value error");
    }
    LYINFLOG("incoming handle value: %d",*handle);
    memset(interDataCallList,0,sizeof(interDataCallList));
    error = getDataCallLists(interDataCallList,&number);
    if(error == 0)
    {
        for(int i = 0;i < number;i++)
        {
            if(strcmp(interDataCallList[i].ifname,lynq_apn_table[lynq_data_call_id].ifaceName)==0)
            {
                dataCallList->active = interDataCallList[i].active;
                dataCallList->suggestedRetryTime = interDataCallList[i].suggestedRetryTime;
                dataCallList->cid = interDataCallList[i].cid;
                dataCallList->status = interDataCallList[i].status;
                dataCallList->mtu = interDataCallList[i].mtu;
                memcpy(dataCallList->addresses,interDataCallList[i].addresses,sizeof(interDataCallList[i].addresses));
                memcpy(dataCallList->ifname,interDataCallList[i].ifname,sizeof(interDataCallList[i].ifname));
                memcpy(dataCallList->dnses,interDataCallList[i].dnses,sizeof(interDataCallList[i].dnses));
                memcpy(dataCallList->type,interDataCallList[i].type,sizeof(interDataCallList[i].type));
                memcpy(dataCallList->gateways,interDataCallList[i].gateways,sizeof(interDataCallList[i].gateways));
                memcpy(dataCallList->pcscf,interDataCallList[i].pcscf,sizeof(interDataCallList[i].pcscf));
                LYDBGLOG("ifname:%s,addr:%s",dataCallList->ifname,dataCallList->addresses);
            }
        }
    }
    return error;
}
int lynq_wait_data_call_state_change(int *handle)
{
    if (data_waiting_status == 1)
    {
        LYDBGLOG("some thread is waiting");
        return -3;
    }
    LYDBGLOG("is empty :%d",s_data_urc_wait_list.empty());
    if (s_data_urc_wait_list.empty())
    {
        LYDBGLOG("start wait");
        data_waiting_status = 1;
        waitPdnChange();
    }
    data_waiting_status = 0;
    for(std::vector<int>::iterator i = s_data_urc_wait_list.begin(); i != s_data_urc_wait_list.end(); i++)
    {
        LYINFLOG("s_data_urc_wait_list iterm:%d\n", *i);
    }
    std::vector<int>::iterator iter;

    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    iter = s_data_urc_wait_list.begin();
    if (iter != s_data_urc_wait_list.end())
    {
        *handle = *iter;
    }
    s_data_urc_wait_list.erase(iter);

    for(std::vector<int>::iterator i = s_data_urc_wait_list.begin(); i != s_data_urc_wait_list.end(); i++)
    {
        LYINFLOG("s_data_urc_wait_list iterm:%d\n", *i);
    }

    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    
    LYINFLOG("lynq_wait_data_call_state_change handle:%d",*handle);
    return 0;
}
/*Warren add for T800 platform 2021/11/19 end*/

/*Typethree add for T800 platform 2022/04/21 start*/

int insert_apn_char(char *agc, char *id,char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][32];
    if (id == NULL)
    {
        sprintf(strtmp[0], "id=;");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (mcc == NULL)
    {
        sprintf(strtmp[1], "mcc=;");
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (mnc == NULL)
    {
        sprintf(strtmp[2], "mnc=;");
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (apn == NULL)
    {
        sprintf(strtmp[3], "apn=;");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (apntype == NULL)
    {
        sprintf(strtmp[4], "apntype=;");
    }
    else
    {
        sprintf(strtmp[4], "apntype=%s;", apntype);
    }
    if (user == NULL)
    {
        sprintf(strtmp[5], "user=;");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (password == NULL)
    {
        sprintf(strtmp[6], "password=;");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (normalprotocol == NULL)
    {
        sprintf(strtmp[7], "normalprotocol=;");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (roamingprotocol == NULL)
    {
        sprintf(strtmp[8], "roamingprotocol=;");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (carrier == NULL)
    {
        sprintf(strtmp[9], "carrier=;");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s",strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);

    return 0;
}

int modify_apn_char(char *agc, char *id, char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][32];
    if (id == NULL)
    {
        sprintf(strtmp[0], "id=;");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (mcc == NULL)
    {
        sprintf(strtmp[1], "mcc=;");
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (mnc == NULL)
    {
        sprintf(strtmp[2], "mnc=;");
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (apn == NULL)
    {
        sprintf(strtmp[3], "apn=;");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (apntype == NULL)
    {
        sprintf(strtmp[4], "apntype=;");
    }
    else
    {
        sprintf(strtmp[4], "apntype=%s;", apntype);
    }
    if (user == NULL)
    {
        sprintf(strtmp[5], "user=;");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (password == NULL)
    {
        sprintf(strtmp[6], "password=;");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (normalprotocol == NULL)
    {
        sprintf(strtmp[7], "normalprotocol=;");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (roamingprotocol == NULL)
    {
        sprintf(strtmp[8], "roamingprotocol=;");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (carrier == NULL)
    {
        sprintf(strtmp[9], "carrier=;");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s", strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);
    return 0;
}


int query_apn_char(char *agc, char *id, char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][32];
    if (id == NULL)
    {
        sprintf(strtmp[0], "");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (mcc == NULL)
    {
        sprintf(strtmp[1], "");
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (mnc == NULL)
    {
        sprintf(strtmp[2], "");
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (apn == NULL)
    {
        sprintf(strtmp[3], "");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (apntype == NULL)
    {
        sprintf(strtmp[4], "");
    }
    else
    {
        sprintf(strtmp[4], "apntype=%s;", apntype);
    }
    if (user == NULL)
    {
        sprintf(strtmp[5], "");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (password == NULL)
    {
        sprintf(strtmp[6], "");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (normalprotocol == NULL)
    {
        sprintf(strtmp[7], "");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (roamingprotocol == NULL)
    {
        sprintf(strtmp[8], "");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (carrier == NULL)
    {
        sprintf(strtmp[9], "");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s", strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);
    return 0;
}

static char *lynqStrdupReadString(Parcel &p)
{
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

int lynq_modify_apn_db(const int cmd, char *id, char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier, char *out)
{
    if (NULL == id && NULL == mcc && NULL == mnc && NULL == apn && NULL == apntype && NULL == user && NULL == password && NULL == normalprotocol && NULL == roamingprotocol && NULL == carrier)
    {
        LYERRLOG("There are no valid parameters");
        return -1;
    }
    lynq_client_t client;
    char argc[512];
    int res = 0;
    Parcel p;
    if (cmd == 0) // insert apn db
    {
        res = insert_apn_char(argc, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);

        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else if (cmd == 1) //delete apn db
    {
        if (NULL == id)
        {
            LYERRLOG("id is NULL!!!please input id: ");
        }
        sprintf(argc, "id=%s", id);
        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else if (cmd == 2) //query apn db
    {
        query_apn_char(argc, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);
        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else if (cmd == 3)  //modify apn db
    {
        modify_apn_char(argc, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);
        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else
    {
        LYERRLOG("incoming command is invalid");
        return -1;
    }
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    waitApnResult();
    strcpy(out, g_lynq_apn_result);
    LYINFLOG(">>>>>output info:%s",out);
    return 0;
}

int lynq_reset_apn(char *result)
{
    Parcel p;
    lynq_client_t client;
    if (NULL == result)
    {
        LYERRLOG("incoming paramters error");
    }
    client.uToken = Global_uToken;
    client.request = 2000 + 194;
    client.paramLen = 0;
    bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s", client.uToken, client.request, client.paramLen, client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if (send_request(lynq_client_sockfd, &client) == -1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    waitApnResult();
    strcpy(result, g_lynq_apn_result);
    LYINFLOG(">>>>>result:%s",result);
    return 0;
}

int lynq_get_apn_table(int *size,lynq_apn_info **list)
{
    if (NULL == size || NULL == list)
    {
        LYERRLOG("size or list  is NULL");
        return LYNQ_E_NULL_ANONALY;
    }
    int count = 0;
    int i = 0;
    for (i = 0;i < LYNQ_APN_CHANNEL_MAX;i++)
    {
        if (lynq_apn_table[i].hasUsed == 1)
        {
            if (NULL ==  list[count])
            {
                LYERRLOG("list[%d] is NULL",count);
                return LYNQ_E_NULL_ANONALY;
            }
            list[count]->index = i;
            memcpy(list[count]->apn,lynq_apn_table[i].apn,strlen(lynq_apn_table[i].apn)+1);
            memcpy(list[count]->apnType,lynq_apn_table[i].apnType,strlen(lynq_apn_table[i].apnType)+1);
            count++;
        }
    }
    *size = count;
    return 0;
}
/*Typethree add for T800 platform 2022/04/21 end*/
