#ifndef __LIBLOG_H__
#define __LIBLOG_H__

#ifdef __cplusplus
extern "C" {
#endif

#define LOG_ENABLE  1      

//#if LOG_ENABLE
#if LOG_ENABLE

#define ENABLE(X)               (1<<(X))
#define LOG_LEVEL_ENABLE      	  ENABLE(LOG_VERBOSE)

typedef enum
{
    LOG_VERBOSE = 0,   
    LOG_ERROR,  
    LOG_WARNING,
    LOG_INFO,
    LOG_DEBUG,  
    LOG_LEVEL_MAX
}log_level_enum;

const static char * LogLevelNameInfoTable[LOG_LEVEL_MAX] =
{
    "[VERBOSE]","[ERROR]","[WARNING]","[INFO]","[DEBUG]" //lt add @2021.7.22 for []
};
#endif //LOG_ENABLE

void lynq_log_global_output(log_level_enum Level,const char *format,...);
void lynq_log_configuration_set(char *log_name,char log_data_arr);
void lynq_log_configuration_init(char *log_name);
#ifdef __cplusplus
}
#endif

#endif  //__LOG_H__
