#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include <vendor-ril/telephony/ril.h>
#include <vendor-ril/telephony/mtk_ril_sp.h>
#include "liblog/lynq_deflog.h"
#include "lynq_network.h"
#include "lynq_module_common.h"
#include "lynq_module_socket.h"
#include "lynq_module_state_buffer.h"

#define LYNQ_RESP_STRING_MAX_NUM 128
#define LYNQ_TYPE_BUF 10
#define USER_LOG_TAG "LYNQ_NETWORK"

/*in CR AUTO00210807 MTK confirm set network selection mode max time is 14min 30s, first set 5 min 10s*/
#define WAIT_TIME_LENGTH_FOR_SET_NETWORK_SELECTION_MODE (310)
/*in CR AUTO00207414, in modem, 23G detach need 10s, 5g ims detach need 5s, so set length to 12s */
#define WAIT_TIME_LENGTH_FOR_SET_PREFFERRED_NETWORK_TYPE (12) 


using ::android::Parcel;

static int s_module_wait_urc_id;
static int s_module_urc_slot_id;
static signalStrength_t s_network_urc_solSigStren;

/**g_module_init_flag
* @brief mark network initialization state
* 0:deinit status
* 1:init state
*/
int g_module_init_flag = 0;

int lynq_network_init(int utoken){
    if(g_module_init_flag != MODULE_CLOSED)
    {
        LYERRLOG("module state is %d",g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
   if(utoken <0){
        LYERRLOG("utoken  is less than 0",utoken);      
        return LYNQ_E_PARAMETER_ANONALY;
    }

    g_module_init_flag = MODULE_SWITCHING;

    g_module_Global_uToken = utoken;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    
    int ret;

    init_network_timer_all();
    
    ret = lynq_start_all_urc_socket_thread();
    if(ret != 0)
    {
        LYERRLOG("init socket urc fail!!!");
        g_module_init_flag = MODULE_CLOSED;  
        return LYNQ_E_INNER_ERROR;
    }

    ret = lynq_start_all_rc_socket_thread();
    if(ret !=0)
    {
        LYERRLOG("init socket client fail!!!");
        lynq_close_all_urc_socket_thread();
        g_module_init_flag = MODULE_CLOSED;  
        return LYNQ_E_INNER_ERROR;
    }
    g_module_init_flag = MODULE_RUNNING;
    
    return RESULT_OK;    
}

int lynq_network_deinit(void){

    if (g_module_init_flag != MODULE_RUNNING)
    {
       LYERRLOG("module state is %d",g_module_init_flag);
       return LYNQ_E_CONFLICT;
    }  
    g_module_init_flag = MODULE_SWITCHING;

    lynq_close_all_urc_socket_thread();
    lynq_close_all_rc_socket_thread();    
    deinit_network_timer_all();

    g_module_init_flag = MODULE_CLOSED;
    return RESULT_OK;    
}

int strUpper(char * str)
{
    int i=0;
    while(1)
    {
        if(str[i]=='\0')
        {
            break;
        }
        if(str[i]>='a'&&str[i]<='z')
        {
             str[i]=str[i]-32;
        }
        i++;
    }
    return RESULT_OK;      
}

int copyCellInfoList(Parcel* &p,uint64_t *cellinfo,int *tac,int *earfcn)
{
    int32_t v=0;
    int64_t v6=0;
    if(NULL == cellinfo)
    {
        LYERRLOG("*cellinfo error");
        return LYNQ_E_PARAMETER_ANONALY;   
    }

    int nothing = 0;
    int tmp_uint64 = 0;
    p->readInt32(&v);
    RIL_CellInfoType cellinfoType  = RIL_CellInfoType(v);
    p->readInt32(&nothing);
    // cellinfo->cellinfo.cellInfoType = RIL_CellInfoType(v);
    // p->readInt32(&cellinfo->cellinfo.registered);
    p->readInt32(&v);
    // cellinfo->cellinfo.timeStampType = RIL_TimeStampType(v);
    p->readInt64(&v6);
    // cellinfo->cellinfo.timeStamp = v6;
    switch(cellinfoType) {
        case RIL_CELL_INFO_TYPE_GSM: {
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&tmp_uint64);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            *cellinfo = (uint64_t)tmp_uint64;
            tac = &nothing;
            earfcn = &nothing;
            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: {
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&tmp_uint64);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            *cellinfo = (uint64_t)tmp_uint64;
            tac = &nothing;
            earfcn = &nothing;
            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: {
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            cellinfo = 0;
            tac = &nothing;
            earfcn = &nothing;
            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: {
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&tmp_uint64);
            p->readInt32(&nothing);
            p->readInt32(tac);
            p->readInt32(earfcn);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            *cellinfo = (uint64_t)tmp_uint64;
            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: {
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&tmp_uint64);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            *cellinfo = (uint64_t)tmp_uint64;
            tac = &nothing;
            earfcn = &nothing;
            break;
        }
        case RIL_CELL_INFO_TYPE_NR: {
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readUint64(cellinfo);
            p->readInt32(&nothing);
            p->readInt32(tac);
            p->readInt32(earfcn);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            p->readInt32(&nothing);
            break;
        }
    }
    LYINFLOG("CID in fUNC :%llu",*cellinfo);
    LYINFLOG("tac in fUNC :%d",*tac);
    LYINFLOG("earfcn in fUNC :%d",*earfcn);
    return RESULT_OK;    
}

static char * lynqStrdupReadString(Parcel* &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p->readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

int lynq_query_operater(char *OperatorFN,char *OperatorSH,char *MccMnc)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
    if(NULL == OperatorFN||NULL == OperatorSH|| NULL == MccMnc)
    {
        LYERRLOG("%s some parameter OperatorFN OperatorSH MccMnc %s %s %s is NULL",__func__,OperatorFN,OperatorSH,MccMnc);  
        return LYNQ_E_PARAMETER_ANONALY;   
    }    

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OPERATOR,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }       
 
    int num ;
    char *resp[LYNQ_RESP_STRING_MAX_NUM];

    p->readInt32(&num);
    if(num == 0 || num > LYNQ_RESP_STRING_MAX_NUM)
    {
        LYERRLOG("no paramters or num %d too great",num);        
        delete p;      
        return LYNQ_E_INNER_ERROR;    
    }else{
        int i;
        for(i = 0; i<num;i++)
        {
            resp[i] = lynqStrdupReadString(p);
        }
        if(NULL != resp[0])
        {
            strcpy(OperatorFN,resp[0]);
        }
        if(NULL != resp[1])
        {
            strcpy(OperatorSH,resp[1]);
        }
        if(NULL != resp[2])
        {
            strcpy(MccMnc,resp[2]);
        }
        for(i = 0; i<num;i++)
        {
            if(resp[i]!=NULL)
            {
                free(resp[i]);            
            }            
        }
    }

    LYINFLOG("%s suc",__func__);   
    delete p;       
    return RESULT_OK;    
}

int lynq_query_network_selection_mode(int *netselMode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    if(NULL == netselMode)
    {
        LYERRLOG("%s parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;   
    }    
 
    Parcel* p=NULL;    
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int readnum;
    p->readInt32(&readnum);
    p->readInt32(netselMode);

    LYINFLOG("%s suc",__func__);   
    delete p;       
    return RESULT_OK;  
}

int lynq_set_network_selection_mode(const char *mode,const char* mccmnc)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
    if(NULL == mode || (strlen(mode) == 0))
    {
        LYERRLOG("%s parameter mod %s is error",__func__,mode);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    if(!strcmp(mode,"Manual"))
    {
        if(mccmnc == NULL || strlen(mccmnc) == 0)
        {
             LYERRLOG("%s parameter mccmnc %s is error",__func__,mccmnc);  
             return LYNQ_E_PARAMETER_ANONALY;
        }        
    }
    
    Parcel* p=NULL;
    int ret;

    if(!strcmp(mode,"Auto"))
    {
        ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_SET_NETWORK_SELECTION_MODE,RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC,0,"");
    }
    else if(!strcmp(mode,"Manual"))
    {
        ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_SET_NETWORK_SELECTION_MODE,RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL,1,"%s",mccmnc); 
    }
    else 
    {
        LYERRLOG("%s parameter mode %s is errir",__func__,mode);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
        
    LYINFLOG("%s set mode %s mccmnc %s suc",__func__,mode,mccmnc);   
    delete p;
    return RESULT_OK;  
}

int lynq_query_available_network(char *OperatorFN,char *OperatorSH,char *MccMnc,char * NetStatus)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == OperatorFN||NULL == OperatorSH||NULL == MccMnc||NULL == NetStatus)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }  

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,600,RIL_REQUEST_QUERY_AVAILABLE_NETWORKS,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   

    int num =p->readInt32();
    char *resp[LYNQ_RESP_STRING_MAX_NUM];
    if(num == 0 || num > LYNQ_RESP_STRING_MAX_NUM)
    {
        LYERRLOG("no paramters or num %d too great",num);        
        delete p;      
        return LYNQ_E_INNER_ERROR;    
    }else{
        int i;
        for(i = 0; i<num;i++)
        {
            resp[i] = lynqStrdupReadString(p);
        }
        if(NULL != resp[0])
        {
            strcpy(OperatorFN,resp[0]);
        }
        if(NULL != resp[1])
        {
            strcpy(OperatorSH,resp[1]);
        }
        if(NULL != resp[2])
        {
            strcpy(MccMnc,resp[2]);
        }
        if(NULL != resp[3])
        {
            strcpy(NetStatus,resp[3]);
        }
        for(i = 0; i<num;i++)
        {
            if(resp[i]!=NULL)
            {
                free(resp[i]);            
            }            
        }
    }
    delete p;
    LYINFLOG("%s suc",__func__);   
    return RESULT_OK;  
}

int lynq_query_registration_state_from_parcel(Parcel* p, int num,int reject_index, int* regState,char * LAC,char * CID,int *netType,int *netRejected)
{
    int i;
    char *resp[LYNQ_RESP_STRING_MAX_NUM]={0};    
    int ret = RESULT_OK;
    for(i=0;i<num;i++)
    {
        resp[i]=lynqStrdupReadString(p);
    }            
    if(resp[0]==NULL)
    {
        LYERRLOG("%s resp[0] %s is NULL",__func__,resp[0]);
        ret = LYNQ_E_INNER_ERROR;
        goto registration_from_parcel_return;
    }
    *regState = atoi(resp[0]);   
    strcpy(CID,""); 
    strcpy(LAC,"");
    *netType = RADIO_TECH_UNKNOWN;            
    *netRejected = -1;                   
    if((*regState)==1 || (*regState)==5) 
    {   
        if(resp[1]!=NULL) 
        {
            strcpy(LAC,resp[1]);
        }
        else 
        {           
            LYERRLOG("%s resp[1] %s is NULL",__func__);
        }
        
        if(resp[2]!=NULL) 
        {
            strcpy(CID,resp[2]);
        }
        else 
        {                
            LYERRLOG("%s resp[2] %s is NULL",__func__);
        }

        if(resp[3]!=NULL) 
        {
            *netType = atoi(resp[3]);
        }
        else 
        {            
            LYERRLOG("%s data resp[3] %s is NULL",__func__);
        }
    }
    else if((*regState)==3 || (*regState)==13)
    {    
        if(resp[reject_index]==NULL)
        {    
            LYERRLOG("%s resp[%d] is NULL",__func__,reject_index);            
        }  
        else 
        {
            *netRejected = atoi(resp[reject_index]);            
        }        
    }    

registration_from_parcel_return:

    for(i=0;i<num;i++)
    {
        if(resp[i]!=NULL)
        {
            free(resp[i]);             
        }            
    }                  
    return ret;
}


int lynq_query_registration_state(const char *type,int* regState,int* imsRegState,char * LAC,char * CID,int *netType,int *radioTechFam,int *netRejected)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
    if(NULL == type || NULL ==regState ||NULL ==imsRegState ||NULL ==LAC ||NULL ==CID ||NULL ==netType ||NULL ==radioTechFam || NULL == netRejected)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }  
    if(strlen(type)>LYNQ_TYPE_BUF)
    {
        LYERRLOG("[%s]the parameter is inavaliable !",__FUNCTION__);
        return LYNQ_E_PARAMETER_ANONALY;   
    }   
    
    int request;
    char str[LYNQ_TYPE_BUF];   
    memcpy(str,type,strlen(type)+1);
    strUpper(str);
    if(!strcmp(str,"VOICE"))
    {    
        if(get_state_from_buf(NETWORK_STATE_BUFFER_TYPE_VOICE_REG,3,regState,netType,netRejected,2,LAC,CID)==0)
        {
            return RESULT_OK;  
        }       
        request = RIL_REQUEST_VOICE_REGISTRATION_STATE;
    }else if(!strcmp(str,"DATA")){
        if(get_state_from_buf(NETWORK_STATE_BUFFER_TYPE_DATA_REG,3,regState,netType,netRejected,2,LAC,CID)==0)
        {
            return RESULT_OK;  
        }      
        request = RIL_REQUEST_DATA_REGISTRATION_STATE;
    }else if(!strcmp(str,"IMS")){
        if(get_state_from_buf(NETWORK_STATE_BUFFER_TYPE_IMS_REG,2,imsRegState,radioTechFam,0)==0)
        {
            return RESULT_OK;  
        }       
        request = RIL_REQUEST_IMS_REGISTRATION_STATE;
    }else{
        LYERRLOG("request error");
        return LYNQ_E_PARAMETER_ANONALY;
    }    

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,request,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num,i;
    char *resp[LYNQ_RESP_STRING_MAX_NUM]={0};       
    if(!strcmp(str,"VOICE"))
    {        
        p->readInt32(&num);        
        if(num >0 && num<=15)
        {
            ret=lynq_query_registration_state_from_parcel(p, num, 13, regState, LAC,CID,netType,netRejected);
            if(ret!=RESULT_OK)
            {
                LYERRLOG("%s call lynq_query_registration_state_from_parcel fail",__func__);             
                goto registration_return;       
            }  
            set_state_to_buf(NETWORK_STATE_BUFFER_TYPE_VOICE_REG,3,*regState,*netType,*netRejected,2,LAC,CID);
            goto registration_return;
        }
        else 
        {
            LYERRLOG("%s type %s num %d error",__func__,str,num);
            delete p;
            return LYNQ_E_INNER_ERROR;
        }            
    }
    else if(!strcmp(str,"DATA")){
        p->readInt32(&num);
        if(num >0 && num <=11)
        {        
            ret=lynq_query_registration_state_from_parcel(p, num, 4, regState, LAC,CID,netType,netRejected);
            if(ret!=RESULT_OK)
            {
                LYERRLOG("%s call lynq_query_registration_state_from_parcel fail",__func__);             
                goto registration_return;       
            }              
                        
            set_state_to_buf(NETWORK_STATE_BUFFER_TYPE_DATA_REG,3,*regState,*netType,*netRejected,2,LAC,CID);                
            goto registration_return;
        }
        else 
        {
            LYERRLOG("%s type %s num %d error",__func__,str,num);
            delete p;
            return LYNQ_E_INNER_ERROR;
        }            

    }
    else // "IMS"
    {
        p->readInt32(&num);
        if(num == 2)
        {
            p->readInt32(imsRegState);
            p->readInt32(radioTechFam);
            set_state_to_buf(NETWORK_STATE_BUFFER_TYPE_IMS_REG,2,*imsRegState,*radioTechFam,0);
        }
        else 
        {
            LYERRLOG("%s type %s num %d error",__func__,str,num);
            delete p;
            return LYNQ_E_INNER_ERROR;
        }            
    }  
     
registration_return:

    if(ret==RESULT_OK)
    {
        LYINFLOG("%s suc",__func__); 
    }    
   
    delete p;
    return ret;
    
}

int lynq_query_prefferred_networktype(int *preNetType)
{    
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == preNetType)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }          

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num;
    p->readInt32(&num);
    p->readInt32(preNetType);  
    
    LYINFLOG("%s suc",__func__); 
    delete p;
    return RESULT_OK;  
}

int lynq_set_prefferred_networktype(const int preffertype)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(preffertype < 0||preffertype >33)
    {
        LYERRLOG("%s parameter %d error",__func__,preffertype);  
        return LYNQ_E_PARAMETER_ANONALY;
    }     

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_SET_PREFFERRED_NETWORK_TYPE,RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE,1,"%d",preffertype);
     
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    LYINFLOG("%s set %d suc",__func__,preffertype);     
    delete p;
    return RESULT_OK;  
   
}

int lynq_query_cell_info(uint64_t cellinfo[CELLINFO_MAX_NUM],int tac[CELLINFO_MAX_NUM],int earfcn[CELLINFO_MAX_NUM],int * realNum)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == realNum)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }      
    
    Parcel* p=NULL;      
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_GET_CELL_INFO_LIST,0,"");
    
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num;

    p->readInt32(&num);
    LYINFLOG("cell info num:%d",num);
    *realNum = num;
    for(int i = 0;i<num;i++)
    {
        copyCellInfoList(p,&cellinfo[i],&tac[i],&earfcn[i]);
    }
    
    LYINFLOG("%s suc",__func__); 
    delete p;
    return RESULT_OK;  
}

int lynq_set_unsol_cell_info_listrate(const int rate)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;      
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE,1,"%d",rate);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    LYINFLOG("%s set %d suc",__func__,rate);    
    delete p;
    return RESULT_OK;      
}

int lynq_set_band_mode(const int bandmode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;      
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SET_BAND_MODE,1,"%d",bandmode);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    LYINFLOG("%s set %d suc",__func__,bandmode);    
    delete p;
    return RESULT_OK;  
}

int lynq_query_available_bandmode(int availBanMode[])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == availBanMode)
    {
        LYERRLOG("%s parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE,0,"");
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num = 0;
    int res = 0;
    int i;

    p->readInt32(&num);
    LYINFLOG("num = %d",num);
    availBanMode[0] = num;
    for(i=1 ;i<=num;i++)
    {
        p->readInt32(&res);
        availBanMode[i]=res;
    }
 
    LYINFLOG("%s suc",__func__);  
    delete p;
    return RESULT_OK;                
}

int lynq_radio_on(const lynq_network_radio_on_type type)
{     
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if (type != NETWORK_RADIO_ON_TYPE_CFUN_0  && type != NETWORK_RADIO_ON_TYPE_NORMAL_MODE && type!=NETWORK_RADIO_ON_TYPE_FLIGHT_MODE)
    {
        LYERRLOG("%s parameter %d error",__func__,type);  
        return LYNQ_E_PARAMETER_ANONALY;
    }     
    
    Parcel* p=NULL;      
    int ret;

    if(type==NETWORK_RADIO_ON_TYPE_CFUN_0)
    {
        ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"%s","AT+CFUN=0");
    }
    else 
    {
        ret=lynq_send_common_request(p,65,RIL_REQUEST_RADIO_POWER,1,"%d",(type==NETWORK_RADIO_ON_TYPE_NORMAL_MODE));
    }

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }       

    LYINFLOG("%s set %d suc",__func__,type);  
    delete p;
    return RESULT_OK;  
}

const char * lynq_get_raw_data(Parcel* &p, int* data_len) 
{
    int32_t len;
    int status;
    char *data;

    *data_len=0;

    status = p->readInt32(&len);

    if (status != 0) {
        LYERRLOG("%s status is %d",__func__,status);
        return NULL;
    }

    // The java code writes -1 for null arrays
    if (((int)len) == -1 || ((int)len) == 0) 
    {
        LYERRLOG("%s len is %d",__func__,len);
        return NULL;
    }
    LYINFLOG("%s len is %d",__func__,len);

    data = (char*) p->readInplace(len); 
    *data_len=len;

    return data;
}

int lynq_query_radio_state(int *radio_state)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == radio_state)
    {
        LYERRLOG("%s radio state is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"%s","AT+CFUN?");
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }           

    int bfind=false;
    const char* data;
    int data_len;
    char* data_str;
    char* start;
    int length;
    int i;
    int num_start;
    data = lynq_get_raw_data(p,&data_len);
    if(data==NULL || data_len == 0)
    {
        LYERRLOG("%s lynq_get_raw_data NULL or data_len is 0",__func__);    
        delete p;
        return LYNQ_E_INNER_ERROR; 
    }
    data_str = (char*) calloc(1,data_len+1);
    if (NULL == data_str) 
    {
         LYERRLOG("%s alloc mem error, data_len is %d",__func__,data_len+1);         
         delete p;
         return LYNQ_E_MALLOC_ERROR;
    }
    memmove(data_str, data, data_len);     
    data_str[data_len]='\0';           
    LYINFLOG("%s return string is %s",__func__,data_str);  
    start = strstr(data_str,"CFUN");
    if(start!=NULL)
    {
         start=start+4;
         length=strlen(start);
         for(i=0; i<length;i++)
         {
             if((!bfind) && (start[i] >= '0') && (start[i] <= '9'))
             {
                 bfind=true;  
                 num_start=i;
             }
             else if(bfind && ((start[i] < '0') || (start[i] > '9')))
             {
                start[i]='\0';
                break;
             }
         }
         if(bfind)
         {                    
             (*radio_state) = atoi(start+num_start);
             LYINFLOG("%s, radio state is %s %d",__func__,start+num_start,*radio_state);  
             free(data_str);
             delete p;
             return RESULT_OK;                         
         }
    }             
    LYERRLOG("%s return string %s no cfun or no digit",__func__,data_str);  
    free(data_str);
    delete p;
    return LYNQ_E_INNER_ERROR;              
}

int lynq_query_radio_tech(int* radioTech)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == radioTech)
    {
        LYERRLOG("%s radio tech is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;   
    }    

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_VOICE_RADIO_TECH,0,"");
    
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }              
         
    int num;
    p->readInt32(&num);
    p->readInt32(radioTech);

    LYINFLOG("%s suc",__func__);  
    delete p;
    return RESULT_OK;   
}

int lynq_solicited_signal_strength(signalStrength_t *solSigStren)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == solSigStren)
    {
        LYERRLOG("%s parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SIGNAL_STRENGTH,0,"");
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }                
    
    int sum = 0;
    int none = 0;

    p->readInt32(&solSigStren->rssi);
    if((solSigStren->rssi > 0)&&(solSigStren->rssi < 99))
    {
        solSigStren->gw_sig_valid = 1;
    }else{
        solSigStren->gw_sig_valid = 0;
    }


    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&solSigStren->lte_signalstrength);

    // p->readInt32(&solSigStren->signalStrength.LTE_SignalStrength.signalStrength);
    p->readInt32(&solSigStren->rsrp);
    p->readInt32(&solSigStren->rsrq);
    p->readInt32(&solSigStren->rssnr);

    LYINFLOG("LTE_signalstrength:%d",solSigStren->lte_signalstrength);
    if((solSigStren->lte_signalstrength > 0)&&(solSigStren->lte_signalstrength< 99))
    {
        solSigStren->lte_sig_valid = 1;
    }else{
        solSigStren->lte_sig_valid = 0;
    }


    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&solSigStren->wcdma_signalstrength);
    p->readInt32(&none);
    p->readInt32(&solSigStren->rscp);
    p->readInt32(&solSigStren->ecno);
    LYINFLOG("WCDMA_signalstrength:%d",solSigStren->wcdma_signalstrength);
    if((solSigStren->wcdma_signalstrength > 0)&&(solSigStren->wcdma_signalstrength < 99))
    {
        solSigStren->wcdma_sig_valid = 1;
    }else{
        solSigStren->wcdma_sig_valid = 0;
    }
    /*bug fix*/
    p->readInt32(&solSigStren->ssRsrp);
    p->readInt32(&solSigStren->ssRsrq);
    p->readInt32(&solSigStren->ssSinr);
    p->readInt32(&solSigStren->csiRsrp);
    p->readInt32(&solSigStren->csiRsrq);
    p->readInt32(&solSigStren->csiSinr);
    if(solSigStren->ssRsrp > 0 &&  solSigStren->ssRsrp < 255)
    {
        solSigStren->nr_sig_valid = 1;
    }else{
        LYERRLOG("None of NR signal info");
        solSigStren->nr_sig_valid = 0;
    }        

    LYINFLOG("%s suc",__func__);  
    delete p;
    return RESULT_OK;    
}

int lynq_set_ims(const int ims_mode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if (ims_mode < 0 || ims_mode > 1)
    {
        LYERRLOG("%s parameter %d error",__func__,ims_mode);  
        return LYNQ_E_PARAMETER_ANONALY;
    }     

    Parcel* p=NULL;
    int ret = lynq_send_common_request(p,65,RIL_REQUEST_SET_IMS_ENABLE,1,"%d",ims_mode);
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }        
    
    LYINFLOG("%s set %d suc",__func__,ims_mode);    
    delete p;
    return RESULT_OK;   
}

/*Used to get urc info*/
int lynq_get_urc_info(const int handle,signalStrength_t *solSigStren,int *slot_id)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    LYDBGLOG("start get urc info");
    if(handle != RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED &&handle != RIL_UNSOL_SIGNAL_STRENGTH)
    {
        LYINFLOG("invalid handle!!!");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if((handle ==RIL_UNSOL_SIGNAL_STRENGTH && NULL == solSigStren) || 
        (handle ==RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED && NULL == slot_id))
    {
        LYINFLOG("incoming solSigStren or slot_id is NULL!!!");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    switch(handle)
    {
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED: //1002
        {
            LYDBGLOG("get state update to VOICE");
            *slot_id = s_module_urc_slot_id;
            LYINFLOG("slot_id = %d",s_module_urc_slot_id);
            break;
        }
        case RIL_UNSOL_SIGNAL_STRENGTH: //1009
        {
            LYDBGLOG("get state update to signal info");
            solSigStren->gw_sig_valid = s_network_urc_solSigStren.gw_sig_valid;
            solSigStren->rssi = s_network_urc_solSigStren.rssi;
            solSigStren->wcdma_signalstrength = s_network_urc_solSigStren.wcdma_signalstrength;
            solSigStren->wcdma_sig_valid = s_network_urc_solSigStren.wcdma_sig_valid;
            solSigStren->rscp = s_network_urc_solSigStren.rscp;
            solSigStren->ecno = s_network_urc_solSigStren.ecno;
            solSigStren->lte_signalstrength = s_network_urc_solSigStren.lte_signalstrength;
            solSigStren->lte_sig_valid = s_network_urc_solSigStren.lte_sig_valid;
            solSigStren->rsrp = s_network_urc_solSigStren.rsrp;
            solSigStren->rsrq = s_network_urc_solSigStren.rsrq;
            solSigStren->rssnr = s_network_urc_solSigStren.rssnr;
            solSigStren->nr_sig_valid = s_network_urc_solSigStren.nr_sig_valid;
            solSigStren->ssRsrp = s_network_urc_solSigStren.ssRsrp;
            solSigStren->ssRsrq = s_network_urc_solSigStren.ssRsrq;
            solSigStren->ssSinr = s_network_urc_solSigStren.ssSinr;
            solSigStren->csiRsrp = s_network_urc_solSigStren.csiRsrp;
            solSigStren->csiRsrq = s_network_urc_solSigStren.csiRsrq;
            solSigStren->csiSinr = s_network_urc_solSigStren.csiSinr;
            break;
        }
    }
    return RESULT_OK;   
}

static pthread_mutex_t urc_signal_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t urc_signal_state_change_cond = PTHREAD_COND_INITIALIZER;

int wait_urc_signal_changes()
{
    pthread_mutex_lock(&urc_signal_state_change_mutex);
    pthread_cond_wait(&urc_signal_state_change_cond,&urc_signal_state_change_mutex);
    pthread_mutex_unlock(&urc_signal_state_change_mutex);
    return RESULT_OK;   
}

void send_urc_signal_changes()
{
    pthread_mutex_lock(&urc_signal_state_change_mutex);
    pthread_cond_signal(&urc_signal_state_change_cond);
    pthread_mutex_unlock(&urc_signal_state_change_mutex);
    return;
}

bool is_support_urc(int urc_id)
{
    switch(urc_id)
    {
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_SIGNAL_STRENGTH:
            return true;                
        default:
            return false;
    }    
}

void urc_msg_process(Parcel *p)
{ 
    int resp_type; 
    int none = 0;
    int NR_sum = 0;
    int size=p->dataSize();
    p->readInt32(&resp_type);
    p->readInt32(&s_module_wait_urc_id);
    p->readInt32(&s_module_urc_slot_id);
    LYINFLOG("%s urc id = %d, slot_id = %d, size is %d, msg is %s",__func__, s_module_wait_urc_id,s_module_urc_slot_id,size,requestToString(s_module_wait_urc_id));
    switch(s_module_wait_urc_id)
    {
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
        {
            set_state_buffer_valid(NETWORK_STATE_BUFFER_TYPE_VOICE_REG,false);
            send_urc_signal_changes();
            break;
        }
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
        {                    
            set_state_buffer_valid(NETWORK_STATE_BUFFER_TYPE_DATA_REG,false);
            send_urc_signal_changes();
            break;
        }
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED:
        {                   
            set_state_buffer_valid(NETWORK_STATE_BUFFER_TYPE_IMS_REG,false);                                       
            send_urc_signal_changes();
            break;
        }
        case RIL_UNSOL_SIGNAL_STRENGTH:
        {
            p->readInt32(&s_network_urc_solSigStren.rssi);
            if((s_network_urc_solSigStren.rssi<=31)&&(s_network_urc_solSigStren.rssi>=0))
            {
                s_network_urc_solSigStren.gw_sig_valid = 1;
                LYINFLOG("urc_GSM_signalstrength:%d",s_network_urc_solSigStren.rssi);
            }else{
                s_network_urc_solSigStren.gw_sig_valid = 0;
            }
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&s_network_urc_solSigStren.lte_signalstrength);
            p->readInt32(&s_network_urc_solSigStren.rsrp);
            p->readInt32(&s_network_urc_solSigStren.rsrq);
            p->readInt32(&s_network_urc_solSigStren.rssnr);
            if((s_network_urc_solSigStren.lte_signalstrength<=31)&&(s_network_urc_solSigStren.lte_signalstrength>=0))
            {
                s_network_urc_solSigStren.lte_sig_valid = 1;
                LYINFLOG("urc_LTE_signalstrength:%d",s_network_urc_solSigStren.lte_signalstrength);
            }else{
                s_network_urc_solSigStren.lte_sig_valid = 0;
            }
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&s_network_urc_solSigStren.wcdma_signalstrength);
            p->readInt32(&none);//bitErrorRate
            p->readInt32(&s_network_urc_solSigStren.rscp);
            p->readInt32(&s_network_urc_solSigStren.ecno);
            if((s_network_urc_solSigStren.wcdma_signalstrength<=31)&&(s_network_urc_solSigStren.wcdma_signalstrength>=0))
            {
                s_network_urc_solSigStren.wcdma_sig_valid = 1;
                LYINFLOG("urc_WCDMA_signalstrength:%d",s_network_urc_solSigStren.wcdma_signalstrength);
            }else{
                s_network_urc_solSigStren.wcdma_sig_valid = 0;
            }
            p->readInt32(&s_network_urc_solSigStren.ssRsrp);
            p->readInt32(&s_network_urc_solSigStren.ssRsrq);
            p->readInt32(&s_network_urc_solSigStren.ssSinr);
            p->readInt32(&s_network_urc_solSigStren.csiRsrp);
            p->readInt32(&s_network_urc_solSigStren.csiRsrq);
            p->readInt32(&s_network_urc_solSigStren.csiSinr);
            NR_sum = (s_network_urc_solSigStren.ssRsrp) + (s_network_urc_solSigStren.ssRsrq) + (s_network_urc_solSigStren.ssSinr) + (s_network_urc_solSigStren.csiRsrp)+\
            (s_network_urc_solSigStren.csiRsrq) + (s_network_urc_solSigStren.csiSinr);
            if(NR_sum != 0)
            {
                s_network_urc_solSigStren.nr_sig_valid = 1;
                LYINFLOG("[NR signal]ssRsrp is %d , ssRsrq is %d , ssSinr is %d , csiRsrp is %d , csiRsrq is %d , csiSinr is %d",\
                s_network_urc_solSigStren.ssRsrp,s_network_urc_solSigStren.ssRsrq,s_network_urc_solSigStren.ssSinr, \
                s_network_urc_solSigStren.csiRsrp,s_network_urc_solSigStren.csiRsrq,s_network_urc_solSigStren.csiSinr);
            }else{
                s_network_urc_solSigStren.nr_sig_valid = 0;
            }           
            send_urc_signal_changes();
            break;
        }
    }
}

/*Used to wait for an update signal*/
int lynq_wait_signalchanges(int *handle)
{
    LYDBGLOG("start wait signalchanges info");
    if(NULL == handle)
    {
        LYERRLOG("illegal input");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    wait_urc_signal_changes();
    LYDBGLOG("get signalchanges");
    *handle = s_module_wait_urc_id;
    return RESULT_OK;   
}

#ifdef MODEM_GEN97
/**@brief parse at response,return error code,and the response
* @param response [IN] <response>:original at response,This parameter must be a character array.

* @param value [OUT] <value>: Used to receive the parsed value, if multiple values are separated by ";".
*  field:
*    eg:
*       "+cnum: 123456\n+cnum: 456"
*       value:12345;456;
* @param value_len [IN] <value_len>: The value length.

* @return:AT error code
*/
static int parse_at_result(char response[],char value[],int value_len)
{
    if(response == NULL || value == NULL)
    {
        LYERRLOG("parameter invalid");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if(strstr(response,"ERROR"))
    {
        int i;
        for(i = 0;i < strlen(response);i++)
        {
            if(response[i]==':')
            {
                break;
            }
        }
        if(i < strlen(response))
        {
            LYINFLOG("parse_result:%d\n",atoi(response+i+1));
            return atoi(response+i+1);
        }
        else
        {
            LYINFLOG("%s parse_result:fail,this response invalid\n",response);
            return 100; //unknown
        }
    }
    else if(strstr(response,"OK"))
    {
        /** parse the at response value
        * eg:
        * --> at+cnum
        * <-- +CNUM:"1243452"
        * need parse the "1243452" to <value>
        *@  To-Do
        */
        int count;
        int resp_addr[32] = {0};
        char temp_buf[1024] = {0};
        char *dest;
        dest = NULL;
        count = 0;
        int res_len = strlen(response);
        LYINFLOG("res_len:%d",res_len);
        for(int i = 0; i < res_len; i++)
        {
            if(response[i]==':')
            {
                resp_addr[count] = i;
                count++;
            }
            if(response[i] == '\n')
            {
                response[i] = '\0';
            }
        }
        LYINFLOG("count:%d",count);
        if(count > 0)
        {
            for(int i = 0; i < count; i++)
            {
                if((strlen(temp_buf) + strlen(response+resp_addr[i]+2)) >= 1023)
                {
                    LYINFLOG("2 will be out of range\n");
                    break;
                }
                if(strlen(temp_buf) >= 1023)
                {
                    LYINFLOG("1 will be out of range\n");
                    break;
                }
                strcat(temp_buf,response+resp_addr[i]+2);

                if(strlen(temp_buf) >= 1023)
                {
                    LYINFLOG("1 will be out of range\n");
                    break;
                }
                strcat(temp_buf,";");
                printf("parse_result[%d]:%s,strcated:%s\n",i,response+resp_addr[i]+2,temp_buf);
            }
            LYINFLOG("parse_result:%s\n",temp_buf);
            if(strlen(temp_buf) > value_len)
            {
                printf("result length over value:%ld,%d\n",strlen(temp_buf),value_len);
                memcpy(value,temp_buf,value_len);
            }
            else
            {
                memcpy(value,temp_buf,strlen(temp_buf));
            }
        }
        return RESULT_OK;   
    }
    else
    {
        LYINFLOG("%s this response invalid\n",response);
        return LYNQ_E_INNER_ERROR;
    }
}

int lynq_oos_recover_timer_interval(int mode, char interval[LY_RECOVER_TIMER_INTERVAL],char result[LY_RECOVER_TIMER_INTERVAL])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    if((mode < 0) || (mode >1) || (mode == 0 && NULL == interval) || (NULL == result))
    {
        LYERRLOG("%s mode %d interval %s result %s error",__func__,mode,interval,result);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret;

    if(mode == 0)
    {
        ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"AT+ERSCFG=%s",interval);
    }
    else 
    {
        ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"AT+ERSCFG?");
    }

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }        

    int recv_len;    
    char res_data[LY_RECOVER_TIMER_INTERVAL] = {0};
    char response_interval[LY_RECOVER_TIMER_INTERVAL*2] = {0};

    LYINFLOG("get recover timer interval");
    p->readInt32(&recv_len);
    if(recv_len == -1)
    {
        LYINFLOG("no responset");
        delete p;
        return LYNQ_E_INNER_ERROR;
    }
    else
    {
        LYINFLOG("recv_len:%d",recv_len);
        p->read(response_interval,recv_len);
    }
    LYINFLOG("response_interval:%s",response_interval);
    ret = parse_at_result(response_interval,res_data,LY_RECOVER_TIMER_INTERVAL);
    if(mode == 1)
    {
        if(strlen(res_data) <= LY_RECOVER_TIMER_INTERVAL)
        {
            memcpy(result,res_data,strlen(res_data));
        }
    }
    LYERRLOG("%s ret:%d",__func__,ret);
    delete p;
    return ret;         
}

int lynq_oos_deep_sleep_recover_timer_interval(int recovery_threshold,int fullband_timer,int sniffer_timer,int inactive_mode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
     if(((recovery_threshold < 2) || (recovery_threshold > 10)) || (fullband_timer < 90) || 
    ((sniffer_timer < 10) || (sniffer_timer > 60)) || ((inactive_mode < 0) || (inactive_mode > 1)))
    {
        LYERRLOG("%s paramter recovery_threshold %d fullband_timer %d sniffer_timer %d inactive_mode %d error!",__func__,recovery_threshold,fullband_timer,sniffer_timer,inactive_mode);
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"AT+ESRVREC=%d,%d,%d,%d",recovery_threshold,fullband_timer,sniffer_timer,inactive_mode);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }        
 
    int recv_len;   
    char res_data[LY_RECOVER_TIMER_INTERVAL] = {0};
    char response_interval[LY_RECOVER_TIMER_INTERVAL*2] = {0};
 
    p->readInt32(&recv_len);
    if(recv_len == -1)
    {
        LYINFLOG("no responset");
        delete p;
        return LYNQ_E_INNER_ERROR;
    }
    else
    {
        LYINFLOG("recv_len:%d",recv_len);
        p->read(response_interval,recv_len);
    }
    LYINFLOG("response_interval:%s",response_interval);
    ret = parse_at_result(response_interval,res_data,LY_RECOVER_TIMER_INTERVAL);
    LYERRLOG("%s ret:%d",__func__,ret);
    delete p;
    return ret;      
 
}
#endif

