
#include <stdint.h>
#ifndef __MBTK_GNSS_H__
#define __MBTK_GNSS_H__
#include "ringbuffer.h"
#ifdef __cplusplus
extern "C" {
#endif


/*
GGA: GNSS 定位数据
$GNGGA,,,,,,0,00,99.99,,,,,,*56
*/
struct gnss_gga
{
    char sys;
    char time;
    char lat;
    char lat_dir;
    char lon;
    char lon_dir;
    int local_state;
    int sv_size;
    float hdop;
    float msl;
    char m;
    float altref;
    char _m;
    float diff_age;
    float diff_station;
    char crc;
};
/*
GSV : 可见的GNSS卫星
$GPGSV,1,1,00,0*65
$GBGSV,1,1,00,0*77
*/
struct gnss_gsv
{
    char sys;
    int msg_size;
    int msg_num;
    int sv_size;
    int sv1_num;
    int sv2_num;
    int sv3_num;
    int sv4_num;
    int elv1;
    int elv2;
    int elv3;
    int elv4;
    int az1;
    int az2;
    int az3;
    int az4;
    int cno1;
    int cno2;
    int cno3;
    int cno4;
    char crc;

};
/*
GSA: GNSS精度因子与有效卫星信息
$GNGSA,A,1,,,,,,,,,,,,,99.99,99.99,99.99,4*36
*/
struct gnss_gsa
{
    char sys;
    char s_mode;
    char g_mode;
    int sv1_num;
    int sv2_num;
    int sv3_num;
    int sv4_num;
    int sv5_num;
    int sv6_num;
    int sv7_num;
    int sv8_num;
    int sv9_num;
    int sv10_num;
    int sv11_num;
    int sv12_num;
    float pdop;
    float hdop;
    float vdop;
    int system_id;
    char crc;
};

/*
VTG: 航迹向和地速
$GNVTG,,,,,,,,,N*2E
*/
struct gnss_vtg
{
    char sys;
    float cogt;
    char _t;
    float cogm;
    char _m;
    float sog;
    char _n;
    float kph;
    char _k;
    char mode;
    char crc;
};

/*
推荐的最少数据
RMC
$GNRMC,,V,,,,,,,,,,N,V*37
*/
struct gnss_rmc
{
    char sys;
    char time;
    int local_status;
    char lat;
    char lat_dir;
    char lon;
    char lon_dir;
    float spd;
    float cog;
    char date;
    float mv;
    char mve;
    char mode;
    char nav_states;
    char crc;
};

typedef uint32_t gnss_client_handle_type;

typedef enum
{
    E_MT_LOC_MSG_ID_LOCATION_INFO = 1,          /**<  pv_data = &QL_LOC_LOCATION_INFO_T  */
    E_MT_LOC_MSG_ID_NMEA_INFO = 3,              /**<  pv_data = &QL_LOC_NMEA_INFO_T  */
}e_msg_id_t;  //0,2reserve

#define     QL_LOC_MAX_SEVER_ADDR_LENGTH    255 /**  Maximum generic server address length for the host name. */
typedef struct 
{/** Indication Message; Indication with the reported XTRA server URLs. */
    char server1[QL_LOC_MAX_SEVER_ADDR_LENGTH + 1];  /**<   server1.*/
    char server2[QL_LOC_MAX_SEVER_ADDR_LENGTH + 1];  /**<   server2.*/
    char server3[QL_LOC_MAX_SEVER_ADDR_LENGTH + 1];  /**<   server3.*/
}QL_LOC_XTRA_REPORT_SERVER_INTO_T;

typedef enum 
{
    E_QL_LOC_STATUS_NONE            = 0, /**<  GPS status unknown.  */
    E_QL_LOC_STATUS_SESSION_BEGIN   = 1, /**<  GPS has begun navigating.  */
    E_QL_LOC_STATUS_SESSION_END     = 2, /**<  GPS has stopped navigating.  */
    E_QL_LOC_STATUS_ENGINE_ON       = 3, /**<  GPS has powered on but is not navigating.  */
    E_QL_LOC_STATUS_ENGINE_OFF      = 4, /**<  GPS is powered off.  */
}E_QL_LOC_STATUS_VALUE_T;

typedef void (*gnss_handler_func_t)
(
        uint32_t    h_loc,
        e_msg_id_t  e_msg_id,
        void        *pv_data,
        void        *context_ptr
        );

struct mopen_location_info_t
{
    uint32_t    size;                   /**<   Set to the size of mcm_gps_location_t. */
    int flags; /**<   Contains GPS location flags bits. */
    int position_source;  /**<   Provider indicator for HYBRID or GPS. */
    double      latitude;               /**<   Latitude in degrees. */
    double      longitude;              /**<   Longitude in degrees. */
    double      altitude;               /**<   Altitude in meters above the WGS 84 reference ellipsoid. */
    float       speed;                  /**<   Speed in meters per second. */
    float       bearing;                /**<   Heading in degrees. */
    float       accuracy;               /**<   Expected accuracy in meters. */
    int64_t     timestamp;              /**<   Timestamp for the location fix in UTC million-second base.  */
    int32_t     is_indoor;              /**<   Location is indoors. */
    float       floor_number;           /**<   Indicates the floor number. */
};

#define MOPEN_GNSS_NMEA_MAX_LENGTH  255                 /**  NMEA string maximum length. */
typedef struct
{
    int64_t     timestamp;                          /**<   System Timestamp, marked for when got the nmea data */
    int         length;                             /**<   NMEA string length. */
    char        nmea[MOPEN_GNSS_NMEA_MAX_LENGTH + 1];   /**<   NMEA string.*/
}mopen_gnss_nmea_info_t;  /* Message */

struct mopen_gnss_device_info_t
{
    int      device_info_valid;
    int      usrt_bandrate;
    char     product_name[10];
    char     dev_config[6];
    char     hw_ver[6];
    char     fw_ver[32];
    char     pn[16];
    char     sn[16];
    char     nmea_ver[4];
};

#ifdef DEBUG
#define gnss_log(...)                    printf(__VA_ARGS__)
#else
#define gnss_log(...)
#endif
#endif
#define LOGE printf
#define LOGI printf

// 默认为 9600，打开为 115200，但是 AT+MGPSCMD 会重启。
#define BAUDRATE_115200  0

#define TTFF_TEST   0

#define MBTK_GNSS_DEV  "/dev/ttyS2"

#define MBTK_UART_RECV_BUFFER_SIZE 1024
#define MBTK_UART_SEND_BUFFER_MAX 128

#define TRUE 1
#define uint32 uint32_t


// 获取当前时间
#define GET_TIME()  { gettimeofday(&time_m, NULL); \
    time_m.tv_sec += TIMEOUT_SEC;\
}
// 设置从循环中退出的时间
#define SET_TIME_OUT(x)  { gettimeofday(&time_m, NULL); \
    time_m.tv_sec += x;\
}
// 检测时间是否超时，超时则退出当前函数
#define CHK_TIME()  { gettimeofday(&time_n, NULL); \
    if(time_n.tv_sec > time_m.tv_sec) { \
    printf("\ntimeout!!!\n\n");\
    close(fd); \
    return ret; \
} \
}
// 检测时间是否超时，超时则退出当前循环
#define CHK_TIME_BREAK()  { gettimeofday(&time_n, NULL); \
    if(time_n.tv_sec > time_m.tv_sec) { \
    printf("\ntimeout!!!\n\n");\
    break; \
} \
}
// 检测延时是否到达，到达则退出当前循环
#define DELAY_TIME_BREAK()  { gettimeofday(&time_n, NULL); \
    if(time_n.tv_sec > time_m.tv_sec) { \
    break; \
} \
}

typedef void (*gnss_msg_func_t)
(
        int index,
        char *in_data,
        void *out_ptr
        );

struct mbtk_gnss_cmd_msg_t
{
    int index; // 序号
    char *cmd_str; // 匹配字符
    gnss_msg_func_t gnss_msg_func; // 回调函数
    int is_continue; // 是否随NEMA数据一起输出
};



static struct mopen_gnss_device_info_t mopen_gnss_device_info;
static struct mbtk_gnss_handle_t *mbtk_gnss_handle = NULL;
static int firmware_extren_state = 0;

static char g_no_sv = 0;// 参与定位的卫星数量

int mopen_gnss_get_nmea_config(uint32 h_gnss);
int mopen_gnss_get_ant_state_info(uint32 h_gnss);

static void get_gnss_time_info(int cmd, char *str, void *data);
static void get_gnss_agnss_state(int cmd, char *str, void *data);
static void get_gnss_device_info(int type, char *str, void *usr_ptr);
static void gnss_uart_info(int cmd, char *str, void *data);
static void gnss_gsa_info(int cmd, char *str, void *data);
static int mopen_uart_change(int fd, int check);

static int select_read( int fd, int timeout );
ssize_t deal_read(int fd, void *buf, size_t count);



int mopen_gnss_print_version(uint32 h_gnss);
int lynq_gnss_client_init(uint32 *ph_gnss);
int lynq_gnss_client_deinit(uint32 h_gnss);
int mopen_gnss_add_rx_msg_handler(uint32 h_gnss, gnss_handler_func_t handler_ptr);
int mopen_gnss_set_mode(uint32 h_gnss, int mode);
int mopen_gnss_set_system_config(uint32 h_gnss, int mode);
int mopen_gnss_set_nema_config(uint32 h_gnss, int mode);
int mopen_gnss_download_tle(void);
int mopen_gnss_injects_aidpos(uint32 h_gnss);
int mopen_gnss_firmware_update(void);
int mbtk_at_gnss_start_ttff(int type, int timeout_sec, int count);
int lynq_gnss_send_cmd(uint32 h_gnss, const char *cmd, int cmd_len);
int mopen_gnss_write(int fd, const char* buf, unsigned int buf_len);
int set_baudrate(int fd, int baudrate);
int mopen_gnss_dev_reset(uint32 h_gnss, int type, int mode);
int lynq_open_gps(int state);
int lynq_gnss_Injection_ephemeris(uint32 h_gnss);
int exec_cmd(const char *cmd, char *result);
int lynq_gnss_get_aidinfo(uint32 h_gnss);
int lynq_gnss_get_device_info(uint32 h_gnss);
int lynq_gnss_get_uart(uint32 h_gnss);
int lynq_gnss_get_ap_data(void);

#ifdef __cplusplus
}
#endif
