#include <stdio.h>
#include <stdint.h>
#include <sys/types.h>
#include <string.h>
#include <lynq_network.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <liblog/lynq_deflog.h>
#include "lynq_qser_network.h"

#define USER_LOG_TAG "LYNQ_QSER_NETWORK"
#define RESULT_OK (0)
#define RESULT_ERROR (-1)
#define INVALID_PREFER_TYPE (0xffff)
#define INVALID_CLIENT_HANDLE (0)

static QSER_NW_RxMsgHandlerFunc_t s_handlerPtr=NULL;
static void* s_contextPtr=NULL;
static pthread_t s_new_network_tid =-1;

nw_client_handle_type g_ph_hw = INVALID_CLIENT_HANDLE;

int switch_preferred_nw_mode(const uint64_t preferred_nw_mode)
{
    int map[13]={
            0xffff,    // "0 : GSM/WCDMA (WCDMA preferred)"
            QSER_NW_MODE_GSM, // "1 : GSM only"
            QSER_NW_MODE_WCDMA, // "2 : WCDMA"
            QSER_NW_MODE_GSM | QSER_NW_MODE_WCDMA, // "3 : GSM/WCDMA (auto mode, according to PRL)"
            QSER_NW_MODE_CDMA | QSER_NW_MODE_EVDO, // "4 : CDMA and EvDo (auto mode, according to PRL)"
            QSER_NW_MODE_CDMA, // "5 : CDMA only"
            QSER_NW_MODE_EVDO, // "6 : EvDo only"
            QSER_NW_MODE_GSM | QSER_NW_MODE_WCDMA | QSER_NW_MODE_CDMA | QSER_NW_MODE_EVDO, // "7 : GSM/WCDMA, CDMA, and EvDo (auto mode, according to PRL)"
            QSER_NW_MODE_LTE | QSER_NW_MODE_CDMA | QSER_NW_MODE_EVDO, // "8 : LTE, CDMA and EvDo"
            QSER_NW_MODE_LTE | QSER_NW_MODE_GSM | QSER_NW_MODE_WCDMA, // "9 : LTE, GSM/WCDMA"
            QSER_NW_MODE_LTE | QSER_NW_MODE_CDMA | QSER_NW_MODE_EVDO| QSER_NW_MODE_GSM | QSER_NW_MODE_WCDMA, // "10: LTE, CDMA, EvDo, GSM/WCDMA"
            QSER_NW_MODE_LTE , // "11: LTE only"
            QSER_NW_MODE_LTE | QSER_NW_MODE_WCDMA, // "12: LTE/WCDMA"            
    };
    int array_length=sizeof (map)/ sizeof (map[0]);

    for(int i=0;i<array_length;i++)
    {
        if(map[i]==preferred_nw_mode)
        {
            return i;
        }
    }
    
    return INVALID_PREFER_TYPE;
}

void urc_msg_process_voice_reg()
{
    if(s_handlerPtr!=NULL)
    {
        s_handlerPtr(g_ph_hw,NW_IND_VOICE_REG_EVENT_IND_FLAG,NULL,0,s_contextPtr);
    }
}

void urc_msg_process_data_reg()
{
    if(s_handlerPtr!=NULL)
    {
        s_handlerPtr(g_ph_hw,NW_IND_DATA_REG_EVENT_IND_FLAG,NULL,0,s_contextPtr);
    }  
}


void urc_msg_process_signal_strength()
{
    signalStrength_t signalstrength;
    int slot_id;

    int ret = lynq_get_urc_info(1009,&signalstrength,&slot_id);
    if (ret == 0)
    {
        QSER_NW_SINGNAL_EVENT_IND_T msg_buf;
        msg_buf.gsm_sig_info_valid = signalstrength.gw_sig_valid;
        msg_buf.gsm_sig_info.rssi = signalstrength.rssi;
        msg_buf.wcdma_sig_info_valid = signalstrength.wcdma_sig_valid;
        msg_buf.wcdma_sig_info.rssi = signalstrength.rscp;
        msg_buf.wcdma_sig_info.ecio = signalstrength.ecno;
        msg_buf.tdscdma_sig_info_valid = 0;
        msg_buf.lte_sig_info_valid = signalstrength.lte_sig_valid;
        msg_buf.lte_sig_info.rssi = -125;
        msg_buf.lte_sig_info.rsrp = signalstrength.rsrp;
        msg_buf.lte_sig_info.rsrq = signalstrength.rsrq;
        msg_buf.lte_sig_info.snr = signalstrength.rssnr;
        msg_buf.cdma_sig_info_valid = 0;
        msg_buf.hdr_sig_info_valid = 0;
        msg_buf.nr_sig_info_valid = signalstrength.nr_sig_valid;
        msg_buf.nr_sig_info.ssRsrp = signalstrength.ssRsrp;
        msg_buf.nr_sig_info.ssRsrq = signalstrength.ssRsrq;
        msg_buf.nr_sig_info.ssSinr = signalstrength.ssSinr;
        msg_buf.nr_sig_info.csiRsrp = signalstrength.csiRsrp;
        msg_buf.nr_sig_info.csiRsrq = signalstrength.csiRsrq;
        msg_buf.nr_sig_info.csiSinr = signalstrength.csiSinr;
        void *ind_msg_buf= &msg_buf;
        if(s_handlerPtr!=NULL)
        {
            s_handlerPtr(g_ph_hw,NW_IND_SIGNAL_STRENGTH_EVENT_IND_FLAG,ind_msg_buf,sizeof (msg_buf) ,s_contextPtr);
        }         
   }   
}


void *new_network_thread_recv(void *context)
{
    int handle = -1;
    int ret = 0;
    int slot_id = 0;
    uint32_t ind_flag = 0;

    while (1)
    {
        lynq_wait_signalchanges(&handle);

        switch(handle)
        {
            case 1002: //RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
            {
                urc_msg_process_voice_reg();
               
                break;
            }
            case 3015://RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
            {   
                urc_msg_process_data_reg();               
                break;
            }        
            case 1009://RIL_UNSOL_SIGNAL_STRENGTH:
            {   
                urc_msg_process_signal_strength();
                break;
            }
        }        
    }
    return NULL;
}

int qser_nw_client_init(nw_client_handle_type  *ph_nw)
{
    if(NULL == ph_nw)
    {
        LYERRLOG("input  error\n");
        return RESULT_ERROR;
    }
    *ph_nw = (nw_client_handle_type)getpid();
    
    int ret=lynq_network_init(*ph_nw);
    
    if (ret != RESULT_OK)
    {
        LYERRLOG("lynq_network_init failed ret is %d",ret);
        return RESULT_ERROR;
    }
    g_ph_hw = *ph_nw;
    return RESULT_OK;    
}

int qser_nw_client_deinit(nw_client_handle_type h_nw)
{
    if(h_nw != g_ph_hw || h_nw == INVALID_CLIENT_HANDLE)
    {
        LYERRLOG("h_nw not right %d %d",h_nw,g_ph_hw);
        return RESULT_ERROR;
    }    

    int ret;
    
    if(s_new_network_tid!=-1)
    {
        ret = pthread_cancel(s_new_network_tid);
        LYINFLOG("pthread cancel waiting urc thread, ret = %d",ret);            
  
        ret = pthread_join(s_new_network_tid,NULL);
        LYINFLOG("pthread join waiting urc thread ret = %d",ret);
        s_new_network_tid =-1;
    }

    ret=lynq_network_deinit();
    
    if (ret != RESULT_OK)
    {
        LYERRLOG("lynq_network_deinit failed ret is %d",ret);
        return RESULT_ERROR;
    }

    g_ph_hw = INVALID_CLIENT_HANDLE;
  
    return RESULT_OK;      
}

int qser_nw_set_config(nw_client_handle_type h_nw,QSER_NW_CONFIG_INFO_T *pt_info)
{
    int pretype = 0;
    if(NULL == pt_info)
    {
        LYERRLOG("invalid client parameters incoming");
        return RESULT_ERROR;
    }
    
    if(h_nw != g_ph_hw || h_nw == INVALID_CLIENT_HANDLE)
    {
        LYERRLOG("h_nw not right %d %d",h_nw,g_ph_hw);
        return RESULT_ERROR;
    }    
    
    pretype = switch_preferred_nw_mode(pt_info->preferred_nw_mode);
    if (pretype ==INVALID_PREFER_TYPE)
    {
        LYERRLOG("invalid client parameters incoming %d",pt_info->preferred_nw_mode);
        return RESULT_ERROR;
    }

    int ret = lynq_set_prefferred_networktype(pretype);
    if (ret != RESULT_OK)
    {
        LYERRLOG("lynq_set_prefferred_networktype failed ret is %d",ret);
        return RESULT_ERROR;
    }
    return RESULT_OK;
}

/*To Do*/
int qser_nw_event_register(nw_client_handle_type h_nw,uint32_t bitmask)
{
    if(h_nw == 0)
    {
        LYERRLOG("invalid client parameters incoming");
        return RESULT_ERROR;
    }
    LYINFLOG("To be complie API");
    return RESULT_OK;
}

int qser_nw_get_operator_name(nw_client_handle_type h_nw,QSER_NW_OPERATOR_NAME_INFO_T  *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("invalid client parameters incoming");
        return RESULT_ERROR;
    }

    if(h_nw != g_ph_hw || h_nw == INVALID_CLIENT_HANDLE)
    {
        LYERRLOG("h_nw not right %d %d",h_nw,g_ph_hw);
        return RESULT_ERROR;
    }    
    
    int ret = 0;
    char op_FN[128];
    char op_SN[128];
    char mccmnc[8];
    memset(op_FN,0,sizeof(op_FN));
    memset(op_SN,0,sizeof(op_SN));
    memset(mccmnc,0,sizeof(mccmnc));
    ret = lynq_query_operater(op_FN,op_SN,mccmnc);
    if (ret != RESULT_OK)
    {
        LYERRLOG("lynq_query_operater failed ret is %d",ret);
        return RESULT_ERROR;
    }
    strcpy(pt_info->long_eons,op_FN);
    strcpy(pt_info->short_eons,op_SN);
    strncpy(pt_info->mcc,mccmnc,3);
    pt_info->mcc[3] = '\0';
    strcpy(pt_info->mnc,mccmnc+3);
    pt_info->mnc[3] = '\0';
    return RESULT_OK;
}

/*
        E_QL_MCM_NW_RADIO_TECH_NONE, //RADIO_TECH_UNKNOWN = 0,
        E_QL_MCM_NW_RADIO_TECH_GPRS , //RADIO_TECH_GPRS = 1,
        E_QL_MCM_NW_RADIO_TECH_EDGE, //RADIO_TECH_EDGE = 2,
        E_QL_MCM_NW_RADIO_TECH_UMTS, //RADIO_TECH_UMTS = 3,
        E_QL_MCM_NW_RADIO_TECH_IS95A, //RADIO_TECH_IS95A = 4,
        E_QL_MCM_NW_RADIO_TECH_IS95B, //RADIO_TECH_IS95B = 5,
        E_QL_MCM_NW_RADIO_TECH_1xRTT, //RADIO_TECH_1xRTT =  6,
        E_QL_MCM_NW_RADIO_TECH_EVDO_0, //RADIO_TECH_EVDO_0 = 7,
        E_QL_MCM_NW_RADIO_TECH_EVDO_A, //RADIO_TECH_EVDO_A = 8,
        E_QL_MCM_NW_RADIO_TECH_HSDPA, //RADIO_TECH_HSDPA = 9,
        E_QL_MCM_NW_RADIO_TECH_HSUPA, //RADIO_TECH_HSUPA = 10,
        E_QL_MCM_NW_RADIO_TECH_HSPA, //RADIO_TECH_HSPA = 11,
        E_QL_MCM_NW_RADIO_TECH_EVDO_B, //RADIO_TECH_EVDO_B = 12,
        E_QL_MCM_NW_RADIO_TECH_EHRPD, //RADIO_TECH_EHRPD = 13,
        E_QL_MCM_NW_RADIO_TECH_LTE, //RADIO_TECH_LTE = 14,
        E_QL_MCM_NW_RADIO_TECH_HSPAP, //RADIO_TECH_HSPAP = 15, // HSPA+
        E_QL_MCM_NW_RADIO_TECH_GSM, //RADIO_TECH_GSM = 16, // Only supports voice
        E_QL_MCM_NW_RADIO_TECH_TD_SCDMA, //RADIO_TECH_TD_SCDMA = 17,
        E_QL_MCM_NW_RADIO_TECH_NONE, //RADIO_TECH_IWLAN = 18,
        E_QL_MCM_NW_RADIO_TECH_NONE, //RADIO_TECH_LTE_CA = 19,
        E_QL_MCM_NW_RADIO_TECH_NONE, //RADIO_TECH_NR = 20

        E_QL_MCM_NW_RADIO_TECH_TD_SCDMA = 1,
        E_QL_MCM_NW_RADIO_TECH_GSM      = 2,    /**<  GSM; only supports voice. 
        E_QL_MCM_NW_RADIO_TECH_HSPAP    = 3,    /**<  HSPA+. 
        E_QL_MCM_NW_RADIO_TECH_LTE      = 4,    /**<  LTE. 
        E_QL_MCM_NW_RADIO_TECH_EHRPD    = 5,    /**<  EHRPD. 
        E_QL_MCM_NW_RADIO_TECH_EVDO_B   = 6,    /**<  EVDO B. 
        E_QL_MCM_NW_RADIO_TECH_HSPA     = 7,    /**<  HSPA. 
        E_QL_MCM_NW_RADIO_TECH_HSUPA    = 8,    /**<  HSUPA. 
        E_QL_MCM_NW_RADIO_TECH_HSDPA    = 9,    /**<  HSDPA. 
        E_QL_MCM_NW_RADIO_TECH_EVDO_A   = 10,   /**<  EVDO A. 
        E_QL_MCM_NW_RADIO_TECH_EVDO_0   = 11,   /**<  EVDO 0. 
        E_QL_MCM_NW_RADIO_TECH_1xRTT    = 12,   /**<  1xRTT. 
        E_QL_MCM_NW_RADIO_TECH_IS95B    = 13,   /**<  IS95B. 
        E_QL_MCM_NW_RADIO_TECH_IS95A    = 14,   /**<  IS95A. 
        E_QL_MCM_NW_RADIO_TECH_UMTS     = 15,   /**<  UMTS. 
        E_QL_MCM_NW_RADIO_TECH_EDGE     = 16,   /**<  EDGE. 
        E_QL_MCM_NW_RADIO_TECH_GPRS     = 17,   /**<  GPRS. 
        E_QL_MCM_NW_RADIO_TECH_NONE     = 18    /**<  No technology selected. */
int qser_radio_tech_qurey(int radiotechfam)
{
    int qser_radiotech = -1;
    if (radiotechfam <18 && radiotechfam >0)
    {
        qser_radiotech = 18 - radiotechfam;
    }
    else
    {
        qser_radiotech = E_QSER_NW_RADIO_TECH_NONE;
    }
    return qser_radiotech;
}

E_QSER_NW_SERVICE_TYPE_T switch_nw_regstate(int regstate)
{
    E_QSER_NW_SERVICE_TYPE_T state = E_QSER_NW_SERVICE_NONE;
    switch (regstate)
    {
    case 1:
    case 5:
        state = E_QSER_NW_SERVICE_FULL;
        break;
    case 10:
    case 12:
    case 13:
    case 14:
        state = E_QSER_NW_SERVICE_LIMITED;
        break;  
    }
    return state;  
}


int qser_nw_get_reg_status(nw_client_handle_type h_nw,QSER_NW_REG_STATUS_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("invalid client parameters incoming");
        return RESULT_ERROR;
    }

    if(h_nw != g_ph_hw || h_nw == INVALID_CLIENT_HANDLE)
    {
        LYERRLOG("h_nw not right %d %d",h_nw,g_ph_hw);
        return RESULT_ERROR;
    }    
    
    int ret = 0;
    int regState = 0;
    int imsRegState = 0;
    char CID[128]={0};
    char LAC[128]={0};
    int netType = 0;
    int radioTechFam = 0;
    int netreject = 0;
    pt_info->voice_registration_valid = 1;
    ret = lynq_query_registration_state("VOICE",&regState,&imsRegState,LAC,CID,&netType,&radioTechFam,&netreject);
    if(ret == 0)
    {
        pt_info->voice_registration_valid = 1;
        pt_info->voice_registration.tech_domain = E_QSER_NW_TECH_DOMAIN_NONE;
        pt_info->voice_registration.radio_tech = qser_radio_tech_qurey(netType);
        if (regState == 5)
        {
            pt_info->voice_registration.roaming = E_QSER_NW_ROAM_STATE_ON;
        }
        else
        {
            pt_info->voice_registration.roaming = E_QSER_NW_ROAM_STATE_OFF;
        }
        pt_info->voice_registration.registration_state = switch_nw_regstate(regState);
    }
    else
    {
        pt_info->voice_registration_valid = 0;
        LYERRLOG("get voice regstate fail");
    }
    ret = lynq_query_registration_state("DATA",&regState,&imsRegState,LAC,CID,&netType,&radioTechFam,&netreject);
    if(ret == 0)
    {
        pt_info->data_registration_valid = 1;
        pt_info->data_registration.tech_domain = E_QSER_NW_TECH_DOMAIN_NONE;
        pt_info->data_registration.radio_tech = qser_radio_tech_qurey(netType);
        if (regState == 5)
        {
            pt_info->data_registration.roaming = E_QSER_NW_ROAM_STATE_ON;
        }
        else
        {
            pt_info->data_registration.roaming = E_QSER_NW_ROAM_STATE_OFF;
        }
        pt_info->data_registration.registration_state = switch_nw_regstate(regState);
    }
    else
    {
        pt_info->data_registration_valid = 0;
        LYERRLOG("get data regstate fail");
    }
    pt_info->voice_registration_details_3gpp_valid = 0;
    pt_info->data_registration_details_3gpp_valid = 0;
    pt_info->voice_registration_details_3gpp2_valid = 0;
    pt_info->data_registration_details_3gpp2_valid = 0;
    return RESULT_OK;
}

int qser_nw_setlowpowermode(nw_client_handle_type h_nw,uint32_t low_power_mode_on)
{
    if(h_nw == 0)
    {
        LYERRLOG("invalid client parameters incoming");
        return RESULT_ERROR;
    }
    LYINFLOG("To be complie API");
    return RESULT_OK;
}

int qser_nw_get_signal_strength(nw_client_handle_type h_nw,QSER_NW_SIGNAL_STRENGTH_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("invalid client parameters incoming");
        return RESULT_ERROR;
    }

    if(h_nw != g_ph_hw || h_nw == INVALID_CLIENT_HANDLE)
    {
        LYERRLOG("h_nw not right %d %d",h_nw,g_ph_hw);
        return RESULT_ERROR;
    }    
    
    signalStrength_t lib_info;
    int ret = 0;
    ret = lynq_solicited_signal_strength(&lib_info);
    if(ret != 0)
    {
        LYERRLOG("get signal strength fail");
        return RESULT_ERROR;
    }
    pt_info->gsm_sig_info_valid = lib_info.gw_sig_valid;
    pt_info->gsm_sig_info.rssi = lib_info.rssi-110;
    pt_info->wcdma_sig_info_valid = lib_info.wcdma_sig_valid;
    pt_info->wcdma_sig_info.rssi = lib_info.wcdma_signalstrength-110;
    pt_info->wcdma_sig_info.ecio = lib_info.ecno/5;
    pt_info->tdscdma_sig_info_valid = 0;
    pt_info->lte_sig_info_valid = lib_info.lte_sig_valid;
    pt_info->lte_sig_info.rssi = lib_info.lte_signalstrength-110;
    pt_info->lte_sig_info.rsrp = lib_info.rsrp*(-1);
    pt_info->lte_sig_info.rsrq = lib_info.rsrq*(-1);
    pt_info->lte_sig_info.snr = lib_info.rssnr;
    pt_info->cdma_sig_info_valid = 0;
    pt_info->hdr_sig_info_valid = 0;
    pt_info->nr_sig_info_valid = lib_info.nr_sig_valid;
    pt_info->nr_sig_info.ssRsrp = lib_info.ssRsrp;
    pt_info->nr_sig_info.ssRsrq = lib_info.ssRsrq;
    pt_info->nr_sig_info.ssSinr = lib_info.ssSinr;
    pt_info->nr_sig_info.csiRsrp = lib_info.csiRsrp;
    pt_info->nr_sig_info.csiRsrq = lib_info.csiRsrq;
    pt_info->nr_sig_info.csiSinr = lib_info.csiSinr;
    return RESULT_OK;
}



int qser_nw_add_rx_msg_handler(nw_client_handle_type h_nw,QSER_NW_RxMsgHandlerFunc_t handlerPtr,void* contextPtr)
{  
    if(h_nw != g_ph_hw || h_nw == INVALID_CLIENT_HANDLE)
    {
        LYERRLOG("h_nw not right %d %d",h_nw,g_ph_hw);
        return RESULT_ERROR;
    }     

    s_handlerPtr = handlerPtr;
    s_contextPtr = contextPtr;
    if(s_handlerPtr!=NULL)
    {       
        int rt = pthread_create(&s_new_network_tid, NULL, new_network_thread_recv, NULL);
        if(rt < 0)
        {
            LYDBGLOG("%s pthread_create error!!!",__func__);
            s_handlerPtr=NULL;
            s_contextPtr=NULL;
            return RESULT_ERROR;
        }
    }
   
    return RESULT_OK;
}
