#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <lynq_network/lynq_network/lynq_network.h>
#include "network.h"
#include <include/lynq_qser_network.h>
#define TEST_RESULT "lynq_result="

int init_network(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int uToken = atoi(argv[1]);
    ret = lynq_network_init(uToken);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int deinit_network(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = lynq_network_deinit();
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int query_operater(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = lynq_query_operater(argv[1], argv[2], argv[3]);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_QUERY_OPERATER: OperatorFN=%s, OperatorSH=%s, MccMnc=%s\n", argv[1], argv[2], argv[3]);
    return ret;
}
int query_network_selection_mode(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int netselMode = atoi(argv[1]);
    ret = lynq_query_network_selection_mode(&netselMode);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_QUERY_NETWORK_SELECTION_MODE: netselMode=%d\n", netselMode);
    return ret;
}
int set_network_selection_mode(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = lynq_set_network_selection_mode(argv[1], argv[2]);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int query_available_network(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = lynq_query_available_network(argv[1], argv[2], argv[3], argv[4]);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_QUERY_AVAILABLE_NETWORK: OperatorFN=%s, OperatorSH=%s, MccMnc=%s, NetStatus=%s\n", argv[1], argv[2], argv[3], argv[4]);
    return ret;    
}
int query_registration_state(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int regState = atoi(argv[2]);
    int imsRegState = atoi(argv[3]);
    int netType = atoi(argv[6]);
    int radioTechFam = atoi(argv[7]);
    int netRejected = atoi(argv[8]);
    ret = lynq_query_registration_state(argv[1], &regState, &imsRegState, argv[4], argv[5], &netType, &radioTechFam, &netRejected);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_QUERY_REGISTRATION_STATE: regState=%d, imsRegState=%d, LAC=%s, CID=%s, netType=%d, radioTechFam=%d, netRejected=%d\n", regState, imsRegState, argv[4], argv[5], netType, radioTechFam, netRejected);
    return ret;  
}
int query_prefferred_networktype(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int preNetType = atoi(argv[1]);
    ret = lynq_query_prefferred_networktype(&preNetType);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_QUERY_PREFFERRED_NETWORKTYPE: preNetType=%d\n", preNetType);
    return ret;
}
int set_prefferred_networktype(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int preNetType = atoi(argv[1]);
    ret = lynq_set_prefferred_networktype(preNetType);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int solicited_signal_strength(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    signalStrength_t solSigStren = {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    ret = lynq_solicited_signal_strength(&solSigStren);
    printf("%s%d\n",TEST_RESULT,ret);
    if(ret==0)
    {
        printf("solicited_signal_strength gw_sig_valid = %d\n"
                                               " rssi = %d\n"
                                               " wcdma_sig_valid = %d\n"                                                
                                               " wcdma_signalstrength = %d\n"
                                               " rscp"
                                               " ecio = %d\n"                                      
                                               " lte_sig_info_valid = %d\n"
                                               " lte_signalstrength = %d\n"
                                               " rsrp = %d\n"
                                               " rsrq = %d\n"
                                               " rssnr = %d\n"                                             
                                               " nr_sig_valid = %d\n"
                                               " ssRsrp = %d\n"
                                               " ssRsrq = %d\n"
                                               " ssSinr = %d\n"
                                               " csiRsrp = %d\n"
                                               " csiRsrq = %d\n"
                                               " nr_sig_info.csiSinr = %d\n",
              solSigStren.gw_sig_valid, solSigStren.rssi,
                solSigStren.wcdma_sig_valid, solSigStren.wcdma_signalstrength,  solSigStren.rscp,solSigStren.ecno,        
              solSigStren.lte_sig_valid, solSigStren.lte_signalstrength, solSigStren.rsrp, solSigStren.rsrq, solSigStren.rssnr,    
              solSigStren.nr_sig_valid, solSigStren.ssRsrp, solSigStren.ssRsrq, solSigStren.ssSinr,
              solSigStren.csiRsrp, solSigStren.csiRsrq, solSigStren.csiSinr);
    }    
    return ret;
}
int set_ims(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int ims_mode = atoi(argv[1]);
    ret = lynq_set_ims(ims_mode);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_network_init(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    
    int ret = -1;  
    nw_client_handle_type h_nw;
    
    ret = qser_nw_client_init(&h_nw);       
    printf("%s%d\n",TEST_RESULT,ret);
    if(ret==0)
    {
        printf("qser_nw_client_init: h_nw=%d\n", h_nw);          
    }    
    return ret;    
}

int qser_network_deinit(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);

    if(argc !=2)
    {
        printf("error, argc %d is not equal 2 \n",argc);
        return -1;
    }
    
    int ret = -1;  
    nw_client_handle_type h_nw;
    
    h_nw=atoi(argv[1]);
    ret = qser_nw_client_deinit(h_nw);
    printf("%s%d\n",TEST_RESULT,ret);    
    return ret;    
}

int qser_network_set_config(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);

    if(argc !=3)
    {
        printf("error, argc %d is not equal 3 \n",argc);
        return -1;
    }

    nw_client_handle_type       h_nw;
    QSER_NW_CONFIG_INFO_T     t_info;

    h_nw=atoi(argv[1]);
    t_info.preferred_nw_mode=atoi(argv[2]);
    
    int ret = -1;  
    ret = qser_nw_set_config(h_nw,&t_info);
    printf("%s%d\n",TEST_RESULT,ret);    
    return ret;    
}

int qser_network_get_operator_name(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);

    if(argc !=2)
    {
        printf("error, argc %d is not equal 2 \n",argc);
        return -1;
    }

    nw_client_handle_type       h_nw;
    QSER_NW_OPERATOR_NAME_INFO_T  t_info;

    h_nw=atoi(argv[1]);    
    
    int ret = -1;  
    ret = qser_nw_get_operator_name(h_nw,&t_info);
    printf("%s%d\n",TEST_RESULT,ret);    
    if(ret==0)
    {
        printf("qser_nw_get_operator_name: h_nw=%d, long_eons=%s, short_eons=%s, mcc=%s, mnc=%s \n", h_nw, t_info.long_eons,t_info.short_eons,t_info.mcc,t_info.mnc);          
    }    
    return ret;    
}

int qser_network_get_reg_status(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);

    if(argc !=2)
    {
        printf("error, argc %d is not equal 3 \n",argc);
        return -1;
    }

    nw_client_handle_type       h_nw;
    QSER_NW_REG_STATUS_INFO_T  t_info;

    h_nw=atoi(argv[1]);    
    
    int ret = -1;  
    ret = qser_nw_get_reg_status(h_nw,&t_info);
    printf("%s%d\n",TEST_RESULT,ret);    
    if(ret==0)
    {    
        printf("qser_nw_get_reg_status: voice_registration_valid=%d, tech_domain=%d, radio_tech=%d, roaming=%d deny_reason=%d registration_state=%d\n", 
                      t_info.voice_registration_valid,
                      t_info.voice_registration.tech_domain,
                      t_info.voice_registration.radio_tech,
                      t_info.voice_registration.roaming,
                      t_info.voice_registration.deny_reason,
                      t_info.voice_registration.registration_state);         
        printf("qser_nw_get_reg_status: data_registration_valid=%d, tech_domain=%d, radio_tech=%d, roaming=%d deny_reason=%d registration_state=%d\n", 
                      t_info.data_registration_valid,
                      t_info.data_registration.tech_domain,
                      t_info.data_registration.radio_tech,
                      t_info.data_registration.roaming,
                      t_info.data_registration.deny_reason,
                      t_info.data_registration.registration_state);       
    }    
    return ret;        
}


int qser_network_solicited_signal_strength(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    if(argc !=2)
    {
        printf("error, argc %d is not equal 2 \n",argc);
        return -1;
    }
    int ret = -1;  
    nw_client_handle_type h_nw;
    QSER_NW_SIGNAL_STRENGTH_INFO_T t_info;
    memset(&t_info,sizeof (t_info) , 0);
    h_nw=atoi(argv[1]);
    ret = qser_nw_get_signal_strength(h_nw,&t_info);
    printf("%s%d\n",TEST_RESULT,ret);
    if(ret==0)
    {         
        printf("qser_solicited_signal_strength gsm_sig_info_valid = %d\n"
               "                               gsm_sig_info.rssi = %d\n"
               "                               wcdma     _sig_info_valid = %d\n" 
               "                               wcdma_sig_info.rssi = %d\n"
               "                               wcdma_sig_info.ecio = %d\n"
               "                               tdscdma_sig_info_valid = %d\n"
               "                               lte_sig_info_valid = %d\n"
               "                               lte_sig_info.rssi = %d\n"
               "                               lte_sig_info.rsrp = %d\n"
               "                               lte_sig_info.rsrq = %d\n"
               "                               lte_sig_info.snr = %d\n"
               "                               cdma_sig_info_valid = %d\n"
               "                               hdr_sig_info_valid = %d\n"
               "                               nr_sig_info_valid = %d\n"
               "                               nr_sig_info.ssRsrp = %d\n"
               "                               nr_sig_info.ssRsrq = %d\n"
               "                               nr_sig_info.ssSinr = %d\n"
               "                               nr_sig_info.csiRsrp = %d\n"
               "                               nr_sig_info.csiRsrq = %d\n"
               "                               nr_sig_info.csiSinr = %d\n",
              t_info.gsm_sig_info_valid, t_info.gsm_sig_info.rssi,
                t_info.wcdma_sig_info_valid, t_info.wcdma_sig_info.rssi,  t_info.wcdma_sig_info.ecio,
              t_info.tdscdma_sig_info_valid,
              t_info.lte_sig_info_valid, t_info.lte_sig_info.rssi, t_info.lte_sig_info.rsrp, t_info.lte_sig_info.rsrq, t_info.lte_sig_info.snr,
              t_info.cdma_sig_info_valid, 
              t_info.hdr_sig_info_valid, 
              t_info.nr_sig_info_valid, t_info.nr_sig_info.ssRsrp, t_info.nr_sig_info.ssRsrq, t_info.nr_sig_info.ssSinr,
              t_info.nr_sig_info.csiRsrp, t_info.nr_sig_info.csiRsrq, t_info.nr_sig_info.csiSinr);
    }    
    return ret;
}

