#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libsms/lynq_sms.h>
#include <include/lynq_qser_sms.h>
#include "sms.h"
#define TEST_RESULT "lynq_result="

int init_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int uToken = atoi(argv[1]);
    ret = lynq_sms_init(uToken);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int deinit_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = lynq_sms_deinit();
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int send_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int charset = atoi(argv[2]);
    int msglen = atoi(argv[4]);
    ret = lynq_send_sms(argv[1], charset, argv[3], msglen);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int read_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int index = atoi(argv[1]);
    int status = atoi(argv[2]);
    int charset = atoi(argv[3]);
    int smscLen = atoi(argv[5]);
    int smslen = atoi(argv[7]);
    int numLen = atoi(argv[9]);
    int current = atoi(argv[10]);
    int total = atoi(argv[11]);
    ret = lynq_read_sms(index, &status, &charset, argv[4], &smscLen, &smslen, argv[6], argv[8], &numLen, &current, &total);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_SMS_READ: status=%d, charset=%d, smsc=%s, smscLen=%d, message=%s, smslen=%d, teleNum=%s, numLen=%d, current=%d, total=%d\n", status, charset, argv[4], smscLen, argv[6], smslen, argv[8], numLen, current, total);
    return ret;
}
int list_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    
    ret = lynq_list_sms(argv[1]);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_LIST_SMS: index_list=%s\n", argv[1]);
    return ret;
}
int delete_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int index = atoi(argv[1]);

    ret = lynq_delete_sms(index);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int wait_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int handle = atoi(argv[1]);

    ret = lynq_wait_receive_new_sms(&handle);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_WAIT_SMS: handle=%d\n", handle);
    return ret;
}

//QSER API
sms_client_handle_type  ph_sms;
int qser_init_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ph_sms = atoi(argv[1]);
    ret = qser_sms_client_init(&ph_sms);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_deinit_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = qser_sms_client_deinit(ph_sms);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_send_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    QSER_sms_info_t pt_sms_info;
    
    strcpy(pt_sms_info.src_addr, argv[1]);
    pt_sms_info.type = (QSER_SMS_TYPT)atoi(argv[2]);
    strcpy(pt_sms_info.sms_data, argv[3]);
    pt_sms_info.sms_data_len = atoi(argv[4]);
    
    ret = qser_sms_send_sms(ph_sms, &pt_sms_info);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
#if 1
int qser_delete_sms(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    QSER_sms_storage_info_t  pt_sms_storage;
    
    pt_sms_storage.storage_idx= atoi(argv[1]);
    ret = qser_sms_deletefromstorage(ph_sms, &pt_sms_storage);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
#endif
