/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_IMS"

const int MSG_QUERY = 0;
const int MSG_SET = 1;
int mCurrentEmimsFlag = 0;
char mCurrentSettingLabel[32] = {0};
char mCurrentSettingValue[32] = {0};
bool fgImsRead = true;
char retstring[128] = {0};

void sendCommandSet(const char* name, char *value) {
    mCurrentEmimsFlag = MSG_SET;
    char cmd_str[64] = {0};
    sprintf(cmd_str,"AT+ECFGSET=\"%s\",\"%s\"",name,value);
    emSendATCommand(cmd_str, get_default_sim_all_except_data());
}

void sendCommandQuery(const char* name) {
    mCurrentEmimsFlag = MSG_QUERY;
    char cmd_str[64] = {0};
    sprintf(cmd_str,"AT+ECFGGET=\"%s\"",name);
    emSendATCommand(cmd_str,get_default_sim_all_except_data());
}

char * parseCommandResponse(char * data) {
   RLOGD("raw data: %s",data);
   return "";
}

void emImsAtCmdHandle(char*response, int responselen) {
    switch (mCurrentEmimsFlag) {
    case MSG_QUERY:
    {
        memset(retstring,0,sizeof(retstring));
        if ((responselen > 0) && (response != NULL)) {
            RLOGD("Query success for %s ", mCurrentSettingLabel);
            RLOGD("%s",response);
            sprintf(retstring,"%s %s",response,RET_STRING_IMS_SUCCESS);
        }
        else {
            RLOGD("Query failed for %s ", mCurrentSettingLabel);
            sprintf(retstring,"Query failed for %s %s",mCurrentSettingLabel,RET_STRING_IMS_FAIL);
        }
        android::unregisterNetwork();
        android::emResultNotify(retstring);
        break;
    }
    case MSG_SET:
    {
        memset(retstring,0,sizeof(retstring));
        if ((responselen > 0) && (response != NULL)) {
            sprintf(retstring,"Set %s=%s successful %s",mCurrentSettingLabel,mCurrentSettingValue,RET_STRING_IMS_SUCCESS);
            RLOGD("Set successful.");
        }
        else {
            sprintf(retstring,"Set %s=%s failed %s",mCurrentSettingLabel,mCurrentSettingValue,RET_STRING_IMS_FAIL);
            RLOGD("Set failed.");
        }
        android::unregisterNetwork();
        android::emResultNotify(retstring);
        break;
    }
    default:
        break;
    }
}


//create thread to send command
void * emImsThread(void* arg)
{
    if(fgImsRead){
        sendCommandQuery(mCurrentSettingLabel);
    }else{
        sendCommandSet(mCurrentSettingLabel,mCurrentSettingValue);
    }
    pthread_exit(0);
}

int emImsStart(int argc, int *item,char *value)
{
    RLOGD("emImsStart called");
     //init item[0] //common/call/xxx: item[1] property item[2] get/set
    mCurrentEmimsFlag = 0;
    if(argc < 3){
        RLOGD("please select ims get or set : ims get xxx /ims set xxx xx");
        return -1;
    }
    int classid = item[0];
    int propertyid = item[1];
    int operatorid = item[2];

    em_arry_t *subarry = &(ims[classid].subarray[propertyid]);
    RLOGD("IMS property name %s",subarry->name);
    memset(mCurrentSettingLabel,0,sizeof(mCurrentSettingLabel));
    switch(operatorid){
        case 0://get
        {
            strncpy(mCurrentSettingLabel,subarry->name,strlen(subarry->name));
            fgImsRead = true;
            break;
        }
        case 1://set
        {
            strncpy(mCurrentSettingLabel,subarry->name,strlen(subarry->name));
            strncpy(mCurrentSettingValue,value,strlen(value));
            fgImsRead = false;
            break;
        }
    }

    android::registerForATcmdResponse(emImsAtCmdHandle);
    pthread_t emimsthread;
    pthread_create(&emimsthread,NULL, emImsThread, NULL);
    return (0);
}

#endif

