/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <cstdint>
#include <iostream>
#include <string>
#include <memory>
#include <vector>
#include <algorithm>
using namespace std;
#include <vendor-ril/telephony/ril.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include "common.h"
#include "sms_pdu_cdma.h"
#include "UserData.h"
#include "CdmaSmsAddress.h"
#include "BearerData.h"
#include "SmsEnvelope.h"
#include "HexDump.h";
#include "SmsMessageConverter.h"
#include "SmsMessage.h"

static uint32_t msgid = 0;
#undef LOG_TAG
#define LOG_TAG "DEMO_CDMA_SMS"

std::vector<std::uint8_t> mLastDispatchedSmsFingerprint;
std::vector<std::uint8_t> mLastAcknowledgedSmsFingerprint;

uint32_t getNextMessageId() {
  // Testing and dialog with partners has indicated that
  // msgId==0 is (sometimes?) treated specially by lower levels.
  // Specifically, the ID is not preserved for delivery ACKs.
  // Hence, avoid 0 -- constraining the range to 1..65535.
  uint32_t nextMsgId = (msgid % 0xFFFF) + (uint32_t) 1;
  msgid++;
  return nextMsgId;
}

void resposeCdmaSms(RIL_CDMA_SMS_Message *p_cur) {
  std::shared_ptr<SmsMessage> smsMessage =
      SmsMessageConverter::newCdmaSmsMessageFromRil(p_cur);
  mLastAcknowledgedSmsFingerprint.clear();
  mLastAcknowledgedSmsFingerprint = smsMessage->getIncomingSmsFingerprint();
  if ((!mLastAcknowledgedSmsFingerprint.empty()) &&
          (mLastDispatchedSmsFingerprint == mLastAcknowledgedSmsFingerprint)) {
      RLOGD("duplicate CDMA MT SMS, just return");
      std::cout << "duplicate CDMA MT SMS, just return" << std::endl;
      return;
  }
  mLastDispatchedSmsFingerprint.clear();
  mLastDispatchedSmsFingerprint = mLastAcknowledgedSmsFingerprint;
  smsMessage->parseSms();
}

// add for cdma long sms test
int hexCharToInt(char c)
{
    if (c >= '0' && c <= '9')
        return (c - '0');
    if (c >= 'A' && c <= 'F')
        return (c - 'A' + 10);
    if (c >= 'a' && c <= 'f')
        return (c - 'a' + 10);

    return 0;
}

void hexStringToBytes(const char *in, int inLength, char *out, int outLength)
{
    int i;

    if (in == NULL || out == NULL)
    {
        return;
    }

    if (inLength != outLength * 2)
    {
        return;
    }

    for (i = 0 ; i < inLength ; i += 2)
    {
        out[i/2] = (char)((hexCharToInt(in[i]) << 4)
                           | hexCharToInt(in[i+1]));
    }
}

//

void createCdmaMessage(RequestInfo *pRI, char* dest, char* message, bool isStored, uint8_t retry,int32_t messageRef) {
  bool statusReportRequested = false;
  int priority = -1/*PRIORITY_NORMAL*/;
  std::shared_ptr<UserData> uData = std::make_shared<UserData>();
  uData->payloadStr = message;
  uint32_t ascii_unsupported = 0;
  uint32_t i;
  uint32_t len;

  len = strlen (message);

  /* Check if we can do ASCII-7 */
  for (i = 0; i < len; i++) {
      if (message[i] & 0x80) {
          ascii_unsupported++;
          break;
      }
  }
  if (ascii_unsupported) {
      RLOGD("createCdmaMessage encoding (ENCODING_UNICODE_16)");
      uData->msgEncodingSet = true;
      uData->msgEncoding = UserData::ENCODING_UNICODE_16;
  }
  //std::cout << "dest: " << dest << std::endl;
  //std::cout << "uData.payloadStr:" << uData->payloadStr << std::endl;
  //uData.userDataHeader = smsHeader;
  std::shared_ptr<CdmaSmsAddress> destAddr = CdmaSmsAddress::parse(dest); //TBD free.
  //string str1 = HexDump::toHexString(destAddr->origBytes);
  //std::cout << str1 << std::endl;
  if (destAddr == nullptr)
    return;
  BearerData bearerData;
  bearerData.messageType = BearerData::MESSAGE_TYPE_SUBMIT;

  bearerData.messageId = getNextMessageId();

  bearerData.deliveryAckReq = statusReportRequested;
  bearerData.userAckReq = false;
  bearerData.readAckReq = false;
  bearerData.reportReq = false;
  if (priority >= PRIORITY_NORMAL && priority <= PRIORITY_EMERGENCY) {
    bearerData.priorityIndicatorSet = true;
    bearerData.priority = priority;
  }
  bearerData.userData = uData;
  std::vector<uint8_t> encodedBearerData = BearerData::encode(&bearerData);
  RLOGD("MO (encoded) BearerData =  %s", bearerData.toString().c_str());
  RLOGD("MO raw BearerData = '%s'", HexDump::toHexString(encodedBearerData).c_str());
  //std::cout << "MO (encoded) BearerData = " << bearerData.toString() << std::endl;
  //std::cout <<  "MO raw BearerData = '" << HexDump::toHexString(encodedBearerData) << "'" << std::endl;
  if (encodedBearerData.empty())
    return;

  int teleservice =
      bearerData.hasUserDataHeader ?
          SmsEnvelope::TELESERVICE_WEMT : SmsEnvelope::TELESERVICE_WMT;

  SmsEnvelope envelope;
  envelope.messageType = SmsEnvelope::MESSAGE_TYPE_POINT_TO_POINT;
  envelope.teleService = teleservice;
  envelope.destAddress = destAddr;
  envelope.bearerReply = RETURN_ACK;
  envelope.bearerData = encodedBearerData;

  uint32_t uTeleserviceID = envelope.teleService;
  uint8_t bIsServicePresent = 0; //read?
  uint32_t uServicecategory = 0;
  uint32_t sAddress_digit_mode = destAddr->digitMode;
  uint32_t sAddress_number_mode = destAddr->numberMode;
  uint32_t sAddress_number_type = destAddr->ton;
  uint32_t sAddress_number_plan = destAddr->numberPlan;
  uint8_t sAddress_number_of_digits = destAddr->numberOfDigits;
  uint8_t sAddress_digits[destAddr->origBytes.size()];
  std::copy(destAddr->origBytes.begin(), destAddr->origBytes.end(),
      sAddress_digits);
  uint32_t sSubAddress_subaddressType = 0;
  uint8_t sSubAddress_odd = 0;
  uint8_t sSubAddress_number_of_digits = 0;
//  uint8_t sSubAddress_digits;
//  uint8_t sSubAddress.digits[digitCount]
  int uBearerDataLen = encodedBearerData.size();
  uint8_t aBearerData[uBearerDataLen];
  std::copy(encodedBearerData.begin(), encodedBearerData.end(), aBearerData);

  android::Parcel p;
  size_t pos =  p.dataPosition();
  if(pRI->pCI->requestNumber == RIL_REQUEST_IMS_SEND_SMS) {
      p.writeInt32(RADIO_TECH_3GPP2);
      p.write(&retry,sizeof(retry)); //retry
      p.write(&messageRef, sizeof(messageRef)); //messageRef
  }

  if(isStored) {
    p.writeInt32(2); /*      2 = "STO UNSENT"    */
  }

  p.writeInt32(uTeleserviceID);
  p.write(&bIsServicePresent,sizeof(bIsServicePresent));
  p.writeInt32(uServicecategory);
  p.writeInt32(sAddress_digit_mode);
  p.writeInt32(sAddress_number_mode);
  p.writeInt32(sAddress_number_type);
  p.writeInt32(sAddress_number_plan);
  p.write(&sAddress_number_of_digits, sizeof(sAddress_number_of_digits));
//  for(int i=0; i < sAddress_number_of_digits; i++){
//    p.write(&(sAddress_digits[i]), sizeof(sAddress_digits[i]));
//  }
  for(auto i: destAddr->origBytes) {
    p.write(&i, sizeof(i));
  }
  p.writeInt32(sSubAddress_subaddressType);
  p.write(&sSubAddress_odd, sizeof(sSubAddress_odd));
  p.write(&sSubAddress_number_of_digits, sizeof(sSubAddress_number_of_digits));
  //add for 3gpp2 long sms test
  size_t posDataLen =  p.dataPosition();
  int payloadLen = bearerData.userData->payload.size();
  if (payloadLen > SmsConstants::MAX_USER_DATA_BYTES && !isStored)
  {
    RLOGD("MO CDMA SMS, encoded user data too large (%d > %d bytes). Send test encoded string from phone: %s",
        payloadLen, SmsConstants::MAX_USER_DATA_BYTES,message);
    int smsCount=0, encodedStrBytes=0;
    encodedStrBytes = strlen(message);
    smsCount= encodedStrBytes/336; //the longest part SMS from phone is encoded into a string which has 336 characters in total;
    if(encodedStrBytes%336)
    {
        smsCount += 1;
    }
    RLOGD("encodedStrBytes=%d, smsCount=%d",encodedStrBytes, smsCount);
    int msgSegLen = 168; //336/2, two characters convert to an octet
    int hasSendBytes = 0;
    char msgSegByteArray[168]={0};
    int iBearerDataLenInd=18; // bearer data len field is at 19th octect, index in an array is 18
    for(int i = 0; i < smsCount; i++){
      char* messageStart = message+i*336;
      if(i == smsCount - 1 ){
        msgSegLen = encodedStrBytes/2 - hasSendBytes;
      }

      hexStringToBytes(messageStart,msgSegLen*2,msgSegByteArray,msgSegLen);

      int uBearerTestDataLen = msgSegByteArray[iBearerDataLenInd];
      RLOGD("MO CDMA SMS, uBearerTestDataLen=%d",uBearerTestDataLen);
      p.writeInt32(uBearerTestDataLen);
      RLOGD("MO CDMA SMS, send part-%d, msgSegLen=%d, hasSendBytes=%d", i+1, msgSegLen, hasSendBytes);
      for(int j=iBearerDataLenInd+1; j<msgSegLen; j++){
        p.writeByte(msgSegByteArray[j]);
      }

      RequestInfo *pRI_backup = (RequestInfo *)calloc(1, sizeof(RequestInfo));
      pRI_backup->token = pRI->token;
      pRI_backup->pCI = pRI->pCI;
      pRI_backup->socket_id = pRI->socket_id;
      pRI_backup->p_next = pRI->p_next;
      p.setDataPosition(pos);
      pRI->pCI->dispatchFunction(p, pRI_backup);
      //clean array and update pos
      memset(msgSegByteArray,0,168);
      hasSendBytes += msgSegLen;
      p.setDataPosition(posDataLen);
    }

    if(pRI != NULL)
      free(pRI);
    return;
  }
  //end for 3gpp2 long sms test

  p.writeInt32(uBearerDataLen);
//  for (int i = 0; i < uBearerDataLen; i++) {
//    p.write(&(aBearerData[i]), sizeof(aBearerData[i]));
//  }
  for(auto i: encodedBearerData) {
    p.write(&i, sizeof(i));
  }
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
}
