/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <unistd.h>
#include <string.h>
#include <log/log.h>
#include <vendor-ril/telephony/ril.h>
extern "C" {
#include <gio/gio.h>
#include <glib.h>
}

#include "common.h"
/*Warren add for T800 platform 2021/11/11 start*/
#include "lynq_common.h"
/*Warren add for T800 platform 2021/11/11 start*/

#define LOG_TAG "DEMO_DATA_GDBUS"
#define TELEPHONY_SERVICE "mtk.telephony" /*well-known bus name */
#define TELEPHONY_DATA_INTERFACE "mtk.telephony.Data" /*interface name*/
#define TELEPHONY_DATA_PATH "/mtk/telephony/data" /*object name*/

GMainLoop *loop = NULL;
GDBusProxy *proxy = NULL;
MTK_Data_Call_Response_v1 req_response;
MTK_Data_Call_Response_v1 urc_response;
/*Warren add for T800 platform 2021/11/11 start*/
int lynq_data_management(MTK_Data_Call_Response_v1 *urc_response)
{
    char apn_t[LYNQ_APN_LEN_MAX] = {};
    char apnType_t[LYNQ_APNTPYE_LEN_MAX] = {};
    char iface_t[LYNQ_APNTPYE_LEN_MAX] = {};
    if(!urc_response)
    {
        RLOGD("urc_response is null!!!");
        return -1;
    }
    bool apnHasCreated = FALSE;
    char Buf[1024] = {0};
    bzero(Buf, 1024);
    if(urc_response->cId > 0)
    {
        if(urc_response->pdnState==PDN_DISCONNECTED)//if user disable data call,the pdn state wiil change to disconnected.
        {
            printf("data test 001\n");
            for(int i = 0;i < LYNQ_APN_CHANNEL_MAX;i++)
            {
                printf("data test 002:count:%d\n",i);
                printf("[PDN_DISCONNECTED]apn_table[%d],apntype:%s,apnstatus:%d,,,urc_response->apnName:%s\n",i,apn_table[i].apntype,apn_table[i].apnstatus,urc_response->apnType);
                if((strcmp(apn_table[i].apntype,urc_response->apnType)==0)&&(apn_table[i].apnstatus==0))
                {
                    bzero(apn_table[i].apn,LYNQ_APN_LEN_MAX);
                    bzero(apn_table[i].apntype,LYNQ_APNTPYE_LEN_MAX);
                    apn_table[i].used=0;
                    apn_table[i].netId=0;
                    apn_count--;
                    printf("send signa start\n");
                    lynqUnlockWaitingReq();
                    printf("send signa end\n");
                    RLOGD("removed apn:%s,apntype:%s",apn_table[i].apn,apn_table[i].apntype);
                    printf("removed apn:%s,apntype:%s\n",apn_table[i].apn,apn_table[i].apntype);
                    break;
                }
            }
            //test
            for(int i = 0;i < LYNQ_APN_CHANNEL_MAX;i++)
            {
                RLOGD("for apn_table[%d].apn:%s,apntype:%s,used:%d,apnstatus:%d\n",i,apn_table[i].apn,
                apn_table[i].apntype,apn_table[i].used,apn_table[i].apnstatus);
            }
        }
        else
        {
            /*if the pdn status change,tele-fwk will send pdn status to me.
            **The reason for the status change may be that enable data call, 
            **the user disable the data call, and the signal is interrupted.
            */
            if(apn_count==0)//first new apn has created 
            {
                RLOGD("first apn_count:%d\n",apn_count);
                memcpy(apn_table[apn_count].apn,urc_response->apnName,strlen(urc_response->apnName)+1);
                memcpy(apn_table[apn_count].apntype,urc_response->apnType,strlen(urc_response->apnType)+1);
                memcpy(apn_table[apn_count].ifaceName,urc_response->ifname,strlen(urc_response->ifname)+1);
                //printf("apn_table[%d].apn:%s,,,,urc_response->apnName:%s\n",apn_count,apn_table[apn_count].apn,urc_response->apnName);
                RLOGD("apn_table[%d].apn:%s,apntype:%s,,,urc_response->apnName:%s,urc_response->apntype:%s\n",apn_count,apn_table[apn_count].apn,apn_table[apn_count].apntype,urc_response->apnName,urc_response->apnType);
                apn_table[apn_count].apnstatus=1;
                apn_table[apn_count].used=1;
                apn_table[apn_count].netId=urc_response->netId;
                apn_count++;
                lynqUnlockWaitingReq();
            }
            else
            {
                for(int i = 0;i < LYNQ_APN_CHANNEL_MAX;i++)
                {
                    RLOGD("for apn_table[%d].apn:%s,,,,urc_response->apnName:%s\n",i,apn_table[i].apn,urc_response->apnName);
                    if(strcmp(apn_table[i].apn,urc_response->apnName)==0)
                    {
                        RLOGD("This apn has been created!!!");
                        printf("This apn has been created!!!\n");
                        apnHasCreated = TRUE;
                        if(apn_table[i].netId!=urc_response->netId)
                        {
                            apn_table[i].netId=urc_response->netId;
                            memcpy(iface_t,apn_table[i].ifaceName,strlen(apn_table[i].ifaceName)+1);
                            memcpy(apnType_t,apn_table[i].apntype,strlen(apn_table[i].apntype)+1);
                            memcpy(apn_t,apn_table[i].apn,strlen(apn_table[i].apn)+1);
                            lynq_data_callback(apn_t,apnType_t,urc_response->pdnState,iface_t);
                            //sprintf(Buf,"+LAPNST:%s,%s,%d,%s\n",apn_table[i].apn,apn_table[i].apntype,urc_response->pdnState,urc_response->ifname);
                            //printf("eBuf:%s\n",Buf);
                            //int n = write(ttyGS3_fd,Buf,strlen(Buf));
                            //if(n<0)
                            //{
                            //     perror("lynq resp write:");
                            //}
                        }
                        break;
                    }
                }
                if(!apnHasCreated)//new apn has created
                {
                    bool getLable = FALSE;
                    int lable = 0;
                    for(lable;lable < LYNQ_APN_CHANNEL_MAX;lable++)
                    {
                        if(apn_table[lable].used==0)
                        {
                            getLable = TRUE;
                            break;
                        }
                    }
                    if(getLable)
                    {
                        RLOGD("[getLable]:label==%d\n",lable);
                        memcpy(apn_table[lable].apn,urc_response->apnName,strlen(urc_response->apnName)+1);
                        memcpy(apn_table[lable].apntype,urc_response->apnType,strlen(urc_response->apnType)+1);
                        memcpy(apn_table[lable].ifaceName,urc_response->ifname,strlen(urc_response->ifname)+1);
                        RLOGD("new apn_table[%d].apn:%s,apntype:%s,,,urc_response->apnName:%s,urc_response->apntype:%s\n",lable,apn_table[lable].apn,apn_table[lable].apntype,urc_response->apnName,urc_response->apnType);
                        apn_table[lable].apnstatus=1;
                        apn_table[lable].used=1;
                        apn_table[lable].netId=urc_response->netId;
                        apn_count++;
                        lynqUnlockWaitingReq();
                    }
                    else
                    {
                        RLOGD("unkown error");
                    }
                }
            }
        }
    }
    else
    {
        apnHasCreated = FALSE;
        RLOGD("[cid < 0] apn_count:%d\n",apn_count);
        if(apn_count>0)
        {
            int i = 0;
            for(i;i < LYNQ_APN_CHANNEL_MAX;i++)
            {
                RLOGD("[cid<0]apn_table[%d].apntype:%s,,,,urc_response->apntype:%s\n",i,apn_table[i].apntype,urc_response->apnType);
                if(strcmp(apn_table[i].apntype,urc_response->apnType)==0)
                {
                    RLOGD("apntype:%s PDN status has changed!!!",urc_response->apnType);
                    RLOGD("apntype:%s PDN status has changed!!!\n",urc_response->apnType);
                    apnHasCreated = TRUE;
                    break;
                }
            }
            if(apnHasCreated)
            {
                //sprintf(Buf,"+LAPNST:%s,%s,%d\n",apn_table[i].apn,apn_table[i].apntype,urc_response->pdnState);
                //printf("Buf:%s\n",Buf);
                memcpy(iface_t,apn_table[i].ifaceName,strlen(apn_table[i].ifaceName)+1);
                memcpy(apnType_t,apn_table[i].apntype,strlen(apn_table[i].apntype)+1);
                memcpy(apn_t,apn_table[i].apn,strlen(apn_table[i].apn)+1);
                lynq_data_callback(apn_t,apnType_t,urc_response->pdnState,iface_t);
                //int n = write(ttyGS3_fd,Buf,strlen(Buf));
                //if(n<0)
                //{
                //    perror("lynq resp write:");
                //}
            }
        }
    }
    return 0;
}
/*Warren add for T800 platform 2021/11/11 end*/
void freeMem(MTK_Data_Call_Response_v1 response)
{
    g_free(response.apnType);
    g_free(response.type);
    g_free(response.ifname);
    g_free(response.addresses);
    g_free(response.dnses);
    g_free(response.gateways);
    g_free(response.pcscf);
}

char* apnState2string(RIL_Data_Call_PdnState apnState) {
    switch (apnState) {
    case RIL_Data_Call_PdnState::PDN_CONNECTED:
        return "PDN_CONNECTED";
    case RIL_Data_Call_PdnState::PDN_CONNECTING:
        return "PDN_CONNECTING";
    case RIL_Data_Call_PdnState::PDN_DISCONNECTED:
        return "PDN_DISCONNECTED";
    case RIL_Data_Call_PdnState::PDN_DISCONNECTING:
        return "PDN_DISCONNECTING";
    case RIL_Data_Call_PdnState::PDN_FAILED:
        return "PDN_FAILED";
    case RIL_Data_Call_PdnState::PDN_IDLE:
        return "PDN_IDLE";
    case RIL_Data_Call_PdnState::PDN_RETRYING:
        return "PDN_RETRYING";
    case RIL_Data_Call_PdnState::PDN_SCANNING:
        return "PDN_SCANNING";
    default:
        return "UNKNOWN";
    }
}

void dumpResponse(MTK_Data_Call_Response_v1 *dataCallResponse)
{
    RLOGD("dumpResponse: netId: %d, pdnState: %s, status: %d, cId: %d, apnType: %s,"
            " protocolType: %s, ifaceName: %s, address: %s, dns: %s, gateway: %s, pcscf: %s, mtu: %d, apn: %s",
            dataCallResponse->netId, apnState2string(RIL_Data_Call_PdnState(dataCallResponse->pdnState)),
            dataCallResponse->status, dataCallResponse->cId, dataCallResponse->apnType, dataCallResponse->type,
            dataCallResponse->ifname, dataCallResponse->addresses, dataCallResponse->dnses,
            dataCallResponse->gateways, dataCallResponse->pcscf, dataCallResponse->mtu, dataCallResponse->apnName);
    /*printf("dumpResponse: netId: %d, pdnState: %s, status: %d, cId: %d, apnType: %s,"
            " protocolType: %s, ifaceName: %s, address: %s, dns: %s, gateway: %s, pcscf: %s, mtu: %d, apn: %s",
            dataCallResponse->netId, apnState2string(RIL_Data_Call_PdnState(dataCallResponse->pdnState)),
            dataCallResponse->status, dataCallResponse->cId, dataCallResponse->apnType, dataCallResponse->type,
            dataCallResponse->ifname, dataCallResponse->addresses, dataCallResponse->dnses,
            dataCallResponse->gateways, dataCallResponse->pcscf, dataCallResponse->mtu, dataCallResponse->apnName);
            */
}

void parse(GVariant* result, MTK_Data_Call_Response_v1* data) {
    g_variant_get(result, "((iiiisssssssis))", &(data->netId),
            &(data->pdnState), &(data->status),
            &(data->cId), &(data->apnType), &(data->type),
            &(data->ifname), &(data->addresses),
            &(data->dnses), &(data->gateways),
            &(data->pcscf), &(data->mtu),&(data->apnName));
}

void proxy_method_cb (GDBusProxy   *proxy,
                                      GAsyncResult *res,
                                      gpointer      user_data)
{
    RLOGD("method call back");
    GError *error;
    GVariant *result;

    error = NULL;
    result = g_dbus_proxy_call_finish(proxy, res, &error);

    if(error != NULL)
    {
        RLOGD("method call back error %s", error->message);
        g_error_free(error);
        return;
    }
    freeMem(req_response);
    parse(result, &req_response);
    dumpResponse(&req_response);
    g_variant_unref(result);
}

int enableData (bool isEnable, gchar *apn_type)
{
    RLOGD("send: %s, %s", (isEnable ? "TRUE": "FALSE"), apn_type);
    g_dbus_proxy_call(proxy,
            "enableData",
            g_variant_new("(bs)", isEnable, apn_type),
            G_DBUS_CALL_FLAGS_NONE,
            -1,
            NULL,
            (GAsyncReadyCallback) proxy_method_cb,
            NULL);
    return 1;
}

void modifyApnDB_method_cb (GDBusProxy   *proxy,
                                      GAsyncResult *res,
                                      gpointer      user_data)
{
    RLOGD("method call back");
    GError *error;
    GVariant *result;
    gchar* reason = NULL;

    error = NULL;
    result = g_dbus_proxy_call_finish(proxy, res, &error);

    if(error != NULL)
    {
        RLOGD("method call back error %s", error->message);
        printf("modify apn db error: %s\n", error->message);
        g_error_free(error);
        return;
    }
    //reason = const_cast<gchar*>(g_variant_dup_string(result, NULL));
    g_variant_get (result, "(&s)", &reason);
    RLOGD("modifyApnDB_method_cb reason %s", ((reason == NULL)? "":reason));
    printf("modify apn db success, return message: %s\n", ((reason == NULL)? "":reason));
    //printf("modifyApnDB_method_cb reason %s\n", ((reason == NULL)? "":reason));
    g_variant_unref(result);
}

int modifyApnDB(int cmd, gchar *record) {
    RLOGD("%s: cmd: %d, record:%s", __FUNCTION__, cmd, record);
    g_dbus_proxy_call(proxy,
            "modifyApnDB",
            g_variant_new("(is)", cmd, record),
            G_DBUS_CALL_FLAGS_NONE,
            -1,
            NULL,
            (GAsyncReadyCallback) modifyApnDB_method_cb,
            NULL);
    return 1;
}

void resetApnDB_method_cb (GDBusProxy   *proxy,
                                      GAsyncResult *res,
                                      gpointer      user_data)
{
    RLOGD("resetApnDB_method_cb call back");
    GError *error;
    GVariant *result;
    gchar* reason = NULL;

    error = NULL;
    result = g_dbus_proxy_call_finish(proxy, res, &error);

    if(error != NULL)
    {
        RLOGD("method call back error %s", error->message);
        printf("reset apn DB error: %s\n", error->message);
        g_error_free(error);
        return;
    }
    g_variant_get (result, "(&s)", &reason);
    //reason = const_cast<gchar*>(g_variant_dup_string(result, NULL));
    RLOGD("resetApnDB_method_cb reason %s", ((reason == NULL)? "":reason));
    printf("reset apn DB success, return message: %s\n", ((reason == NULL)? "":reason));
    //printf("resetApnDB_method_cb reason %s\n", ((reason == NULL)? "":reason));
    g_variant_unref(result);
}

int resetApnDB() {
    RLOGD("%s", __FUNCTION__);
    g_dbus_proxy_call(proxy,
            "resetApnDB",NULL,
            G_DBUS_CALL_FLAGS_NONE,
            -1,
            NULL,
            (GAsyncReadyCallback) resetApnDB_method_cb,
            NULL);
    return 1;
}

void proxy_signals_on_signal (GDBusProxy  *proxy,
                              const gchar *sender_name,
                              const gchar *signal_name,
                              GVariant    *parameters,
                              gpointer     user_data)
{
    RLOGD("signal_name: %s", signal_name);
    printf("signal_name: %s\n", signal_name);
    freeMem(urc_response);
    parse(parameters, &urc_response);
    dumpResponse(&urc_response);
    if(g_strcmp0(signal_name, "lynq_data_resp") == 0)
    {
        printf("[lynq_data_resp]do something\n");
        return;
    }
    lynq_data_management(&urc_response);
    if(g_strcmp0(signal_name, "LYNQ_TEST") == 0)
    {
        printf("do something\n");
    }
    if(g_strcmp0(signal_name, "default") == 0)
    {
        if(urc_response.pdnState == RIL_Data_Call_PdnState::PDN_DISCONNECTED) {
            notifyDataSignal();
        }
    }
    return;

}

void proxy_ready(GObject *source, GAsyncResult *result, gpointer user_data) {
    GError *error;

    error = NULL;
    proxy = g_dbus_proxy_new_for_bus_finish(result, &error);
    if (proxy == NULL) {
        RLOGE("create proxy fail");
        return ;
    }
    RLOGD("proxy is ready");
    gulong signal_handler_id;

    signal_handler_id = g_signal_connect(proxy, "g-signal",
            G_CALLBACK (proxy_signals_on_signal), NULL);
    if (signal_handler_id == 0) {
        RLOGE("listen singal fail!");
    }
}

void* init_data_gdbus_cb(void *param)
{
    /* all the tests rely on a shared main loop */
    loop = g_main_loop_new(NULL, FALSE);

    g_dbus_proxy_new_for_bus(G_BUS_TYPE_SYSTEM,
            G_DBUS_PROXY_FLAGS_NONE,
            NULL, /* GDBusInterfaceInfo */
            TELEPHONY_SERVICE, /* name */
            TELEPHONY_DATA_PATH, /* object path */
            TELEPHONY_DATA_INTERFACE, /* interface */
            NULL, /* GCancellable */
            proxy_ready,
            NULL);

    g_main_loop_run(loop);

    RLOGD("data gdbus main loop run()");
    if(proxy != NULL) {
        g_object_unref (proxy);
    }
    if(loop != NULL) {
        g_main_loop_unref(loop);
    }
}

