/*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*
  LINUX ZTE LOG MODULE

  GENERAL DESCRIPTION
  print the log to the log file
 *====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*/

 /*===========================================================================
  INCLUDES
  ===========================================================================*/
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <pthread.h>
#include <sys/stat.h>
#include <unistd.h> 

#include "libzte_log.h"

#include "softap_api.h"
/*===========================================================================
  DATA
  ===========================================================================*/
char para_buf[MAX_PARA_BUF]= {0};
char log_buf[MAX_LOG_BUF]= {0};
static int log_switch = 0;
const off_t log_max_size = 2 * 1024 * 1024;

pthread_mutex_t A_SmsMutexForLog;
static int iSymbol = -1;
/*===========================================================================
  FUNCTIONS
  ===========================================================================*/
void zte_msg_print(const char *source_file,const unsigned int line,const char *fmt,...)
{
    va_list arg = {0};

    if(NULL == source_file || NULL == fmt)
    {
        return ;
    }
    va_start(arg,fmt);
    vsprintf(para_buf,fmt,arg);
    va_end(arg);

    printf("%s in FILE :%s,LINE :%d\n",para_buf,source_file,line);
}

extern int slog(char *mod, int prio, const char *fmt, ...);

extern char *get_local_date_time(void);
void zte_log_append(const char *source_file,const unsigned int line,
                    const char *log_file,const char *fmt,...)
{
    //printf("[ccapp]:");
    //printf(fmt);
   // printf("\n");
    //slog("[ccapp]", 4, fmt);

//if(access("/usr/ccapp_log_printf", F_OK)>=0)
{
	va_list arg = {0};
	char log_buf[1024]= {0};

	if(NULL == source_file || NULL == fmt)
	{
		return ;
	}
	va_start(arg,fmt);
	vsprintf(log_buf,fmt,arg);
	va_end(arg);

	printf("%s %s %d %s\n",get_local_date_time(),source_file,line,log_buf);
	return;
}
#if 0
else if(access("/usr/ccapp_log_file", F_OK)>=0)
{
    char nv_buf[NV_LOG_BUF_LEN]= {0};
    char log_path[256]={0};
    va_list arg;
    int nv_status ;
    int fd;
    time_t clock;
    char time_buf[64]={0};
  
	char log_path_old[300]={0};
    struct stat statbuf;
	
	if(-1 == iSymbol)
	{
		pthread_mutex_init(&A_SmsMutexForLog, NULL);
		iSymbol = 0;
	}
   
	pthread_mutex_lock(&A_SmsMutexForLog);
    
#if 0
    if(0 == access("/data/zte_apps_data/log_enable.flg",F_OK))
    {
        return;
    }
#endif
    if(NULL == source_file || NULL == fmt || NULL == log_file)
    {
    	pthread_mutex_unlock(&A_SmsMutexForLog);
        return ;
    }
    va_start(arg,fmt);
    vsprintf(para_buf,fmt,arg);
    va_end(arg);
#if 0
    sprintf(log_buf,"%s[` basename %s` %d H]   '%s' %s%s%s","echo ",\
            source_file,line,para_buf,OP_APPEND,LOG_DIR_PATH,log_file);
    soft_system(log_buf);
#endif

#if 1
    time(&clock);
    sprintf(time_buf, "%s", ctime(&clock));
    //set the final \n to \0
    time_buf[strlen(time_buf)-1] = 0;
    sprintf(log_path, "%s%s", LOG_DIR_PATH, log_file);
    sprintf(log_buf,"%s %s %d %s\n", time_buf, source_file, line, para_buf);
	
	if(0 == access(log_path, 0))
	{
		if (0 == stat(log_path, &statbuf)) {//cov m
			if(statbuf.st_size > log_max_size)
			{
				sprintf(log_path_old, "%s%s_old", LOG_DIR_PATH, log_file);       
				if (0 == remove(log_path_old)) {
					if (rename(log_path, log_path_old) != 0) {//cov m
						printf("rename zte_log_append err\n");
					}
				}
			}
		}
	}
	
    if((fd=open(log_path, O_CREAT|O_WRONLY|O_APPEND, 0666))<0)//cov m
    {
        printf("can not open log: %s!\n", log_path);
		pthread_mutex_unlock(&A_SmsMutexForLog);
        return ;
    }
    write(fd, log_buf, strlen(log_buf));
    close(fd);


    
#endif
    //printf("%s\n",para_buf);
	pthread_mutex_unlock(&A_SmsMutexForLog);
    return ;
}
#endif
}
void zte_system_call(const char *fmt,...)
{
    va_list arg = {0};

    va_start(arg,fmt);
    vsprintf(para_buf,fmt,arg);
    va_end(arg);
    soft_system(para_buf);
}
