#include	"wsIntrn.h"

static sym_fd_t	formSymtab = -1;

void websHeader(webs_t wp)
{
	a_assert(websValid(wp));

	websWrite(wp, T("HTTP/1.0 200 OK\n"));

	websWrite(wp, T("Server: %s\r\n"), WEBS_NAME);
#ifdef WEBINSPECT_FIX
	websWrite(wp, T("X-Frame-Options: SAMEORIGIN\n"));
#endif	
	websWrite(wp, T("Pragma: no-cache\n"));
	websWrite(wp, T("Cache-control: no-cache\n"));
	websWrite(wp, T("Content-Type: text/html\n"));
	websWrite(wp, T("\n"));
	websWrite(wp, T("<html>\n"));
}


int websFormDefine(char_t *name, void (*fn)(webs_t wp, char_t *path, 
	char_t *query))
{
	a_assert(name && *name);
	a_assert(fn);

	if (fn == NULL) {
		return -1;
	}

	symEnter(formSymtab, name, valueInteger((int) fn), (int) NULL);
	return 0;
}

void websFooter(webs_t wp)
{
	a_assert(websValid(wp));

	websWrite(wp, T("</html>\n"));
}

int websFormHandler(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg, 
	char_t *url, char_t *path, char_t *query)
{	
	char_t		form_buf[FNAMESIZE];
	char_t		*cp, *form_name;
	sym_t		*sp;
	int			(*fn)(void *sock, char_t *path, char_t *args);

	a_assert(websValid(wp));
	a_assert(url && *url);
	a_assert(path && *path == '/');

	websStats.formHits++;
#ifdef WEBS_SECURITY
	if (strstr(query,"_method")) {
		printf("websFH: qry=%s\n",query);
		websError(wp, 405, T(""));
		return 1;
	}
#endif

	gstrncpy(form_buf, path, TSZ(form_buf)-1);
	if ((form_name = gstrchr(&form_buf[1], '/')) == NULL) {
		websError(wp, 200, T("Missing form name"));
		return 1;
	}
	form_name++;
	if ((cp = gstrchr(form_name, '/')) != NULL) {
		*cp = '\0';
	}

	sp = symLookup(formSymtab, form_name);
	if (sp == NULL) {
#ifdef WEBINSPECT_FIX
		websDone(wp, 0);
#else
		websError(wp, 200, T("Form %s is not defined"), form_name);
#endif		
	} else {
		fn = (int (*)(void *, char_t *, char_t *)) sp->content.value.integer;
		a_assert(fn);
		if (fn) {
			(*fn)((void*) wp, form_name, query);
		}
	}
	return 1;
}


void websFormClose()
{
	if (formSymtab != -1) {
		symClose(formSymtab);
		formSymtab = -1;
	}
}


void websFormOpen()
{
	formSymtab = symOpen(WEBS_SYM_INIT);
}


