/**
* @File: codec_res_ctrl.c
* @Brief: Implementation of Device Manager in Sanechips
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @Author:
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
* */

/*******************************************************************************
 *                          ͷļ                                       *
 ******************************************************************************/
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <stdio.h>
#include <unistd.h>
#include "cfg_nv_def.h"
#include "message.h"
#include <errno.h>
#include <stdlib.h>
#include "softap_api.h"

/*******************************************************************************
 *                             궨                                         *
 ******************************************************************************/
#define  INVALID_TYPE  0XFF


/*******************************************************************************
 *                             Ͷ                                    *
 ******************************************************************************/
/*ڼ¼ǰƽ̨дڵҵԹIDLE_AUDIO_INFO֪ͨ,һģIDжtypeһtypeֻһģID */
typedef struct audio_type_list
{
    struct audio_type_list *next;
    int type;      //ҵ
    int src_id;    //ԴģIDҪע˵ģIDμT_Module_IDֵ
    int tempSrcId; //ʱģID ҵӿڶʹ
} T_exist_applist;

/*******************************************************************************
 *                             ̬                                    *
 ******************************************************************************/
static int  using_type = 0XFF;     //ָʾǰʹõҵ
static int  releasing_type = 0XFF; //ָʾǰڱҪͷԴҵ̬ͣ

static T_exist_applist  *exist_apphead = NULL;

/*******************************************************************************
 *                            ڲ                                     *
 ******************************************************************************/
/**
 * ƣregister_exist_app
 * Ϣ壬Ǽǵǰƽ̨ʹAUDIOҵ
 * ˵msg
 *   ֵ
 * ˵
 */
static void  register_exist_app(MSG_BUF *msg)
{
    T_audio_UseReq *req_data = (T_audio_UseReq *)(msg->aucDataBuf);
    T_exist_applist  *tmp = exist_apphead;
    T_exist_applist  *node = NULL;
/* kw 3
    if(!req_data)
        softap_assert("param is null \n");
*/
    while (tmp != NULL)
    {
        if (tmp->src_id == req_data->moduleId && tmp->type == req_data->type)
        {
            tmp->tempSrcId = req_data->tempModuleId;   //temp Id
            return;
        }
        tmp = tmp->next;
    }
    node = (T_exist_applist *)malloc(sizeof(T_exist_applist));
    if (!node)
    {
        softap_assert("malloc node fail");
        return;
    }
    memset(node, 0, sizeof(T_exist_applist));
    node->tempSrcId = req_data->tempModuleId;
    node->src_id = req_data->moduleId;
    node->type = req_data->type;

    if (NULL == exist_apphead)
    {
        exist_apphead = node;
    }
    else
    {
        node->next = exist_apphead;
        exist_apphead = node;
    }
}

/**
 * ƣfind_module_by_type
 * ҵͲģID
 * ˵
 *   ֵ
 * ˵
 */
static int  find_module_by_type(int type)
{
    T_exist_applist  *tmp = exist_apphead;

    while (tmp != NULL)
    {
        if (tmp->type == type)
            return tmp->src_id;
        tmp = tmp->next;
    }
    softap_assert("finding module error now \n");
    return -1;
}

static int find_module_temp_by_type(int type)
{
    T_exist_applist  *tmp = exist_apphead;

    while (tmp != NULL)
    {
        if (tmp->type == type)
            return tmp->tempSrcId;
        tmp = tmp->next;
    }
    softap_assert("finding temp module error now\n");
    return -1;
}

/**
 * ƣcompare_type_priority
 * ҵȼȽϣԾ˭ʹaudio
 * ˵src, dst Ƚϵҵ
 *   ֵ1ʾdstȼsrc
 * ˵
 */
static int compare_type_priority(int src, int dst)
{
    char priority_nv[100] = {0};
    char  src_str[4] = {0};
    char  dst_str[4] = {0};
    char *src_diff = NULL;
    char *dst_diff = NULL;

    slog(RTC_PRINT, SLOG_NORMAL, "%s: LINE(%d),compare_type_priority: rc-type(%d), dst-type(%d)\n", __FILE__, __LINE__, src, dst);
    if (src == dst)
	{
        //softap_assert("have common priority now");
		return 0;
	}

    /* 绰ȼߣһ  */
    if (dst == VOICE_23G || dst == VOICE_VOLTE)
        return 1;

#if 1  // for debug 
    /*%s,%s,%sʽǰȼΪߣֵοaudio_type궨 */
    sc_cfg_get("audio_priority", priority_nv, sizeof(priority_nv));
    snprintf(src_str, 3, "%d", src);
    snprintf(dst_str, 3, "%d", dst);

    src_diff = strstr(priority_nv, src_str);
    dst_diff = strstr(priority_nv, dst_str);
    if (src_diff == NULL || dst_diff == NULL)
        softap_assert("can not find type now ");
    if (src_diff < dst_diff)
        return 0;
    else
        return  1;
#else
    return 1;
#endif
}

/**
 * ƣproc_use_req
 * ҵaudioʹaudioԴ
 * ˵msg Ϣṹ
 *   ֵ
 * ˵
 */
static void  proc_use_req(MSG_BUF *msg)
{
    int src_id = 0;
    T_audio_UseRsp  use_rsp_data = {0};
    T_audio_RelReq  rel_req_data = {0};
    T_audio_UseReq *use_req_data = (T_audio_UseReq *)(msg->aucDataBuf);
    register_exist_app(msg);

    slog(RTC_PRINT, SLOG_NORMAL, "%s:%s: LINE(%d),moduleId(%x), type(%d), using_type(%d),releasing_type(%d)\n", __FILE__, __FUNCTION__, __LINE__, use_req_data->moduleId, use_req_data->type, using_type, releasing_type);
    /* ǰڿ̬, ظɹ */
    if (using_type == INVALID_TYPE)
    {
        using_type = use_req_data->type;
        use_rsp_data.result = 0;
        use_rsp_data.type = use_req_data->type;
        use_rsp_data.using_type = use_req_data->type;
        if (0 > platform_send_msg(MODULE_ID_CODEC, use_req_data->tempModuleId, USE_AUDIO_RSP, sizeof(T_audio_UseRsp), (unsigned char *)&use_rsp_data))
            slog(RTC_PRINT, SLOG_NORMAL, "proc_use_req function: send USE_AUDIO_RSP  msg error ");
    }
    /* ǰеȼʹã֪ͨԷͷź󷽿ʹ */
    else if (compare_type_priority(using_type, use_req_data->type))
    {
        /* ͷʹȨҵ֪ͨʹҵͷ */
        if (releasing_type == INVALID_TYPE)
        {
            releasing_type = using_type;
            //rel_req_data.using_type = using_type;
            rel_req_data.using_type = use_req_data->type;
            rel_req_data.mouleId = use_req_data->moduleId;
            src_id = find_module_by_type(using_type);
            if (0 > platform_send_msg(MODULE_ID_CODEC, src_id, REL_AUDIO_REQ, sizeof(T_audio_RelReq), (unsigned char *)&rel_req_data))
                slog(RTC_PRINT, SLOG_NORMAL, "proc_use_req function: send REL_AUDIO_REQ  msg error ");
            using_type = use_req_data->type;
        }
        /*ǰڽͷ˲̬̣֪ͨмȼʹȨʧ*/
        else
        {
            /*ظ׼ʹԴҵиȼҵҪʹ*/
            use_rsp_data.result = 1;
            use_rsp_data.type = using_type;
            use_rsp_data.using_type = use_req_data->type;
            src_id = find_module_temp_by_type(using_type);
            if (0 > platform_send_msg(MODULE_ID_CODEC, src_id, USE_AUDIO_RSP, sizeof(T_audio_UseRsp), (unsigned char *)&use_rsp_data))
                softap_assert("proc_use_req function: send USE_AUDIO_RSP  msg error ");
            /*ǰҵΪȼҵ񣬵ȴREL_AUDIO_INDϢ*/
            using_type = use_req_data->type;
        }
    }
    /*ҵȼʹõȼظʧ*/
    else
    {
        use_rsp_data.result = 1;
        use_rsp_data.type = use_req_data->type;
        use_rsp_data.using_type = using_type;
        //src_id = find_module_by_type(use_req_data->type);  /*͸ҵģ*/
        if (0 > platform_send_msg(MODULE_ID_CODEC, use_req_data->tempModuleId, USE_AUDIO_RSP, sizeof(T_audio_UseRsp), (unsigned char *)&use_rsp_data))
            softap_assert("proc_use_req function: send USE_AUDIO_RSP  msg error ");
    }

    slog(RTC_PRINT, SLOG_NORMAL, "%s:%s: LINE(%d),moduleId(%x), type(%d), using_type(%d),releasing_type(%d)\n", __FILE__, __FUNCTION__, __LINE__, use_req_data->moduleId, use_req_data->type, using_type, releasing_type);
}

/**
 * ƣproc_rel_rsp
 * ҵģͷָʾȼĽͷź֪ͨͷ
 * ˵msg ͷŵϢṹ
 *   ֵ
 * ˵
 */
static void  proc_rel_rsp(MSG_BUF *msg)
{
    T_audio_UseRsp  use_rsp_data = {0};
    T_audio_RelInd  *rel_ind_data = NULL;
    int srcId = -1;

    rel_ind_data = (T_audio_RelInd*)(msg->aucDataBuf);
    if (rel_ind_data->result == 1)
        softap_assert("release fail now, can not happen");

    slog(RTC_PRINT, SLOG_NORMAL, "%s:%s: LINE(%d), moduleId(%x), type(%x), using_type(%d), releasing_type(%d)\n",  __FILE__, __FUNCTION__, __LINE__, rel_ind_data->moduleId, rel_ind_data->type, using_type, releasing_type);
    /*
     *ǰûмʹõҵ㲥ǰиעҵģ,
     *ҵӦñͣյϢʱǽӦõĻָ
     */
    if (using_type == INVALID_TYPE)
    {
        releasing_type = INVALID_TYPE;
        T_exist_applist  *tmp = exist_apphead;
        while (tmp != NULL)
        {
            /*
             *͹㲥пϢĵҵģ飬1ԱӦýٴ,
             *  2ҪָͣҵӦ
             */
            if (0 > platform_send_msg(MODULE_ID_CODEC, tmp->src_id, IDLE_AUDIO_INFO, sizeof(T_audio_RelInd), (unsigned char *)rel_ind_data))
                slog(RTC_PRINT, SLOG_NORMAL, "%s:%s: LINE(%d),send MODULE_ID_CODEC msg error, dest moduleId(%d)\n", __FILE__, __FUNCTION__, __LINE__, tmp->src_id);
            tmp = tmp->next;
        }
    }
    else
    {
        /*ȼͷųɹ֪ͨȼɹ */
        if (releasing_type == rel_ind_data->type)
        {
            use_rsp_data.result = 0;
            use_rsp_data.type = using_type;
            use_rsp_data.using_type = using_type;
            srcId = find_module_temp_by_type(using_type);
            if (0 > platform_send_msg(MODULE_ID_CODEC, srcId, USE_AUDIO_RSP, sizeof(T_audio_UseRsp), (unsigned char *)&use_rsp_data))
                softap_assert("proc_rel_rsp function: send USE_AUDIO_RSP msg error\n");
            releasing_type = INVALID_TYPE;
        }
        /*1ȼδɹʱͷָʾղ绰Ҷ
         *2ûȼPK, Ӧͷ
         */
        else if (using_type == rel_ind_data->type)
        {
#if 0
            {
                use_rsp_data.result = 0;
                use_rsp_data.type = using_type;
                use_rsp_data.using_type = using_type;
                srcId = find_module_temp_by_type(using_type);
                if (0 > platform_send_msg(MODULE_ID_CODEC, srcId, USE_AUDIO_RSP, sizeof(T_audio_UseRsp), (unsigned char *)&use_rsp_data))
                    softap_assert("proc_rel_rsp function: send USE_AUDIO_RSP msg error\n");
            }
#endif
            using_type = INVALID_TYPE;
            releasing_type = INVALID_TYPE;
            T_exist_applist  *tmp = exist_apphead;
            while (tmp != NULL)
            {
                if (0 > platform_send_msg(MODULE_ID_CODEC, tmp->src_id, IDLE_AUDIO_INFO, sizeof(T_audio_RelInd), (unsigned char *)rel_ind_data))
                    slog(RTC_PRINT, SLOG_NORMAL, "%s:%s: LINE(%d) proc_rel_rsp function: send IDLE_AUDIO_INFO msg error dest moduleId(%d)\n", __FILE__, __FUNCTION__, __LINE__, tmp->src_id);
                tmp = tmp->next;
            }
        }
        /*ûȨҵͷſȨϢʱԼ״̬쳣ҵģ*/
        else if (releasing_type != INVALID_TYPE)
            softap_assert("release resource error: using_type(%d), relesasing_type(%d), rel_ind_data->type(%d)", using_type, releasing_type, rel_ind_data->type);
    }

    slog(RTC_PRINT, SLOG_NORMAL, "%s:%s: LINE(%d), moduleId(%x), type(%x), using_type(%d), releasing_type(%d)\n",  __FILE__, __FUNCTION__, __LINE__, rel_ind_data->moduleId, rel_ind_data->type, using_type, releasing_type);
}

static void  unregister_exist_app(int moduleId, int type)
{
	T_exist_applist  *tmp = NULL;
	T_exist_applist  *node = exist_apphead;

	slog(RTC_PRINT, SLOG_NORMAL, "unregister_exist_app: moduleId(%x) type(%d) \n", moduleId, type);

	while (node != NULL)
    {
        if (node->tempSrcId == moduleId && node->type == type)
        {
        	if(NULL != tmp)
        	{
        		tmp->next = node->next;	
        	}
			else
			{
				exist_apphead = node->next;
			}
            free(node);
			slog(RTC_PRINT, SLOG_NORMAL, "unregister_exist_app: %d moduleId(%x) type(%d) \n", __LINE__,moduleId, type);
            return;
        }
		tmp = node;
        node = node->next;
    }
}
static void  unregister_exist_app_proc(MSG_BUF *msg)
{
	T_audio_ExitInd *exitIndData = (T_audio_ExitInd*)(msg->aucDataBuf);
	unregister_exist_app(exitIndData->moduleId, exitIndData->type);
	if(EXIT_AUDIO_REQ == msg->usMsgCmd) {
		if (0 > platform_send_msg(MODULE_ID_CODEC, exitIndData->moduleId, EXIT_AUDIO_RSP, 0, NULL))
			softap_assert("unregister_exist_app_proc function: send USE_AUDIO_RSP msg error\n");
    }
}

/*******************************************************************************
 *                             ȫֺ                                   *
 ******************************************************************************/
/**
 * ƣmain
 * audioģں
 * ˵
 *   ֵ
 * ˵
 */
int zte_audio_res_ctrl_main(void)
{
    MSG_BUF msg = {0};
    int msgfd = 0;
    int ret = 0;
    prctl(PR_SET_NAME, "audio_ctrl", 0, 0, 0);

    /*NVʼӡ𣬲עᶯ̬ӡź*/
    loglevel_init();

    /* Ϣ*/
    slog(RTC_PRINT, SLOG_NORMAL, "audio res-ctrl starting now ...\n");
    if (0 > (msgfd = msgget(MODULE_ID_CODEC, IPC_CREAT | 0600))) {
        softap_assert("Create msg queue Error: %s", strerror(errno));
		return -1; //kw 3
	}

    while (1)
    {
        memset(&msg, 0x00, sizeof(MSG_BUF));

        /* ȡϢϢ */
        if (0 > (ret = msgrcv(msgfd, &msg, sizeof(MSG_BUF) - sizeof(long), 0, 0)))
        {
            //softap_assert("Recv msg Error: %s", strerror(errno));
            slog(RTC_PRINT, SLOG_ERR, "%s: %s: LINE(%d) : audio res-ctrl Recv msg Error: %s\n", __FILE__, __FUNCTION__, __LINE__, strerror(errno));
            continue;
        }

        slog(RTC_PRINT, SLOG_NORMAL, "%s: %s: LINE(%d) : audio res-ctrl msg info : msgId(%d), srcId(%x), dstId(%x), using_type(%d),releasing_type(%d)\n", __FILE__, __FUNCTION__, __LINE__, msg.usMsgCmd, msg.src_id, msg.dst_id, using_type, releasing_type);

        switch (msg.usMsgCmd)
        {
        case USE_AUDIO_REQ:
            if (msg.src_id == 0)
            {
                slog(RTC_PRINT, SLOG_ERR, "request src id error now\n");
            }
            else
                proc_use_req(&msg);
            break;

        case REL_AUDIO_IND:
            if (msg.src_id == 0)
            {
                slog(RTC_PRINT, SLOG_ERR, "release src id error now\n");
            }
            else
                proc_rel_rsp(&msg);
            break;

		case EXIT_AUDIO_IND:
		case EXIT_AUDIO_REQ:
			unregister_exist_app_proc(&msg);
			break;
        default:
            slog(RTC_PRINT, SLOG_NORMAL, "%s: %s LINE(%d) other msg: MsgCmd(%d), srcId(%d), dstId(%d)\n", __FILE__, __FUNCTION__, __LINE__, msg.usMsgCmd, msg.src_id, msg.dst_id);
            break;
        }
    }
}
