#ifndef __ZCTRM_LOCKNET_H__
#define __ZCTRM_LOCKNET_H__

#include "at_context.h"
#include <sys/ioctl.h>
#include "libcpnv.h"
#include "RONvConfig.h"

#define EFUSE_IOC_MAGIC     'E'

#define EFUSE_GET_DATA			_IOWR(EFUSE_IOC_MAGIC, 1, char *)


#define LOCKNET_KEY_LEN 16
#define ZCTRM_LOCKNET_AT_LEN 64
#define KEY_LEN 128

#define IDENTIFIER_GID1 28478
#define IDENTIFIER_GID2 28479

#define LOCKNET_ITEM_NUM 6
#define LOCKNET_FIRST_NUM 42
#define LOCKNET_MAX_NUM 50
#define LOCKNET_MAX_AT_LEN 560

#define EXT_SUCCESS   0
#define EXT_ERROR   -1

// 2 Bytes
#define USED_GID_LEN 4
#define MAX_AMT_AT_LEN 1024
#define MAX_RETRY_TIMES 10
#define LIST_MCCMNC_LEN 4
#define LIST_IMSI_LEN 2
#define LIST_GID_LEN 256
#define LIST_LEN (LIST_MCCMNC_LEN*2+LIST_IMSI_LEN*2+LIST_GID_LEN*2)
#define MAX_IMSI_LEN 32
#define AT_STR_LEN 64
//lock state
#define AMT_LOCKNET_BASE OS_FLASH_ROW_OFFSET_FROM_NV//0x000D0000
#define AMT_LOCKNET_TIMES (AMT_LOCKNET_BASE + 0x40)
#define AMT_LOCKNET_KEY (AMT_LOCKNET_BASE + 0x80)
#define AMT_LOCKNET_USRKEY (AMT_LOCKNET_BASE + 0x100)
#define AMT_LOCKNET_SIGN (AMT_LOCKNET_BASE + 0x120)
#define AMT_LOCKNET_LIST (AMT_LOCKNET_BASE + 0x1A0)

/*ݽṹ*/
typedef struct
{
	unsigned int pubKeyRsaE[32];
	unsigned int pubKeyRsaN[32];
	unsigned int secureFlag;
	unsigned int pubKeyHash[4];
	unsigned int secureDevId[3];
}T_ZDrvEfuse_Secure;


typedef enum
{
    ENCRYPT_INITING = 0,
    ENCRYPT_ERROR, 
    ENCRYPT_LOCK,
    ENCRYPT_UNLOCK_CORRECT,
}T_zAt_SecStatue;

typedef struct
{
    UINT8 mcc[LIST_MCCMNC_LEN]; 
    UINT8 mnc[LIST_MCCMNC_LEN]; 
    UINT8 imsi6[LIST_IMSI_LEN]; 
    UINT8 imsi7[LIST_IMSI_LEN]; 
    UINT8 gid1[LIST_GID_LEN]; 
    UINT8 gid2[LIST_GID_LEN]; 
}T_zCtrm_LockListPara;

typedef struct
{
	UINT8  cmd[2];
    UINT8  code[32];
} T_zAt_LockListAuthRes;

typedef enum
{
    PARA_MCC = 0,    
	PARA_MNC,
	PARA_IMSI6,
	PARA_IMSI7,
    PARA_GID1,
    PARA_GID2,
}T_zCtrm_LockPara;


typedef enum
{
    LOCKFLAG_ERROR = 0,    
	ALREADY_UNLOCKED,
	LOCKED,
	NEVER_LOCKED = 0xFFFFFFFF,
}T_zCtrm_LockLevel;

typedef enum
{
    NO_ACTION = 0,    
    NET_LOCK, 
    SIM_LOCK, 
    NET_SIM_LOCK, 
    
}T_zCtrm_SecItems;

typedef enum
{
    RESULT_ERROR = 0,//
    RESULT_LOCKED,//
    RESULT_UNLOCKED,//
}T_zCtrm_RESULT;

typedef enum
{
    READ_ERROR=0,
    LOCKKEY_ISNULL,
    READ_SUCCESS,
}T_zCtrm_ReadResult;


typedef struct
{
    UINT16 cardMode;
    UINT16 mncLen;
    UINT32 fileLen;
    UINT8 simImsi[MAX_IMSI_LEN];
}T_zCtrm_SIMPara;

typedef enum
{
    CARDMODE_UNKNOW = 0,
    CARDMODE_SIM,
    CARDMODE_USIM,
}T_zCtrm_SimType;

typedef enum
{
    GET_NONE = 0,
    GET_GID1LEN,
    GET_GID1,
    GET_GID2LEN,
    GET_GID2,
    GET_MNCLEN
}T_zCtrm_CrsmReq;

/**
 * @brief ӦϢͨýṹ壬ӦϢMSG_CMD_LOCKNET_AUTH_RSP/MSG_CMD_LOCKNET_UNLOCK_RSP
 * @param result  AT_RSP_OK/AT_RSP_ERR
 * @param errcode Ȩʧܣش
 */
typedef struct
{
	int result;
	char errcode[8];
}AT_LOCKNET_RSP_INFO;

int zCtrm_LocknetAuthProc(MSG_BUF *msg);
int zCtrm_LocknetListSet(MSG_BUF *msg);
int zCtrm_LocknetKeyProc(MSG_BUF *msg);
int zCtrm_LocknetAmtStatus(MSG_BUF *msg);
int zCtrm_LocknetDigestGet(MSG_BUF *msg);
int zCtrm_LocknetSignSet(MSG_BUF *msg);
int zCtrm_LocknetLevel(MSG_BUF *msg);
int zCtrm_LocknetListGetProc(MSG_BUF *msg);
int zCtrm_makeLocknetAuth(MSG_BUF *msg);
int zCtrm_LocknetUnlockTimes(MSG_BUF *msg);
int zCtrm_LocknetStatus(MSG_BUF *msg);
int zCtrm_LocknetUnlock(MSG_BUF *msg);
int zCtrm_makeLocknetAuth(MSG_BUF *msg);
/*ⲿ,ӿ*/
extern void zDrvEfuse_GetSecureMsg(T_ZDrvEfuse_Secure *secure);

#endif
