
#include "headers.h"
#include "util.h"

/* -------------------------------------------------------------------
 * warn
 *
 * Prints message and return
 * ------------------------------------------------------------------- */

void warn(const char *inMessage, const char *inFile, int inLine)
{
	fflush(0);

//#ifdef NDEBUG
//    fprintf( stderr, "%s failed\n", inMessage );
//#else

	/* while debugging output file/line number also */
	fprintf(stderr, "%s failed (%s:%d)\n", inMessage, inFile, inLine);
//#endif
} /* end warn */

/* -------------------------------------------------------------------
 * warn_errno
 *
 * Prints message and errno message, and return.
 * ------------------------------------------------------------------- */

void warn_errno(const char *inMessage, const char *inFile, int inLine)
{
	int my_err;
	const char* my_str;

	/* get platform's errno and error message */
	my_err = errno;
	my_str = strerror(my_err);

	fflush(0);

//#ifdef NDEBUG
//    fprintf( stderr, "%s failed: %s\n", inMessage, my_str );
//#else

	/* while debugging output file/line number and errno value also */
	fprintf(stderr, "%s failed (%s:%d): %s (%d)\n",
	        inMessage, inFile, inLine, my_str, my_err);
//#endif
} /* end warn_errno */
