#ifndef SETTINGS_H
#define SETTINGS_H

#include "headers.h"

#include "socketHelper.h"

// server/client mode
typedef enum {
	zMode_Unknown = 0,
	zMode_Server,
	zMode_Client
} zMode_t;

// tcp/udp type
typedef enum {
	zType_Unknown = 0,
	zType_Tcp,
	zType_Udp
} sock_type_t;

typedef struct {
	int ip_type; // 0:ipv4,  1:ipv6

	char address_str[64];
	zping_sockaddr_t zping_sockaddr;

	int pingcount;
	int timeout;
	int interval;

	u_int16_t itemcount;// max item num, default is 10

	u_int32_t size; // packet data size

	int unstopped;
	int delayoutput;
	int lostoutput;

	int maxwaitnum;
	u_int16_t set_id;
} zping_settings_t;

#endif // SETTINGS_H
