
#ifndef UTIL_H
#define UTIL_H

void warn(const char *inMessage, const char *inFile, int inLine);
void warn_errno(const char *inMessage, const char *inFile, int inLine);

#define FAIL(cond, msg)             \
  do {                                          \
    if (cond) {                               \
      warn(msg, __FILE__, __LINE__);          \
      exit(1);                                \
    }                                           \
  } while(0)

#define FAIL_errno(cond, msg)       \
  do {                                          \
    if (cond) {                               \
      warn_errno(msg, __FILE__, __LINE__);    \
      exit(1);                                \
    }                                           \
  } while( 0 )

#define WARN( cond, msg )                       \
  do {                                          \
    if ( cond ) {                               \
      warn( msg, __FILE__, __LINE__ );          \
    }                                           \
  } while( 0 )

#define WARN_errno( cond, msg )                 \
  do {                                          \
    if ( cond ) {                               \
      warn_errno( msg, __FILE__, __LINE__ );    \
    }                                           \
  } while( 0 )

/* -------------------------------------------------------------------
 * delete macro
 * ------------------------------------------------------------------- */
/*
#define DELETE_PTR( ptr )                       \
 do {                                          \
   if ( ptr != NULL ) {                        \
     delete ptr;                               \
     ptr = NULL;                               \
   }                                           \
 } while( false )

#define DELETE_ARRAY( ptr )                     \
 do {                                          \
   if ( ptr != NULL ) {                        \
     delete [] ptr;                            \
     ptr = NULL;                               \
   }                                           \
 } while( false )
*/
#endif /* UTIL_H */
