#ifndef __ZPING_H__
#define __ZPING_H__

#include "headers.h"

typedef unsigned int u_int;

typedef signed char int8_t;
typedef unsigned char u_int8_t;
typedef signed short int16_t;
typedef unsigned short u_int16_t;
typedef signed int int32_t;
typedef unsigned int u_int32_t;
typedef signed long long int64_t;
typedef unsigned long long u_int64_t;

#define ZPING_EXCLUDE 0x01

#define DEFAULT_BUFFER_SIZE 1460

#define DEFAULT_BUFFER_COPY_TIMEOUT 3

typedef enum {
	//pcʹ÷Χ0~31
	LABEL_NULL = 0,

	CLINET_RECV,
	CLINET_SEND,
	SERVER_RECV,
	SERVER_SEND,

	//AP32ʼͬĺ˲òͬݶζ,32~63
	AP_USB_IN = 32,
	AP_USB_OUT,
	AP_PS_IN,
	AP_PS_OUT,
	AP_WIFI_WAN_IN,
	AP_WIFI_WAN_OUT,
	AP_WIFI_LAN_IN,
	AP_WIFI_LAN_OUT,
	AP_ETH_WAN_IN,
	AP_ETH_WAN_OUT,
	AP_ETH_LAN_IN,
	AP_ETH_LAN_OUT,
	AP_PS_EXT1_IN,
	AP_PS_EXT1_OUT,
	AP_PS_EXT2_IN,
	AP_PS_EXT2_OUT,
	AP_PS_EXT3_IN,
	AP_PS_EXT3_OUT,
	AP_PS_EXT4_IN,
	AP_PS_EXT4_OUT,

	//CP64ʼ.64~95
	CP_ETH1_IN = 64,
	CP_ETH1_OUT,
	CP_ETH2_IN,
	CP_ETH2_OUT,
	CP_ETH3_IN,
	CP_ETH3_OUT,
	CP_ETH4_IN,
	CP_ETH4_OUT,
	CP_PS1_IN,
	CP_PS1_OUT,
	CP_PS2_IN,
	CP_PS2_OUT,
	CP_PS3_IN,
	CP_PS3_OUT,
	CP_PS4_IN,
	CP_PS4_OUT,
	CP_CTRM1_IN,
	CP_CTRM1_OUT,
	CP_CTRM2_IN,
	CP_CTRM2_OUT,
	CP_CTRM3_IN,
	CP_CTRM3_OUT,
	CP_CTRM4_IN,
	CP_CTRM4_OUT,
} zping_label;

typedef struct {
	zping_label label;
	char name[32];
} zping_print_t;


#pragma pack(push)
#pragma pack(1)
typedef struct { // 4 bytes align
	u_int16_t id; // useless in this case, use id in the icmp header instead
	u_int16_t item_count;
	u_int16_t item_index;
	u_int16_t item_index_padding;
	u_int16_t flags;
	u_int16_t flags_padding;
} zping_hdr_t;

typedef struct { // 4 bytes align
	u_int16_t label;
	u_int16_t label_padding;

	u_int32_t secs;
	u_int32_t secs_padding;

	u_int32_t usecs;
	u_int32_t usecs_padding;

	u_int16_t last_seq;
	u_int16_t last_seq_padding;
} zping_item_t ;

typedef struct { // 4 bytes align
	u_int16_t label;
	u_int16_t label_padding;

	u_int16_t last_seq;
	u_int16_t last_seq_padding;
} zping_pktlost_item_t;
#pragma pack(pop)

#endif /* __ZPING_H__ */
