#include <linux/module.h>
#include <linux/errno.h>
#include <linux/proc_fs.h>
#include <linux/uaccess.h>
#include <linux/cdev.h>
#include <linux/cpnv.h>
#include <linux/vmalloc.h>
#include <linux/string.h>
#include <linux/cp_types.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/kthread.h>
#include <linux/device.h>

MODULE_AUTHOR("ZTE");
MODULE_LICENSE("Proprietary");

extern unsigned int zOss_ResetNVFactory(void);
extern unsigned int zOss_NvramFlush(void);
extern unsigned int zOss_NvItemWrite(unsigned int,unsigned char *,unsigned int);
extern int zDrvNand_Program(unsigned int,unsigned int,unsigned char *);
extern void zOss_NvItemWriteFactory(unsigned int,unsigned char *,unsigned int);
extern int zDrvNand_ChangeNvrAttr(unsigned int);
extern unsigned int zOss_NvItemRead(unsigned int,unsigned char *,unsigned int);
extern ssize_t zCatAgt_App_Write(const char *, size_t);
extern ssize_t zCatAgt_Kernel_Write(const char *, size_t);
extern void linux_oss_tick_timer_function(void);
extern unsigned int zOss_GetExceptResetFlag(void);
extern int zSys_ExceptReboot(unsigned int);
extern int zDrvRpMsg_Write(const void *);
extern int zDrvRpMsg_CreateChannel(unsigned int, unsigned int, unsigned int size);
extern int zDrvRpMsg_RegCallBack(unsigned int, unsigned int, void *);
extern int zAti_CidIsUsed(unsigned char);
//extern unsigned char *zGetpsbufferHead(unsigned char *);
extern int zAti2_Send(unsigned char , unsigned char *, unsigned short , unsigned int );
extern unsigned char zAti_GetDualCardStat(unsigned char *pbSim1Stat, unsigned char *pbSim2Stat, unsigned char *pbIsCardSwitching);
extern unsigned char *zPutSkb2Psbuf(unsigned char *, unsigned short, unsigned char *, unsigned char *);
extern unsigned short zGetUpLinkSduSize(void);
extern int zAti2_Open(unsigned char);
extern unsigned int zAt_AutoTestInit(void);
extern int zAti2_IsExCid(unsigned char,unsigned char *);
extern void zUsat_RegisterSendMsgFun(void *);
extern int zAti2_RegRecvCb(void *);
extern void zUsat_SendAtCmd(unsigned int, const unsigned char *, unsigned short, unsigned int);
extern void AmtAgent_ComposeAndProcess(unsigned char *, unsigned int);
extern void RegSendDataToAmtAppFunction(void *);
extern void zDrvLpm_IrqDisable(unsigned int);
extern void zDrvLpm_IrqEnable(unsigned int);
extern void zDrvInt_MaskIrq(unsigned int);
extern void zDrvInt_UnmaskIrq(unsigned int);
extern int zPs_IsTdMasterMode(void);
extern int zPs_IsLteMasterMode(void);
extern int zPs_IsFddMasterMode(void);
extern void psm_ModemDevSleep(void);
extern bool psm_ModemSleepCheck(void);
extern unsigned int psm_ModemSleepTimeGet(void);
extern void psm_GetModemSleepFlagStatus(void);
extern void psm_TimeCompensate(unsigned int);
extern void zFreeDlBuf(unsigned char *);
extern int zte_modem_start(void);
extern unsigned long Comm_Read_CP_TO_AP_Data(const char  *, unsigned long);
extern unsigned long Comm_Write_AP_TO_CP_Data(const char *, unsigned long);
extern int zDrvVoice_Close(void);
extern int zDrvVoice_ReadStart(void);
extern int zDrvVoice_ReadStop(void);
extern int zDrvVoice_WriteStart(void);
extern int zDrvVoice_WriteStop(void);
extern int zDrvVoice_Open(void *);
extern int zDrvVoice_WriteOneFrame(unsigned char *);
extern int zDrvVoice_ReadOneFrame(unsigned char *);
extern int halVoice_SetPathIn(void *);
extern int halVoice_SetPathOut(void *);
extern int halVoice_SetVolOut(void *);
extern int halVoice_Enable(void);
extern int halVoice_Open(void);
extern int halVoice_Disable(void);
extern int halVoice_Close(void);
extern int halVoice_Open3G(void);
extern int halVoice_Close3G(void);
extern int zDrv_Audio_Printf(void *, ...);
extern void zDrvVp_SetDtmfMute_Wrap(void);
extern int zDrvVp_SetTone_Wrap(int);
extern int zDrvVp_SetMute_Wrap(int);
extern int zDrvVp_GetMute_Wrap(void);
extern int zDrvVp_SetRxMute_Wrap(int );
extern int zDrvVp_GetRxMute_Wrap(void);
extern int zDrvVp_SetVol_Wrap(int);
extern int zDrvVp_GetVol_Wrap(void);
extern int zDrvVp_GetTxVol_Wrap(void);
extern int zDrvVp_SetTxVol_Wrap(int);
extern int zDrvVp_SetVol_Gain_Wrap(int);
extern int zDrvVp_GetVol_Gain_Wrap(void);
extern int zDrvVp_SetTxVol_Gain_Wrap(int);
extern int zDrvVp_GetTxVol_Gain_Wrap(void);
extern int zDrvVp_GetPath_Wrap(void);
extern int zDrvVp_Loop(int);
extern int zDrvVp_Soft_Dtmf_Loop(int);
extern void zDrvDtmf_Detect_RegCallbacks(T_DrvDtmf_Detect_Opt);
extern int zDrvVp_SetPath_Wrap(int);
extern int zDrvVp_GetPath_Wrap(void);
extern int  zDrvVp_GetSlicFlag(void);
extern int  zDrvVp_SetEchoDelay_Wrap(int val);
extern int  zDrvVp_GetEchoDelay_Wrap(void);
extern int  zDrvVp_SetTxNsMode_Wrap(int val);
extern int  zDrvVp_GetTxNsMode_Wrap(void);
extern int  zDrvVp_SetRxNsMode_Wrap(int val);
extern int  zDrvVp_GetRxNsMode_Wrap(void);
extern int  zDrvVp_SetModuleState_Wrap(int *,int);
extern int  zDrvVp_GetModuleState_Wrap(int *,int);
extern VOID*  mmp_AmrDecOpen  (T_zMmp_CodecType codecType);
extern VOID*  mmp_AmrEncOpen  (T_zMmp_CodecType codecType, BOOL isDtxEnable);
extern UINT16 mmp_AmrDecode   (VOID *pCodecContext, const UINT8 *pAmr, UINT16 *pPcm);
extern UINT16 mmp_AmrEncode   (VOID *pCodecContext, T_zMmp_AmrEncMode mode, const UINT16 *pPcm,  UINT8 *pAmr);
extern VOID   mmp_AmrDecClose (VOID *pCodecContext);
extern VOID   mmp_AmrEncClose (VOID *pCodecContext);
extern UINT8 zDrvEdcp_IsBusy(int EdcpNum);
extern SINT32 zDrvVp_AudioDataWrite(const VOID *pBuf, UINT32 uiLen);
extern SINT32 zDrvVp_AudioDataOpen(UINT32 audioType, UINT32 sampleRate);
extern SINT32 zDrvVp_AudioDataClose(void);
extern SINT32 zDrvVp_GetVpLoop_Wrap(VOID);
extern VOID zDrvVp_Status(UINT32 *sample_rate, UINT32 *voice_status);
extern VOID zDrvVp_UpdateVoiceNv(UINT8 *voice_nv_update);
extern int zDrvVp_SetVoiceProc_Wrap(int val);
extern int zDrvVp_GetVoiceProc_Wrap(void);
extern int zDrvVp_SetVoiceBuffer_Wrap(int en,int type);
extern void zDrvVp_GetVoiceBuffer_Wrap(int *en,int *type);




typedef struct cpko_section {
	unsigned int	cpko_text_start;
	unsigned int	cpko_rodata_start;
	unsigned int	__utran_modem_text_start;
	unsigned int	__lte_modem_text_start;
	unsigned int	__comm_modem_text_start;
	unsigned int	modem_text_end;
	unsigned int    cpko_data_start;
	unsigned int    cpko_bss_start;
	unsigned int    cpko_text_offset;
} cpko_section_layout;
cpko_section_layout cpko_ps_section;


int raise(int signo)
{
    return 0x00;
}

//__initdata DECLARE_COMPLETION(sysentry_done);

extern unsigned int SysEntry(void);
static int ko_Main_Thread(void * data)
{
	struct sched_param param = { .sched_priority =  MAX_USER_RT_PRIO/2 - 3 };
	int ret = 0;

	sched_setscheduler(current, SCHED_FIFO, &param);

	ret = SysEntry();
	if(ret != 0)
		panic("Main_Thread\n");

	param.sched_priority = MAX_USER_RT_PRIO - 46;
	sched_setscheduler(kthreadd_task, SCHED_FIFO, &param);

	return 0;
}

int zte_modem_ko_start(void)
{

	kthread_run(ko_Main_Thread, NULL, "ZTEMainThread");
	//wait_for_completion(&sysentry_done);

	return 0;
}
static void cpko_sectioninfo_set(void)
{
	int ret; 
	struct file *fp;
	mm_segment_t old_fs;
	loff_t cpko_pos = 0;
	struct cpps_globalModem globalVar;
	
	fp = filp_open("/lib/cpko/cpko_secinfo.bin", 0, 0);
	if(IS_ERR(fp) || fp == NULL)
		panic("open file error\n");

	old_fs = get_fs();
	set_fs(KERNEL_DS);
	ret = vfs_read(fp, (char*)&cpko_ps_section, sizeof(cpko_section_layout), &cpko_pos);
	if (ret <= 0)
		panic("read file error\n");
	filp_close(fp, NULL);

#ifdef CONFIG_MODEM_CODE_IS_MAPPING
	fp = filp_open("/lib/cpko/cpko.ko",0, 0);
	if(IS_ERR(fp) || fp == NULL)
		panic("open file error\n");
	fp->f_ra.ra_pages = 0;
#endif

	if (cpko_ps_section.cpko_text_start){
		globalVar.cpko_text_start = (unsigned long)cpko_ps_section.cpko_text_start;
		globalVar.cpko_rodata_start = (unsigned long)cpko_ps_section.cpko_rodata_start;
		globalVar.cpko_data_start = (unsigned long)cpko_ps_section.cpko_data_start;
		globalVar.cpko_bss_start = (unsigned long)cpko_ps_section.cpko_bss_start;


#ifdef CONFIG_MODEM_CODE_IS_MAPPING
		globalVar.fp_code = fp;
		globalVar.__utran_modem_text_start = (unsigned long)cpko_ps_section.__utran_modem_text_start;
		globalVar.__lte_modem_text_start = (unsigned long)cpko_ps_section.__lte_modem_text_start;
		globalVar.__comm_modem_text_start = (unsigned long)cpko_ps_section.__comm_modem_text_start;
		globalVar.modem_text_end = (unsigned long)cpko_ps_section.modem_text_end;
		globalVar.modem_offset = cpko_ps_section.cpko_text_offset;
#endif
		cpps_globalVar_register(&globalVar);

#ifdef CONFIG_MODEM_CODE_IS_MAPPING
		vfree_modem_section(globalVar.cpko_text_start, globalVar.modem_text_end);
#endif
	}
	else
		panic("file error\n");
}
static int cpko_start(void)
{
	struct cpps_callbacks callback = {0};

	//memset(&callback, 0 , sizeof(callback));

	callback.zOss_ResetNVFactory = zOss_ResetNVFactory;
	callback.zOss_NvramFlush = zOss_NvramFlush;
	callback.zOss_NvItemWrite = zOss_NvItemWrite;
	callback.zOss_NvItemWriteFactory = zOss_NvItemWriteFactory;
	callback.zOss_NvItemRead = zOss_NvItemRead;
	callback.zCatAgt_App_Write = zCatAgt_App_Write;
	callback.zCatAgt_Kernel_Write = zCatAgt_Kernel_Write;
	callback.linux_oss_tick_timer_function = linux_oss_tick_timer_function;
	callback.zOss_GetExceptResetFlag = zOss_GetExceptResetFlag;
	callback.zSys_ExceptReboot = zSys_ExceptReboot;
	callback.zDrvRpMsg_Write = zDrvRpMsg_Write;
	callback.zDrvRpMsg_CreateChannel = zDrvRpMsg_CreateChannel;
	callback.zDrvRpMsg_RegCallBack = zDrvRpMsg_RegCallBack;
	callback.zDrvLpm_IrqDisable = zDrvLpm_IrqDisable;
	callback.zDrvInt_MaskIrq = zDrvInt_MaskIrq;
	callback.zDrvLpm_IrqEnable = zDrvLpm_IrqEnable;
	callback.zDrvInt_UnmaskIrq = zDrvInt_UnmaskIrq;
	callback.Comm_Read_CP_TO_AP_Data = Comm_Read_CP_TO_AP_Data;
	callback.Comm_Write_AP_TO_CP_Data = Comm_Write_AP_TO_CP_Data;
	callback.zDrvEdcp_IsBusy = zDrvEdcp_IsBusy;

#ifndef _USE_TestHarness
	callback.zAti2_Open = zAti2_Open;
	callback.zAt_AutoTestInit = zAt_AutoTestInit;
	callback.zAti2_IsExCid = zAti2_IsExCid;
	callback.zPutSkb2Psbuf = zPutSkb2Psbuf;
	//callback.zGetpsbufferHead = zGetpsbufferHead;
	callback.zAti_CidIsUsed = zAti_CidIsUsed;
	callback.zAti2_Send = zAti2_Send;
	callback.zAti_GetDualCardStat = zAti_GetDualCardStat;
	callback.zGetUpLinkSduSize = zGetUpLinkSduSize;
	callback.zUsat_RegisterSendMsgFun = zUsat_RegisterSendMsgFun;
	callback.zAti2_RegRecvCb = zAti2_RegRecvCb;
	callback.zUsat_SendAtCmd = zUsat_SendAtCmd;
	callback.RegSendDataToAmtAppFunction = RegSendDataToAmtAppFunction;
	callback.zFreeDlBuf = zFreeDlBuf;
	callback.AmtAgent_ComposeAndProcess = AmtAgent_ComposeAndProcess;
	callback.zPs_IsTdMasterMode = zPs_IsTdMasterMode;
	callback.zPs_IsLteMasterMode = zPs_IsLteMasterMode;
	callback.zPs_IsFddMasterMode = zPs_IsFddMasterMode;
#ifdef USE_VOICE_SUPPORT
	callback.zDrvVoice_Close = zDrvVoice_Close;
	callback.zDrvVoice_ReadStart = zDrvVoice_ReadStart;
	callback.zDrvVoice_ReadStop = zDrvVoice_ReadStop;
	callback.zDrvVoice_WriteStart = zDrvVoice_WriteStart;
	callback.zDrvVoice_WriteStop = zDrvVoice_WriteStop;
	callback.zDrvVoice_Open = zDrvVoice_Open;
	callback.zDrvVoice_WriteOneFrame = zDrvVoice_WriteOneFrame;
	callback.zDrvVoice_ReadOneFrame = zDrvVoice_ReadOneFrame;
	callback.halVoice_SetPathIn = halVoice_SetPathIn;
	callback.halVoice_SetPathOut = halVoice_SetPathOut;
	callback.halVoice_SetVolOut = halVoice_SetVolOut;
	callback.halVoice_Enable = halVoice_Enable;
	callback.halVoice_Open = halVoice_Open;
	callback.halVoice_Disable = halVoice_Disable;
	callback.halVoice_Close = halVoice_Close;
	callback.zDrv_Audio_Printf = zDrv_Audio_Printf;
	callback.zDrvVp_SetTone_Wrap = zDrvVp_SetTone_Wrap;
	callback.zDrvVp_SetMute_Wrap = zDrvVp_SetMute_Wrap;
	callback.zDrvVp_GetMute_Wrap = zDrvVp_GetMute_Wrap;
	callback.zDrvVp_SetRxMute_Wrap = zDrvVp_SetRxMute_Wrap;
	callback.zDrvVp_GetRxMute_Wrap = zDrvVp_GetRxMute_Wrap;	
	callback.zDrvVp_SetVol_Wrap = zDrvVp_SetVol_Wrap;
	callback.zDrvVp_GetVol_Wrap = zDrvVp_GetVol_Wrap;
	callback.zDrvVp_SetDtmfMute_Wrap = zDrvVp_SetDtmfMute_Wrap;
	callback.zDrvVp_SetTxVol_Wrap = zDrvVp_SetTxVol_Wrap;
	callback.zDrvVp_GetTxVol_Wrap = zDrvVp_GetTxVol_Wrap;	
    callback.zDrvVp_SetVol_Gain_Wrap = zDrvVp_SetVol_Gain_Wrap;
    callback.zDrvVp_GetVol_Gain_Wrap = zDrvVp_GetVol_Gain_Wrap;
    callback.zDrvVp_SetTxVol_Gain_Wrap = zDrvVp_SetTxVol_Gain_Wrap;
    callback.zDrvVp_GetTxVol_Gain_Wrap = zDrvVp_GetTxVol_Gain_Wrap;
	callback.zDrvVp_GetPath_Wrap = zDrvVp_GetPath_Wrap;
	callback.zDrvVp_Loop = zDrvVp_Loop;
	callback.zDrvVp_GetVpLoop_Wrap = zDrvVp_GetVpLoop_Wrap;
    callback.zDrvVp_Soft_Dtmf_Loop = zDrvVp_Soft_Dtmf_Loop;
    callback.zDrvDtmf_Detect_RegCallbacks = zDrvDtmf_Detect_RegCallbacks;
	callback.zDrvVp_SetPath_Wrap = zDrvVp_SetPath_Wrap;
	callback.zDrvVp_GetPath_Wrap = zDrvVp_GetPath_Wrap;
	callback.halVoice_Open3G = halVoice_Open3G;
	callback.halVoice_Close3G = halVoice_Close3G;
	callback.zDrvVp_GetSlicFlag = zDrvVp_GetSlicFlag;
	callback.zDrvVp_SetVoiceProc_Wrap = zDrvVp_SetVoiceProc_Wrap;
	callback.zDrvVp_GetVoiceProc_Wrap = zDrvVp_GetVoiceProc_Wrap;
	callback.zDrvVp_SetVoiceBuffer_Wrap = zDrvVp_SetVoiceBuffer_Wrap;
	callback.zDrvVp_GetVoiceBuffer_Wrap = zDrvVp_GetVoiceBuffer_Wrap;	
	callback.zDrvVp_SetEchoDelay_Wrap = zDrvVp_SetEchoDelay_Wrap;
	callback.zDrvVp_GetEchoDelay_Wrap = zDrvVp_GetEchoDelay_Wrap;
	callback.zDrvVp_SetTxNsMode_Wrap = zDrvVp_SetTxNsMode_Wrap;
	callback.zDrvVp_GetTxNsMode_Wrap = zDrvVp_GetTxNsMode_Wrap;
	callback.zDrvVp_SetRxNsMode_Wrap = zDrvVp_SetRxNsMode_Wrap;
	callback.zDrvVp_GetRxNsMode_Wrap = zDrvVp_GetRxNsMode_Wrap;	
	callback.zDrvVp_SetModuleState_Wrap = zDrvVp_SetModuleState_Wrap;
	callback.zDrvVp_GetModuleState_Wrap = zDrvVp_GetModuleState_Wrap;
	callback.mmp_AmrDecOpen = mmp_AmrDecOpen;
	callback.mmp_AmrEncOpen = mmp_AmrEncOpen;
	callback.mmp_AmrDecode = mmp_AmrDecode;
	callback.mmp_AmrEncode = mmp_AmrEncode;
	callback.mmp_AmrDecClose = mmp_AmrDecClose;
	callback.mmp_AmrEncClose = mmp_AmrEncClose; 
    callback.zDrvVp_AudioDataOpen = zDrvVp_AudioDataOpen;
    callback.zDrvVp_AudioDataWrite = zDrvVp_AudioDataWrite;
    callback.zDrvVp_AudioDataClose = zDrvVp_AudioDataClose;
    callback.zDrvVp_Status = zDrvVp_Status;
    callback.zDrvVp_UpdateVoiceNv = zDrvVp_UpdateVoiceNv; 
#endif	
	callback.psm_ModemDevSleep = psm_ModemDevSleep;
	callback.psm_ModemSleepCheck = psm_ModemSleepCheck;
	callback.psm_ModemSleepTimeGet = psm_ModemSleepTimeGet;
	callback.psm_TimeCompensate = psm_TimeCompensate;
	callback.psm_GetModemSleepFlagStatus = psm_GetModemSleepFlagStatus;	   

#endif


	cpps_callbacks_register(&callback);
	cpko_sectioninfo_set();
	zte_modem_ko_start();

	return 0;
}

static int cpko_stop(void)
{
	return 0;
}

module_init(cpko_start);
module_exit(cpko_stop);
