/***********************************************************************
* Copyright (C) 2016, Sanechips Corporation.
*
* File Name:  zx29-keypad-int.c
* File Mark:
* Description:
* Others:
* Version:  v1.0
* Author:   qihongfang yuxiang lvfei ZhouTianbao
* Date:     2017-2-28
*
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
**********************************************************************/
#include <linux/module.h>
#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/interrupt.h>
#include <linux/input.h>
#include <linux/errno.h>
#include <linux/io.h>
#include <linux/pm_runtime.h>
#include <linux/slab.h>
#include <asm/irq.h>
#include <linux/workqueue.h>

#include <linux/gpio.h>
#include <mach/gpio.h>
#include <mach/pcu.h>
#include <linux/irq.h>
#include <linux/gpio_keys.h>
#include <linux/delay.h>
#include <linux/wakelock.h>

#include <mach/irqs.h>
#include <linux/mfd/zx234290.h>
#include <linux/kthread.h>
#include <linux/soc/zte/pm/drv_idle.h>

/**********************************************************************/
//#define ERROR_REGISTER_IRQ        -100

#define KEY_STATUS_UP               0
#define KEY_STATUS_DOWN             1   /*inputϵͳvalueΪ1ǰ*/

#define KEY_DELAY_TIME              30  /* ms */
#define KEY_NUM					    30

static struct input_dev *button_dev = NULL;

typedef struct _zx234290_keypad
{
    struct zx234290 *zx234290;
}zx234290_keypad_data;

static zx234290_keypad_data zx234290_keypad;

static spinlock_t kpd_lock;
static volatile unsigned int key_active_count = 0;
static struct wake_lock keypad_wake_lock;
static struct semaphore kpd_sem;

//#ifdef KPD_DEBUG
struct key_info
{
    unsigned int index;
	unsigned int code;
	int value;
};
struct key_info key_info_tab[KEY_NUM]=
{
    {0},
};
static unsigned int key_info_idx = 0;
static unsigned int key_info_counter = 0;
//#endif

static int zx29_kpd_queue(unsigned int code, int value)
{
    key_info_tab[key_info_idx].code = code;
    key_info_tab[key_info_idx].value= value;
    key_info_tab[key_info_idx].index = key_info_counter;
    key_info_idx++;
    key_info_counter++;
    if(key_info_idx >= KEY_NUM)
    {
        key_info_idx = 0;
    }
    return 0;
}

static void zx29_key_set_active(void)
{
	spin_lock(&kpd_lock);

    if(key_active_count == 0)
    {
		zx_cpuidle_set_busy(IDLE_FLAG_KPD);
		wake_lock(&keypad_wake_lock);
    }
    key_active_count++;

	spin_unlock(&kpd_lock);
}

static void zx29_key_set_idle(void)
{
	spin_lock(&kpd_lock);

    key_active_count--;
    if(key_active_count == 0)
    {
    	wake_unlock(&keypad_wake_lock);
		zx_cpuidle_set_free(IDLE_FLAG_KPD);
    }

	spin_unlock(&kpd_lock);
}

/*******************************************************************************
* Function: zx29_kpd_get_keystate
* Description:    Test key state
* Parameters:
*          Input:
*       Output:
* Returns:  0: key down ͵ƽ(press)    1: key up ߵƽ(release)
* Others:
*   zx29_gpio_config(unsigned int gpio, unsigned int value)  ø
*   value:  0:GPIO    1:FUNCTION
********************************************************************************/

static int zx29_kpd_get_keystate(int gpioNum,unsigned int gpio_sel_gpio,unsigned int gpio_sel_int)
{
    unsigned int gpio_state = GPIO_HIGH;
    int irq;

    zx29_gpio_config(gpioNum, gpio_sel_gpio);
    irq = gpio_to_irq(gpioNum);
    //pcu_clr_irq_pending(irq);
    zx29_gpio_set_direction(gpioNum, GPIO_IN);
    msleep(KEY_DELAY_TIME);
    gpio_state = gpio_get_value(gpioNum);
    /* msleep(30); */
    zx29_gpio_config(gpioNum, gpio_sel_int);/******qhf***int****/
    //pcu_clr_irq_pending(irq);

    //printk(KERN_INFO "gpio state=%d.\n",gpio_state);

    return gpio_state;  /* 0: ͵ƽ(press), 1:ߵƽ(release) */

}

static irqreturn_t zx29_kpd_pwron_inform(int irq, void *dev_id)
{
	up(&kpd_sem);
	return IRQ_HANDLED;
}

/*******************************************************************************
* Function: zx29_kpd_pwron_thread
* Description:
* Parameters:
*          Input:
*       Output:
* Returns:
* Others:
********************************************************************************/
#define USE_EXT_DEV
#ifdef USE_EXT_DEV
//extern struct input_dev *button5x6_dev;
extern struct input_dev *input_dev_table[32];
#endif
int zx29_kpd_pwron_thread(void *dev_id)
{
	struct gpio_keys_button *buttons = (struct gpio_keys_button *)dev_id;
	int ret = 0;
	unsigned char status = 0;

	struct sched_param param;
	param.sched_priority = 33;
	sched_setscheduler(current, SCHED_FIFO, &param);

	while (!kthread_should_stop()) {
		down(&kpd_sem);

		zx29_key_set_active();

		msleep(10);
		ret = zx234290_i2c_read_simple(ZX234290_REG_ADDR_STSA, &status);
		if(ret)
		{
			printk(KERN_INFO "kpd read reg return=%d.\n", ret);
		}
		else if((status >> ZX234290_STATUSA_POWERON_LSH) & 0x1)
		{
#ifdef USE_EXT_DEV
			if (input_dev_table[1]) {
				set_bit(buttons->code, input_dev_table[1]->keybit);
				input_report_key(input_dev_table[1], buttons->code, KEY_STATUS_DOWN);
				input_sync(input_dev_table[1]);
			}
#endif
			input_report_key(button_dev, buttons->code, KEY_STATUS_DOWN);
			input_sync(button_dev);

			zx29_kpd_queue(buttons->code, KEY_STATUS_DOWN);
			printk(KERN_INFO "kpd down code=%d .\n",buttons->code);

			while(1)
			{
				msleep(60);

				ret = zx234290_i2c_read_simple(ZX234290_REG_ADDR_STSA, &status);
				if(ret)
				{
					printk(KERN_INFO "kpd read reg return=%d.\n", ret);
					break;
				}
				//printk(KERN_INFO "kpd reg status=%d.\n", status);

				if(((status>>ZX234290_STATUSA_POWERON_LSH)&0x1) == 0x0)
				{
#ifdef USE_EXT_DEV
					if (input_dev_table[1]) {
						input_report_key(input_dev_table[1], buttons->code, KEY_STATUS_UP);
						input_sync(input_dev_table[1]);
					}
#endif
					input_report_key(button_dev, buttons->code, KEY_STATUS_UP);
					input_sync(button_dev);

					zx29_kpd_queue(buttons->code, KEY_STATUS_UP);
					printk(KERN_INFO "kpd up code=%d.\n",buttons->code);
					break;
				}
			}
		}
		else
		{
			printk(KERN_INFO "kpd power key noise.\n");
		}

		zx29_key_set_idle();
	}

	return 0;
}

static irqreturn_t zx29_kpd_irq_thread(int irq, void *dev_id)
{
    struct gpio_keys_button *buttons = (struct gpio_keys_button *)dev_id;
    int gpio_val = 0;
	int state;

    zx29_key_set_active();

    //printk(KERN_INFO "handle irq=%d.\n",irq);
    gpio_val = zx29_kpd_get_keystate(buttons->gpio,buttons->gpio_sel_gpio,buttons->gpio_sel_int);
	state = !!gpio_val ^ !!buttons->active_low;

    zx29_gpio_set_inttype(buttons->gpio,
						  (gpio_val ? IRQ_TYPE_LEVEL_LOW : IRQ_TYPE_LEVEL_HIGH));
    //pcu_int_clear(irq);
    //pcu_clr_irq_pending(irq);

#ifdef USE_EXT_DEV
	if (input_dev_table[1]) {
		set_bit(buttons->code, input_dev_table[1]->keybit);
		input_report_key(input_dev_table[1], buttons->code, state);
		input_sync(input_dev_table[1]);
	}
#endif

    input_report_key(button_dev, buttons->code, state);  //ϱkey ֵ
    //key_info_tab[key_num].lastStatus = state;
    input_sync(button_dev);
    zx29_kpd_queue(buttons->code, state);
    printk(KERN_INFO "kpd %s code=%d, irq=%d.\n",
			(state ? "down" : "up"),
			buttons->code,
			irq);

    //enable_irq(irq);    //ж

    zx29_key_set_idle();
    return IRQ_HANDLED;
}

/*******************************************************************************
* Function: zx29_kpd_irq_handler
* Description: clear irq , wake thread irq
* Parameters:
*          Input:
*       Output:
********************************************************************************/
static irqreturn_t zx29_kpd_irq_handler(int irq, void *dev_id)
{
    //disable_irq_nosync(irq);
    //pcu_int_clear(irq);
    pcu_clr_irq_pending(irq);

    //printk(KERN_INFO "kpd handler irq=%d.\n", irq);

    return IRQ_WAKE_THREAD;
}

/*******************************************************************************
* Function: zx29_kpd_request_irqs
* Description:
* Parameters:
*          Input:
*       Output:
********************************************************************************/
static int zx29_kpd_request_irqs(struct gpio_keys_platform_data *pdata )
{
    int ret = -1;
    struct gpio_keys_button *buttons = pdata->buttons;
    int keypad_num = pdata->nbuttons;
    int irq_num = 0;

    for(keypad_num = 0; keypad_num < pdata->nbuttons; keypad_num++)
    {
        if(buttons[keypad_num].use_pmu_pwron == 0)
        {
			ret = gpio_request(buttons[keypad_num].gpio, buttons[keypad_num].desc);
			if (ret < 0) {
				printk(KERN_ERR "kpd request gpio%d failed.\n", buttons[keypad_num].gpio);
				break;
			}
            zx29_gpio_config(buttons[keypad_num].gpio,buttons[keypad_num].gpio_sel_int);
			/* some switch may be active before booting. use level irq to avoid lack of falling edge. */
            zx29_gpio_set_inttype(buttons[keypad_num].gpio,
					(buttons[keypad_num].active_low ? IRQ_TYPE_LEVEL_LOW : IRQ_TYPE_LEVEL_HIGH));
            zx29_gpio_pd_pu_set(buttons[keypad_num].gpio, 0);

            msleep(1); /* wait for stable input */

            irq_num = gpio_to_irq(buttons[keypad_num].gpio);
            /*
            if(irq_num > 0){
                printk(KERN_INFO "zx29_kpd_request_irqs error irq_num=%d.\n",irq_num);
            }
            */

            /* pcu_clr_irq_pending(irq_num); */
            ret = request_threaded_irq(irq_num, NULL, zx29_kpd_irq_thread, IRQF_ONESHOT/*IRQF_TRIGGER_HIGH | IRQF_NO_THREAD*/,
                buttons[keypad_num].desc, &buttons[keypad_num]);
			irq_set_irq_wake(irq_num, 1);
        }
        else
        {
			sema_init(&kpd_sem, 0);
			kthread_run(zx29_kpd_pwron_thread, &buttons[keypad_num], "kpd_pwron_thread");

			irq_num = ENT_ZX234290_IRQ_BASE + ZX234290_INT_PWRON;
			ret = request_threaded_irq(irq_num, NULL, zx29_kpd_pwron_inform, 0,
							buttons[keypad_num].desc, &buttons[keypad_num]);
        }
        if(ret)
        {
            return ret;
        }
        printk(KERN_INFO "kpd request_irq irq_num=%d.\n", irq_num);
    }

    return ret;
}

/*******************************************************************************
* Function: zx29_kpd_probe
* Description:
* Parameters:
*          Input:
*        Output:
* Returns:
********************************************************************************/
static int zx29_kpd_probe(struct platform_device *pdev)
{
    int error = -1;
    static int i = 0;
	struct input_handle *handle;
    struct gpio_keys_platform_data *pdata = pdev->dev.platform_data;
    struct gpio_keys_button *buttons = pdata->buttons;
    zx234290_keypad.zx234290 = dev_get_drvdata(pdev->dev.parent);

    button_dev = input_allocate_device();
    if(!button_dev)
    {
        printk("allocate_device error.\n");
        return error;
    }
    button_dev->name = pdev->name;
    button_dev->evbit[0] = BIT_MASK(EV_KEY)|BIT_MASK(EV_REP);

    for(i=0; i < pdata->nbuttons; i++)
    {
        set_bit(buttons[i].code,button_dev->keybit);
    }

    error = input_register_device(button_dev);
    if(error)
    {
        printk("register device error\n");
        goto err_free_dev;
    }
	handle = container_of(button_dev->h_list.next, struct input_handle, d_node);
	/* printk(KERN_INFO "%s registered evdev %s/%p.\n", __FUNCTION__, handle->name, handle->private); */

    platform_set_drvdata(pdev, button_dev);

	spin_lock_init(&kpd_lock);
	wake_lock_init(&keypad_wake_lock, WAKE_LOCK_SUSPEND, "keypad");
    zx29_kpd_request_irqs(pdata);

    return 0;

err_free_dev:
    input_free_device(button_dev);
    return error;
}


/*******************************************************************************
* Function: zx29_kpd_remove
* Description:
* Parameters:
*          Input:
*        Output:
* Returns:
********************************************************************************/
static int zx29_kpd_remove(struct platform_device *pdev)
{
    struct gpio_keys_platform_data *pdata = pdev->dev.platform_data;
    struct gpio_keys_button *buttons = pdata->buttons;
    static struct input_dev *button_dev = NULL;
    int i = 0;
    int irq_num;

    for(i = 0; i < pdata->nbuttons; i++){
        irq_num = gpio_to_irq(buttons[i].gpio);
        if(irq_num < 0){
            printk(KERN_INFO "%s error keypad_num=%d.\n", __FUNCTION__, i);
        }

    	free_irq(irq_num,NULL);
		gpio_free(buttons[i].gpio);
    }
    button_dev = (struct input_dev *)platform_get_drvdata(pdev);
    input_free_device(button_dev);
    button_dev = NULL;

    zx234290_keypad.zx234290 = NULL;

    wake_lock_destroy(&keypad_wake_lock);

    return 0;
}

static int zx29_kpd_resume(struct platform_device *pdev)
{
    struct gpio_keys_platform_data *pdata = pdev->dev.platform_data;
    struct gpio_keys_button *buttons = pdata->buttons;
    int i = 0;
    int irq_num = 0;

    for(i = 0; i < pdata->nbuttons; i++){

        irq_num = gpio_to_irq(buttons[i].gpio);
        if(irq_num < 0){
            printk(KERN_INFO "%s error keypad_num=%d.\n", __FUNCTION__, i);
        }
        if(irq_num != 0){
            enable_irq(irq_num);
        }

    }
    printk(KERN_INFO "%s\n", __FUNCTION__);
    return 0;
}

static int zx29_kpd_suspend(struct platform_device *pdev, pm_message_t state)
{
    struct gpio_keys_platform_data *pdata = pdev->dev.platform_data;
    struct gpio_keys_button *buttons = pdata->buttons;
    int i = 0;
    int irq_num = 0;

    for(i = 0; i < pdata->nbuttons; i++){
        irq_num = gpio_to_irq(buttons[i].gpio);
        if(irq_num < 0){
            printk(KERN_INFO "%s error keypad_num=%d.\n", __FUNCTION__, i);
        }
        if(irq_num != 0){
            disable_irq(irq_num);
        }

    }
    printk(KERN_INFO "%s\n", __FUNCTION__);
    return 0;
}

static struct platform_driver zx29_kpd_driver =
{
    .probe  = zx29_kpd_probe,
    .remove = zx29_kpd_remove,
    .driver =
    {
        .name   =   "zx29_keypad_int",
        .owner  =   THIS_MODULE,
    },
    //.resume = zx29_kpd_resume,
    //.suspend    = zx29_kpd_suspend,
};

static int __init zx29_kpd_init(void)
{
    return platform_driver_register(&zx29_kpd_driver);
}

static void __exit zx29_kpd_exit(void)
{
    platform_driver_unregister(&zx29_kpd_driver);
}

module_init(zx29_kpd_init);
module_exit(zx29_kpd_exit);

MODULE_AUTHOR("Sanechips");
MODULE_DESCRIPTION("Sanechips Keypad Driver");
MODULE_LICENSE("GPL");

