/***********************************************************************
* Copyright (C) 2015, Sanechips Corporation.
*
* File Name: 	 7520_3x3_keypad.c
* File Mark:  	 None
* Description:   None
* Others:
* Version:  	v1.0
* Author:    	zhaoyu
* Date:     	2015-11-30
*
* History 1:  	Primary edition
*     Date:
* 	 Version:
*     Author:
*     Modification:
* History 2: 
**********************************************************************/
/*include area*/
#include <linux/module.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/input.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/slab.h>
#include <linux/platform_device.h>
#include <linux/io.h>
#include <mach/pcu.h>

#include <linux/input/zx29_keypad_5x6.h>
#include <linux/clk.h>
#include <linux/gpio.h>
#include <mach/gpio.h>
#include <linux/irq.h>

/*define area*/
#define KEYPAD_DBG_EN				(0)

#if KEYPAD_DBG_EN
#define KEYPAD_DBG(fmt, args...)	printk(fmt , ## args)
#else
#define KEYPAD_DBG(fmt, args...)
#endif
#define DBG_ENTER()                 KEYPAD_DBG("%s Enter.\n", __FUNCTION__)
#define DBG_EXIT()                  KEYPAD_DBG("%s Exit.\n", __FUNCTION__)

/* #define INT_POSEDGE                 (0x2) */       /* 10: raise edge */
#define KEY_STATUS_UP               0
#define KEY_STATUS_DOWN             1   /*inputϵͳvalueΪ1ǰ*/

/*global & static variable area*/
static void __iomem* KEY_BASE_ADDR_VIR;
static void __iomem* RM_MOD_RST1_REG_VIR;
//static void __iomem* RM_MOD_CLKEN2_REG_VIR;
//static void __iomem* PIN_MUX_CTRLREG13_REG_VIR;

struct kpd_gpio_desc {
	uint32_t gpio;
	uint32_t func;
	char *desc;
};

static const struct kpd_gpio_desc kpd_pins[] = {
	{83,	GPIO83_KEY_COL0,	"kpd_col0"},
	{84,	GPIO84_KEY_COL1,	"kpd_col1"},
	{85,	GPIO85_KEY_ROW0,	"kpd_row0"},
	{86,	GPIO86_KEY_ROW1,	"kpd_row1"},

	{66,	GPIO66_KEY_COL2,	"kpd_col2"},
	{67,	GPIO67_KEY_COL3,	"kpd_col3"},
	{68,	GPIO68_KEY_COL4,	"kpd_col4"},
	{69,	GPIO69_KEY_ROW2,	"kpd_row2"},
	{70,	GPIO70_KEY_ROW3,	"kpd_row3"},
	{71,	GPIO71_KEY_ROW4,	"kpd_row4"},

	{126,	GPIO126_KEY_COL2,	"kpd_col2"},
	{127,	GPIO127_KEY_COL3,	"kpd_col3"},
	{128,	GPIO128_KEY_COL4,	"kpd_col4"},
	{129,	GPIO129_KEY_COL5,	"kpd_col5"},
	{130,	GPIO130_KEY_ROW2,	"kpd_row2"},
	{131,	GPIO131_KEY_ROW3,	"kpd_row3"},
	{132,	GPIO132_KEY_ROW4,	"kpd_row4"}
};

/*
#if CONFIG_ARCH_ZX297520V3_WATCH
static const struct kpd_gpio_desc kpd_col[KPD_MAX_COLUMN] = {
	{83,	GPIO83_KEY_COL0,	"kpd_col0"},
};

static const struct kpd_gpio_desc kpd_row[KPD_MAX_ROW] = {
	{85,	GPIO85_KEY_ROW0,	"kpd_row0"},
};
#else
static const struct kpd_gpio_desc kpd_col[KPD_MAX_COLUMN] = {
	{83,	GPIO83_KEY_COL0,	"kpd_col0"},
	{84,	GPIO84_KEY_COL1,	"kpd_col1"},
#if 0
	{126,	GPIO126_KEY_COL2,	"kpd_col2"},
	{127,	GPIO127_KEY_COL3,	"kpd_col3"},
	{128,	GPIO128_KEY_COL4,	"kpd_col4"},
	{129,	GPIO129_KEY_COL5,	"kpd_col5"},
#else
	{66,	GPIO66_KEY_COL2,	"kpd_col2"},
	{67,	GPIO67_KEY_COL3,	"kpd_col3"},
#endif
};

static const struct kpd_gpio_desc kpd_row[KPD_MAX_ROW] = {
	{85,	GPIO85_KEY_ROW0,	"kpd_row0"},
	{86,	GPIO86_KEY_ROW1,	"kpd_row1"},
#if 0
	{130,	GPIO130_KEY_ROW2,	"kpd_row2"},
	{131,	GPIO131_KEY_ROW3,	"kpd_row3"},
	{132,	GPIO132_KEY_ROW4,	"kpd_row4"},
#else
	{69,	GPIO69_KEY_ROW2,	"kpd_row2"},
	{70,	GPIO70_KEY_ROW3,	"kpd_row3"},
	{71,	GPIO71_KEY_ROW4,	"kpd_row4"},
#endif
};
#endif
*/

static void zx29_key_param_init(unsigned interval,unsigned debounce,unsigned inten)
{
	T_KeyType *ptKey = (T_KeyType*)KEY_BASE_ADDR_VIR;

	DBG_ENTER();

	if (!(KEY_BASE_ADDR_VIR))
		return;

	ptKey->INTERVAL.Bit.interval = interval;
	ptKey->DEBOUNCE.Bit.debounce = debounce;

	ptKey->Int_En.Bit.int_en     = inten;
	ptKey->Cfg_Upt.Bit.cfg_upt   = 1;

	DBG_EXIT();
}


static unsigned zx29_key_index_read(void)
{
	T_KeyType *ptKey = (T_KeyType*)KEY_BASE_ADDR_VIR;

	if (!(KEY_BASE_ADDR_VIR))
		return 0;

	return ptKey->Key_Index.val;
}

static unsigned zx29_key_state_read(unsigned KeyStat[])
{
    T_KeyType *ptKey = (T_KeyType*)KEY_BASE_ADDR_VIR;

	if (!(KEY_BASE_ADDR_VIR))
		return 0;

    KeyStat[0] = ptKey->keystate[0];
	KeyStat[1] = ptKey->keystate[1];
	KeyStat[2] = ptKey->keystate[2];
	return 0;
}

#if KEYPAD_DBG_EN
char key_state[2 * KPD_TOTAL_ROW * KPD_TOTAL_COLUMN + 200];
#endif
static unsigned zx29_key_state_print(void)
{
	unsigned KeyStat[3];
    T_KeyType *ptKey = (T_KeyType*)KEY_BASE_ADDR_VIR;

	if (!(KEY_BASE_ADDR_VIR))
		return 0;

    KeyStat[0] = ptKey->keystate[0];
	KeyStat[1] = ptKey->keystate[1];
	KeyStat[2] = ptKey->keystate[2];

	printk("kpd %02X%08X%08X\n", KeyStat[2], KeyStat[1], KeyStat[0]);

#if KEYPAD_DBG_EN
	int i, j, key_state_index;
	char *p = KeyStat;

	key_state_index = sprintf(key_state, "\n\t\tC0\tC1\tC2\tC3\tC4\tC5\tC6\tC7\tC8\n");
	for(i = 0; i < KPD_TOTAL_ROW; i++)
	{
		key_state[key_state_index++] = 'R';
		key_state[key_state_index++] = '0' + i;
		key_state[key_state_index++] = '\t';
		for(j = 0; j < KPD_TOTAL_COLUMN; j++)
		{
			key_state[key_state_index + j * 2] = (p[j] & (1 << i)) ? 'P' : ' ';
			key_state[key_state_index + j * 2 + 1] = '\t';
		}
		key_state_index += KPD_TOTAL_COLUMN * 2;
		key_state[key_state_index - 1] = '\n';
	}
	key_state[key_state_index] = 0;
	KEYPAD_DBG("%s\n", key_state);
#endif

	return 0;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief λkey
 *
 * :
 *     - key_resetڽӿں, 书:
 *      -  λkey
 *
 * :
 *
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void zx29_key_reset(void)
{
	unsigned reg = 0;

	DBG_ENTER();

	if (!(RM_MOD_RST1_REG_VIR))
		return;

	reg = __raw_readl(RM_MOD_RST1_REG_VIR);
	//rm Key apb sw reset
	HAL_BIT_CLR(reg, RM_MODRST1_KEY_SWWRST_POS);
	//rm Key work sw reset
	HAL_BIT_CLR(reg, RM_MODRST1_KEY_SWPRST_POS);
	__raw_writel(reg, RM_MOD_RST1_REG_VIR);

	reg = __raw_readl(RM_MOD_RST1_REG_VIR);
	//rm Key apb sw unreset
	HAL_BIT_SET(reg, RM_MODRST1_KEY_SWPRST_POS);
	//rm Key work sw unreset
	HAL_BIT_SET(reg, RM_MODRST1_KEY_SWWRST_POS);
	__raw_writel(reg, RM_MOD_RST1_REG_VIR);

	DBG_EXIT();
}


#if 0

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʹkey߼ʱ
 *
 * :
 *     - key_clkenڽӿں, 书:
 *      -  ʹkey߼ʱ
 *
 * :
 *
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void key_clken(bool clken)
{
	DBG_ENTER();
	unsigned reg = 0;
	if (!(RM_MOD_CLKEN2_REG_VIR))
	return;

	reg = __raw_readl(RM_MOD_CLKEN2_REG_VIR);
	if(clken == 1)
	{
		//rm key apb clk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_PCLKEN_POS);
		//rm key work clk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_WCLKEN_POS);
	}
	else
	{
		//rm key work clk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_WCLKEN_POS);
		//rm key apb clk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_PCLKEN_POS);
	}
	__raw_writel(reg, RM_MOD_CLKEN2_REG_VIR);

	DBG_EXIT();
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʹkeyԶſ
 *
 * :
 *     - key_auto_clkenڽӿں, 书:
 *      -  ʹkeyԶſ
 *
 * :
 *
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void key_auto_clken(bool clken)
{
	DBG_ENTER();
	unsigned reg = 0;
	if (!(RM_MOD_CLKEN2_REG_VIR))
	return;

	reg = __raw_readl(RM_MOD_CLKEN2_REG_VIR);
	if(clken == 1)
	{
		//rm key work autoclk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_WCLK_AUTOGEN_POS);
		//rm key apb autoclk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_PCLK_AUTOGEN_POS);
	}
	else
	{
		//rm key work autoclk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_WCLK_AUTOGEN_POS);
		//rm key apb autoclk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_PCLK_AUTOGEN_POS);
	}
	__raw_writel(reg, RM_MOD_CLKEN2_REG_VIR);

	DBG_EXIT();
}
#endif

/**-------------------------------------------------------------------------------------------------------------------@n

 *--------------------------------------------------------------------------------------------------------------------*/
static void zx29_key_pin_config(struct platform_device *pdev)
{
	struct zx29_5x6_keypad_platform_data *pdata = dev_get_platdata(&pdev->dev);
	uint32_t i, j;
	int ret;

	DBG_ENTER();
	#if 0
	unsigned udData = 0;
	unsigned reg = 0;
	if (!(PIN_MUX_CTRLREG13_REG_VIR))
	return;

    /*20~23 kbr_2; 19~16 kbr_1; 15~12 kbr_0
     // //11~8 kbc_2; 7~4 kbc_1; 3~0 kbc_0*/
    udData=0x111111;

	reg = __raw_readl(PIN_MUX_CTRLREG13_REG_VIR);
    HAL_FINS(reg, KEY_PINMUX_CTRL, udData);
	__raw_writel(reg, PIN_MUX_CTRLREG13_REG_VIR);
	#endif

/*pin config*/
	for (i = 0; i < KPD_MAX_COLUMN + KPD_MAX_ROW; i++) {
		if (pdata->pin_col_row[i] == 0)
			continue;
		for (j = 0; j < ARRAY_SIZE(kpd_pins); j++) {
			if (pdata->pin_col_row[i] == kpd_pins[j].gpio)
				break;
		}
		if (j == ARRAY_SIZE(kpd_pins))
			continue;
		ret = gpio_request(kpd_pins[j].gpio, kpd_pins[j].desc);
		if (ret < 0) {
			printk(KERN_ERR "kpd request gpio%d failed.\n", kpd_pins[j].gpio);
			continue;
		}
		zx29_gpio_config(kpd_pins[j].gpio, kpd_pins[j].func);
		if (!memcmp(kpd_pins[j].desc, "kpd_row", 7))
			zx29_gpio_pd_pu_set(kpd_pins[j].gpio, IO_CFG_PULL_UP);
		else
			zx29_gpio_pd_pu_set(kpd_pins[j].gpio, IO_CFG_PULL_DISABLE);
	}

/*end of pin config*/
	DBG_EXIT();
}


/***sys driver layer***/

/* Initializing the kp Module */
static int zx29_5x6_keypad_initialize(struct zx29_5x6_kpd *keypad)
{
	int error = 0;

	DBG_ENTER();

	KEY_BASE_ADDR_VIR = ioremap(KEY_BASE_ADDR, 0x4);

	RM_MOD_RST1_REG_VIR = ioremap(RM_MOD_RST1_REG, 0x4);
#if 0
	RM_MOD_CLKEN2_REG_VIR = ioremap(RM_MOD_CLKEN2_REG, 0x4);
#endif
	//PIN_MUX_CTRLREG13_REG_VIR = ioremap(PIN_MUX_CTRLREG13_REG, 0x4);

	if (!KEY_BASE_ADDR_VIR || !RM_MOD_RST1_REG_VIR) {
		error = -ENOMEM;
		pr_err("could not remap register memory");
		goto exit;
	}

	zx29_key_reset();
    zx29_key_pin_config(keypad->pdev);
   // key_clken(1);
	zx29_key_param_init(KEY_SCAN_INTERVAL, KEY_DEBOUNCE_TIME, KEY_INTERRUPUT_EN);

	KEYPAD_DBG("------------------>>keypad register read begin<<----------------\n");
	KEYPAD_DBG("KEY_INTERVAL = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_INTERVAL));
	KEYPAD_DBG("KEY_DEBOUNCE = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_DEBOUNCE));
	KEYPAD_DBG("KEY_INT_EN = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_INT_EN));
	KEYPAD_DBG("KEY_CFG_UPT = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_CFG_UPT));
	KEYPAD_DBG("KEY_INDEX = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_INDEX));
	KEYPAD_DBG("KEY_STATE1 = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_STATE1));
	KEYPAD_DBG("KEY_STATE2 = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_STATE2));
	KEYPAD_DBG("KEY_STATE3 = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_STATE3));
	//KEYPAD_DBG("PIN_MUX_CTRLREG13_REG = %08x\n",__raw_readl(PIN_MUX_CTRLREG13_REG_VIR));
	KEYPAD_DBG("------------------>>keypad register read end<<----------------\n");
exit:
	DBG_EXIT();
	return error;
}

/*interrupt primary handler*/
static irqreturn_t zx29_5x6_keypad_irq_primary_handler(int irq, void *dev_id)
{
	disable_irq_nosync(irq);
	pcu_int_clear(irq);

	return IRQ_WAKE_THREAD;
}

/*interrupt handle thread*/
static irqreturn_t zx29_5x6_keypad_interrupt(int irq, void *dev_id)
{
	unsigned int dwkindex = 0;
	int temp = 0;
	unsigned int key1;
	unsigned int key2;
	static unsigned keycode = KEY_RESERVED;
	struct zx29_5x6_kpd *keypad = dev_id;
	struct zx29_5x6_keypad_platform_data *pdata = dev_get_platdata(&keypad->pdev->dev);

	DBG_ENTER();

	dwkindex = zx29_key_index_read();
	temp = (dwkindex >> 16) & 0x7f;
	key2 = ((dwkindex >> 8) & 0x7f) - 1;
	key1 = (dwkindex & 0x7f) - 1;
	KEYPAD_DBG("[%s] key cnt = %d key1=%d key2=%d\n", __FUNCTION__, temp, key1, key2);
	if(temp == 1)
	{
		unsigned int row = key1 % KPD_TOTAL_ROW;
		unsigned int col = key1 / KPD_TOTAL_ROW;

		if ((row < KPD_MAX_ROW) && (col < KPD_MAX_COLUMN)) {
			keycode = pdata->key_map[row][col];
			input_report_key(keypad->input, keycode, KEY_STATUS_DOWN);
			input_sync(keypad->input);
			printk(KERN_INFO "kpd 5X6 down code=%d.\n", keycode);
		} else {
			pr_err("key1 = %#X should never happen!", key1);
		}
	}
	else if(temp == 0)
	{
		input_report_key(keypad->input, keycode, KEY_STATUS_UP);
		/* input_reset_device(keypad->input);	*/
		input_sync(keypad->input);
		/* printk(KERN_INFO "kpd 5X6 up code=%d.\n", keycode); */
		printk(KERN_INFO "kpd 5X6 all keys up.\n");
	}
	else
	{
		printk(KERN_INFO "kpd status cnt=%d key1=%d key2=%d.\n", temp, key1, key2);
		zx29_key_state_print();
	}

#if KEYPAD_DBG_EN
	zx29_key_state_print();
#endif

	enable_irq(irq);

	DBG_EXIT();
	return IRQ_HANDLED;
}



/*probe*/
static int zx29_5x6_keypad_probe(struct platform_device *pdev)
{
	struct input_handle *handle;
	struct zx29_5x6_kpd *keypad;
	struct zx29_5x6_keypad_platform_data *pdata = dev_get_platdata(&pdev->dev);
	struct input_dev *key_dev;
	int error = 0;
	int i, j;
	struct clk *pclk=NULL;
	struct clk *wclk=NULL;
	struct resource *res_irq;

	DBG_ENTER();

	if (!pdata) {
		return -EINVAL;
	}

	keypad = kzalloc(sizeof(struct zx29_5x6_kpd), GFP_KERNEL);
	if (!keypad) {
		return -ENOMEM;
	}
	keypad->pdev = pdev;

	/*set the clk*/
	pclk = clk_get_sys("zx29_kpd.0","apb_clk");
	if (IS_ERR(pclk))
		panic("failed to get kpd pclk.");
	clk_prepare_enable(pclk);

	wclk = clk_get_sys("zx29_kpd.0","work_clk");
	if (IS_ERR(wclk))
		panic("failed to get kpd wclk.");
	//clk_set_rate(wclk,32000);
	clk_prepare_enable(wclk);

	res_irq = platform_get_resource(pdev, IORESOURCE_IRQ, 0);
	if (!res_irq) {
		error = -EINVAL;
		goto fail0;
	}
	keypad->irq = res_irq->start;
//	memcpy(keypad->key_map, pdata->key_map, sizeof(keypad->key_map));

	key_dev = input_allocate_device();
	if (!key_dev) {
		error = -1;
		goto fail0;
	}
	keypad->input = key_dev;

	/* __set_bit(EV_REP, key_dev->evbit); */
	__set_bit(EV_KEY, key_dev->evbit);

    for (i = 0; i < KPD_MAX_ROW; i++) {
	    for (j = 0; j < KPD_MAX_COLUMN; j++) {
		if (pdata->key_map[i][j])
        	set_bit(pdata->key_map[i][j], key_dev->keybit);
	    }
    }

	key_dev->name = pdev->name;

	error = input_register_device(keypad->input);
	if (error < 0) {
		goto fail1;
	}
	handle = container_of(key_dev->h_list.next, struct input_handle, d_node);
	/* printk(KERN_INFO "%s registered %s/%p.\n", __FUNCTION__, handle->name, handle->private); */

	error = zx29_5x6_keypad_initialize(keypad);
	if (error < 0) {
		goto fail2;
	}

	platform_set_drvdata(pdev, keypad);

    pcu_clr_irq_pending(keypad->irq);
	//error = request_irq(keypad->irq, zx297520_3x3_keypad_interrupt, 0, pdev->name, keypad);
	error = request_threaded_irq(keypad->irq, zx29_5x6_keypad_irq_primary_handler, zx29_5x6_keypad_interrupt, IRQF_TRIGGER_RISING, pdev->name, keypad);
	if (error < 0) {
		goto fail2;
	}
	irq_set_irq_wake(keypad->irq, 1);
    printk("probe keypad: irq:%d\n", keypad->irq);

	goto end;
/*
fail3:
	free_irq(keypad->irq, keypad); */
fail2:
	input_unregister_device(keypad->input);
fail1:
	input_free_device(key_dev);
fail0:
	kfree(keypad);
end:
	DBG_EXIT();
	return error;
}

/*remove*/
static int zx29_5x6_keypad_remove(struct platform_device *pdev)
{
	struct zx29_5x6_keypad_platform_data *pdata = dev_get_platdata(&pdev->dev);
	int i;
	struct zx29_5x6_kpd *keypad = platform_get_drvdata(pdev);

	DBG_ENTER();

	free_irq(keypad->irq, keypad);

	input_unregister_device(keypad->input);

	input_free_device(keypad->input);

	kfree(keypad);

	for (i = 0; i < KPD_MAX_COLUMN + KPD_MAX_ROW; i++) {
		if (pdata->pin_col_row[i] == 0)
			continue;
		gpio_free(pdata->pin_col_row[i]);
	}

	DBG_EXIT();
	return 0;
}

/*resume*/
static int zx29_5x6_keypad_resume(struct platform_device *pdev)
{
	return 0;
}

/*suspend*/
static int zx29_5x6_keypad_suspend(struct platform_device *pdev, pm_message_t state)
{
	return 0;
}


/**/
static struct platform_driver zx29_5x6_keypad_driver =
{
	.probe	= zx29_5x6_keypad_probe,
	.remove	= zx29_5x6_keypad_remove,
	.driver	=
	{
		.name	=	"zx29_keypad",
		.owner  =	THIS_MODULE,
	},
	.resume	= zx29_5x6_keypad_resume,
	.suspend	= zx29_5x6_keypad_suspend,
};

static int __init zx29_5x6_keypad_init(void)
{
	return platform_driver_register(&zx29_5x6_keypad_driver);
}

static void __exit zx29_5x6_keypad_exit(void)
{
	platform_driver_unregister(&zx29_5x6_keypad_driver);
}

module_init(zx29_5x6_keypad_init);
module_exit(zx29_5x6_keypad_exit);

MODULE_AUTHOR("Sanechips");
MODULE_DESCRIPTION("Sanechips-7520v3_5x6_keypad Driver");
MODULE_LICENSE("GPL");


