/*
 * Synopsys DesignWare Multimedia Card Interface driver
 *
 * Copyright (C) 2009 NXP Semiconductors
 * Copyright (C) 2009, 2010 Imagination Technologies Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/io.h>
#include <linux/irq.h>
#include <linux/platform_device.h>
#include <linux/slab.h>
#include <linux/mmc/host.h>
#include <linux/mmc/mmc.h>
#include <mach/zx29_mmc.h>
#include "zx29_mmc.h"
#include <linux/interrupt.h>

#include <linux/clk.h>
#include <linux/clockchips.h>
#include <mach/clock.h>
#include <mach/gpio.h>

//static u32 sdmmc_reg;
static int  dw_mci_pltfm_probe(struct platform_device *pdev)
{
	struct dw_mci *host;
	struct resource	*regs;
	struct resource *dmaChannel;
	int ret;
    struct clk *sdmmc_wclk;
    struct clk *sdmmc_aclk;
	host = kzalloc(sizeof(struct dw_mci), GFP_KERNEL);
	if (!host)
		return -ENOMEM;

	regs = platform_get_resource(pdev, IORESOURCE_MEM, 0);
	if (!regs) {
		ret = -ENXIO;
		goto err_free;
	}

	host->irq = platform_get_irq(pdev, 0);
	if (host->irq < 0) {
		ret = host->irq;
		goto err_free;
	}

#ifdef CONFIG_MMC_ZX29_EDMAC

	  dmaChannel = platform_get_resource(pdev, IORESOURCE_DMA, 0);

     if (!dmaChannel){
       
		dev_err(&pdev->dev, "Unable to get zx29 dma resource\n");
		}

#endif

   	host->dev = pdev->dev;
	host->irq_flags = IRQF_TRIGGER_HIGH;
	host->pdata = pdev->dev.platform_data;
    	sdmmc_aclk = clk_get(&pdev->dev, "apb_clk");
    	clk_enable(sdmmc_aclk);


	sdmmc_wclk = clk_get(&pdev->dev, "work_clk");
    	clk_set_rate(sdmmc_wclk, 48000000);
    	clk_enable(sdmmc_wclk);
    
	clk_get_rate(sdmmc_wclk);
	ret = -ENOMEM;
	if (!host->pdata || !host->pdata->init) {
		dev_err(&host->dev,
			"Platform data must supply init function\n");
		return -ENODEV;
	}
    	host->pdata->init(0, NULL, NULL);
#ifdef CONFIG_MMC_ZX29_EDMAC
    host->channel_id_tx= dmaChannel->start;/*qihongfang add for dma channel*/
    host->channel_id_rx= dmaChannel->end;/*qihongfang add for dma channel*/
    host->sdmmc_addr = regs->start;
#endif

	host->regs = ioremap(regs->start, resource_size(regs));
	//sdmmc_reg=(int)(host->regs);
	if (!host->regs)
		goto err_free;
	platform_set_drvdata(pdev, host);
	ret = dw_mci_probe(host);
	if (ret)
		goto err_out;
	return ret;
err_out:
	iounmap(host->regs);
err_free:
	kfree(host);
	return ret;
}

int dw_mci_pltfm_remove(struct platform_device *pdev)
{
	struct dw_mci *host = platform_get_drvdata(pdev);

	platform_set_drvdata(pdev, NULL);
	dw_mci_remove(host);
	iounmap(host->regs);
	kfree(host);
	return 0;
}

#ifdef CONFIG_PM_SLEEP
/*
 * TODO: we should probably disable the clock to the card in the suspend path.
 */
static int dw_mci_pltfm_suspend(struct device *dev)
{
	int ret;
	struct dw_mci *host = dev_get_drvdata(dev);

	ret = dw_mci_suspend(host);
	if (ret)
		return ret;

	return 0;
}

static int dw_mci_pltfm_resume(struct device *dev)
{
	int ret;
	struct dw_mci *host = dev_get_drvdata(dev);

	ret = dw_mci_resume(host);
	if (ret)
		return ret;

	return 0;
}
#else
#define dw_mci_pltfm_suspend	NULL
#define dw_mci_pltfm_resume	NULL
#endif /* CONFIG_PM_SLEEP */

static SIMPLE_DEV_PM_OPS(dw_mci_pltfm_pmops, dw_mci_pltfm_suspend, dw_mci_pltfm_resume);

static struct platform_driver dw_mci_pltfm_driver = {
	.remove		= __exit_p(dw_mci_pltfm_remove),
	.driver		= {
		.name		= "zx297510_sd",
		.pm		= &dw_mci_pltfm_pmops,
	},
};

static struct platform_driver dw_mci_pltfm_hotplug_driver = {
	.remove		= dw_mci_pltfm_remove,
	.probe 		= dw_mci_pltfm_probe,
	.driver		= {
		.name		= "zx297510_sd",
		.pm		= &dw_mci_pltfm_pmops,
	},
};
static int __init dw_mci_init(void)
{
	return platform_driver_register(&dw_mci_pltfm_hotplug_driver);
	//return platform_driver_probe(&dw_mci_pltfm_driver, dw_mci_pltfm_probe);
}

static void __exit dw_mci_exit(void)
{
	platform_driver_unregister(&dw_mci_pltfm_driver);
}

module_init(dw_mci_init);
module_exit(dw_mci_exit);

MODULE_DESCRIPTION("DW Multimedia Card Interface driver");
MODULE_AUTHOR("NXP Semiconductor VietNam");
MODULE_AUTHOR("Imagination Technologies Ltd");
MODULE_LICENSE("GPL v2");
