#ifndef _MMC_XLOG_H_
#define _MMC_XLOG_H_

#define XLOG_MMC_TF_CARD_SUPPORT
#define XLOG_MMC_WIFI_SUPPORT
#define XLOG_MMC_TF_CARD_INDEX	1
#define XLOG_MMC_WIFI_INDEX	0
#define XLOG_USB_ENABLE
#define XLOG_MMC_ENABLE



typedef signed char s8;
typedef unsigned char u8;

typedef signed short s16;
typedef unsigned short u16;

typedef signed int s32;
typedef unsigned int u32;

typedef signed long long s64;
typedef unsigned long long u64;


#define XLOG_MMC0_BUF_LEN			700	// 28 * 10000 = 280 K
#define XLOG_MMC1_BUF_LEN			700

#define XLOG_MMC0_KEY_BUF_LEN		100	// 28 * 1000 = 28 K
#define XLOG_MMC1_KEY_BUF_LEN		100

#define XLOG_USE_STATIC_BUF			0
#define XSH_DEBUG_MASS_SPEED

enum __attribute__ ((__packed__)) xlog_type {

	XLOG_TYPE_TF_CMD,
	XLOG_TYPE_TF_REG,
	XLOG_TYPE_TF_STATUS,
	XLOG_TYPE_TF_LOG,
	XLOG_TYPE_TF_EXCEPTION
};

enum __attribute__ ((__packed__)) xlog_tf_status_type {
	XLOG_TF_STATUS_CMD_COMPLETE,
	XLOG_TF_STATUS_DATA_COMPLETE
};

union xlog_content {
	int cap[4];

	/* command */
	struct {
		//u8	mmc_idx, opcode;
		u32	arg;
		u32 blkcs;		/* data block count and size */
		u32 cmdf;		/* CMD reg flag */
	} tf_c;

	/* reg */
	struct {
		void * p;
		u32 flags;
	} tf_r;

	/* status */
	struct {
		enum xlog_tf_status_type type;
		//u8	mmc_idx, opcode;
		s32 err;
		u32	param1;
		u32 param2;		/* expected response type */
	} tf_s;

	/* string log */
	struct {
		//u8	mmc_idx, opcode;
		const char *str;
		u32 p0;
		u32	p1;
		u32 p2;
		//u32	p3;
	} tf_l;

	/* exception */
	struct {
	} tf_e;
};

struct xlog {
	unsigned _jiffies;
	u8	opcode;
	enum xlog_type type;	/* command, data, status */
	union xlog_content u;
};

void xlog_mmc_cmd(u8 mmc_idx, u8 opcode, u32 arg, u32 blkCntSz, u32 cmdf);
void xlog_mmc_reg(u8 mmc_idx);
void xlog_mmc_status(u8 mmc_idx, u8 opcode, enum xlog_tf_status_type type, s32 err, u32 param1, u32 param2);
void xlog_mmc_log_save(u8 mmc_idx, u8 opcode, union xlog_content *xcontent, u32 is_key);
void xlog_print_all(u8 mmc_idx);
void xlog_reset(u8 mmc_idx);
int xlog_mmc_probe(int mmc_idx);


#if 1
#define xlog_tf_printk_cmd(_format, _args...)	do{printk("[%u][CMD%d]ARG=%08x, blkCntSz=%08x, CMDF=%08x, " _format, \
												log->_jiffies, log->opcode, \
												log->u.tf_c.arg, log->u.tf_c.blkcs, log->u.tf_c.cmdf, \
												## _args);}while(0)

#define xlog_tf_printk_status(_format, _args...)	do{printk("[%u][CMD%d]" _format, \
													log->_jiffies, log->opcode, \
													## _args);}while(0)

#define xlog_tf_printk_log(_format, _args...)	do{printk("[%u][%s][%x %x %x]" _format, \
												log->_jiffies, log->u.tf_l.str, \
												log->u.tf_l.p0, log->u.tf_l.p1, log->u.tf_l.p2, \
												## _args);}while(0)

#define xlog_tf_printk_log_op(_format, _args...)	do{printk("[%u][CMD%d][%s][%x %x %x]" _format, \
													log->_jiffies, log->opcode, log->u.tf_l.str, \
													log->u.tf_l.p0, log->u.tf_l.p1, log->u.tf_l.p2, \
													## _args);}while(0)

static inline void
xlog_mmc_log(u8 mmc_idx, const char *str, u32 p0, u32 p1, u32 p2)
{
	union xlog_content xcontent;

	xcontent.tf_l.str = str;
	xcontent.tf_l.p0 = p0;
	xcontent.tf_l.p1 = p1;
	xcontent.tf_l.p2 = p2;

	xlog_mmc_log_save(mmc_idx, 0xFF, &xcontent, 0);

	return;
}

static inline void
xlog_mmc_log_key(u8 mmc_idx, const char *str, u32 p0, u32 p1, u32 p2)
{
	union xlog_content xcontent;

	xcontent.tf_l.str = str;
	xcontent.tf_l.p0 = p0;
	xcontent.tf_l.p1 = p1;
	xcontent.tf_l.p2 = p2;

	xlog_mmc_log_save(mmc_idx, 0xFF, &xcontent, 1);

	return;
}

static inline void
xlog_mmc_log_op(u8 mmc_idx, u8 opcode, const char *str, u32 p0, u32 p1, u32 p2)
{
	union xlog_content xcontent;

	xcontent.tf_l.str = str;
	xcontent.tf_l.p0 = p0;
	xcontent.tf_l.p1 = p1;
	xcontent.tf_l.p2 = p2;

	xlog_mmc_log_save(mmc_idx, opcode, &xcontent, 0);

	return;
}

static inline void
xlog_mmc_log_opkey(u8 mmc_idx, u8 opcode, const char *str, u32 p0, u32 p1, u32 p2)
{
	union xlog_content xcontent;

	xcontent.tf_l.str = str;
	xcontent.tf_l.p0 = p0;
	xcontent.tf_l.p1 = p1;
	xcontent.tf_l.p2 = p2;

	xlog_mmc_log_save(mmc_idx, opcode, &xcontent, 1);

	return;
}
#else

#define xlog_tf_printk_cmd(_format, _args...)	do{}while(0)

#define xlog_tf_printk_status(_format, _args...)	do{}while(0)

#define xlog_tf_printk_log(_format, _args...)	do{}while(0)
#endif

#endif
