/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spifc.c
* File Mark:
* Description:
* Others:
* Version:
* Author:
* Date:

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/dma-mapping.h>
#include <linux/wait.h>
#include <linux/mutex.h>
#include <linux/slab.h>
#include <linux/mtd/mtd.h>
#include <linux/module.h>
#include <linux/clk.h>
#include <linux/err.h>
#include <linux/stddef.h>

#include <linux/io.h>
#include <linux/ioport.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/wakelock.h>
//#include <linux/dev_info.h>
#include <linux/gpio.h>
#include <linux/dmaengine.h>
#include <mach/iomap.h>
#include <mach/gpio.h>
#include <mach/spinlock.h>
#include <mach/dma.h>
#include "nor_spifc.h"


#define zDrv_ASSERT(_EXP)  printk("spifc error\n")


spinor_cmd_t nor_cmd_table[]=
{	
	{CMD_WREN, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "write enable"},
	{CMD_WRDI, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "write disable"},
	{CMD_WRENVSR, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "write ensable vsr"},		
	{CMD_RDSR0, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "read SR S7-S0"},
	{CMD_RDSR1, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "read SR S15-S8"},
	{CMD_WRSR, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_EN, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "write SR S15-S0"},
	{CMD_RDB, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "read data bytes"},
	{CMD_RDFT, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_EN, 1, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "read fast"},
	{CMD_RDDFT, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_EN, 1, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_EN, TRANS_MOD_DUAL, "read dual fast"},
	{CMD_RDQFT, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_EN, 1, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_EN, TRANS_MOD_QUAD, "read quad fast"},
	{CMD_PP, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_EN, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "page program"},
	{CMD_QPP, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_EN, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_EN, TRANS_MOD_QUAD, "quad page program"},
	{CMD_SE, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "sector erase"},
	{CMD_32KBE, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "32K block erase"},
	{CMD_64KBE, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_EN, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "64K block erase"},
	{CMD_CE, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "chip erase"},
	{CMD_DP, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "deep power-down"},
	{CMD_RDPRDI, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "releae DP adn RDI"},
	{CMD_REMS, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "read manufacture device id"},	
	{CMD_RDID, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_EN, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "read identification"},
	{CMD_ENRESET, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "reset enable"},	
	{CMD_RESET, TX_DMA_DIS, RX_DMA_DIS, ADDR_TX_DIS, ADDR_WIDTH_24, DATA_TX_DIS, DATA_RX_DIS, DUMY_TX_DIS, 0, 0, ADDR_MULTI_LINE_DIS, DATA_MULTI_LINE_DIS, TRANS_MOD_SINGLE, "reset"},			
	{NULL}
};


struct mtd_info *mtd_fota;


#define	NOR_TRANS_USE_DMA	1

#if NOR_TRANS_USE_DMA
static void spifc_dma_callback(struct fsl_qspi *q)
{
	if(q->dma_dir == FC_DMA_RX)
		up(&q->rx_semaphore);
	else if(q->dma_dir == FC_DMA_TX)
		up(&q->tx_semaphore);
	else
		BUG();
}

static int spifc_wait_dma_done(struct fsl_qspi *q)
{
	if(q->dma_dir == FC_DMA_RX)
		down(&q->rx_semaphore);
	else if(q->dma_dir == FC_DMA_TX)
		down(&q->tx_semaphore);
	else
		BUG();
	
	return 0;
}

static int spifc_config_dma(struct fsl_qspi *q, uint8_t *buf, uint32_t len, int dir)
{
	struct dma_chan *chan;
	struct dma_async_tx_descriptor *desc;
	int ret = 0;
    dma_channel_def dma_conf 	={
		.dma_control.irq_mode 		= DMA_ALL_IRQ_ENABLE,
		.dma_control.src_burst_size	= DMA_BURST_SIZE_32BIT,
		.dma_control.src_burst_len	= DMA_BURST_LEN_8,
		.dma_control.dest_burst_size= DMA_BURST_SIZE_32BIT,
		.dma_control.dest_burst_len	= DMA_BURST_LEN_8,
		.link_addr = 0,
		};

	if(dir == FC_DMA_RX)
	{
		dma_conf.src_addr = SF_DATA;
		dma_conf.dest_addr = (unsigned int)buf;
		chan	= q->rx_channel;
		q->dma_dir = dir;
		dma_conf.dma_control.tran_mode = TRAN_PERI_TO_MEM;		
	}
	else if(dir == FC_DMA_TX)
	{	
		dma_conf.src_addr = (unsigned int)buf;
		dma_conf.dest_addr = SF_DATA;
		chan	= q->tx_channel;
		q->dma_dir = dir;
		dma_conf.dma_control.tran_mode = TRAN_MEM_TO_PERI;
	}
	else
		BUG();

	dma_conf.count = len;
	
	ret = dmaengine_slave_config(chan,(struct dma_slave_config*) &dma_conf);
	if(ret != 0)
	{
		pr_info("dmaengine_slave_config failed(%d)~~~~~~", ret);
		return ret;
	}

	desc = chan->device->device_prep_interleaved_dma(chan, NULL, 0);
	desc->callback 			= spifc_dma_callback;
	desc->callback_param 	= q;
	dmaengine_submit(desc);
	dma_async_issue_pending(chan);

	return 0;
}

static int spifc_init_dma(struct fsl_qspi *q) 
{
	int ret = 0;
	dma_cap_mask_t mask;

	dma_cap_zero(mask);
	dma_cap_set(DMA_SLAVE, mask);

	q->tx_channel = dma_request_channel(mask, zx29_dma_filter_fn, (void*)DMA_CH_SPIFC_TX);
	if (!q->tx_channel) 
	{
		dev_err(q->dev, "no TX DMA channel!\n");
		return -ENODEV;
	}

	q->rx_channel = dma_request_channel(mask, zx29_dma_filter_fn, (void*)DMA_CH_SPIFC_RX);
	if(!q->rx_channel) 
	{
		dev_err(q->dev, "no RX DMA channel!\n");
		return -ENODEV;
	}	

	q->dev->dma_mask = &(q->dma_mask);
	
	/* Is 32-bit DMA supported? */
	ret = dma_set_mask(q->dev, DMA_BIT_MASK(32));
	if (ret) {
		pr_err("Spectra: no usable DMA configuration\n");
		return ret;
	}
/*	
	spifc->buf.buf = (dma_addr_t)kmalloc(SPI_NAND_BUF_SIZE, GFP_KERNEL);
	if(!spifc->buf.buf) 
		return -ENOMEM;
*/	
	q->buf.buf = (unsigned char *)ALIGN64((unsigned int)q->buf._buf);
	q->buf.dma_buf = dma_map_single(q->dev, q->buf.buf, 
									SPI_NOR_BUF_SIZE, DMA_BIDIRECTIONAL);
	
	//q->nor[0].mtd.dev = q->dev; 
	printk("[SPI NOR]dma ok addr is %x\n",q->buf.dma_buf);

	sema_init(&q->rx_semaphore , 0);
	sema_init(&q->tx_semaphore , 0);	

	return 0;
}
#endif

#define SPI_FLASH_CONTROLLER 1

#if SPI_FLASH_CONTROLLER


 void spifc_enable(struct fsl_qspi *q)
{
   volatile struct spifc_nor_reg_t* spifc = q->iobase;
    
    if(spifc->SFC_EN & FC_EN_BACK)
    {
		printk("spifc enable error.\n");
		return;
	}   
    spifc->SFC_EN |= (1 << FC_EN);  
    spifc->SFC_CTRL0 |= (1 << FC_SCLK_PAUSE_EN);
}

 void spifc_disable(struct fsl_qspi *q)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;
    
    if(!(spifc->SFC_EN & FC_EN_BACK))
    {
		printk("spifc disable error.\n");
		return;
	}     
    spifc->SFC_EN &= (~(1 <<FC_EN));    
}

 void spifc_set_timing(struct fsl_qspi *q, uint32_t rd_delay, uint32_t cs_setup, 
                      uint32_t cs_hold, uint32_t cs_desel)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;
    
    spifc->SFC_TIMING = 0;
    spifc->SFC_TIMING  |= ((rd_delay&0x3) << 16)|((cs_setup&0x7) <<11)|
                        ((cs_hold&0x7) << 6)|((cs_desel&0xf) << 0);
}

 void spifc_setup_cmd(struct fsl_qspi *q, 
							spinor_cmd_t *cmd, uint32_t addr, uint32_t len)
{   
	volatile struct spifc_nor_reg_t* spifc = q->iobase;

	/* clear dma config */
	spifc->SFC_CTRL0 &= ~((1 << FC_RX_DMA_EN)|(1 << FC_TX_DMA_EN));
	/* clear dma fifo */
	spifc->SFC_CTRL0 |= ((1 << FC_RXFIFO_CLR)|(1 << FC_TXFIFO_CLR));

	/* clear interrupt register */
	spifc->SFC_INT_SW_CLR = 0xFF;  
		
	/* dma + fifo config */
	spifc->SFC_CTRL0 |= ((cmd->tx_dma_en << FC_TX_DMA_EN) 
						  | (cmd->rx_dma_en << FC_RX_DMA_EN)
						  | (1 << FC_RXFIFO_THRES)
						  | (1 << FC_TXFIFO_THRES));


	/* addr dumy data code config */
    spifc->SFC_CTRL1 = 0;
    spifc->SFC_CTRL1 = ((cmd->addr_tx_en << FC_ADDR_TX_EN) 
						| (cmd->dumy_tx_en << FC_DUMMY_TX_EN) 
                        | (cmd->data_rx_en << FC_READ_DAT_EN) 
                        | (cmd->data_tx_en << FC_WRITE_DAT_EN));

	/* 空周期数、地址宽度(1，2，3，4字节)、地址/数据线度、传输模式 */
    spifc->SFC_CTRL2 = 0;
    spifc->SFC_CTRL2 = ((cmd->dumy_byte_num << FC_DUMMY_BYTE_NUM) 
            			| (cmd->dumy_bit_num << FC_DUMMY_BIT_NUM) 
	            		| (cmd->addr_byte_num << FC_ADDR_BYTE_NUM)
	            		| (cmd->addr_multi_line_en << FC_ADDR_MULTI_LINE_EN)
	            		| (cmd->data_multi_line_en << FC_DAT_MULTI_LINE_EN)
	            		| (cmd->trans_mod << FC_TRANS_MOD));

	/* 数据长度 */
    if(len)
        spifc->SFC_BYTE_NUM = len - 1;
    else
        spifc->SFC_BYTE_NUM = 0; 
	
	/* addr code register */
	spifc->SFC_ADDR = addr; 
	
	/* 命令码 */  
    spifc->SFC_INS = cmd->cmd;          
}

int spifc_wait_cmd_end(struct fsl_qspi *q)
{
    unsigned long comp_res, flags = 0;
	uint32_t intr_status = 0;
	unsigned long timeout = msecs_to_jiffies(1000);
    volatile struct spifc_nor_reg_t* spifc = q->iobase;

	while(spifc->SFC_START & FC_BUSY);
	
	do {
		comp_res = down_timeout(&q->c, timeout);
		intr_status = q->irq_status;
		
		if(intr_status & FC_INT_RAW_CMD_END) 
		{
			q->irq_status &= ~FC_INT_RAW_CMD_END;
			break;
		} 
		else if(intr_status & FC_INT_RAW_ERR_MASK)
		{	
			printk(KERN_ERR "spifc err interrupt, status = 0x%x\n",
				   intr_status);
            q->irq_status &= ~FC_INT_RAW_ERR_MASK;
			return -5;
		}
		else {
		}
	}while(comp_res == 0);

	if(comp_res != 0) {
		/* timeout */
		printk(KERN_ERR "spifc timeout occurred, status = 0x%x\n",
				intr_status);
		return -5;
	}
	
	return 0; 
}

uint32_t spifc_read_fifo(struct fsl_qspi *q, uint8_t *buf, uint32_t len)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;
    uint32_t *p = (uint32_t *)buf;
    uint32_t cnt = 0;
   
   int remainder_cnt = len % 4;
   
   if(remainder_cnt != 0)
   {
	   len = len + (4 - remainder_cnt);
   }
   else
   {
	   remainder_cnt = 4;
   }
   
   while(cnt < (len>>2))  
   {
	   if(spifc->SFC_SW & (FC_RX_FIFO_CNT_MASK<<FC_RX_FIFO_CNT))//rx fifo not empty
	   {		   
		   p[cnt++]= spifc->SFC_DATA;
	   }
   }
   
   return ((cnt<<2) - (4 - remainder_cnt));

}

int spifc_write_data(struct fsl_qspi *q, uint8_t *buf, uint32_t len)
{
    uint32_t *p = (uint32_t *)buf;
    uint32_t cnt = 0;
    volatile struct spifc_nor_reg_t* spifc = q->iobase;
	int remainder_cnt = len % 4;
	
	if(remainder_cnt != 0)
	{
		len = len + (4 - remainder_cnt);
	}
	else
	{
		remainder_cnt = 4;
	}
	
    while(cnt < (len >> 2))  
    {
        if(spifc->SFC_SW & (FC_TX_FIFO_CNT_MASK<<FC_TX_FIFO_CNT))//tx fifo not full
        {       
            spifc->SFC_DATA = p[cnt++];
        }
    }

    return ((cnt<<2) - (4 - remainder_cnt));
}

 void spifc_start(struct fsl_qspi *q)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;
    
    spifc->SFC_START |= FC_START;
}

static void spifc_irq_enable(struct fsl_qspi *q, uint32_t int_mask)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;

	spifc->SFC_INT_EN = 0;
	spifc->SFC_INT_EN |= int_mask;
}

static void spifc_irq_disable(struct fsl_qspi *q)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;

	spifc->SFC_INT_EN = 0;
}


static uint32_t spifc_read_interrupt_status(struct fsl_qspi *q)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;
	uint32_t intr_status = 0;
	
	intr_status = spifc->SFC_INT_SW_CLR;

	return intr_status;
}


static inline void clear_interrupt(struct fsl_qspi *q, uint32_t irq_mask)
{
    volatile struct spifc_nor_reg_t* spifc = q->iobase;

	spifc->SFC_INT_SW_CLR = irq_mask;
} 


#endif

static void clear_interrupts(struct fsl_qspi *q)
{
	uint32_t status = 0x0;
	unsigned long flags;
	
	raw_spin_lock_irqsave(&q->irq_lock, flags);

	status = spifc_read_interrupt_status(q);
	clear_interrupt(q, status);

	q->irq_status = 0x0;
	raw_spin_unlock_irqrestore(&q->irq_lock, flags);
}

static void spifc_set_intr_modes(struct fsl_qspi *q, uint16_t INT_ENABLE)
{
	if (INT_ENABLE)
		spifc_irq_enable(q, SPIFC_IRQ_ALL);
	else
		spifc_irq_disable(q);
}
static inline bool is_flash_bank_valid(int flash_bank)
{
	return 1;
}


static void spifc_irq_cleanup(struct fsl_qspi *q)
{
	spifc_set_intr_modes(q, false);
	free_irq(q->irq, q);
}

/* This function only returns when an interrupt that this driver cares about
 * occurs. This is to reduce the overhead of servicing interrupts
 */
static inline uint32_t spifc_irq_detected(struct fsl_qspi *q)
{
	return spifc_read_interrupt_status(q) & SPIFC_IRQ_ALL;
}


static uint16_t spi_nor_set_timing(struct fsl_qspi *q)
{
	spifc_set_timing(q,2,1,1,9);
	
	return 0;
}



/*******************************************************************************
 * Function:    spifc_lock/unlock
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spifc_lock(struct fsl_qspi *q)
{
	if(!q->int_en_flag)
	{
		enable_irq(q->irq);
		q->int_en_flag =1;
	}	
}

static void spifc_unlock(struct fsl_qspi *q)
{
	clear_interrupts(q);
	if(q->int_en_flag)
	{
		disable_irq(q->irq);
		q->int_en_flag = 0;
	}
}

static void fsl_qspi_set_base_addr(struct fsl_qspi *q, struct spi_nor *nor)
{
	q->chip_base_addr = q->nor_size * (nor - q->nor);
}

spinor_cmd_t *cmd_seek(u8 opcode)
{
	int i;

	for(i = 0; (&nor_cmd_table[i]) != NULL; i++)
	{
		if(opcode == nor_cmd_table[i].cmd)
		{
			return (&nor_cmd_table[i]);
		}
	}

	return NULL;	 
}


static int fsl_qspi_read_reg(struct spi_nor *nor, u8 opcode, u8 *buf, int len)
{
	int ret = 0;
	struct fsl_qspi *q = nor->priv;
	spinor_cmd_t *cmd = NULL;
	
	cmd = cmd_seek(opcode);
	if(cmd == NULL)
	{
		printk("cmd_seek unkown cmd = 0x%x error.\n", opcode);
		return -1;
	}
	
	spifc_setup_cmd(q, cmd, 0x0, len);            
    spifc_start(q);                          
    ret = spifc_wait_cmd_end(q);             
    if(ret != 0)
    {
		printk("spifc_wait_cmd_end error.\n");
	   	return ret;
    }
	
	ret = spifc_read_fifo(q, buf, len);
	if(ret < 0)
	{
		printk("spifc_read_fifo error.\n");
	    return ret;
	}
	
	return 0;	

}

static int fsl_qspi_write_reg(struct spi_nor *nor, u8 opcode, u8 *buf, int len)
{
	int ret;
	struct fsl_qspi *q = nor->priv;
	spinor_cmd_t *cmd = NULL;

	int nor_status = 0;
	
	cmd = cmd_seek(opcode);
	if(cmd == NULL)
	{
		printk("cmd_seek unkown cmd = 0x%x error.\n", opcode);
		return -1;
	}
	
	spifc_setup_cmd(q, cmd, 0x0, len);  

	if(len > 0)
	{
		ret = spifc_write_data(q, buf, len);
		if(ret != len)
		{
			printk("spifc_write_data error.\n");
		    return ret;
		}
	}

	spifc_start(q);
	
    ret = spifc_wait_cmd_end(q);             
    if(ret != 0)
    {
		printk("spifc_wait_cmd_end error.\n");
	   	return ret;
    }
	
	return 0;
}

static int spifc_write_page(struct spi_nor *nor, loff_t to,
						     size_t len, size_t *retlen, const u_char *buf)
{
	int ret;
	int nor_status = 0;
	struct fsl_qspi *q = nor->priv;
	spinor_cmd_t *cmd = NULL;
	
	cmd = cmd_seek(nor->program_opcode);
	if(cmd == NULL)
	{
		printk("cmd_seek unkown cmd = 0x%x error.\n", nor->program_opcode);
		return -1;
	}

#if NOR_TRANS_USE_DMA
	cmd->tx_dma_en = TX_DMA_EN;
#else
	cmd->tx_dma_en = TX_DMA_DIS;
#endif
	spifc_setup_cmd(q, cmd, to, len);				
	

#if NOR_TRANS_USE_DMA
	spifc_config_dma(q, buf, len, FC_DMA_TX);
	spifc_start(q);
#else
	spifc_start(q);
	ret = spifc_write_data(q, buf, len);
	if(ret < 0)
	{
		printk("spifc_write_fifo error.\n");
		return ret;
	}
#endif

	ret = spifc_wait_cmd_end(q);			 
	if(ret != 0)
	{
		printk("spifc_wait_cmd_end error.\n");
		return ret;
	}

#if NOR_TRANS_USE_DMA
	spifc_wait_dma_done(q);
	*retlen += len;
	
#else
	*retlen += ret;
	
#endif

	do{
		ret = fsl_qspi_read_reg(nor, CMD_RDSR0, &nor_status, 1);
		if(ret != 0)
		{
			printk("read WIP fail.\n");
		}
		else
		{
			if(!(nor_status & 0x1))
			{
				break;
			}
		}
		usleep_range(50,50);
	}while(nor_status & 0x1);
	
	return 0;
}

static int fsl_qspi_write(struct spi_nor *nor, loff_t to,
						   size_t len, size_t *retlen, const u_char *buf)
{
	int ret = 0;
	struct fsl_qspi *q = NULL;

	if((nor == NULL) || (nor->priv == NULL) || (retlen == NULL) || (buf == NULL))
	{
		printk("fsl_qspi_write parameter is error.\n");
		return -1;
	}
	q = nor->priv;

	memcpy((void*)q->buf.buf, buf, len);

	dma_sync_single_for_device(q->dev, q->buf.dma_buf, nor->page_size, DMA_BIDIRECTIONAL);
	
	ret = spifc_write_page(nor, to, len, retlen, q->buf.dma_buf);
	if(ret != 0)
	{
		printk("spifc_write_page error.\n");
		return -1;
	}
	dma_sync_single_for_cpu(q->dev, q->buf.dma_buf, nor->page_size, DMA_BIDIRECTIONAL);

	return 0;
}


static int spifc_read_page(struct spi_nor *nor, loff_t from,
						   size_t len, size_t *retlen, u_char *buf)
{
	int ret;
	struct fsl_qspi *q = nor->priv;
	spinor_cmd_t *cmd = NULL;

	cmd = cmd_seek(nor->read_opcode);
	if(cmd == NULL)
	{
		printk("cmd_seek unkown cmd = 0x%x error.\n", nor->read_opcode);
		return -1;
	}

#if NOR_TRANS_USE_DMA
	cmd->rx_dma_en = RX_DMA_EN;
#else
	cmd->rx_dma_en = RX_DMA_DIS;
#endif
	spifc_setup_cmd(q, cmd, from, len); 			
	
#if NOR_TRANS_USE_DMA
	spifc_config_dma(q, buf, len, FC_DMA_RX);
	spifc_start(q);
#else
	spifc_start(q);
	ret = spifc_read_fifo(q, buf, len);
	if(ret < 0)
	{
		printk("spifc_read_fifo error.\n");
		return ret;
	}
#endif

	ret = spifc_wait_cmd_end(q);			 
	if(ret != 0)
	{
		printk("spifc_wait_cmd_end error.\n");
		return ret;
	}
	
#if NOR_TRANS_USE_DMA
	spifc_wait_dma_done(q);
#endif

	return 0;
}

static int fsl_qspi_read(struct spi_nor *nor, loff_t from,
						 size_t len, size_t *retlen, u_char *buf)
{
	int ret = 0;
	struct fsl_qspi *q = NULL;
	loff_t from_alligned = 0;

	if((nor == NULL) || (nor->priv == NULL) || (retlen == NULL) || (buf == NULL))
	{
		printk("fsl_qspi_write parameter is error.\n");
		return -1;
	}
	from_alligned = from&(~(nor->page_size - 1));
	q = nor->priv;

	dma_sync_single_for_device(q->dev, q->buf.dma_buf, nor->page_size, DMA_BIDIRECTIONAL);
	
	ret = spifc_read_page(nor, from_alligned, nor->page_size, retlen, q->buf.dma_buf);
	if(ret != 0)
	{
		printk("spifc_write_page error.\n");
		return -1;
	}
	dma_sync_single_for_cpu(q->dev, q->buf.dma_buf, nor->page_size, DMA_BIDIRECTIONAL);

	memcpy(buf, (void*)q->buf.buf + (from&(nor->page_size - 1)), len);

	*retlen += len;

	return 0; 
}

static int fsl_qspi_erase(struct spi_nor *nor, loff_t offs)
{
	int ret;
	int nor_status = 0;
	struct fsl_qspi *q = nor->priv;
	spinor_cmd_t *cmd = NULL;
	
	cmd = cmd_seek(nor->erase_opcode);
	if(cmd == NULL)
	{
		printk("cmd_seek unkown cmd = 0x%x error.\n", nor->read_opcode);
		return -1;
	}
	spifc_setup_cmd(q, cmd, offs, 0);

	spifc_start(q);
    ret = spifc_wait_cmd_end(q);             
    if(ret != 0)
    {
		printk("spifc_wait_cmd_end error.\n");
	   	return ret;
    }

	do{
		msleep(10);
		ret = fsl_qspi_read_reg(nor, CMD_RDSR0, &nor_status, 1);
		if(ret != 0)
		{
			printk("read WIP fail.\n");
		}
	}while(nor_status & 0x1);
	
	return 0;
}

static int fsl_qspi_prep(struct spi_nor *nor, enum spi_nor_ops ops)
{
	struct fsl_qspi *q = nor->priv;
	int ret;

	mutex_lock(&q->lock);

	fsl_qspi_set_base_addr(q, nor);
	return 0;
}

static void fsl_qspi_unprep(struct spi_nor *nor, enum spi_nor_ops ops)
{
	struct fsl_qspi *q = nor->priv;

	mutex_unlock(&q->lock);
}


/* This is the interrupt service routine. It handles all interrupts
 * sent to this device. Note that on CE4100, this is a shared
 * interrupt. */
static irqreturn_t spi_nor_isr(int irq, void *dev_id)
{
	uint32_t irq_status = 0x0;
	irqreturn_t result = IRQ_NONE;
	unsigned long flags;
	struct fsl_qspi *q = dev_id;

	raw_spin_lock_irqsave(&q->irq_lock, flags);

	/* check to see if a valid NAND chip has
	 * been selected.
	 */
	if (is_flash_bank_valid(q->chip_base_addr)) {
		/* check to see if controller generated
		 * the interrupt, since this is a shared interrupt */
		irq_status = spifc_irq_detected(q);

		if (irq_status != 0) {
			/* handle interrupt */
			/* first acknowledge it */
			clear_interrupt(q, irq_status);
			
			/* store the status in the device context for someone
			   to read */
			q->irq_status |= irq_status;
			/* notify anyone who cares that it happened */
			up(&q->c);
			
			/* tell the OS that we've handled this */
			result = IRQ_HANDLED;
		}
	}
	raw_spin_unlock_irqrestore(&q->irq_lock, flags);
	
	return result;
}

static int spi_nor_init_resource(struct platform_device *pdev, struct fsl_qspi *q)
{
	int ret = 0;
	struct resource *spi_nor_reg;

	spi_nor_reg = platform_get_resource_byname(pdev, IORESOURCE_MEM, "spi_nor_reg");
	if(!spi_nor_reg) 
	{
		dev_err(&pdev->dev, "resources not completely defined\n");
		return  -EINVAL;
	}
	
	q->dev = &pdev->dev;
	q->irq = platform_get_irq(pdev, 0);
	if(q->irq < 0) 
	{
		dev_err(&pdev->dev, "no irq defined\n");
		return q->irq;
	}
	
	q->iobase = (void __iomem *)(spi_nor_reg->start);
	if(!q->iobase)
	{
		dev_err(&pdev->dev, "q->iobase is null error.\n");
		return -ENOMEM;
	}	

	ret = spifc_init_dma(q);	

	return ret;
}

/* initialize driver data structures */
void spifc_drv_init(struct fsl_qspi *q)
{
	sema_init(&q->c, 0);
	raw_spin_lock_init(&q->irq_lock);

	/* initialize our irq_status variable to indicate no interrupts */
	q->irq_status = 0;
	q->int_en_flag = 1;
}

/*******************************************************************************
 * Function:    spifc_hw_init
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spifc_hw_init(void)
{
    int ret;

	/*configure gpio12 to sfc_data3*/
	ret = gpio_request(98, "sfc_data3");
	if (ret)
	{	
		printk("gpio fail 1\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(98, 0x1);
	
	/*configure gpio11 to sfc_data2*/
	ret = gpio_request(97, "sfc_data2");
	if (ret)
	{	
		printk("gpio fail 2\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(97, 0x1);
	
	/*configure gpio10 to sfc_data2*/
	ret = gpio_request(96, "sfc_data1");
	if (ret)
	{	
		printk("gpio fail 3\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(96, 0x1);
	
	/*configure gpio9 to sfc_data0*/
	ret = gpio_request(95, "sfc_data0");
	if (ret)
	{	
		printk("gpio fail 4\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(95, 0x1);

/*configure gpio5 to sfc_cs*/
	ret = gpio_request(93, "sfc_cs");
	if (ret)
	{	
		printk("gpio fail 5\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(93, 0x1);

/*configure gpio3 to sfc_sclk*/
	ret = gpio_request(94, "sfc_sclk");
	if (ret)
	{	
		printk("gpio fail 6\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(94, 0x1);
}

int spi_nor_probe(struct platform_device *pdev)
{
	int ret = 0;
    struct fsl_qspi *q;
	struct spi_nor *nor;
	struct mtd_info *mtd;
	struct device *dev = &pdev->dev;

	pr_info("spi_nor_probe...\n");

	q = kzalloc(sizeof(*q), GFP_KERNEL);
	if (!q)
		return -ENOMEM;

	soft_spin_lock(NAND_SFLOCK);

	ret = spi_nor_init_resource(pdev, q);
	if(ret)
	{
		pr_info("[spi_nor_init_resource failed!]\n");
		ret =  -EINVAL;
		goto failed_alloc_memery;		
	}

	spifc_hw_init();
	q->nor_num = 1;
	spifc_disable(q);
	
	spifc_drv_init(q);
	spifc_enable(q);

    spifc_irq_disable(q);
	if (request_irq(q->irq, spi_nor_isr, IRQF_ONESHOT,
					"spi-nor", q)) 
	{
		pr_err("Spectra: Unable to allocate IRQ\n");
		ret = -ENODEV;
		goto failed_alloc_memery;
	}
    spifc_irq_enable(q, SPIFC_IRQ_ALL);
	printk("[SPI NOR]request_irq ok\n");
		
	//spi_nor_set_timing(q);

	mutex_init(&q->lock);

	nor = &q->nor[0];
	mtd = &nor->mtd;

	nor->dev = dev;
	nor->priv = q;

	/* fill the hooks */
	nor->read_reg = fsl_qspi_read_reg;
	nor->write_reg = fsl_qspi_write_reg;
	nor->read = fsl_qspi_read;
	nor->write = fsl_qspi_write;
	nor->erase = fsl_qspi_erase;

	nor->prepare = fsl_qspi_prep;
	nor->unprepare = fsl_qspi_unprep;


	/* set the chip address for READID */
	fsl_qspi_set_base_addr(q, nor);
	
	ret = spi_nor_scan(nor, NULL, SPI_NOR_QUAD);
	if (ret)
		goto mutex_failed;

	mtd_fota = mtd;	

	ret = mtd_device_register(mtd, NULL, 0);
	if (ret) {
		dev_err(q->dev, "Spectra: Failed to register MTD: %d\n",ret);
	}

	/* Set the correct NOR size now. */
	if(q->nor_size == 0) 
	{
		q->nor_size = mtd->size;
	}
	
    soft_spin_unlock(NAND_SFLOCK);

	platform_set_drvdata(pdev, q);

	pr_info("spi_nor_probe ok.\n");

	return 0;
mutex_failed:
	mutex_destroy(&q->lock);
failed_alloc_memery:
	kfree(q);
	
	return ret;
}

static int spi_nor_remove(struct platform_device *ofdev)
{
	struct fsl_qspi *q = platform_get_drvdata(ofdev);

	spifc_irq_cleanup(q);
	dma_unmap_single(q->dev, q->buf.dma_buf, SPI_NOR_BUF_SIZE,
					 DMA_BIDIRECTIONAL);

	kfree(q);

	return 0;
}


static const struct of_device_id spi_nor_dt_ids[] = {
	{ .compatible = "zxic,spi-nor-dt" },
	{ /* sentinel */ }
};
MODULE_DEVICE_TABLE(of, spi_nor_dt_ids);


static struct platform_driver spi_nor_driver = 
{

	.probe		= spi_nor_probe,
	.remove		= spi_nor_remove,
	.driver		= {
		.name	= "spi-nor-dt",
		.owner	= THIS_MODULE,
		.of_match_table	= spi_nor_dt_ids,
	},
};

module_platform_driver(spi_nor_driver);


