#include <linux/module.h>
#include <linux/syscalls.h>

#ifdef USE_CPPS_KO

struct cpps_callbacks cpps_callbacks;
EXPORT_SYMBOL(cpps_callbacks);

int cpps_callbacks_register(struct cpps_callbacks *p_call)
{
	cpps_callbacks = *p_call;

	return 0;
}
EXPORT_SYMBOL(cpps_callbacks_register);

int cpps_callbacks_unregister(void)
{
	memset(&cpps_callbacks,0,sizeof(cpps_callbacks));

	return 0;
}
EXPORT_SYMBOL(cpps_callbacks_unregister);

struct cpps_globalModem cpps_global_var;
EXPORT_SYMBOL(cpps_global_var);

int cpps_globalVar_register(struct cpps_globalModem *p_var)
{
	cpps_global_var = *p_var;

	return 0;
}
EXPORT_SYMBOL(cpps_globalVar_register);


#endif /* USE_CPPS_KO */

long kernel_sys_mount(char __user *dev_name, char __user *dir_name,
				char __user *type, unsigned long flags,
				void __user *data)
{
	return sys_mount(dev_name, dir_name, type, flags, data);
}
EXPORT_SYMBOL(kernel_sys_mount);

long kernel_sys_umount(char __user *name, int flags)
{
	return sys_umount(name, flags);
}
EXPORT_SYMBOL(kernel_sys_umount);

long kernel_sys_lseek(unsigned int fd, off_t offset,
			  unsigned int origin)
{
	return sys_lseek(fd, offset, origin);  
}
EXPORT_SYMBOL(kernel_sys_lseek);

long kernel_sys_unlink(const char __user *pathname)
{
	return sys_unlink(pathname);
}
EXPORT_SYMBOL(kernel_sys_unlink);

long kernel_sys_fsync(unsigned int fd)
{
	return sys_fsync(fd);
}
EXPORT_SYMBOL(kernel_sys_fsync);

long kernel_sys_rename(const char __user *oldname,
				const char __user *newname)
{
	return sys_rename(oldname, newname);
}
EXPORT_SYMBOL(kernel_sys_rename);

long kernel_sys_read(unsigned int fd, char __user *buf, size_t count)
{
	return sys_read(fd, buf, count);
}
EXPORT_SYMBOL(kernel_sys_read);

long kernel_sys_write(unsigned int fd, const char __user *buf,
			  size_t count)
{
	return sys_write(fd, buf, count);
}
EXPORT_SYMBOL(kernel_sys_write);

long kernel_sys_mkdir(const char __user *pathname, umode_t mode)
{
	return sys_mkdir(pathname, mode);
}
EXPORT_SYMBOL(kernel_sys_mkdir);

long kernel_sys_getcwd(char __user *buf, unsigned long size)
{
	return sys_getcwd(buf, size);
}
EXPORT_SYMBOL(kernel_sys_getcwd);

long kernel_sys_ftruncate(unsigned int fd, unsigned long length)
{
	return sys_ftruncate(fd, length);
}
EXPORT_SYMBOL(kernel_sys_ftruncate);

long kernel_sys_newstat(const char __user *filename,
				struct stat __user *statbuf)
{
	return sys_newstat(filename, statbuf);
}
EXPORT_SYMBOL(kernel_sys_newstat);

long kernel_sys_getdents(unsigned int fd,
				struct linux_dirent __user *dirent,
				unsigned int count)
{
	return sys_getdents(fd, dirent, count);
}
EXPORT_SYMBOL(kernel_sys_getdents);

long kernel_sys_chdir(const char __user *filename)
{
	return sys_chdir(filename);
}
EXPORT_SYMBOL(kernel_sys_chdir);

long kernel_sys_rmdir(const char __user *pathname)
{
	return sys_rmdir(pathname);
}
EXPORT_SYMBOL(kernel_sys_rmdir);

long kernel_sys_newfstat(unsigned int fd, struct stat __user *statbuf)
{
	return sys_newfstat(fd, statbuf);
}
EXPORT_SYMBOL(kernel_sys_newfstat);

long kernel_sys_sync(void)
{
	return sys_sync();
}
EXPORT_SYMBOL(kernel_sys_sync);

long kernel_sys_chmod(const char __user *filename, umode_t mode)
{
	return sys_chmod(filename, mode);
}
EXPORT_SYMBOL(kernel_sys_chmod);

long kernel_sys_open(const char __user *filename,
				int flags, umode_t mode)
{
	return sys_open(filename, flags, mode);
}
EXPORT_SYMBOL(kernel_sys_open);

long kernel_sys_ioctl(const char __user *filename, unsigned int cmd,
				unsigned long arg)
{
       return sys_ioctl(filename,cmd,arg);
}
EXPORT_SYMBOL(kernel_sys_ioctl);

long kernel_sys_access(const char __user *filename, int mode)
{
	return sys_access(filename, mode);
}
EXPORT_SYMBOL(kernel_sys_access);

long kernel_sys_statfs(const char __user * path,
				struct statfs __user *buf)
{
	return sys_statfs(path, buf);
}
EXPORT_SYMBOL(kernel_sys_statfs);

long kernel_sys_creat(const char __user *pathname, umode_t mode)
{
	return sys_creat(pathname, mode);
}
EXPORT_SYMBOL(kernel_sys_creat);

long kernel_sys_close(unsigned int fd)
{
	return sys_close(fd);
}
EXPORT_SYMBOL(kernel_sys_close);

/*
ERROR: "sys_lseek" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_unlink" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_fsync" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_rename" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_read" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_write" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_mkdir" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_getcwd" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_ftruncate" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_newstat" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_getdents" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_chdir" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_rmdir" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_newfstat" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_sync" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_chmod" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_open" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_access" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_statfs" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
ERROR: "sys_creat" [drivers/cpkodemo/cpkodemo.ko.ko] undefined!
*/
