/*
 * ZTE CPU low power powerdown and powerup code.
 *
 * Copyright (C) 2013 ZTE, Inc.
 * Written by ZXP
 *
 */
#include <linux/linkage.h>
#include <linux/threads.h>
#include <asm/asm-offsets.h>
#include <asm/assembler.h>
#include <asm/glue-cache.h>
#include <asm/glue-proc.h>
	 
#include <asm/memory.h>

.arm
/* =======================================================================
 * The wakeup code will jump to this code in ddr-mem.
 * This code will build C environment for resume code. 
 *
 * =======================================================================*/
ENTRY(cpu_reset_handler)
	blx	invalidate_icache_v7		/* Clear I cache */

	blx enable_icache_v7
	blx	invalidate_dcache_v7_all	/* Clear all data cache levels visible to CPU */

	blx  cpu_resume
ENDPROC(cpu_reset_handler)


/* =======================================================================
 * Because IRAM may power down, M0 will copy this code to IRAM(address 0) 
 * after CPU_AP is waked up. 
 *
 * So this code will run in IRAM.
 * =======================================================================*/
ENTRY(cpu_wake_up)
	nop					/* add 16 nops */
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	nop	
	nop
	nop	

 	mov r2, #0x3e8  /*ldr  r2, =1000	cpu_reset_handler */
 	
	
	ldr  r5, [r2]		
	bx   r5  				/* call cpu_reset_handler */
ENDPROC(cpu_wake_up)

/* =======================================================================
 * When ddr dfs, A9 must run in iram and waiting till this process finished.
 *
 * r0 -- address for dfs finish flag
 * =======================================================================*/
#define	DDR_DFS_FINISH		0x2
 
ENTRY(waiting_ddr_dfs)
waiting_ddr_dfs:
	stmfd	sp!, {r2, lr}

acquire_again:
	ldr  	r2, [r0]
	cmp		r2, #DDR_DFS_FINISH
	bne		acquire_again

	ldmfd	sp!, {r2, pc}
ENDPROC(waiting_ddr_dfs)

/* =======================================================================
 * 
 * disable ddr port3.
 * addr assigned 0x200
 * =======================================================================*/
ENTRY(do_sleep_cpu)

	isb
	dsb
	wfi	

	bx 	lr
ENDPROC(do_sleep_cpu)

ENTRY(zx_jump_addr)
	//mov 	pc, r0
	B do_sleep_cpu
ENDPROC(zx_jump_addr)

wake_up_buf:			.space 1024


