#include "at_io.h"
#include <linux/module.h>
#include <linux/cp_types.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/soc/zte/rpm/rpmsg_sim.h>
#include "zpsi_api.h"

extern zx29_rpmsg_ser rpmsg_sim_zx29;

#define  ATIO_SUCCESS	0
#define  ATIO_ERROR		1

#define  ZATI2_SUCCESS	0
#define  ZATI2_ERROR	1

#define  VSIM_CHID_BASE	90
#define  VSIM_MAX_MSG_LEN	1024
#define  VSIM_APDU_TIMEOUT	8//Сˮصʱʱ6룬ҪСˮ

enum{
	MSG_CMD_VSIM_GET_SWITCH = 1,
	MSG_CMD_VSIM_SET_SWITCH,
	MSG_CMD_VSIM_GET_STANDBY,
	MSG_CMD_VSIM_SET_STANDBY,
	MSG_CMD_VSIM_GET_TAUING,
	MSG_CMD_VSIM_SET_TAUING,
	MSG_CMD_VSIM_GET_AUTHING,
	MSG_CMD_VSIM_SET_AUTHING,
	MSG_CMD_VSIM_GET_CARD_STAT,
	MSG_CMD_VSIM_APDU,
	MSG_CMD_VSIM_GET_FLOW_STATISTIC,//ȡǰͳ
	MSG_CMD_VSIM_RESET_FLOW_STATISTIC,//õǰͳ
	MSG_CMD_VSIM_GET_SCANING,
	MSG_CMD_VSIM_SET_SCANING,
	MSG_CMD_VSIM_MAX,
};
typedef struct {
    unsigned short usMsgCmd;               /* Ϣ */  
    unsigned short usDataLen;                /* Ϣȣͷ */  
    unsigned char aucDataBuf[VSIM_MAX_MSG_LEN];  /* Ϣ */  
} VSIM_MSG_BUF;
typedef int (*vsim_async_CB)(unsigned char *msg);
typedef int (*vsim_sync_CB)(unsigned char *in_msg, unsigned char *out_msg);

extern vsim_async_CB g_vsim_read;
extern vsim_async_CB g_vsim_write;
extern vsim_sync_CB g_vsim_proc;
extern unsigned char cid_reserved;

extern unsigned char zAti_GetDualCardStat(unsigned char * pbSim1Stat, unsigned char * pbSim2Stat, unsigned char * pbIsCardSwitching);
extern unsigned char psnet_get_pschid_stat_all(void);
extern void psnet_set_pschid_stat_by_sim(unsigned char stat, unsigned char sim);
extern void psnet_get_flow_statistic_by_sim(unsigned long *tx_bytes, unsigned long *rx_bytes, unsigned char sim);
extern void psnet_reset_stat_by_sim(unsigned char sim);

VSIM_MSG_BUF g_vsim_msg = {0};
int g_vsim_msg_flag = 0;
struct mutex g_vsim_msg_mutex;
struct semaphore g_vsim_read_sem;
struct semaphore g_vsim_write_sem;
atomic_t g_vsim_switch = ATOMIC_INIT(0);
atomic_t g_vsim_standby = ATOMIC_INIT(0);
atomic_t g_vsim_tauing = ATOMIC_INIT(0);
atomic_t g_vsim_authing = ATOMIC_INIT(0);
atomic_t g_vsim_scaning = ATOMIC_INIT(0);
unsigned char g_vsim_psnet_stat = 0;
unsigned char g_vsim_cid_reserved = 0;

static int vsim_rw_sync(VSIM_MSG_BUF *in_msg, VSIM_MSG_BUF *out_msg, int timeout)
{
	mutex_lock(&g_vsim_msg_mutex);
	if(g_vsim_msg_flag){
		mutex_unlock(&g_vsim_msg_mutex);
		printk("vsim_rw busy flag=%d !\n",g_vsim_msg_flag);
		return 0;
	}
	memcpy(&g_vsim_msg, in_msg, sizeof(VSIM_MSG_BUF));
	g_vsim_msg_flag = 1;
	mutex_unlock(&g_vsim_msg_mutex);
	up(&g_vsim_read_sem);
	if(down_timeout(&g_vsim_write_sem, timeout*HZ) != 0){
		mutex_lock(&g_vsim_msg_mutex);
		g_vsim_msg_flag = 0;
		mutex_unlock(&g_vsim_msg_mutex);
		printk("vsim_rw timeout !\n");
		down_trylock(&g_vsim_read_sem);
		return 0;
	}
	mutex_lock(&g_vsim_msg_mutex);
	if(g_vsim_msg_flag != 3){//û˳
		g_vsim_msg_flag = 0;
		mutex_unlock(&g_vsim_msg_mutex);
		printk("vsim_rw fail!\n");
		down_trylock(&g_vsim_read_sem);
		return 0;
	}
	memcpy(out_msg, &g_vsim_msg, sizeof(VSIM_MSG_BUF));
	g_vsim_msg_flag = 0;
	mutex_unlock(&g_vsim_msg_mutex);
	return 1;
}

static int vsim_app_read(unsigned char *msg)
{
	if(down_interruptible(&g_vsim_read_sem) < 0){
		printk("vsim_read interrupt!\n");
		return 0;
	}
	mutex_lock(&g_vsim_msg_mutex);
	if(g_vsim_msg_flag != 1){
		mutex_unlock(&g_vsim_msg_mutex);
		printk("vsim_read fail flag=%d !\n",g_vsim_msg_flag);
		return 0;
	}
	memcpy(msg, &g_vsim_msg, sizeof(VSIM_MSG_BUF));
	g_vsim_msg_flag = 2;
	mutex_unlock(&g_vsim_msg_mutex);
	return 1;
}

static int vsim_app_write(unsigned char *msg)
{
	mutex_lock(&g_vsim_msg_mutex);
	if(g_vsim_msg_flag != 2){
		mutex_unlock(&g_vsim_msg_mutex);
		printk("vsim_write fail flag=%d !\n",g_vsim_msg_flag);
		return 0;
	}
	memcpy(&g_vsim_msg, msg, sizeof(VSIM_MSG_BUF));
	g_vsim_msg_flag = 3;
	mutex_unlock(&g_vsim_msg_mutex);
	up(&g_vsim_write_sem);
	return 1;
}

static int vsim_app_proc(unsigned char *in_msg, unsigned char *out_msg)
{
	VSIM_MSG_BUF *msg_buf = (VSIM_MSG_BUF *)in_msg;
	VSIM_MSG_BUF *out_buf = (VSIM_MSG_BUF *)out_msg;
	unsigned char default_param = msg_buf->aucDataBuf[0];
	
	switch (msg_buf->usMsgCmd)
	{
	case MSG_CMD_VSIM_GET_SWITCH:
		out_buf->usMsgCmd = MSG_CMD_VSIM_GET_SWITCH;
		out_buf->aucDataBuf[0] = atomic_read(&g_vsim_switch);
		out_buf->usDataLen = 1;
		break;
	case MSG_CMD_VSIM_SET_SWITCH:
		if(default_param == 0 || default_param == 1) {
			atomic_set(&g_vsim_switch, default_param);
		}else{
			printk("vsim_app_proc SET_SWITCH=%d fail!\n",default_param);
			return 0;
		}
		break;
	case MSG_CMD_VSIM_GET_STANDBY:
		out_buf->usMsgCmd = MSG_CMD_VSIM_GET_STANDBY;
		out_buf->aucDataBuf[0] = atomic_read(&g_vsim_standby);
		out_buf->usDataLen = 1;
		break;
	case MSG_CMD_VSIM_SET_STANDBY:
		if(default_param == 0 || default_param == 1) {
			if(atomic_read(&g_vsim_standby) != default_param){
				if(!atomic_read(&g_vsim_tauing)){
					unsigned char old_stat = g_vsim_psnet_stat;//ȡ·״̬
					g_vsim_psnet_stat = psnet_get_pschid_stat_all();//¼ǰ·״̬
					psnet_set_pschid_stat_by_sim(0, !default_param);//رյǰ·
					psnet_set_pschid_stat_by_sim(old_stat, default_param);//ԭ·״̬
				}
				if(default_param){
					g_vsim_cid_reserved = cid_reserved;
					cid_reserved |= 15;
				} else {
					cid_reserved = g_vsim_cid_reserved;
				}
				atomic_set(&g_vsim_standby, default_param);
			}
		}else{
			printk("vsim_app_proc SET_STANDBY=%d fail!\n",default_param);
			return 0;
		}
		break;
	case MSG_CMD_VSIM_GET_TAUING:
		out_buf->usMsgCmd = MSG_CMD_VSIM_GET_TAUING;
		out_buf->aucDataBuf[0] = atomic_read(&g_vsim_tauing);
		out_buf->usDataLen = 1;
		break;
	case MSG_CMD_VSIM_SET_TAUING:
		if(default_param == 0 || default_param == 1) {
			static int old_standby = 0;
			static unsigned char stat = 0;
			if(atomic_read(&g_vsim_tauing) == default_param){
				printk("vsim_app_proc SET_TAUING=%d dup!\n",default_param);
				return 0;
			}
			if(default_param){
				stat = psnet_get_pschid_stat_all();
				old_standby = atomic_read(&g_vsim_standby);
				psnet_set_pschid_stat_by_sim(0, old_standby);//رյǰ·
			}else{
				if(old_standby == atomic_read(&g_vsim_standby)){
					psnet_set_pschid_stat_by_sim(stat, old_standby);//ԭTAU·״̬
				}else{
					psnet_set_pschid_stat_by_sim(g_vsim_psnet_stat, !old_standby);//ԭ·״̬
					g_vsim_psnet_stat = stat;//¼ǰ·״̬
				}
			}
			atomic_set(&g_vsim_tauing, default_param);
		}else{
			printk("vsim_app_proc SET_TAUING=%d fail!\n",default_param);
			return 0;
		}
		break;
	case MSG_CMD_VSIM_GET_AUTHING:
		out_buf->usMsgCmd = MSG_CMD_VSIM_GET_AUTHING;
		out_buf->aucDataBuf[0] = atomic_read(&g_vsim_authing);
		out_buf->usDataLen = 1;
		break;
	case MSG_CMD_VSIM_SET_AUTHING:
		if(default_param == 0 || default_param == 1) {
			atomic_set(&g_vsim_authing, default_param);
		}else{
			printk("vsim_app_proc SET_AUTHING=%d fail!\n",default_param);
			return 0;
		}
		break;
	case MSG_CMD_VSIM_GET_CARD_STAT:
		out_buf->usMsgCmd = MSG_CMD_VSIM_GET_CARD_STAT;
#ifdef USE_CPPS_KO
		cpps_callbacks.zAti_GetDualCardStat(&out_buf->aucDataBuf[0], &out_buf->aucDataBuf[1], &out_buf->aucDataBuf[2]);
#else
		zAti_GetDualCardStat(&out_buf->aucDataBuf[0], &out_buf->aucDataBuf[1], &out_buf->aucDataBuf[2]);
#endif
		printk("vsim_app_proc GET_CARD_STAT=%d %d %d !\n",out_buf->aucDataBuf[0], out_buf->aucDataBuf[1], out_buf->aucDataBuf[2]);
		out_buf->usDataLen = 3;
		break;
	case MSG_CMD_VSIM_GET_FLOW_STATISTIC:
		out_buf->usMsgCmd = MSG_CMD_VSIM_GET_FLOW_STATISTIC;
		if(default_param == 0 || default_param == 1) {
			psnet_get_flow_statistic_by_sim(out_buf->aucDataBuf, out_buf->aucDataBuf+sizeof(unsigned long), default_param);
			out_buf->usDataLen = sizeof(unsigned long)+sizeof(unsigned long);
		}else{
			printk("vsim_app_proc GET_FLOW_STATISTIC=%d fail!\n",default_param);
			return 0;
		}
		break;
	case MSG_CMD_VSIM_RESET_FLOW_STATISTIC:
		if(default_param == 0 || default_param == 1) {
			psnet_reset_stat_by_sim(default_param);
		}else{
			printk("vsim_app_proc RESET_STAT=%d fail!\n",default_param);
			return 0;
		}
		break;
	case MSG_CMD_VSIM_GET_SCANING:
		out_buf->usMsgCmd = MSG_CMD_VSIM_GET_SCANING;
		out_buf->aucDataBuf[0] = atomic_read(&g_vsim_scaning);
		out_buf->usDataLen = 1;
		break;
	case MSG_CMD_VSIM_SET_SCANING:
		if(default_param == 0 || default_param == 1 || default_param == 2) {
			atomic_set(&g_vsim_scaning, default_param);
		}else{
			printk("vsim_app_proc SET_SCANING=%d fail!\n",default_param);
			return 0;
		}
		break;
	default:
		printk("vsim_app_proc fail msgid=%d!\n",msg_buf->usMsgCmd);
		return 0;
	}
	return 1;
}

static void *vsim_switch_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *vsim_switch_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void vsim_switch_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

static int vsim_switch_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "vsim state:%d standby:%d tauing:%d authing:%d scaning:%d datastat:%d msgflg:%d cid:%d-%d\n", 
		atomic_read(&g_vsim_switch), atomic_read(&g_vsim_standby), atomic_read(&g_vsim_tauing), atomic_read(&g_vsim_authing),
		atomic_read(&g_vsim_scaning), g_vsim_psnet_stat, g_vsim_msg_flag, g_vsim_cid_reserved, cid_reserved);
    return 0;
}

static const struct seq_operations vsim_switch_seq_ops = {
    .start = vsim_switch_seq_start,
    .next  = vsim_switch_seq_next,
    .stop  = vsim_switch_seq_stop,
    .show  = vsim_switch_seq_show
};

static int vsim_switch_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &vsim_switch_seq_ops);
}

static ssize_t vsim_switch_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    char vsim_switch[2] = {0};

    //countβ1ֻ֧0-1
    if (count != 2)
        return -EINVAL;
    
    if (copy_from_user(vsim_switch, buffer, 1))
        return -EFAULT;

    if (vsim_switch[0] < '0' || vsim_switch[0] > '1')
        return -EINVAL;
    atomic_set(&g_vsim_switch, vsim_switch[0]-'0');
    return count;
}

static const struct file_operations vsim_switch_file_ops = {
	.owner = THIS_MODULE,
	.open	 = vsim_switch_open,
	.read	 = seq_read,
	.llseek  = seq_lseek,
	.release = seq_release,
	.write = vsim_switch_set,
};

int atio_is_scaning(void)
{
	return atomic_read(&g_vsim_scaning);
}

int atio_vsim_apdu_cfg(unsigned char*apdu_req, unsigned short apdu_req_len, unsigned char *apdu_rsp, unsigned short *apdu_rsp_len, unsigned char slot,unsigned char is_auth)
{
	VSIM_MSG_BUF in_msg = {0};
	VSIM_MSG_BUF out_msg = {0};

	if(apdu_req  == NULL || apdu_req_len == 0 || apdu_req_len+2 > VSIM_MAX_MSG_LEN || apdu_rsp == NULL || apdu_rsp_len == NULL){
		printk("vsim_apdu param err in=0x%p %d out=0x%p 0x%p!\n", apdu_req, apdu_req_len, apdu_rsp, apdu_rsp_len);
		return ATIO_ERROR;
	}
	in_msg.usMsgCmd = MSG_CMD_VSIM_APDU;
	in_msg.usDataLen = apdu_req_len;
	in_msg.aucDataBuf[0] = slot;
	in_msg.aucDataBuf[1] = is_auth;
	memcpy(&in_msg.aucDataBuf[2], apdu_req, apdu_req_len);
	if(vsim_rw_sync(&in_msg, &out_msg, VSIM_APDU_TIMEOUT)){
		if(out_msg.usDataLen == 0 || out_msg.usDataLen > 264){//buff264
			printk("vsim_apdu rsp len=%d fail!\n", out_msg.usDataLen);
			return ATIO_ERROR;
		}
		memcpy(apdu_rsp, out_msg.aucDataBuf, out_msg.usDataLen);
		*apdu_rsp_len = out_msg.usDataLen;
		printk("vsim_apdu succ len=%d msg=%d!\n", out_msg.usDataLen, out_msg.usMsgCmd);
		return ATIO_SUCCESS;
	}
	return ATIO_ERROR;
}

static int PS_CallBack_Init = 0;
extern int transdataToTCPIP(unsigned int index, void *buffer, unsigned int length);
extern void psnet_set_pschid_stat(unsigned int chid, unsigned int newstat);

//PL add 4GPIO power save
#ifdef BTRUNK_SUPPORT
static int g_bFGpioSet = 0;
extern int zDrvXp2xp_Cp2ApWakeupAp(void);
#endif

#ifdef _USE_VEHICLE_DC
char *at_psm_filter;//="+CREG:+CGREG:+CEREG:^MODE:";
module_param(at_psm_filter, charp, 0644);
extern int pcu_CoreIsActive(int core);
int atio_psm_check(const char *buffer)
{
	if(at_psm_filter && pcu_CoreIsActive(2) == 0 && buffer){
		char prefix[128] = {0};
		char *inform = strstr(buffer, ": ");
		char *rsp_ok = strstr(buffer, "\r\nOK\r\n");
		char *rsp_err = strstr(buffer, "ERROR");
		
		if(inform && rsp_ok == NULL && rsp_err == NULL){
			if(inform - buffer - 1 < sizeof(prefix)){
				strncpy(prefix, buffer + 2, inform - buffer - 1);
				if(strstr(at_psm_filter, prefix))
					return 1;
			}
		}
	}
	return 0;
}
#endif

int PSCallBackEntry(unsigned char ch_ID, unsigned char *data, unsigned short dataLen, T_zAti2_CtrmChInd chInd)
{
	int ret = ATIO_SUCCESS;
	int ret2 = 0; 
	zx29_rpmsg_channel *rpmsg_channel = NULL;
	unsigned char chID = ch_ID;

	if(chID == 72)
	{
#ifdef USE_CPPS_KO
		cpps_callbacks.zUsat_SendAtCmd(72, data, dataLen, 0);
#else
		zUsat_SendAtCmd(72, data, dataLen, 0);
#endif
		return ATIO_SUCCESS;
	}
	//ǰΪETHͨݣͨص͸TCPIPЭջ
	if( (ZATI2_CHIND_PSD == chInd) )
	{
#ifdef BTRUNK_SUPPORT
		if(1 == g_bFGpioSet)
		{
			//PL add 4GPIO power save
			ret2 = zDrvXp2xp_Cp2ApWakeupAp();
			if(ret2 < 0)
			{
				printk(KERN_ERR "ZTE-TSP zx29 USB wake up failed\n");
			}
		}
#endif
		ret = transdataToTCPIP(chID, data, dataLen);
		return ret;
	}
	//ǰΪETHͨͨδȥͨPS
	else if(ZATI2_CHIND_TURN_PSD == chInd)
	{
		//zOss_ASSERT(0);
		//printk("TURN_PSD :PS chid [%d] is opened\n", chID);
		psnet_set_pschid_stat(chID, 1);
		return ATIO_SUCCESS;
	}
	else if(ZATI2_CHIND_TURN_AT == chInd)
	{
		psnet_set_pschid_stat(chID, 0);
		return ATIO_SUCCESS;
	}
	if(chID > VSIM_CHID_BASE) {
		if(atomic_read(&g_vsim_switch) == 0){
			printk("err vsim0 chid=%d cmd=%s!\n",chID, data);
			return ATIO_SUCCESS;
		}
		chID = chID - VSIM_CHID_BASE;
	} else if(atomic_read(&g_vsim_switch)){
		printk("err vsim1 chid=%d cmd=%s!\n",chID, data);
		return ATIO_SUCCESS;
	}
	if (chID > CHANNEL_NUM || chID == 0)
	{
		//printk("err chid=%d cmd=%s!\n",ch_ID, data);
		return ATIO_SUCCESS;
	}
#ifdef _USE_VEHICLE_DC
	if(atio_psm_check(data)){
		//printk("psm drop chid=%d cmd=%s!\n",ch_ID, data);
		return ATIO_SUCCESS;
	}
#endif
	//ǰΪATͨ
	if( (ZATI2_CHIND_AT == chInd) && ((rpmsg_channel = &rpmsg_sim_zx29.rpmsg_channel[chID-1]) != NULL) )
	{
		//printk("channel %d ind cmd %s\n",chID, data);
		
#ifdef BTRUNK_SUPPORT		
		//PL add 4GPIO power save
		if(1 == g_bFGpioSet)
		{
		    ret2 = zDrvXp2xp_Cp2ApWakeupAp();
		    if(ret2 < 0)
		    {
		    	printk(KERN_ERR "ZTE-TSP zx29 USB wake up failed\n");
		    }
		}
#endif		
		ret = TransdataToRpmsg(chID, data, dataLen);
	}	
	//ATϱÿͨԻᷢͣûд򿪵ͨ˴ERRԱPSͷڴĴ
	else
	{			
		//printk("%s : PS chid [%d] not open, chInd = [%d] \r\n", __func__, chID, chInd);
		return ATIO_ERROR;
	}
	
	return ret;
}

int zUsatFuncCb(UINT8 *data, UINT16 dataLen)
{
	int ret =-1;

	printk("zUsatFuncCb: %s.\n",data);
#ifdef USE_CPPS_KO
	ret = cpps_callbacks.zAti2_Send(72,data,dataLen,ZATI2_CHIND_AT);
#else
	ret = zAti2_Send(72,data,dataLen,ZATI2_CHIND_AT);
#endif
	return ret;
}

void ATchannelOpen(unsigned int chid)
{
#ifdef USE_DSDS_VSIM
#ifdef USE_CPPS_KO
	cpps_callbacks.zAti2_Open(chid + VSIM_CHID_BASE);
#else
	zAti2_Open(chid + VSIM_CHID_BASE);
#endif
#endif
	//rpmsg_channel->chID= PS_AT_CH[index].at_chid;
#ifdef USE_CPPS_KO
	if(cpps_callbacks.zAti2_Open(chid) != ZATI2_SUCCESS)
#else
	if(zAti2_Open(chid) != ZATI2_SUCCESS)
#endif
		//panic("open ps channel failed!!!!");
	//else
	{
		//printk("open channel fail %d !\n",chid);
	}

	if(PS_CallBack_Init == 0)
	{
#ifdef USE_CPPS_KO
		if(cpps_callbacks.zAti2_Open(72) != ZATI2_SUCCESS)
#else
		if(zAti2_Open(72) != ZATI2_SUCCESS)
#endif
			panic("open ps channel 72 failed!!!!");
#ifdef USE_CPPS_KO
		cpps_callbacks.zUsat_RegisterSendMsgFun((ZUSAT_SENDATCMDTOACCESSCHANNEL_FUNC)zUsatFuncCb);
		cpps_callbacks.zAti2_RegRecvCb((T_ZAti2_AtRecvFunc)PSCallBackEntry);
#else
		zUsat_RegisterSendMsgFun((ZUSAT_SENDATCMDTOACCESSCHANNEL_FUNC)zUsatFuncCb);
		zAti2_RegRecvCb((T_ZAti2_AtRecvFunc)PSCallBackEntry);
#endif
		PS_CallBack_Init = 1;
#ifdef USE_CPPS_KO
	cpps_callbacks.zAt_AutoTestInit();
#else
	zAt_AutoTestInit();
#endif
	}
	return ;
}
void ATchannelClose(unsigned int chid)
{
	//ʵΪգATֶ֧̬ͨر
}

void TransdataToPS(unsigned int ch_id, const void *buffer, unsigned int length)
{
	unsigned int chid = ch_id;
	int writeRst=0;

	if(atomic_read(&g_vsim_switch) && chid < VSIM_CHID_BASE)
		chid = chid + VSIM_CHID_BASE;
		
	//printk("TransdataToPS chid:%d, buffer:%s !\n",chid, (char *)buffer);

#ifdef BTRUNK_SUPPORT
	char *str = strstr(buffer, "AT+PTTFGPIOSET=");
	if(str != NULL)
    {
        if(str[15] == '1')
		{
		    g_bFGpioSet = 1;
			PSCallBackEntry(chid,"\r\nOK\r\n",1+strlen("\r\nOK\r\n"),ZATI2_CHIND_AT);
		}
		else if(str[15] == '0')
		{
		    g_bFGpioSet = 0;
			PSCallBackEntry(chid,"\r\nOK\r\n",1+strlen("\r\nOK\r\n"),ZATI2_CHIND_AT);
		}
        else
		{
		    PSCallBackEntry(chid,"\r\n+CME:ERROR:6003\r\n",1+strlen("\r\n+CME:ERROR:6003\r\n"),ZATI2_CHIND_AT);
		}
		return;
	}
#endif
#ifdef USE_CPPS_KO
	writeRst = cpps_callbacks.zAti2_Send(chid, buffer, length, ZATI2_CHIND_AT);
#else
	writeRst = zAti2_Send(chid, buffer, length, ZATI2_CHIND_AT);
#endif
	if(writeRst != ZATI2_SUCCESS)
	{
			//panic("send at string to ps failed!!!!");
		PSCallBackEntry(chid,"\r\n+CME ERROR: 8006\r\n",1+strlen("\r\n+CME ERROR: 8006\r\n"),ZATI2_CHIND_AT);
	}
	else
	{
		//printk("TransdataToPS channel %d !\n",chid);
	}
	return ;	
}

int TransdataToRpmsg(unsigned int chid, const void *buffer, unsigned int length)
{
	//zx29_rpmsg_channel *rpmsg_channel = &rpmsg_sim_zx29.rpmsg_channel[chid-1];
	rpmsg_recv_notify(chid,buffer,length);
    	return 0;
}
#if 1
int ATchannelInit(void)
{
	int i = 0;
	for (i = 0; i < rpmsg_sim_zx29.num; i++) 
	{	if((i != 9) && (i != 0)) //channel_9 for amt use channel_0 for vsimagt use
		{
			registerOpsCallback(i, ATchannelOpen, ATchannelClose, TransdataToPS);
		}
	}
#ifdef USE_DSDS_VSIM	
	mutex_init(&g_vsim_msg_mutex);
	sema_init(&g_vsim_read_sem, 0);
	sema_init(&g_vsim_write_sem, 0);
	proc_create("vsim_switch", 0440, NULL, &vsim_switch_file_ops);
	g_vsim_read = vsim_app_read;
	g_vsim_write = vsim_app_write;
	g_vsim_proc = vsim_app_proc;
#endif
	return 0;
}

int ATchannelExit(void)
{
	return 0;
}

late_initcall(ATchannelInit);
module_exit(ATchannelExit);

MODULE_AUTHOR("ZTE");
MODULE_DESCRIPTION("ZTE Lan Net Device");
MODULE_LICENSE("GPL");
#endif

