/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name: icp.c
 * File Mark:
 * Description:
 * Others:
 * Version:       V0.1
 * Author:        ShiDeYou
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 ******************************************************************************/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/io.h>
#include <linux/suspend.h>
#include <linux/time.h>
#include <linux/timer.h>
#include <linux/delay.h>

#ifdef CONFIG_ZX_RAM_CONSOLE 
#define	 RPMSG_LOG_SIZE	(4*1024)
static char rpmsg_printk_buf[RPMSG_LOG_SIZE];	// ring buffer
static u32  rpmsg_log_point = 0;
static u32  rpmsg_sram_inited = 0;
//static char rpmsg_log_temp_buf[512] = {0};

static void rpmsg_sram_cpy(char *s, unsigned len)
{
	if(rpmsg_log_point + len >= RPMSG_LOG_SIZE)
		rpmsg_log_point = 0;

	memcpy(rpmsg_printk_buf+rpmsg_log_point, s, len);
	rpmsg_log_point += len;
}
#endif

/**
 * usage: like printk(...)
 */
void rpmsg_printk(const char *fmt, ...)
{
#ifdef CONFIG_ZX_RAM_CONSOLE
	va_list args;
	unsigned long long t;
	unsigned long nanosec_rem;	
	int tlen, len;
	char rpmsg_log_temp_buf[512] = {0};

	if(!rpmsg_sram_inited)
		return;
	
	va_start(args, fmt);

	/* add time stamp */
	t = cpu_clock(smp_processor_id());
	nanosec_rem = do_div(t, 1000000000);
	tlen = sprintf(rpmsg_log_temp_buf, ">%5lu.%06lu< ",
		       (unsigned long) t, nanosec_rem / 1000);
	
	len = vsprintf(rpmsg_log_temp_buf+tlen, fmt, args);
	len += tlen;

	rpmsg_sram_cpy(rpmsg_log_temp_buf, len);

	va_end(args);
#endif
}

void rpmsg_sram_init(void)
{
#ifdef CONFIG_ZX_RAM_CONSOLE
    pr_info("[RPMSG] LOG_INIT \n");

	rpmsg_printk_buf[0] = 0;
	rpmsg_log_point = 0;

	rpmsg_sram_inited = 1;
#endif
}

 
