/*
 * ZTE tsc driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by tsp
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/io.h> 
#include <linux/kthread.h>	/*For kthread_run()*/
#include <linux/timer.h>	/*for mod timer*/
#include <linux/semaphore.h>/*for semaphore*/
#include <linux/delay.h>
#include <mach/iomap.h> 
#include "zx-tsc.h"
#include <linux/timer.h>
#include <linux/cp_types.h>
#include "NvParam_drv.h"
#include "pub_debug_info.h"
#include <mach/spinlock.h>

/****************************************************************************
*                                           Types
****************************************************************************/

/*******************************************************************************
*                                       Global Variables                                      *
*******************************************************************************/
/*
ЭջصǰȼǷִй
ps_rate_flag:
1: imite rate ٷһ;
0: limite rateûз
*/
//static  volatile u32 ps_rate_flag=0;
/*
ЭջصǰȼǷִй
ڷפʩ֮ǰȼ֮ǰ״̬ǲany resident
ǣܷפʩȥפʩ
any_resident_flag:
1: any resident ٷһ;
0: any resident ûз
*/
//static  volatile u32 any_resident_flag=0;

/*
õƵǷִй
ps_freq_flag:
1: tsc dfs ٷһ;
0: tsc dfs ûз
*/
//static  volatile u32 ps_freq_flag=0;

struct timer_list timer_tsctrl;
static int temp_percent = 0;

T_TsCtrl_CallbackFunction   s_tsctrl_callback[MAX_TSCTRL_STRATEGY_ID] = {NULL};

typedef void (*T_Probe_Strategy)(u32 probe_num,int temperature );
T_Probe_Strategy g_probe_strategy[PROBE_MAX]={0,};

T_TscP_Strategy g_ps_Strategy[STRATEGY_PS_NUM]={
	{"ps anyresident: ",   0},
	{"ps rate limit: ",   0},
	{"ps freq 312M: ",   0},
};

T_TscP_Strategy g_phy_Strategy[STRATEGY_PHY_NUM]={
	{"lte downrate1 limit: ",   0},
	{"lte downrate2 limit: ",   0},
	{"w downrate1 limit: ",    0},
	{"w downrate2 limit: ",    0},
	{"lte up_tansmitepower1 limit: ",  0},
	{"lte up_tansmitepower2 limit: ",  0},
	{"w up_tansmitepower1 limit: ",  0},
	{"w up_tansmitepower2 limit: ",  0},
};

u8 g_bit_probe[PROBE_MAX]={
	BIT_PROBE_ADC1,
	BIT_PROBE_ADC2,
	BIT_PROBE_ADCRF,
	BIT_PROBE_ADCRFd,
	BIT_PROBE_RESEV3,
	BIT_PROBE_RESEV4	
};

/*******************************************************************************
*                                       ⲿ                                *
*******************************************************************************/
extern struct semaphore s_tsc_adc_semaphore;
extern T_SYS_NV_TSC_CONFIG TsNvData; 
extern volatile u32 g_adc1_flag;
extern volatile u32 g_adc2_flag;
extern volatile u32 g_adc3_flag;
extern s32 g_tsc_print_log_debug;
/*******************************************************************************
*                                        ⲿ                                  *
*******************************************************************************/
#ifdef CONFIG_CPU_FREQ
extern int zx29_set_frequency(unsigned int old_index,unsigned int new_index);
extern unsigned int zx_getspeed(unsigned int cpu);
#endif

extern void zx29_restart(char str,const char * cmd);
/*******************************************************************************
*                                       functions                                     *
*******************************************************************************/
void tsc_set_reg_bits(u32 regName, u32 bitsAddr, u32 bitsLen, u32 bitsValue )
{
	u32 temp;
	
	hw_spin_lock(REGLOCK_HWLOCK);
	temp= (tsc_read_reg(regName)&(~(((0x1<<bitsLen)-0x1)<<bitsAddr)))|(bitsValue<<bitsAddr);
	tsc_write_reg(regName,temp);
	hw_spin_unlock(REGLOCK_HWLOCK);	
}

/*******************************************************************************
 * Function: tsctrl_set_strategy2Iram
 * Description: ÿ̽ǷִзõӦiramַеĶӦbitλ
 * Parameters: 
 *   Input:	 Stra_iram_addr---洢̽ĳԵĿϢiramַ
 *			 probe_bit--------̽ԲԵĿϢӦ洢IRAMʼbitλ
 			 Strategy---------ԿϢ

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
void tsctrl_set_strategy2Iram(u32 Stra_iram_addr, u32 probe_bit,  Ts_TsCtrlStrategy Strategy )
{
	tsc_set_reg_bits(Stra_iram_addr, probe_bit, BITS_FOR_PROBES, Strategy);
}

/*******************************************************************************
 * Function: tsc_ProbeStrategy
 * Description: 
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
void tsctrl_probe_strategy(u32 probe_num,int temperature ) 
{

	int  temp1=(temperature-TsNvData.Threshods[probe_num].THROSHOLD_3);
	int  temp2=(TsNvData.Threshods[probe_num].THROSHOLD_6-TsNvData.Threshods[probe_num].THROSHOLD_3);

	if(temperature<=TsNvData.Threshods[probe_num].THROSHOLD_3){
		temp_percent=0;	
	}else if((temperature<=TsNvData.Threshods[probe_num].THROSHOLD_6)){
		temp_percent=((100*temp1/temp2)/TEMP_PERCENT_INTERVAL)*TEMP_PERCENT_INTERVAL;
	}else{
		temp_percent=100;
	}
	
	if(TsNvData.AdcRFd_En==0xB2){
		/**/
		if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_9)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN, g_bit_probe[probe_num] ,STRTEGY_START);
		}	
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_7)
		{
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num] ,STRTEGY_START);
		}
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_5)
		{
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2, g_bit_probe[probe_num] ,STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
		}
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_3)
		{   
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
		}
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_1)
		{	
			//tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
		}   
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_0)
		{
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_HOLD);
		}
		else
		{	

		}

		/**/
		if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_0)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_STOP);
		}
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_2)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2 ,g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_STOP);
		}
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_4)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP); 
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2,g_bit_probe[probe_num],STRTEGY_STOP);
		}
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_6)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT,g_bit_probe[probe_num],STRTEGY_STOP);
		}   
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_8)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
		} 
		else
		{

		}
	}else{
		/**/
		if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_9)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN, g_bit_probe[probe_num] ,STRTEGY_START);
		}
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_7)
		{
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num] ,STRTEGY_START);
		}
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_5)
		{
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2, g_bit_probe[probe_num] ,STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_START);//zDrvPow_SetArmPsCoreFreq(CLK312M);	   
		}
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_3)
		{   
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_START);
			tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_START);//zDrvPow_SetArmPsCoreFreq(CLK312M);	   
		}
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_1)
		{	
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
			//tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_START);
		}   
		else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_0)
		{
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_HOLD);
		}
		else
		{	

		}
		/**/
		if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_0)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_STOP);// zDrvPow_SetArmPsCoreFreq(CLK624M);
		}
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_2)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2 ,g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_DOWNRATE2, g_bit_probe[probe_num], STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_STOP);// zDrvPow_SetArmPsCoreFreq(CLK624M);
		}
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_4)
		{

			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2,g_bit_probe[probe_num],STRTEGY_STOP);
		}
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_6)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
			tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT,g_bit_probe[probe_num],STRTEGY_STOP);
		}   
		else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_8)
		{
			tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
		}  
		else
		{

		}
	}
 
}

/*******************************************************************************
 * Function: tsc_ProbeAdc1Strategy
 * Description: adc1̽¿ز
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
void tsctrl_probe_adc1_strategy(u32 probe_num,int temperature ) 
{	
	tsctrl_probe_strategy(probe_num, temperature);
}

/*******************************************************************************
 * Function: tsc_ProbeAdc2Strategy
 * Description: adc2̽¿ز
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
void tsctrl_probe_adc2_strategy(u32 probe_num,int temperature ) 
{
	tsctrl_probe_strategy(probe_num, temperature);
}

/*******************************************************************************
 * Function: tsc_ProbeAdcRfStrategy
 * Description: adcRf̽¿ز
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
void tsctrl_probe_adcRf_strategy(u32 probe_num,int temperature ) 
{
	tsctrl_probe_strategy(probe_num, temperature);
}


/*******************************************************************************
 * Function: tsc_ProbeAdcRfStrategy
 * Description: adcRfd̽¿ز
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
void tsctrl_probe_adcRfd_strategy(u32 probe_num,int temperature ) 
{
#if 1
	int  temp1=(temperature-TsNvData.Threshods[probe_num].THROSHOLD_3);
	int  temp2=(TsNvData.Threshods[probe_num].THROSHOLD_6-TsNvData.Threshods[probe_num].THROSHOLD_3);

	if(temperature<=TsNvData.Threshods[probe_num].THROSHOLD_3){
		temp_percent=0;	
	}else if((temperature<=TsNvData.Threshods[probe_num].THROSHOLD_6)){
		temp_percent=((100*temp1/temp2)/TEMP_PERCENT_INTERVAL)*TEMP_PERCENT_INTERVAL;
	}else{
		temp_percent=100;
	}

	/**/
   if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_9)
   {
	   tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN, g_bit_probe[probe_num] ,STRTEGY_START);
   }	
   else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_7)
   {
	 //  tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num] ,STRTEGY_START);
	tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_START);	   
   }
   else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_5)
   {
	//tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
	tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_START);	   
   }
   else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_3)
   {   
	//tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
	tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_START);	   
   }
	else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_1)
	{	
	   //tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_START);
	}   
	else if(temperature>=TsNvData.Threshods[probe_num].THROSHOLD_0)
   {
		//tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_HOLD);
   }
   else
   {	
   
   }
	
	/**/
   if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_0)
   {
	   tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
	//   tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num], STRTEGY_STOP);
	 //  tsctrl_set_strategy2Iram(TSCTRL_PS_RATE, g_bit_probe[probe_num], STRTEGY_STOP);
	  tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_STOP);// zDrvPow_SetArmPsCoreFreq(CLK624M);
   }
   else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_2)
   {
	   tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
	  // tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT, g_bit_probe[probe_num], STRTEGY_STOP);
	  tsctrl_set_strategy2Iram(TSCTRL_DFS, g_bit_probe[probe_num], STRTEGY_STOP);// zDrvPow_SetArmPsCoreFreq(CLK624M);
   }
   else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_4)
   {
  	tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP); 
	//tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT,g_bit_probe[probe_num],STRTEGY_STOP);
   }
   else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_6)
   {
	   tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
	  // tsctrl_set_strategy2Iram(TSCTRL_PS_ANYRESIDENT,g_bit_probe[probe_num],STRTEGY_STOP);
   }   
   else if(temperature<TsNvData.Threshods[probe_num].THROSHOLD_8)
   {
	   tsctrl_set_strategy2Iram(TSCTRL_SHUTDOWN,g_bit_probe[probe_num],STRTEGY_STOP);
   } 
   else
   {

   }
#endif   
}


/*******************************************************************************
 * Function: tsc_RefSetProbeStr
 * Description: ̽ŵӦĲԺ
 * Parameters:
 *   Input: probe_num:̽
 *			temperature:Ӧ̽¶ֵ

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
static void tsctrl_set_probe_strategy(u32 probe_num,int temperature ) 
{
	if(PROBE_MAX!=probe_num && 0xFF!=temperature) {
		g_probe_strategy[probe_num](probe_num, temperature);
	}
}

/*******************************************************************************
* Function: tsctrl_strategy_init
* Description: 
* Parameters:
*	 Input: N/A
*
*	 Output: N/A
* Returns: N/A

* Others:	//not use
********************************************************************************/
void tsctrl_strategy_init(void)
{
	g_probe_strategy[PROBE_ADC1]= tsctrl_probe_adc1_strategy;
	g_probe_strategy[PROBE_ADC2]= tsctrl_probe_adc2_strategy;
	g_probe_strategy[PROBE_ADCRF]= tsctrl_probe_adcRf_strategy;
	g_probe_strategy[PROBE_ADCRFd]= tsctrl_probe_adcRfd_strategy;
}

/*******************************************************************************
 * Function: tsctrl_callback_dispatch
 * Description:
 * Parameters:
 *   Input:
 		module: Strategy_ModuleId
 		en: 1,ִ;   0,ֹͣ
 *
 *   Output: N/A
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
s32 tsctrl_callback_dispatch(T_TsCtrl_Strategy_ModuleId  module, u8 en)
{
 	T_TsCtrl_CallbackFunction callback = NULL;
	
	if(module>=MAX_TSCTRL_STRATEGY_ID )
		return -EINVAL;

	callback = s_tsctrl_callback[module];
	if (g_tsc_print_log_debug)
		tsc_print_log("tsctrl_callback_dispatch:callback=0x%x,module=%d,en=%d.\n",(u32)callback,module,en);

	if (callback == NULL) {
		return -EINVAL;
	}

	/* pMsgΪûصϢ */
	(*callback)(en);

	return 0;

}

/*******************************************************************************
 * Function: tsc_RefStrategyDispatch
 * Description:
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
static void tsctrl_print_temp(void)
{
	if(g_adc1_flag==1){
		sc_debug_info_record(MODULE_ID_AP_TSC, "temp1:%d\n", zx_read_reg(TSCTRL_TEMPADC1) );
		printk( "temp1:%d\n", zx_read_reg(TSCTRL_TEMPADC1));
	}
	if(g_adc2_flag==1){
		sc_debug_info_record(MODULE_ID_AP_TSC, "temp2:%d\n", zx_read_reg(TSCTRL_TEMPADC2) );
		printk( "temp2:%d\n", zx_read_reg(TSCTRL_TEMPADC2));
	}
	if(g_adc3_flag==1){
		sc_debug_info_record(MODULE_ID_AP_TSC, "tempRf:%d\n", zx_read_reg(TSCTRL_TEMPADCRF) );
		printk( "tempRf:%d\n", zx_read_reg(TSCTRL_TEMPADCRF));
	}
	if(TsNvData.AdcRFd_En==0xB2){		
		sc_debug_info_record(MODULE_ID_AP_TSC, "tempRfd:%d\n", zx_read_reg(TSCTRL_TEMPADCRFd) );
		printk( "tempRfd:%d\n", zx_read_reg(TSCTRL_TEMPADCRFd));
	}		
	
}
/*******************************************************************************
 * Function: tsctrl_set_strategy
 * Description:
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
int cpufreq_performance(void);
int cpufreq_powersave(void);
int cpufreq_normal(void);

static void tsctrl_set_strategy(void)
{
	u32 i=0;
	if(zDrvTsc_GetTscEn() == 0xB2)
	{
		if(TsNvData.User_En == 0xB2){
			/*USER*/
			if(tsc_read_reg(TSCTRL_SHUTDOWN)!=0){
				/*user strategy start*/
				tsc_set_reg_bits(TSCTRL_AP,BIT_SHUTDOWN,BITS_FOR_APPIRAM,STRTEGY_START);			
				sc_debug_info_record(MODULE_ID_AP_TSC, "tsc_reboot!!!\n" );
				zx29_restart(NULL, "tsc_reboot!!!\n");
				
				if(g_tsc_print_log_debug)
					tsc_print_log("user strategy start \n");
			}
			else{
				//tsc_print_log("user strategy stop reserve \n")
				tsc_set_reg_bits(TSCTRL_AP,BIT_SHUTDOWN,BITS_FOR_APPIRAM,STRTEGY_STOP);						
			}
		}
			
		/*PS_ANYRESIDENT*/
		if(tsc_read_reg(TSCTRL_PS_ANYRESIDENT)==0){
			if(g_ps_Strategy[STRATEGY_PS_ANYRESIDENT].flag){
				tsctrl_callback_dispatch(PS_STRATEGY_ANYRESIDENT,false); /*ȥפ,Ҳפ*/
				tsc_set_reg_bits(TSCTRL_PS,BIT_PS_ANYRESIDENT,BITS_FOR_PSIRAM,false);
				tsctrl_print_temp();
				sc_debug_info_record(MODULE_ID_AP_TSC, "AnyResident stop\n");
				tsc_print_log("AnyResident  stop!\n");
				g_ps_Strategy[STRATEGY_PS_ANYRESIDENT].flag=0;
			}
		}else{		
			if(!g_ps_Strategy[STRATEGY_PS_ANYRESIDENT].flag){
				tsctrl_callback_dispatch(PS_STRATEGY_ANYRESIDENT,true);/*פ*/
				tsc_set_reg_bits(TSCTRL_PS,BIT_PS_ANYRESIDENT,BITS_FOR_PSIRAM,true);
				tsctrl_print_temp();
				sc_debug_info_record(MODULE_ID_AP_TSC, "AnyResident start!\n");
				tsc_print_log("AnyResident  start!\n");
				g_ps_Strategy[STRATEGY_PS_ANYRESIDENT].flag=1;
			}
		}
		
		//WIFI
		if(TsNvData.Wifi_RateLmite_En == 0xB2){
			if(tsc_read_reg(TSCTRL_WIFI)==0){
				tsctrl_callback_dispatch(WIFI_STRATEGY,STRTEGY_STOP);//STOP		
				tsc_set_reg_bits(TSCTRL_PERIP,BIT_WIFI,BITS_FOR_PEPIPIRAM,STRTEGY_STOP);
			}else if(((tsc_read_reg(TSCTRL_WIFI)&0x1000)==0x1000)||((tsc_read_reg(TSCTRL_WIFI)&0x0100)==0x0100)||((tsc_read_reg(TSCTRL_WIFI)&0x0010)==0x0010)||((tsc_read_reg(TSCTRL_WIFI)&0x0001)==0x0001))
			{		
				tsctrl_callback_dispatch(WIFI_STRATEGY,STRTEGY_START);//START		
				tsc_set_reg_bits(TSCTRL_PERIP,BIT_WIFI,BITS_FOR_PEPIPIRAM,STRTEGY_START);
			} else{	
				tsctrl_callback_dispatch(WIFI_STRATEGY,STRTEGY_HOLD);//HOLD			
				tsc_set_reg_bits(TSCTRL_PERIP,BIT_WIFI,BITS_FOR_PEPIPIRAM,STRTEGY_HOLD);
			}	
		}

		//ϲӦý
		if(TsNvData.Aprate_En == 0xB2) {	 
			if(tsc_read_reg(TSCTRL_APRATE)==0) {
				tsctrl_callback_dispatch(AP_RATE,STRTEGY_STOP);//			
				tsc_set_reg_bits(TSCTRL_PERIP,BIT_APRATE,BITS_FOR_PEPIPIRAM,STRTEGY_STOP);
			} else {
				tsctrl_callback_dispatch(AP_RATE,STRTEGY_START);//			
				tsc_set_reg_bits(TSCTRL_PERIP,BIT_APRATE,BITS_FOR_PEPIPIRAM,STRTEGY_START);

			}
		}

		//modemʲ
		if(TsNvData.Modemrate_En == 0xB2) {
			//Эջʲ
			if(tsc_read_reg(TSCTRL_PS_RATE)==0){
				if(g_ps_Strategy[STRATEGY_PS_RATE].flag!=0){
					tsctrl_callback_dispatch(PS_STRATEGY_RATE,STRTEGY_STOP);//STOP		
					tsc_set_reg_bits(TSCTRL_PS,BIT_PS_RATE,BITS_FOR_PSIRAM,STRTEGY_STOP);
					tsctrl_print_temp();
					sc_debug_info_record(MODULE_ID_AP_TSC, "ps modem rate limit  stop!\n");
					tsc_print_log("ps modem rate limit  stop!\n");
					g_ps_Strategy[STRATEGY_PS_RATE].flag=0;
				}
			}
			else if(((tsc_read_reg(TSCTRL_PS_RATE)&0x1000)==0x1000)||((tsc_read_reg(TSCTRL_PS_RATE)&0x0100)==0x0100)||((tsc_read_reg(TSCTRL_PS_RATE)&0x0010)==0x0010)||((tsc_read_reg(TSCTRL_PS_RATE)&0x0001)==0x0001))
			{		
				if(g_ps_Strategy[STRATEGY_PS_RATE].flag!=1){
					tsctrl_callback_dispatch(PS_STRATEGY_RATE,STRTEGY_START);//START		
					tsc_set_reg_bits(TSCTRL_PS,BIT_PS_RATE,BITS_FOR_PSIRAM,STRTEGY_START);
					tsctrl_print_temp();
					sc_debug_info_record(MODULE_ID_AP_TSC, "ps modem rate limit  start!\n");
					tsc_print_log("ps modem rate limit  start!\n");
					g_ps_Strategy[STRATEGY_PS_RATE].flag=1;
				}
			}else{	
				if(g_ps_Strategy[STRATEGY_PS_RATE].flag!=2){
					tsctrl_callback_dispatch(PS_STRATEGY_RATE,STRTEGY_HOLD);//HOLD			
					tsc_set_reg_bits(TSCTRL_PS,BIT_PS_RATE,BITS_FOR_PSIRAM,STRTEGY_HOLD);
					tsctrl_print_temp();
					sc_debug_info_record(MODULE_ID_AP_TSC, "ps modem rate limit  hold!\n");
					tsc_print_log("ps modem rate limit  hold!\n");
					g_ps_Strategy[STRATEGY_PS_RATE].flag=2;
				}
			}
			
			//㽵ʲ		
			for(i=0;i<4;i++){
				if(tsc_read_reg(TSCTRL_LIMIT_LTE_DOWNRATE1+i*0x4)==0){
					if(g_phy_Strategy[i].flag !=0) {
						tsc_set_reg_bits(TSCTRL_PHY,(BIT_LIMIT_LTE_DOWNRATE1+i),BITS_FOR_PHYIRAM,STRTEGY_STOP);
						tsctrl_print_temp();
						sc_debug_info_record(MODULE_ID_AP_TSC, "%s stop\n", g_phy_Strategy[i].name );
						tsc_print_log("%s stop\n", g_phy_Strategy[i].name);
						g_phy_Strategy[i].flag=0;
					}
				}else{
					if(g_phy_Strategy[i].flag!=1) {
				
						tsc_set_reg_bits(TSCTRL_PHY,(BIT_LIMIT_LTE_DOWNRATE1+i),BITS_FOR_PHYIRAM,STRTEGY_START);
						tsctrl_print_temp();
						sc_debug_info_record(MODULE_ID_AP_TSC, "%s start\n", g_phy_Strategy[i].name );
						tsc_print_log("%s start\n", g_phy_Strategy[i].name);
						g_phy_Strategy[i].flag=1;
					}
				}				
			}
		}

		//㽵书

		if(TsNvData.TansmitPower_En == 0xB2){
			for(i=4;i<STRATEGY_PHY_NUM;i++){
				if(tsc_read_reg(TSCTRL_LIMIT_LTE_DOWNRATE1+i*0x4)==0){
					if(g_phy_Strategy[i].flag !=0) {
						tsc_set_reg_bits(TSCTRL_PHY,(BIT_LIMIT_LTE_DOWNRATE1+i),BITS_FOR_PHYIRAM,STRTEGY_STOP);
						tsctrl_print_temp();
						sc_debug_info_record(MODULE_ID_AP_TSC, "%s stop\n", g_phy_Strategy[i].name );
						tsc_print_log("%s stop\n", g_phy_Strategy[i].name);
						g_phy_Strategy[i].flag=0;						
					}
				}else{
					if(g_phy_Strategy[i].flag !=1) {
						tsc_set_reg_bits(TSCTRL_PHY,(BIT_LIMIT_LTE_DOWNRATE1+i),BITS_FOR_PHYIRAM,STRTEGY_START);
						tsctrl_print_temp();
						sc_debug_info_record(MODULE_ID_AP_TSC, "%s start\n", g_phy_Strategy[i].name );
						tsc_print_log("%s start\n", g_phy_Strategy[i].name);
						g_phy_Strategy[i].flag=1;
					}
				}				
			}
		}

		/*DFS*/
		if(TsNvData.Dfs_En == 0xB2){

			#ifdef CONFIG_CPU_FREQ

			//tsc_print_log("CPU_FRE:zx_getspeed(0)=%d\n",zx_getspeed(0));

			if(tsc_read_reg(TSCTRL_DFS)==0){
				if(g_ps_Strategy[STRATEGY_PS_DFS].flag){
					//tsc_print_log("CPU_FREQ0:zx_getspeed(0)=%d\n",zx_getspeed(0));
//					if(zx_getspeed(0) != 624000 )
//						zx29_set_frequency(1,0); //zDrvPow_SetArmPsCoreFreq(CLK624M);
					cpufreq_normal();
						
					tsc_set_reg_bits(TSCTRL_PS,BIT_PS_FREQ, BITS_FOR_PSIRAM,STRTEGY_STOP);
					tsctrl_print_temp();
					sc_debug_info_record(MODULE_ID_AP_TSC, "ps freq 624M start\n" );
					tsc_print_log("ps freq 624M start\n");
					g_ps_Strategy[STRATEGY_PS_DFS].flag=0;
				}	
			}else{
				if(!g_ps_Strategy[STRATEGY_PS_DFS].flag){
					//tsc_print_log("CPU_FREQ1:zx_getspeed(0)=%d\n",zx_getspeed(0));	
					//zx29_set_frequency(0,1); //zDrvPow_SetArmPsCoreFreq(CLK312M);
					cpufreq_powersave();
					tsc_set_reg_bits(TSCTRL_PS,BIT_PS_FREQ, BITS_FOR_PSIRAM,STRTEGY_START);					
					tsctrl_print_temp();
					sc_debug_info_record(MODULE_ID_AP_TSC, "ps freq 312M start\n" );
					tsc_print_log("ps freq 312M start\n");
					g_ps_Strategy[STRATEGY_PS_DFS].flag=1;
				}
			}	
			#endif
		}	

		if(g_tsc_print_log_debug) {
			tsc_print_log("[0:stop;1:start;2:hold][bit11~8:ps_dfs,bit7~4:anyregister,bit3~0:ps_rate] reg32(TSCTRL_PS)=0x%x,reg32(PSCORE_SEL)=0x%x(1:624M;2:312M)\n",tsc_read_reg(TSCTRL_PS),tsc_read_reg(PS_CORE_SEL_REG));		
			tsc_print_log("]bit1:limitLtedownrate2;bit3:limitWdownrate2;bit5:limitLteUptransmitrate2;bit7:limitWUptransmitrate2] reg32(TSCTRL_PHY)=0x%x.\n\n",tsc_read_reg(TSCTRL_PHY)); 
		}
	}
	else
	{
		if(TsNvData.Modemrate_En == 0xB2){
			 /*stop ps в*/ 
			if(g_ps_Strategy[STRATEGY_PS_RATE].flag!=0){
				tsctrl_callback_dispatch(PS_STRATEGY_RATE,STRTEGY_STOP);//STOP
				tsc_set_reg_bits(TSCTRL_PS,BIT_PS_RATE,BITS_FOR_PSIRAM,STRTEGY_STOP);
				g_ps_Strategy[STRATEGY_PS_RATE].flag=0;
			}
		}
		
		if(g_ps_Strategy[STRATEGY_PS_ANYRESIDENT].flag){
			tsctrl_callback_dispatch(PS_STRATEGY_ANYRESIDENT,false); /*ȥפ,Ҳפ*/
			tsc_set_reg_bits(TSCTRL_PS,BIT_PS_ANYRESIDENT,BITS_FOR_PSIRAM,false);
			g_ps_Strategy[STRATEGY_PS_ANYRESIDENT].flag=0;
		}
		
		if(TsNvData.Dfs_En == 0xB2) {
			if(g_ps_Strategy[STRATEGY_PS_DFS].flag){
				tsc_set_reg_bits(TSCTRL_PS,BIT_PS_FREQ,BITS_FOR_PSIRAM,false);
				cpufreq_normal();
				g_ps_Strategy[STRATEGY_PS_DFS].flag=0;
			}		
		}
		
		//stop WIFI  
		if(TsNvData.Wifi_RateLmite_En == 0xB2){
			tsctrl_callback_dispatch(WIFI_STRATEGY,STRTEGY_STOP);//STOP		
			tsc_set_reg_bits(TSCTRL_PERIP,BIT_WIFI,BITS_FOR_PEPIPIRAM,STRTEGY_STOP);
		}
		//stopϲӦý 
		if(TsNvData.Aprate_En == 0xB2){	
			tsctrl_callback_dispatch(AP_RATE,STRTEGY_STOP);//			
			tsc_set_reg_bits(TSCTRL_PERIP,BIT_APRATE,BITS_FOR_PEPIPIRAM,STRTEGY_STOP);		
		}
		
		//stop в
		for(i=0;i<STRATEGY_PHY_NUM;i++){		
			tsc_set_reg_bits(TSCTRL_PHY,(BIT_LIMIT_LTE_DOWNRATE1+i),BITS_FOR_PHYIRAM,STRTEGY_STOP);
			g_phy_Strategy[i].flag=0;
		} 

		//sc_debug_info_record(MODULE_ID_AP_TSC, "close all strategy!\n");


		if(g_tsc_print_log_debug)
			tsc_print_log("g_tsc_ctrlen==0, TSC Closed, close all strategy .\n");
	}
}

static void tsctrl_set_strategy_thread(void * arg)
{
	while(1)
	{
		tsctrl_set_strategy();
		msleep(TS_POLLING_TIME);
	}
}

static void tsctrl_set_strategy_thread_create(unsigned long een)
{
	int err;

	err = (int)kthread_run(tsctrl_set_strategy_thread, NULL, "tsctrl_set_strategy");
	if (IS_ERR((const void *)err)) {
		printk(KERN_ERR"[zx tsctrl]: Fail to create and run tsctrl_set_strategy!\n");
    // return PTR_ERR((const void *)err);
  }
}

/*init tsctrl Iram*/
static void tsctrl_createtimer(void)
{
	init_timer(&timer_tsctrl); 
	timer_tsctrl.function = tsctrl_set_strategy_thread_create; 
	
	timer_tsctrl.expires = jiffies + msecs_to_jiffies(TS_STRATEGY_SET_BEGIN_TIME); 
	add_timer(&timer_tsctrl); 

}


/*******************************************************************************
 * Function: TsCtrl_TsCtrlAdcThread
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output: N/A
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void tsctrl_adc_thread(void * arg) 
{

	u32  probe_num ;
	int  temperature ;

	int TsDataValue[PROBE_NUM][PROBE_INFO] = {0};

	while(1)
	{
		down(&s_tsc_adc_semaphore);	
		
		if(zDrvTsc_GetTscEn() == 0xB2) {
			/*bufferлȡǰ̽ż¶*/
			tsc_get_temp_data_info(TsDataValue);
			if(g_adc1_flag==1){
				/*ȡPROBE_ADC1Ϣ*/
				probe_num= TsDataValue[PROBE_ADC1][TS_MEMBER_PROBE];
				temperature= TsDataValue[PROBE_ADC1][TS_MEMBER_TEMP];
				//tsc_set_temp_data_info(probe_num);
				if(g_tsc_print_log_debug)
					tsc_print_log("set strategy for probe%d\n", probe_num);	
				tsctrl_set_probe_strategy(probe_num, temperature );
			}
			
			if(g_adc2_flag==1){
				/*ȡPROBE_ADC2Ϣ*/
				probe_num= TsDataValue[PROBE_ADC2][TS_MEMBER_PROBE];
				temperature= TsDataValue[PROBE_ADC2][TS_MEMBER_TEMP];
				//tsc_set_temp_data_info(probe_num);
				if(g_tsc_print_log_debug)
					tsc_print_log("set strategy for probe%d\n", probe_num);	
						
				tsctrl_set_probe_strategy(probe_num, temperature );
			}
			
			if(g_adc3_flag==1){
				/*ȡPROBE_ADCRFϢ*/
				probe_num= TsDataValue[PROBE_ADCRF][TS_MEMBER_PROBE];
				temperature= TsDataValue[PROBE_ADCRF][TS_MEMBER_TEMP];
				//tsc_set_temp_data_info(probe_num);
				if(g_tsc_print_log_debug)
					tsc_print_log("set strategy for probe%d\n", probe_num);	
				
				tsctrl_set_probe_strategy(probe_num, temperature );
			}
			if(TsNvData.AdcRFd_En==0xB2){		
				/*ȡPROBE_ADCRFϢ*/
				probe_num= TsDataValue[PROBE_ADCRFd][TS_MEMBER_PROBE];
				temperature= TsDataValue[PROBE_ADCRFd][TS_MEMBER_TEMP];
				//tsc_set_temp_data_info(probe_num);
				if(g_tsc_print_log_debug)
					tsc_print_log("set strategy for probe%d\n", probe_num);	
				
				tsctrl_set_probe_strategy(probe_num, temperature );
			}
			
		}else{
			if(g_tsc_print_log_debug)
				tsc_print_log("g_tsc_ctrlen==0, TSC  Closed.\n");
		}
	}
}



void tsctrl_init(void)
{
	int err;

	tsctrl_strategy_init();
	
	err = (int)kthread_run(tsctrl_adc_thread, NULL, "tsctrl_adc_thread");
	if (IS_ERR((const void *)err)) {
		printk(KERN_ERR"[zx tsctrl]: Fail to create and run tsctrl_adc_thread!\n");
    //return PTR_ERR((const void *)err);
  }

	tsctrl_createtimer();
}

/*******************************************************************************
 * Function: zDrvTsCtrl_DfsEn
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output: 1: tsc open dfs
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
u32 zDrvTsCtrl_DfsEn(void)
{
	if(g_ps_Strategy[STRATEGY_PS_DFS].flag)
		return 1;
	else
		return 0;
}
EXPORT_SYMBOL(zDrvTsCtrl_DfsEn);

/*******************************************************************************
 * Function: zDrvTsCtrl_RegCallback
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output: N/A
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
s32 zDrvTsCtrl_RegCallback(T_TsCtrl_Strategy_ModuleId  module,T_TsCtrl_CallbackFunction callback)
{

	if (module >= MAX_TSCTRL_STRATEGY_ID ) 
	{
		BUG();
		return -EINVAL;
	}

	if(NULL==callback)
	{
		BUG();
		return -EINVAL;
	}

	/* callbackType, mes_IcpCallbackListбӻصָ롣 */
	s_tsctrl_callback[module] = callback;

	return 0;

}
EXPORT_SYMBOL(zDrvTsCtrl_RegCallback);

/*******************************************************************************
 * Function: zDrvTsc_GetTscTempPercent
 * Description:
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
VOID zDrvTsc_GetTscTempPercent(int *percent)
{
	*percent=temp_percent;
	tsc_write_reg(TSCTRL_TEMP_PERCENT,temp_percent);
}

